/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.InitTransaction;
import pl.smartapps.hm.WebViewer.shared.rpc.InitTransactionResult;
import pl.smartapps.restserver.rest.response.InitTransactionResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.PaymentServiceExt;

@ActionHandlerBean
public class InitTransactionHandler
implements ActionHandler<InitTransaction, InitTransactionResult> {
    @Autowired
    private PaymentServiceExt paymentService;

    public InitTransactionResult execute(InitTransaction action, ExecutionContext context) throws ActionException {
        Log.info((String)("> InitTransaction::Request: " + action.getLdId()));
        InitTransactionResponse response = null;
        try {
            response = this.paymentService.initTransaction(action.getLdId());
            Log.info((String)("< InitTransaction::Response: " + response));
            if (response == null || response.status != InitTransactionResponse.InitTransactionStatus.SUCCESS) {
                ServerValidation.exception((String)"INIT_TRANSACTION_ERROR", (String)"", (Object[])new Object[0]);
            }
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        InitTransactionResult result = new InitTransactionResult();
        result.setOrderId(response.orderId);
        result.setAmount(response.amount);
        result.setCurrency(response.currency);
        result.setGatewayName(response.gatewayName);
        result.setGatewayData(response.gatewayData);
        return result;
    }

    public void rollback(InitTransaction action, InitTransactionResult result, ExecutionContext context) throws ActionException {
    }

    public Class<InitTransaction> getActionType() {
        return InitTransaction.class;
    }
}

