/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoints;
import pl.smartapps.hm.WebViewer.shared.rpc.GetWLANAccessPoints;
import pl.smartapps.hm.WebViewer.shared.rpc.GetWLANAccessPointsResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class GetWLANAccessPointsHandler
implements ActionHandler<GetWLANAccessPoints, GetWLANAccessPointsResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public GetWLANAccessPointsResult execute(GetWLANAccessPoints action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> GetWLANAccessPoints::Request: " + action.toString()));
        WlanAccessPoints response = null;
        try {
            response = this.lanDeviceService.getWlanAccessPoints(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        if (response.getStatus() != WlanAccessPoints.GetWlanAccessPointsStatus.SUCCESS) {
            ServerValidation.exception((String)("WLANACCESSPOINTS_ERROR" + response.getStatus().toString()), (String)"", (Object[])new Object[0]);
        }
        GetWLANAccessPointsResult result = new GetWLANAccessPointsResult();
        result.setwLANAccessPoints(response.getWlanAccessPoints());
        Log.debug((String)("< GetWLANAccessPoints::Response: " + result.toString()));
        return result;
    }

    public void rollback(GetWLANAccessPoints action, GetWLANAccessPointsResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetWLANAccessPoints> getActionType() {
        return GetWLANAccessPoints.class;
    }
}

