/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.GetVideoStreamPameters;
import pl.smartapps.hm.WebViewer.shared.rpc.GetVideoStreamPametersResult;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.VideoStreamServiceExt;

@ActionHandlerBean
public class GetVideoStreamPametersHandler
implements ActionHandler<GetVideoStreamPameters, GetVideoStreamPametersResult> {
    @Autowired
    private VideoStreamServiceExt videoStreamService;

    public GetVideoStreamPametersResult execute(GetVideoStreamPameters action, ExecutionContext context) throws ActionException {
        Log.info((String)("> GetVideoStreamParameters::Request: " + action.getLanDeviceId().toString()));
        VideoStreamParamsResponse response = new VideoStreamParamsResponse();
        try {
            response = this.videoStreamService.getVideoStreamPameters(action.getLanDeviceId(), false);
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< GetVideoStreamParameters::Response: " + response.status.toString() + " " + response.params.toString()));
        if (response.status != VideoStreamParamsResponse.VideoStreamResponseStatus.OK) {
            ServerValidation.exception((String)("GET_VIDEO_STREAM_PARAM_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        GetVideoStreamPametersResult result = new GetVideoStreamPametersResult();
        result.setVideoStreamParams(response.params);
        return result;
    }

    public void rollback(GetVideoStreamPameters action, GetVideoStreamPametersResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetVideoStreamPameters> getActionType() {
        return GetVideoStreamPameters.class;
    }
}

