/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.GetUsers;
import pl.smartapps.hm.WebViewer.shared.rpc.GetUsersResult;
import pl.smartapps.restserver.rest.response.GetUsersResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class GetUsersHandler
implements ActionHandler<GetUsers, GetUsersResult> {
    @Autowired
    private UserServiceExt userService;

    public GetUsersResult execute(GetUsers action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> GetUsers::Request: " + action.toString()));
        GetUsersResponse response = null;
        try {
            response = this.userService.getUsers(action.isDeleted());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.debug((String)("< GetUsers::Response: " + response.toString()));
        if (response.status != GetUsersResponse.GetUsersStatus.SUCCESS) {
            ServerValidation.exception((String)("GETUSERS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        GetUsersResult result = new GetUsersResult();
        result.setUsers(response.users);
        return result;
    }

    public void rollback(GetUsers action, GetUsersResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetUsers> getActionType() {
        return GetUsers.class;
    }
}

