/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.UserDetails;
import pl.smartapps.hm.WebViewer.shared.rpc.GetUserDetailsByUserId;
import pl.smartapps.hm.WebViewer.shared.rpc.GetUserDetailsByUserIdResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class GetUserDetailsByUserIdHandler
implements ActionHandler<GetUserDetailsByUserId, GetUserDetailsByUserIdResult> {
    @Autowired
    private UserServiceExt userService;

    public GetUserDetailsByUserIdResult execute(GetUserDetailsByUserId action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> GetUserDetailsByUserId::Request: " + action.toString()));
        UserDetails response = null;
        try {
            response = this.userService.getUserDetailsByUserId(action.getUserId(), action.getFetchDeletedDevices().booleanValue());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.debug((String)("< GetUserDetailsByUserId::Response: " + response));
        GetUserDetailsByUserIdResult result = new GetUserDetailsByUserIdResult();
        result.setUser(response.getUser());
        result.setGatewayClients(response.getGatewayClients());
        result.setLanDevices(response.getLanDevices());
        return result;
    }

    public void rollback(GetUserDetailsByUserId action, GetUserDetailsByUserIdResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetUserDetailsByUserId> getActionType() {
        return GetUserDetailsByUserId.class;
    }
}

