/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.rpc.GetSettings;
import pl.smartapps.hm.WebViewer.shared.rpc.GetSettingsResult;
import pl.smartapps.restserver.rest.response.SettingsResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.SettingsServiceExt;

@ActionHandlerBean
public class GetSettingsHandler
implements ActionHandler<GetSettings, GetSettingsResult> {
    @Autowired
    private SettingsServiceExt settingsService;

    public GetSettingsResult execute(GetSettings action, ExecutionContext context) throws ActionException {
        SettingsResponse response = new SettingsResponse();
        Log.info((String)("> GetSettings::Request: " + action.getLanDeviceId().toString()));
        try {
            response = this.settingsService.getLanDeviceSettings(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< GetSettings::Response: " + response.status.toString() + " " + (response.settings == null ? "null" : response.settings.toString())));
        if (response.status == LanDevice.LanDeviceStatus.ERROR || response.status == LanDevice.LanDeviceStatus.NOTFOUND) {
            ServerValidation.exception((String)("GET_SETTINGS_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        GetSettingsResult result = new GetSettingsResult();
        result.setStatus(response.status);
        result.setSettings(response.settings);
        return result;
    }

    public void rollback(GetSettings action, GetSettingsResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetSettings> getActionType() {
        return GetSettings.class;
    }
}

