/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.GetLANDevices;
import pl.smartapps.hm.WebViewer.shared.rpc.GetLANDevicesResult;
import pl.smartapps.restserver.rest.response.GetLanDevicesResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class GetLanDevicesHandler
implements ActionHandler<GetLANDevices, GetLANDevicesResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public GetLANDevicesResult execute(GetLANDevices action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> GetLANDevices::Request: " + action.toString()));
        GetLanDevicesResponse response = null;
        try {
            response = this.lanDeviceService.getLanDevices(null, "camera");
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        if (response.status != GetLanDevicesResponse.GetLanDevicesStatus.SUCCESS) {
            ServerValidation.exception((String)("GET_LAN_DEVICES_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        GetLANDevicesResult result = new GetLANDevicesResult();
        result.setLanDevices(response.devices);
        result.setMaxDeviceCount(response.maxDeviceCount);
        Log.debug((String)("< GetLANDevices::Response: maxDeviceCount = " + result.getMaxDeviceCount() + " lanDevices = " + result.getLanDevices().toString()));
        return result;
    }

    public void rollback(GetLANDevices action, GetLANDevicesResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetLANDevices> getActionType() {
        return GetLANDevices.class;
    }
}

