/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.GetCountryList;
import pl.smartapps.hm.WebViewer.shared.rpc.GetCountryListResult;

@ActionHandlerBean
public class GetCountryListHandler
implements ActionHandler<GetCountryList, GetCountryListResult> {
    public GetCountryListResult execute(GetCountryList action, ExecutionContext context) throws ActionException {
        String[] isoCountries;
        Log.debug((String)("> GetCountryList::Request: " + action.toString()));
        HashMap<String, String> countryToIso = new HashMap<String, String>();
        ArrayList<String> countries = new ArrayList<String>();
        String[] stringArray = isoCountries = Locale.getISOCountries();
        int n = isoCountries.length;
        int n2 = 0;
        while (n2 < n) {
            String country = stringArray[n2];
            Locale locale = new Locale("", country);
            String iso = locale.getISO3Country();
            String code = locale.getCountry();
            String name = locale.getDisplayCountry(new Locale(action.getLanguage().toLowerCase(), action.getCountry().toUpperCase()));
            if (!("".equals(iso) || "".equals(code) || "".equals(name))) {
                countryToIso.put(name, code);
                countries.add(name);
            }
            ++n2;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(countries);
        countries.clear();
        countries.addAll(set);
        Collections.sort(countries);
        Log.debug((String)("< GetCountryList::Response: " + (countryToIso == null ? "Error" : "Ok")));
        GetCountryListResult result = new GetCountryListResult();
        result.setCountryToISOMap(countryToIso);
        result.setCountryOrderedList(countries);
        return result;
    }

    public void rollback(GetCountryList action, GetCountryListResult result, ExecutionContext context) throws ActionException {
    }

    public Class<GetCountryList> getActionType() {
        return GetCountryList.class;
    }
}

