/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import java.util.List;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.FindUsersByName;
import pl.smartapps.hm.WebViewer.shared.rpc.FindUsersByNameResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class FindUsersByNameHandler
implements ActionHandler<FindUsersByName, FindUsersByNameResult> {
    @Autowired
    private UserServiceExt userService;

    public FindUsersByNameResult execute(FindUsersByName action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> FindUsersByName::Request: " + action.toString()));
        List response = null;
        try {
            response = this.userService.findUsersByName(action.getName(), action.getFetchDeleted().booleanValue());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        if (response == null) {
            ServerValidation.exception((String)"FIND_USERS_BY_NAME_STATUS_ERROR", (String)"", (Object[])new Object[0]);
        }
        FindUsersByNameResult result = new FindUsersByNameResult();
        result.setUsers(response);
        Log.debug((String)("< FindUsersByName::Response: " + result.toString()));
        return result;
    }

    public void rollback(FindUsersByName action, FindUsersByNameResult result, ExecutionContext context) throws ActionException {
    }

    public Class<FindUsersByName> getActionType() {
        return FindUsersByName.class;
    }
}

