/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import java.util.List;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.FindAllUsers;
import pl.smartapps.hm.WebViewer.shared.rpc.FindAllUsersResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class FindAllUsersHandler
implements ActionHandler<FindAllUsers, FindAllUsersResult> {
    @Autowired
    private UserServiceExt userService;

    public FindAllUsersResult execute(FindAllUsers action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> FindAllUsers::Request: " + action.toString()));
        List response = null;
        try {
            response = this.userService.findAllUsers(action.getFetchDeleted().booleanValue());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        if (response == null) {
            ServerValidation.exception((String)"FIND_ALL_USERS_STATUS_ERROR", (String)"", (Object[])new Object[0]);
        }
        FindAllUsersResult result = new FindAllUsersResult();
        result.setUsers(response);
        Log.debug((String)("< FindAllUsers::Response: " + result.toString()));
        return result;
    }

    public void rollback(FindAllUsers action, FindAllUsersResult result, ExecutionContext context) throws ActionException {
    }

    public Class<FindAllUsers> getActionType() {
        return FindAllUsers.class;
    }
}

