/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.DeleteEvents;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.rest.response.RemoveEventsResponse;
import pl.smartapps.restserver.service.ext.EventServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class DeleteEventsHandler
implements ActionHandler<DeleteEvents, VoidResult> {
    @Autowired
    private EventServiceExt eventService;

    public VoidResult execute(DeleteEvents action, ExecutionContext context) throws ActionException {
        Log.info((String)("> DeleteEvents::Request: " + action.getEventIds()));
        RemoveEventsResponse response = new RemoveEventsResponse();
        try {
            response = this.eventService.removeEvents(action.getEventIds());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< DeleteEvents::Response: " + response.status.toString()));
        if (response.status != RemoveEventsResponse.RemoveEventsStatus.SUCCESS) {
            ServerValidation.exception((String)("REMOVE_EVENTS_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(DeleteEvents action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<DeleteEvents> getActionType() {
        return DeleteEvents.class;
    }
}

