/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ConfigureLoggerStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.ConfigureGCLogging;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.service.ext.GatewayClientServiceExt;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

@ActionHandlerBean
public class ConfigureGCLoggingHandler
implements ActionHandler<ConfigureGCLogging, VoidResult> {
    @Autowired
    private GatewayClientServiceExt gatewayClientService;

    public VoidResult execute(ConfigureGCLogging action, ExecutionContext context) throws ActionException {
        Log.debug((String)("> ConfigureGCLogging::Request: gcId=" + action.getGcId() + ", loggingConfiguration=" + action.getLoggingConfiguration() + "."));
        ConfigureLoggerStatus response = null;
        try {
            response = this.gatewayClientService.configureLogs(action.getGcId(), action.getLoggingConfiguration());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ConfigureGCLogging::Response: " + response + "."));
        if (response != ConfigureLoggerStatus.SUCCESS) {
            ServerValidation.exception((String)("CONFIGURE_GC_LOGGING_STATUS_" + response), (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(ConfigureGCLogging action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ConfigureGCLogging> getActionType() {
        return ConfigureGCLogging.class;
    }
}

