/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.Rssi;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckRssi;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckRssiResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class CheckRssiHandler
implements ActionHandler<CheckRssi, CheckRssiResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public CheckRssiResult execute(CheckRssi action, ExecutionContext context) throws ActionException {
        Rssi response = new Rssi();
        Log.info((String)("> CheckRssi::Request: " + action.getLanDeviceId().toString()));
        try {
            response = this.lanDeviceService.checkRssi(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< CheckRssi::Response: " + response.getStatus() + " " + (response.getRssi() == null ? "null" : response.getRssi().toString())));
        if (response.getStatus() != Rssi.CheckRssiStatus.SUCCESS) {
            if (response.getStatus() == Rssi.CheckRssiStatus.FAILED_DEVICEDISCONNECTED) {
                ServerValidation.exception((String)("CHECK_RSSI_STATUS_" + response.getStatus().toString()), (String)"", (Object[])new Object[0]);
            } else {
                ServerValidation.exception((String)("CHECK_RSSI_STATUS_ERROR" + response.getStatus().toString()), (String)"", (Object[])new Object[0]);
            }
        }
        CheckRssiResult result = new CheckRssiResult();
        result.setState(response.getRssi());
        return result;
    }

    public void rollback(CheckRssi action, CheckRssiResult result, ExecutionContext context) throws ActionException {
    }

    public Class<CheckRssi> getActionType() {
        return CheckRssi.class;
    }
}

