/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckDeviceTrialProduct;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckDeviceTrialProductResult;
import pl.smartapps.restserver.rest.response.CheckDeviceTrialProductResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class CheckDeviceTrialProductHandler
implements ActionHandler<CheckDeviceTrialProduct, CheckDeviceTrialProductResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public CheckDeviceTrialProductResult execute(CheckDeviceTrialProduct action, ExecutionContext context) throws ActionException {
        String activationCode = action.getActivationCode();
        Log.info((String)("> CheckDeviceTrialProduct::Request: " + action.getActivationCode()));
        CheckDeviceTrialProductResponse response = null;
        try {
            response = this.lanDeviceService.checkDeviceTrialProduct(activationCode);
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< CheckDeviceTrialProduct::Response: " + response.getStatus().toString() + " " + response.getTrialDateValidFrom() + " " + response.getTrialDateValidTo() + " " + response.isPossibleTrial() + " " + response.isTrialPassed()));
        if (response.getStatus() != CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS) {
            ServerValidation.exception((String)"CHECK_DEVICE_PRODUCT_STATUS_FAILED", (String)"", (Object[])new Object[0]);
        }
        CheckDeviceTrialProductResult result = new CheckDeviceTrialProductResult();
        result.setPossibleTrial(response.isPossibleTrial());
        result.setTrialDateValidFrom(response.getTrialDateValidFrom());
        result.setTrialDateValidTo(response.getTrialDateValidTo());
        result.setTrialPassed(response.isTrialPassed());
        result.setAutomaticTrial(response.isAutomaticTrial());
        result.setNoProductSupport(response.isNoProductSupport());
        return result;
    }

    public void rollback(CheckDeviceTrialProduct action, CheckDeviceTrialProductResult result, ExecutionContext context) throws ActionException {
    }

    public Class<CheckDeviceTrialProduct> getActionType() {
        return CheckDeviceTrialProduct.class;
    }
}

