/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckDeviceConfiguration;
import pl.smartapps.hm.WebViewer.shared.rpc.CheckDeviceConfigurationResult;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class CheckDeviceConfigurationHandler
implements ActionHandler<CheckDeviceConfiguration, CheckDeviceConfigurationResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public CheckDeviceConfigurationResult execute(CheckDeviceConfiguration action, ExecutionContext context) throws ActionException {
        Log.info((String)("> CheckDeviceConfiguration::Request: " + action.getLanDeviceId()));
        CheckConfigurationStatus response = null;
        try {
            response = this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(action.getLanDeviceId());
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< CheckDeviceConfiguration::Response: " + response));
        if (response == CheckConfigurationStatus.ERROR) {
            ServerValidation.exception((String)("CHECK_DEVICE_CONFIGURATION_STATUS_" + response), (String)"", (Object[])new Object[0]);
        }
        CheckDeviceConfigurationResult result = new CheckDeviceConfigurationResult();
        result.setStatus(response);
        return result;
    }

    public void rollback(CheckDeviceConfiguration action, CheckDeviceConfigurationResult result, ExecutionContext context) throws ActionException {
    }

    public Class<CheckDeviceConfiguration> getActionType() {
        return CheckDeviceConfiguration.class;
    }
}

