/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.ChangePasswordAsAdmin;
import pl.smartapps.hm.WebViewer.shared.rpc.VoidResult;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class ChangePasswordAsAdminHandler
implements ActionHandler<ChangePasswordAsAdmin, VoidResult> {
    @Autowired
    private UserServiceExt userService;

    public VoidResult execute(ChangePasswordAsAdmin action, ExecutionContext context) throws ActionException {
        Log.info((String)("> ChangePasswordAsAdmin::Request: " + action.getUserId() + " " + action.getNewPassword()));
        try {
            ChangePasswordResponse response = this.userService.changePasswordAsAdmin(action.getUserId(), action.getNewPassword());
            Log.info((String)("< ChangePasswordAsAdmin::Response: " + response.status));
            if (response.status != ChangePasswordResponse.ChangePasswordStatus.SUCCESS) {
                ServerValidation.exception((String)("CHANGE_PASSWORD_STATUS_" + response.status.toString()), (String)"", (Object[])new Object[0]);
            }
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        return VoidResult.VOID;
    }

    public void rollback(ChangePasswordAsAdmin action, VoidResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ChangePasswordAsAdmin> getActionType() {
        return ChangePasswordAsAdmin.class;
    }
}

