/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.rpc.AuthenticateUser;
import pl.smartapps.hm.WebViewer.shared.rpc.AuthenticateUserResult;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.service.ext.UserServiceExt;

@ActionHandlerBean
public class AuthenticateUserHandler
implements ActionHandler<AuthenticateUser, AuthenticateUserResult> {
    @Autowired
    private UserServiceExt userService;

    public AuthenticateUserResult execute(AuthenticateUser action, ExecutionContext context) throws ActionException {
        Log.info((String)("> AuthenticationUser::Request: " + action.getAuthenticationData()));
        AuthenticateResponse response = this.userService.authenticateUser(action.getAuthenticationData());
        Log.info((String)("< AuthenticationUser::Response: " + response.status.toString()));
        if (response.status != AuthenticateResponse.AuthenticateStatus.OK) {
            ServerValidation.exception((String)("AUTHENTICATION_" + response.status.toString()), (String)"", (Object[])new Object[0]);
        }
        AuthenticateUserResult result = new AuthenticateUserResult();
        result.setSessionId(response.sessionId);
        result.setRememberMeCookie(response.rememberMeCookie);
        result.setUsername(action.getAuthenticationData().getUsername());
        return result;
    }

    public void rollback(AuthenticateUser action, AuthenticateUserResult result, ExecutionContext context) throws ActionException {
    }

    public Class<AuthenticateUser> getActionType() {
        return AuthenticateUser.class;
    }
}

