/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.hm.WebViewer.server.handler;

import com.allen_sauer.gwt.log.client.Log;
import eu.maydu.gwt.validation.client.server.ServerValidation;
import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.smartapps.hm.WebViewer.server.support.ActionHandlerBean;
import pl.smartapps.hm.WebViewer.shared.model.ActivateCameraResponse;
import pl.smartapps.hm.WebViewer.shared.rpc.ActivateCamera;
import pl.smartapps.hm.WebViewer.shared.rpc.ActivateCameraResult;
import pl.smartapps.hm.WebViewer.shared.validation.ValidationPropertyEnum;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;

@ActionHandlerBean
public class ActivateCameraHandler
implements ActionHandler<ActivateCamera, ActivateCameraResult> {
    @Autowired
    private LanDeviceServiceExt lanDeviceService;

    public ActivateCameraResult execute(ActivateCamera action, ExecutionContext context) throws ActionException {
        Log.info((String)("> ActivateCamera::Request: " + action.getActivationCode()));
        ActivateCameraResponse response = null;
        try {
            response = this.lanDeviceService.activateCamera(action.getActivationCode(), action.getTrial().booleanValue(), LanDeviceServiceExt.DeviceType.Camera);
        }
        catch (InvalidSessionException e) {
            ServerValidation.exception((String)"SESSION_ERROR", (String)"", (Object[])new Object[0]);
        }
        Log.info((String)("< ActivateCamera::Response: " + response.status.toString() + " " + (response.lanDevice == null ? "null" : response.lanDevice.toString())));
        if (response.status != ActivateCameraResponse.ActivateStatus.SUCCESS) {
            if (response.cameraActivationStatus != ActivateCameraResponse.CameraActivationStatus.NOTCONNECTED_TRYINSTALL) {
                ServerValidation.exception((String)("ACTIVATE_STATUS_" + response.status.toString()), (String)ValidationPropertyEnum.ACTIVATION_CODE.toString(), (Object[])new Object[0]);
            } else if (!action.isSetupByPlugin()) {
                ServerValidation.exception((String)"ACTIVATE_STATUS_FAILED_NOTCONNECTED", (String)ValidationPropertyEnum.ACTIVATION_CODE.toString(), (Object[])new Object[0]);
            }
        }
        ActivateCameraResult result = new ActivateCameraResult();
        result.setStatus(response.cameraActivationStatus);
        return result;
    }

    public void rollback(ActivateCamera action, ActivateCameraResult result, ExecutionContext context) throws ActionException {
    }

    public Class<ActivateCamera> getActionType() {
        return ActivateCamera.class;
    }
}

