/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice.brickcom;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.containserserver.landevice.brickcom.CameraBrickcomGenericTests;
import pl.smartapps.containserserver.landevice.brickcom.CameraBrikcomGenericInternal;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraBrickcomGeneric.class})
public class CameraBrikcomGenericReconfigurationTests
extends CameraBrikcomGenericInternal {
    @Test
    public void testReconfigureSuccessfulyWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("2", "10", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "MODERATE", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("3", "20", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "VERY_GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("10", "40", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("20", "60", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithH264VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.MJPEG), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoClipNotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("audio_detection", "ON", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(true, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(true, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithEnabledAlarmVideoClipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("audio_detection", "ON", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(true, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(true, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(true, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(true, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithEnabledAlarmVideoClipAndEnabledMotionDetectionAndDisabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(true, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(true, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithEnabledAlarmVideoClipAndDisabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "ON", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(true, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(true, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOnAndWithWifiWpa2Aes() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("audio_detection", "ON", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("illumination", "ON", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "0", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "1$millennium", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(true), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(true, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(10), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(true, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOffAndWithWifiWpa2Tkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "AD_HOC", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "0", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "1$millennium", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.AD_HOC, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.TKIP, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOffAndWithWifiWpaTkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "0", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "1$millennium", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA, CameraBrickcomGenericTests.Algorithm.TKIP, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiOpen() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep64Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepKeyType.HEX_64, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep128Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepKeyType.HEX_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep64Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepKeyType.ASCII_64, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep128Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithDisabledWifi() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "0", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "1$millennium", "");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("Brickcom", null, -1, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureDownloadsDeviceCapabilities() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.NOACCESS, "00:1A:B6:00:0B:B5"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.ERROR, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureWifiConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAlarmMediaClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAlarmMediaClient);
        Capture configureAlarmMediaUrlCapture = new Capture();
        EasyMock.expect((Object)configureAlarmMediaClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAlarmMediaUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirVideoclipEventClient);
        Capture configurePirVideovlipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirVideovlipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectioVideoclipEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectioVideoclipEventClient);
        Capture configureAudioDetectionVideoclipEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectioVideoclipEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionVideoclipEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAlarmMediaRequest(25), (Capture)configureAlarmMediaUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirVideoclipEventRequest(false, false), (Capture)configurePirVideovlipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionVideoclipEventRequest(false, false), (Capture)configureAudioDetectionVideoclipEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureAudioDetectionEventConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureAudioDetectionSensitivityConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureIlluminationConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailurePirConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureHttpNotificationConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureMotionDetectionEventConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailurePrivacyButtonConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureLedConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioClient);
        Capture configureAudioUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioRequest(), (Capture)configureAudioUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureChannelsConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)this.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30", CameraBrickcomGenericTests.VideoEncoding.H264), (Capture)configureChannelsUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureUsersConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        PowerMock.verifyAll();
    }
}

