/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice.brickcom;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.Before;
import org.powermock.api.easymock.PowerMock;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.SearchWlanAccessPointsService;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandler;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.containserserver.landevice.brickcom.CameraBrickcomGenericTests;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;

public class CameraBrikcomGenericInternal {
    protected CameraBrickcomGeneric cameraBrickcomGeneric;
    protected AuthenticationUtils authUtils;
    protected UpdateSettingsHandlerFactory updateHandlerFactory;
    protected UpdateSettingsHandler updateSettingsHandler;
    protected DeviceDescDAO deviceDescDAO;
    protected ContainerserverServiceFactory serviceFactory;
    protected SearchWlanAccessPointsService searchWlanAccessPointsService;
    protected SystemSupport systemSupport;
    protected ParameterService parameterService;
    protected LanDeviceService lanDeviceService;

    @Before
    public void setUp() {
        this.cameraBrickcomGeneric = new CameraBrickcomGeneric();
        this.cameraBrickcomGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.cameraBrickcomGeneric.setAuthUtils(this.authUtils);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.cameraBrickcomGeneric.setLanDeviceService(this.lanDeviceService);
        this.updateHandlerFactory = (UpdateSettingsHandlerFactory)PowerMock.createMock(UpdateSettingsHandlerFactory.class);
        this.cameraBrickcomGeneric.setUpdateHandlerFactory(this.updateHandlerFactory);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.cameraBrickcomGeneric.setDeviceDescDAO(this.deviceDescDAO);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.cameraBrickcomGeneric.setServiceFactory(this.serviceFactory);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.cameraBrickcomGeneric.setSystemSupport(this.systemSupport);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.cameraBrickcomGeneric.setParameterService(this.parameterService);
        this.updateSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        this.searchWlanAccessPointsService = (SearchWlanAccessPointsService)PowerMock.createMock(SearchWlanAccessPointsService.class);
    }

    protected Map<String, String> prepareDeviceCapabilities(String macAddress, boolean attachViewerUser, String viewerUsername, boolean wifiSupport) {
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("chipVersion", "G");
        deviceCapabilities.put("sensorID", "OV9715");
        deviceCapabilities.put("macAddress", macAddress);
        deviceCapabilities.put("firmwareVersion", "v3.1.0.1");
        deviceCapabilities.put("firmwareReleaseDate", "08/24/2011 15:29");
        deviceCapabilities.put("internalName", "Brickcom");
        deviceCapabilities.put("productName", "WCB-100Ap");
        deviceCapabilities.put("modelNumber", "100");
        deviceCapabilities.put("companyName", "Brickcom Corporation");
        deviceCapabilities.put("comments", "[CUBE HD IPCam Professional][Wireless]");
        deviceCapabilities.put("channels", "2");
        deviceCapabilities.put("videoCodecs", "H264,MJPEG,MPEG4");
        deviceCapabilities.put("audioCodesc", "G711,AMR-NB");
        deviceCapabilities.put("resolutions", "640x400,320x192,640x352,320x176,640x480,320x240");
        deviceCapabilities.put("H264frameRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("MJPEGframeRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("MPEG4frameRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("bitrate", "64,128,256,384,512,768,1000,1500,2000,4000,6000,8000,10000,12000");
        deviceCapabilities.put("Events", "MD,PIR,AD,SCHEDULE");
        deviceCapabilities.put("Event.actions", "SAVESTREAM,SNAPSHOT,EMAIL,HTTP,UDP,MULTICAST,LIGHTLED,SPEAKER");
        deviceCapabilities.put("Event.SaveStreamMethod", "FTP,EMAIL,HTTP,SAMBA,SD");
        deviceCapabilities.put("Event.SnapshotMethod", "FTP,EMAIL,HTTP,SAMBA,SD");
        deviceCapabilities.put("Event.Schedule.SaveStreamMethod", "sd");
        deviceCapabilities.put("ExposureControl", "1");
        deviceCapabilities.put("AutoIris", "0");
        deviceCapabilities.put("IRCut", "0");
        deviceCapabilities.put("IRLED", "0");
        deviceCapabilities.put("ColorEffect", "2");
        deviceCapabilities.put("PrivacyMask", "1");
        deviceCapabilities.put("EasyLink", "1");
        deviceCapabilities.put("Wireless", wifiSupport ? "1" : "0");
        deviceCapabilities.put("ScheduledEvent", "1");
        deviceCapabilities.put("DIDO", "0");
        deviceCapabilities.put("AudioClip", "1");
        deviceCapabilities.put("PIR", "1");
        deviceCapabilities.put("MSNSetting", "0");
        deviceCapabilities.put("StorageManagement", "1");
        deviceCapabilities.put("CH1.enabled", "1");
        deviceCapabilities.put("CH1.name", "H264");
        deviceCapabilities.put("CH1.transportType", "2");
        deviceCapabilities.put("CH1.video.enabled", "1");
        deviceCapabilities.put("CH1.video.format.sourceDevice", "0");
        deviceCapabilities.put("CH1.video.format.codecType", "MJPEG");
        deviceCapabilities.put("CH1.video.format.constantBitrate", "0");
        deviceCapabilities.put("CH1.video.format.bitrateInKbps", "4000");
        deviceCapabilities.put("CH1.video.format.resolutionWidth", "640");
        deviceCapabilities.put("CH1.video.format.resolutionHeight", "400");
        deviceCapabilities.put("CH1.video.format.frameRate", "25");
        deviceCapabilities.put("CH1.video.format.frameRate2", "20");
        deviceCapabilities.put("CH1.video.format.gop", "0");
        deviceCapabilities.put("CH1.video.format.quality", "30");
        deviceCapabilities.put("CH1.video.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.video.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH1.video.transport.multicastPort", "10000");
        deviceCapabilities.put("CH1.video.transport.ttl", "10");
        deviceCapabilities.put("CH1.audio.enabled", "0");
        deviceCapabilities.put("CH1.audio.format.codecType", "G711");
        deviceCapabilities.put("CH1.audio.format.codecSubType", "PCMU");
        deviceCapabilities.put("CH1.audio.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.audio.transport.multicastAddress", "");
        deviceCapabilities.put("CH1.audio.transport.multicastPort", "10002");
        deviceCapabilities.put("CH1.audio.transport.ttl", "10");
        deviceCapabilities.put("CH1.meta.enabled", "1");
        deviceCapabilities.put("CH1.meta.format.mdAlarmEnabled", "0");
        deviceCapabilities.put("CH1.meta.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.meta.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH1.meta.transport.multicastPort", "10004");
        deviceCapabilities.put("CH1.meta.transport.ttl", "10");
        deviceCapabilities.put("CH2.enabled", "1");
        deviceCapabilities.put("CH2.name", "MJPEG");
        deviceCapabilities.put("CH2.transportType", "2");
        deviceCapabilities.put("CH2.video.enabled", "1");
        deviceCapabilities.put("CH2.video.format.sourceDevice", "0");
        deviceCapabilities.put("CH2.video.format.codecType", "MJPEG");
        deviceCapabilities.put("CH2.video.format.constantBitrate", "0");
        deviceCapabilities.put("CH2.video.format.bitrateInKbps", "64");
        deviceCapabilities.put("CH2.video.format.resolutionWidth", "640");
        deviceCapabilities.put("CH2.video.format.resolutionHeight", "400");
        deviceCapabilities.put("CH2.video.format.frameRate", "25");
        deviceCapabilities.put("CH2.video.format.frameRate2", "20");
        deviceCapabilities.put("CH2.video.format.gop", "0");
        deviceCapabilities.put("CH2.video.format.quality", "30");
        deviceCapabilities.put("CH2.video.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.video.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH2.video.transport.multicastPort", "20000");
        deviceCapabilities.put("CH2.video.transport.ttl", "10");
        deviceCapabilities.put("CH2.audio.enabled", "0");
        deviceCapabilities.put("CH2.audio.format.codecType", "G711");
        deviceCapabilities.put("CH2.audio.format.codecSubType", "PCMU");
        deviceCapabilities.put("CH2.audio.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.audio.transport.multicastAddress", "");
        deviceCapabilities.put("CH2.audio.transport.multicastPort", "20002");
        deviceCapabilities.put("CH2.audio.transport.ttl", "10");
        deviceCapabilities.put("CH2.meta.enabled", "1");
        deviceCapabilities.put("CH2.meta.format.mdAlarmEnabled", "0");
        deviceCapabilities.put("CH2.meta.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.meta.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH2.meta.transport.multicastPort", "20004");
        deviceCapabilities.put("CH2.meta.transport.ttl", "10");
        deviceCapabilities.put("size", "4");
        deviceCapabilities.put("User1.index", "1");
        deviceCapabilities.put("User1.username", "admin");
        deviceCapabilities.put("User1.password", "admin");
        deviceCapabilities.put("User1.privilege", "1");
        deviceCapabilities.put("User2.index", "2");
        deviceCapabilities.put("User2.username", "viewer");
        deviceCapabilities.put("User2.password", "viewer");
        deviceCapabilities.put("User2.privilege", "0");
        deviceCapabilities.put("User3.index", "3");
        deviceCapabilities.put("User3.username", "rviewer");
        deviceCapabilities.put("User3.password", "rviewer");
        deviceCapabilities.put("User3.privilege", "2");
        if (attachViewerUser) {
            deviceCapabilities.put("User4.index", "4");
            deviceCapabilities.put("User4.username", viewerUsername);
            deviceCapabilities.put("User4.password", "OmKMqWmPu1");
            deviceCapabilities.put("User4.privilege", "0");
        }
        return deviceCapabilities;
    }

    protected HTTPClientServiceResult preparePostResponse(HTTPClientServiceResult.Result result, boolean correct) {
        StringBuilder postResponseBody = new StringBuilder();
        postResponseBody.append("statusCode=").append(correct ? "0" : "1").append("\n");
        return this.prepareResponse(result, postResponseBody);
    }

    protected HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, StringBuilder body) {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(result);
        if (body != null) {
            response.setBody(body.toString().getBytes());
        }
        return response;
    }

    protected LanDeviceEntity prepareDeviceForFailureReconfigurationTests() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setVideoEncoding("H264");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUser", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUser", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("audio_detection", "OFF", "");
        device.setParam("audio_detection_sensitivity", "50", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("illumination", "OFF", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("videoclip_duration", "30", "30");
        device.setParam("max_videoclip_duration", "30");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "", "");
        return device;
    }

    protected void downloadDeviceCapabilities() throws MalformedURLException {
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService channelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)channelsClient);
        URL channelsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?action=get");
        EasyMock.expect((Object)channelsClient.get("00:1A:B6:00:0B:B5", channelsUrl)).andReturn((Object)this.prepareChannelsResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService usersClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)usersClient);
        URL usersUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?action=getUsers");
        EasyMock.expect((Object)usersClient.get("00:1A:B6:00:0B:B5", usersUrl)).andReturn((Object)this.prepareUsersResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5", true));
    }

    protected HTTPClientServiceResult prepareSystemResponse(HTTPClientServiceResult.Result result, String macAddress) {
        StringBuilder systemResponseBody = new StringBuilder();
        systemResponseBody.append("chipVersion=G").append("\n");
        systemResponseBody.append("sensorID=OV9715").append("\n");
        systemResponseBody.append("macAddress=").append(macAddress).append("\n");
        systemResponseBody.append("firmwareVersion=v3.1.0.1").append("\n");
        systemResponseBody.append("firmwareReleaseDate=08/24/2011 15:29").append("\n");
        systemResponseBody.append("internalName=Brickcom").append("\n");
        systemResponseBody.append("productName=WCB-100Ap").append("\n");
        systemResponseBody.append("modelNumber=100").append("\n");
        systemResponseBody.append("companyName=Brickcom Corporation").append("\n");
        systemResponseBody.append("comments=[CUBE HD IPCam Professional][Wireless]").append("\n");
        return this.prepareResponse(result, systemResponseBody);
    }

    protected HTTPClientServiceResult prepareCapabilitiesResponse(HTTPClientServiceResult.Result result) {
        StringBuilder capabilitiesResponseBody = new StringBuilder();
        capabilitiesResponseBody.append("[media]").append("\n");
        capabilitiesResponseBody.append("channels=2").append("\n");
        capabilitiesResponseBody.append("videoCodecs=H264,MJPEG,MPEG4").append("\n");
        capabilitiesResponseBody.append("audioCodesc=G711,AMR-NB").append("\n");
        capabilitiesResponseBody.append("resolutions=640x400,320x192,640x352,320x176,640x480,320x240").append("\n");
        capabilitiesResponseBody.append("H264frameRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("MJPEGframeRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("MPEG4frameRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("bitrate=64,128,256,384,512,768,1000,1500,2000,4000,6000,8000,10000,12000").append("\n");
        capabilitiesResponseBody.append("Events=MD,PIR,AD,SCHEDULE").append("\n");
        capabilitiesResponseBody.append("Event.actions=SAVESTREAM,SNAPSHOT,EMAIL,HTTP,UDP,MULTICAST,LIGHTLED,SPEAKER").append("\n");
        capabilitiesResponseBody.append("Event.SaveStreamMethod=FTP,EMAIL,HTTP,SAMBA,SD").append("\n");
        capabilitiesResponseBody.append("Event.SnapshotMethod=FTP,EMAIL,HTTP,SAMBA,SD").append("\n");
        capabilitiesResponseBody.append("Event.Schedule.SaveStreamMethod=sd").append("\n");
        return this.prepareResponse(result, capabilitiesResponseBody);
    }

    protected HTTPClientServiceResult prepareFeatureResponse(HTTPClientServiceResult.Result result) {
        StringBuilder featureResponseBody = new StringBuilder();
        featureResponseBody.append("ExposureControl=1").append("\n");
        featureResponseBody.append("AutoIris=0").append("\n");
        featureResponseBody.append("IRCut=0").append("\n");
        featureResponseBody.append("IRLED=0").append("\n");
        featureResponseBody.append("ColorEffect=2").append("\n");
        featureResponseBody.append("PrivacyMask=1").append("\n");
        featureResponseBody.append("EasyLink=1").append("\n");
        featureResponseBody.append("Wireless=1").append("\n");
        featureResponseBody.append("ScheduledEvent=1").append("\n");
        featureResponseBody.append("DIDO=0").append("\n");
        featureResponseBody.append("AudioClip=1").append("\n");
        featureResponseBody.append("PIR=1").append("\n");
        featureResponseBody.append("MSNSetting=0").append("\n");
        featureResponseBody.append("StorageManagement=1").append("\n");
        return this.prepareResponse(result, featureResponseBody);
    }

    protected HTTPClientServiceResult prepareChannelsResponse(HTTPClientServiceResult.Result result) {
        StringBuilder channelsResponseBody = new StringBuilder();
        channelsResponseBody.append("size = 2").append("\n");
        channelsResponseBody.append("CH1.enabled=1").append("\n");
        channelsResponseBody.append("CH1.name=H264").append("\n");
        channelsResponseBody.append("CH1.transportType=2").append("\n");
        channelsResponseBody.append("CH1.video.enabled=1").append("\n");
        channelsResponseBody.append("CH1.video.format.sourceDevice=0").append("\n");
        channelsResponseBody.append("CH1.video.format.codecType=MJPEG").append("\n");
        channelsResponseBody.append("CH1.video.format.constantBitrate=0").append("\n");
        channelsResponseBody.append("CH1.video.format.bitrateInKbps=4000").append("\n");
        channelsResponseBody.append("CH1.video.format.resolutionWidth=640").append("\n");
        channelsResponseBody.append("CH1.video.format.resolutionHeight=400").append("\n");
        channelsResponseBody.append("CH1.video.format.frameRate=25").append("\n");
        channelsResponseBody.append("CH1.video.format.frameRate2=20").append("\n");
        channelsResponseBody.append("CH1.video.format.gop=0").append("\n");
        channelsResponseBody.append("CH1.video.format.quality=30").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastPort=10000").append("\n");
        channelsResponseBody.append("CH1.video.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH1.audio.enabled=0").append("\n");
        channelsResponseBody.append("CH1.audio.format.codecType=G711").append("\n");
        channelsResponseBody.append("CH1.audio.format.codecSubType=PCMU").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastAddress=").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastPort=10002").append("\n");
        channelsResponseBody.append("CH1.audio.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH1.meta.enabled=1").append("\n");
        channelsResponseBody.append("CH1.meta.format.mdAlarmEnabled=0").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastPort=10004").append("\n");
        channelsResponseBody.append("CH1.meta.transport.ttl=10").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("CH2.enabled=1").append("\n");
        channelsResponseBody.append("CH2.name=MJPEG").append("\n");
        channelsResponseBody.append("CH2.transportType=2").append("\n");
        channelsResponseBody.append("CH2.video.enabled=1").append("\n");
        channelsResponseBody.append("CH2.video.format.sourceDevice=0").append("\n");
        channelsResponseBody.append("CH2.video.format.codecType=MJPEG").append("\n");
        channelsResponseBody.append("CH2.video.format.constantBitrate=0").append("\n");
        channelsResponseBody.append("CH2.video.format.bitrateInKbps=64").append("\n");
        channelsResponseBody.append("CH2.video.format.resolutionWidth=640").append("\n");
        channelsResponseBody.append("CH2.video.format.resolutionHeight=400").append("\n");
        channelsResponseBody.append("CH2.video.format.frameRate=25").append("\n");
        channelsResponseBody.append("CH2.video.format.frameRate2=20").append("\n");
        channelsResponseBody.append("CH2.video.format.gop=0").append("\n");
        channelsResponseBody.append("CH2.video.format.quality=30").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastPort=20000").append("\n");
        channelsResponseBody.append("CH2.video.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH2.audio.enabled=0").append("\n");
        channelsResponseBody.append("CH2.audio.format.codecType=G711").append("\n");
        channelsResponseBody.append("CH2.audio.format.codecSubType=PCMU").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastAddress=").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastPort=20002").append("\n");
        channelsResponseBody.append("CH2.audio.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH2.meta.enabled=1").append("\n");
        channelsResponseBody.append("CH2.meta.format.mdAlarmEnabled=0").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastPort=20004").append("\n");
        channelsResponseBody.append("CH2.meta.transport.ttl=10").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        return this.prepareResponse(result, channelsResponseBody);
    }

    protected HTTPClientServiceResult prepareUsersResponse(HTTPClientServiceResult.Result result, String macAddress, boolean attachViewerUser) {
        StringBuilder usersResponseBody = new StringBuilder();
        usersResponseBody.append("size=4").append("\n");
        usersResponseBody.append("User1.index=1").append("\n");
        usersResponseBody.append("User1.username=admin").append("\n");
        usersResponseBody.append("User1.password=admin").append("\n");
        usersResponseBody.append("User1.privilege=1").append("\n");
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("User2.index=2").append("\n");
        usersResponseBody.append("User2.username=viewer").append("\n");
        usersResponseBody.append("User2.password=viewer").append("\n");
        usersResponseBody.append("User2.privilege=0").append("\n");
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("User3.index=3").append("\n");
        usersResponseBody.append("User3.username=rviewer").append("\n");
        usersResponseBody.append("User3.password=rviewer").append("\n");
        usersResponseBody.append("User3.privilege=2").append("\n");
        usersResponseBody.append("").append("\n");
        if (attachViewerUser) {
            usersResponseBody.append("User4.index=4").append("\n");
            usersResponseBody.append("User4.username=").append(macAddress.replace(":", "")).append("\n");
            usersResponseBody.append("User4.password=OmKMqWmPu1").append("\n");
            usersResponseBody.append("User4.privilege=0").append("\n");
        }
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("").append("\n");
        return this.prepareResponse(result, usersResponseBody);
    }

    protected DeviceDescEntity prepareDeviceDescEntity() {
        DeviceDescEntity deviceDesc = new DeviceDescEntity();
        deviceDesc.setDeviceDescId(Integer.valueOf(1));
        deviceDesc.setClassDevice("camera");
        deviceDesc.setMake("Brickcom");
        deviceDesc.setModel("WCB-100Ap");
        deviceDesc.setDriverclass("CameraBrickcomGeneric");
        return deviceDesc;
    }

    protected String prepareViewerUserRequest(boolean register, String index, String username, String password) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?");
        request.append("action=").append(register ? "add" : "update");
        request.append("&index=").append(index);
        request.append("&username=").append(username);
        request.append("&password=").append(password);
        request.append("&privilege=0");
        return request.toString();
    }

    protected String prepareConfigrationChannelRequest(String fps, String quality, CameraBrickcomGenericTests.VideoEncoding videoEncoding) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?");
        request.append("action=updateAll");
        request.append("&apply=1");
        request.append("&c1Enable=1");
        request.append("&c1VideoFormatCodecType=").append(videoEncoding.name());
        request.append("&c1VideoFormatResolutionWidth=640");
        request.append("&c1VideoFormatResolutionHeight=480");
        request.append("&c1VideoFormatFrameRate=").append(fps);
        request.append("&c1VideoFormatQuality=").append(quality);
        request.append("&c1VideoFormatConstantBitrate=0");
        request.append("&c2Enable=1");
        request.append("&c2VideoFormatCodecType=").append(videoEncoding.name());
        request.append("&c2VideoFormatResolutionWidth=320");
        request.append("&c2VideoFormatResolutionHeight=240");
        request.append("&c2VideoFormatFrameRate=").append(fps);
        request.append("&c2VideoFormatQuality=").append(quality);
        request.append("&c2VideoFormatConstantBitrate=0");
        if (videoEncoding == CameraBrickcomGenericTests.VideoEncoding.MJPEG) {
            request.append("&c1TransportType=2");
            request.append("&c2TransportType=2");
        } else {
            request.append("&c1TransportType=0");
            request.append("&c1VideoFormatCQT=0");
            request.append("&c1VideoFormatGop=0");
            request.append("&c2TransportType=0");
            request.append("&c2VideoFormatCQT=0");
            request.append("&c2VideoFormatGop=0");
        }
        return request.toString();
    }

    protected String prepareConfigrationAudioRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?");
        request.append("action=updateAll");
        request.append("&c1AudioEnabled=0");
        request.append("&c1AudioFormatCodecType=G711");
        request.append("&c1AudioFormatCodecSubType=PCMU");
        request.append("&c2AudioEnabled=0");
        request.append("&c2AudioFormatCodecType=G711");
        request.append("&c2AudioFormatCodecSubType=PCMU");
        return request.toString();
    }

    protected String prepareConfigrationLedRequest(boolean off) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?");
        request.append("action=set");
        request.append("&off=").append(off ? "1" : "0");
        return request.toString();
    }

    protected String prepareConfigrationPrivacyButtonRequest(boolean enabled) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/camera.cgi?");
        request.append("action=setPrivacy");
        request.append("&privacyButtonEnabled=").append(enabled ? "1" : "0");
        return request.toString();
    }

    protected String prepareConfigrationHttpNotificationsRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=setHttp");
        request.append("&HttpUrl=http://homemonitor.ch:8080/app/events/motion/brickcom");
        request.append("&username=alarmUser");
        request.append("&password=alarmPassword");
        request.append("&Message=id=00:1A:B6:00:0B:B5");
        return request.toString();
    }

    protected String prepareConfigrationPirSensorRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/pirsensor.cgi?");
        request.append("action=set");
        request.append("&enabled=0");
        request.append("&sensitivity=10");
        return request.toString();
    }

    protected String prepareConfigrationMotionDetectionEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_PIR");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=PIR");
        request.append("&actions=SNAPSHOT:HTTP");
        return request.toString();
    }

    protected String prepareConfigrationIlluminationRequest(int level) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?");
        request.append("action=set");
        request.append("&method=1");
        request.append("&apply=1");
        request.append("&level=").append(String.valueOf(level));
        return request.toString();
    }

    protected String prepareConfigrationAudioDetectionVideoclipEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_AD2");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=AD");
        request.append("&actions=SNAPSHOT:HTTP,SAVESTREAM:HTTP");
        return request.toString();
    }

    protected String prepareConfigurationAudioDetectionSensitivityRequest(Integer sensitivity) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/audio.cgi?");
        request.append("action=setAudioDetection");
        request.append("&sensitivity=").append(sensitivity);
        return request.toString();
    }

    protected String prepareConfigrationAudioDetectionEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_AD");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=AD");
        request.append("&actions=SNAPSHOT:HTTP");
        return request.toString();
    }

    protected String prepareConfigrationTimeRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/time.cgi?");
        request.append("action=set");
        request.append("&type=2");
        request.append("&timezoneID=13");
        request.append("&ntp.ntpServerLoc1=ntp.homemonitor.ch");
        request.append("&ntp.ntpServerLoc2=clock.stdtime.gov.tw");
        request.append("&enableDST=0");
        return request.toString();
    }

    protected String prepareConfigrationAlarmMediaRequest(int afterEventDuration) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=setAlarmMediaInfo");
        request.append("&timeBeforeEvent=5");
        request.append("&timeAfterEvent=").append(String.valueOf(afterEventDuration));
        request.append("&maxBufferSize=6144");
        request.append("&snapshotPreAlarm=0");
        request.append("&snapshotPostAlarm=1");
        return request.toString();
    }

    protected String prepareConfigrationPirVideoclipEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_PIR2");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=PIR");
        request.append("&actions=SNAPSHOT:HTTP,SAVESTREAM:HTTP");
        return request.toString();
    }

    protected String prepareConfigurationWifiRequest(String ssid, CameraBrickcomGenericTests.WlanMode wlanMode, int channel, CameraBrickcomGenericTests.Encryption encryption, CameraBrickcomGenericTests.Algorithm algorithm, String sharedKey, CameraBrickcomGenericTests.WepKeyType wepKeyType, String key1, String key2, String key3, String key4, int keyIndex) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        request.append("action=set");
        request.append("&SSID=").append(ssid);
        if (wlanMode != null) {
            request.append("&mode=").append(wlanMode.getCode());
        }
        if (channel != -1) {
            request.append("&channel=").append(String.valueOf(channel));
        }
        request.append("&securityMode=").append(encryption.getCode());
        if (encryption != CameraBrickcomGenericTests.Encryption.OPEN) {
            if (encryption == CameraBrickcomGenericTests.Encryption.WEP) {
                request.append("&WEP.wepKeyLength=").append(wepKeyType.getCode());
                request.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=").append(key1);
                request.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=").append(key2);
                request.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=").append(key3);
                request.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=").append(key4);
                request.append("&WEP.defaultTransmitKeyIndex=").append(keyIndex);
                request.append("&WEP.authenticationType=0");
            } else {
                request.append("&WPA.algorithmType=").append(algorithm.getCode());
                request.append("&WPA.sharedKey=").append(sharedKey);
            }
        }
        return request.toString();
    }

    protected HTTPClientServiceResult prepareDeviceConfigResponse(String viewerUsername, String viewerPassword, String alarmUser, String alarmPassword, String videoFps, String videoQuality, CameraBrickcomGenericTests.VideoEncoding videoEncoding, String transportType, boolean privacyButtonEnabled, boolean motionDetectionEnabled, boolean audioDetectionEnabled, boolean motionDetectionVideoclipEnabled, boolean audioDetectionVideoclipEnabled, int postAlarmInterval, boolean ledOff, int illuminationLevel, int audioDetectionSensitivity, String ssid, CameraBrickcomGenericTests.WlanMode wlanMode, int channel, CameraBrickcomGenericTests.Encryption encryption, CameraBrickcomGenericTests.Algorithm algorithm, String wpaPass, CameraBrickcomGenericTests.WepAuthenticationType wepAuthenticationType, CameraBrickcomGenericTests.WepKeyType wepKeyType, String key1, String key2, String key3, String key4, int keyIndex, HTTPClientServiceResult.Result result) {
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("WCB-100Ap").append("\n");
        responseBody.append("UserSetSetting.userList.size=4").append("\n");
        responseBody.append("UserSetSetting.userList.users0.index=1").append("\n");
        responseBody.append("UserSetSetting.userList.users0.password=admin").append("\n");
        responseBody.append("UserSetSetting.userList.users0.privilege=1").append("\n");
        responseBody.append("UserSetSetting.userList.users0.username=admin").append("\n");
        responseBody.append("UserSetSetting.userList.users1.index=2").append("\n");
        responseBody.append("UserSetSetting.userList.users1.password=viewer").append("\n");
        responseBody.append("UserSetSetting.userList.users1.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users1.username=viewer").append("\n");
        responseBody.append("UserSetSetting.userList.users2.index=3").append("\n");
        responseBody.append("UserSetSetting.userList.users2.password=rviewer").append("\n");
        responseBody.append("UserSetSetting.userList.users2.privilege=2").append("\n");
        responseBody.append("UserSetSetting.userList.users2.username=rviewer").append("\n");
        responseBody.append("UserSetSetting.userList.users3.index=4").append("\n");
        responseBody.append("UserSetSetting.userList.users3.password=").append(viewerPassword).append("\n");
        responseBody.append("UserSetSetting.userList.users3.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users3.username=").append(viewerUsername).append("\n");
        responseBody.append("UserSetSetting.userList.users4.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users4.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users4.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users4.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users5.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users5.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users5.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users5.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users6.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users6.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users6.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users6.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users7.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users7.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users7.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users7.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users8.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users8.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users8.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users8.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users9.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users9.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users9.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users9.username=").append("\n");
        responseBody.append("PrivacySetting.ButtonEnabled=").append(privacyButtonEnabled ? "1" : "0").append("\n");
        responseBody.append("WIFISetting.channel=").append(String.valueOf(channel)).append("\n");
        responseBody.append("WIFISetting.mode=").append(wlanMode.getCode()).append("\n");
        responseBody.append("WIFISetting.SSID=").append(ssid).append("\n");
        responseBody.append("WIFISetting.securityMode=").append(encryption.getCode()).append("\n");
        if (encryption == CameraBrickcomGenericTests.Encryption.WEP) {
            responseBody.append("WIFISetting.WEP.authenticationType=").append(wepAuthenticationType.getCode()).append("\n");
            responseBody.append("WIFISetting.WEP.defaultTransmitKeyIndex=").append(keyIndex).append("\n");
            responseBody.append("WIFISetting.WEP.wepKeyLength=").append(wepKeyType.getCode()).append("\n");
            System.out.println("adding key 0");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry0.encryptionKey=").append(key1).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry1.encryptionKey=").append(key2).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry2.encryptionKey=").append(key3).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry3.encryptionKey=").append(key4).append("\n");
        } else if (encryption == CameraBrickcomGenericTests.Encryption.WPA || encryption == CameraBrickcomGenericTests.Encryption.WPA2) {
            responseBody.append("WIFISetting.WPA.algorithmType=").append(algorithm.getCode()).append("\n");
            responseBody.append("WIFISetting.WPA.sharedKey=").append(wpaPass).append("\n");
        }
        responseBody.append("ChannelSetSetting.channelList.size=2").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.enabled=1").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.transportType=").append(transportType).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.codecType=").append(videoEncoding.name()).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.constantBitrate=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.frameRate=").append(videoFps).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.resolutionHeight=480").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.resolutionWidth=640").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.quality=").append(videoQuality).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.gop=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.customQt=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.enabled=1").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.transportType=").append(transportType).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.codecType=").append(videoEncoding.name()).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.constantBitrate=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.frameRate=").append(videoFps).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.resolutionHeight=240").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.resolutionWidth=320").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.quality=").append(videoQuality).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.gop=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.customQt=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.audio.enabled=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.audio.format.codecType=G711").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.audio.format.codecSubType=PCMU").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.audio.enabled=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.audio.format.codecType=G711").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.audio.format.codecSubType=PCMU").append("\n");
        responseBody.append("TimeSetting.type=2").append("\n");
        responseBody.append("TimeSetting.enableDST=0").append("\n");
        responseBody.append("TimeSetting.manual.year=2012").append("\n");
        responseBody.append("TimeSetting.manual.month=1").append("\n");
        responseBody.append("TimeSetting.manual.day=4").append("\n");
        responseBody.append("TimeSetting.manual.hour=11").append("\n");
        responseBody.append("TimeSetting.manual.minute=27").append("\n");
        responseBody.append("TimeSetting.manual.second=38").append("\n");
        responseBody.append("TimeSetting.timezoneID=13").append("\n");
        responseBody.append("TimeSetting.ntp.ntpServerLoc1=ntp.homemonitor.ch").append("\n");
        responseBody.append("TimeSetting.ntp.ntpServerLoc2=clock.stdtime.gov.tw").append("\n");
        responseBody.append("EmailSetting.primary.accountName=").append(alarmUser).append("\n");
        responseBody.append("EmailSetting.primary.authenticationMode=0").append("\n");
        responseBody.append("EmailSetting.primary.password=").append(alarmPassword).append("\n");
        responseBody.append("EmailSetting.primary.portNo=25").append("\n");
        responseBody.append("EmailSetting.primary.smtpServerHostName=homemonitor.ch").append("\n");
        responseBody.append("EmailSetting.secondary.accountName=").append("\n");
        responseBody.append("EmailSetting.secondary.authenticationMode=0").append("\n");
        responseBody.append("EmailSetting.secondary.password=").append("\n");
        responseBody.append("EmailSetting.secondary.portNo=25").append("\n");
        responseBody.append("EmailSetting.secondary.smtpServerHostName=").append("\n");
        responseBody.append("Event.ruleList.size=2").append("\n");
        responseBody.append("Event.ruleList.cEntry0.actions=SNAPSHOT:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry0.enabled=").append(motionDetectionEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry0.eventName=PIR").append("\n");
        responseBody.append("Event.ruleList.cEntry0.token=HOMEMONITOR_PIR").append("\n");
        responseBody.append("Event.ruleList.cEntry0.sched.type=0").append("\n");
        responseBody.append("Event.ruleList.cEntry0.sched.time=").append("\n");
        responseBody.append("Event.ruleList.cEntry1.actions=SNAPSHOT:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry1.enabled=").append(audioDetectionEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry1.eventName=AD").append("\n");
        responseBody.append("Event.ruleList.cEntry1.token=HOMEMONITOR_AD").append("\n");
        responseBody.append("Event.ruleList.cEntry1.sched.type=0").append("\n");
        responseBody.append("Event.ruleList.cEntry2.actions=SNAPSHOT:HTTP,SAVESTREAM:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry2.enabled=").append(motionDetectionVideoclipEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry2.eventName=PIR").append("\n");
        responseBody.append("Event.ruleList.cEntry2.token=HOMEMONITOR_PIR2").append("\n");
        responseBody.append("Event.ruleList.cEntry2.sched.type=0").append("\n");
        responseBody.append("Event.ruleList.cEntry3.actions=SNAPSHOT:HTTP,SAVESTREAM:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry3.enabled=").append(audioDetectionVideoclipEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry3.eventName=AD").append("\n");
        responseBody.append("Event.ruleList.cEntry3.token=HOMEMONITOR_AD2").append("\n");
        responseBody.append("Event.ruleList.cEntry3.sched.type=0").append("\n");
        responseBody.append("AlarmMediaInfo.snapShotEnabled=1").append("\n");
        responseBody.append("AlarmMediaInfo.videoClipEnabled=1").append("\n");
        responseBody.append("AlarmMediaInfo.preAlarmInterval=5").append("\n");
        responseBody.append("AlarmMediaInfo.postAlarmInterval=").append(postAlarmInterval).append("\n");
        responseBody.append("AlarmMediaInfo.snapshotPreAlarm=0").append("\n");
        responseBody.append("AlarmMediaInfo.snapshotPostAlarm=1").append("\n");
        responseBody.append("AlarmMediaInfo.maxBufferSize=6144").append("\n");
        responseBody.append("AlarmMediaInfo.chIndexToRecord=1").append("\n");
        responseBody.append("EventHttp.transport.destURL=http://homemonitor.ch:8080/app/events/motion/brickcom").append("\n");
        responseBody.append("EventHttp.transport.destMsg=id=00:02:D1:06:CD:80").append("\n");
        responseBody.append("EventHttp.transport.username=").append(alarmUser).append("\n");
        responseBody.append("EventHttp.transport.password=").append(alarmPassword).append("\n");
        responseBody.append("LEDSetting.level=0").append("\n");
        responseBody.append("LEDSetting.off=").append(ledOff ? "1" : "0").append("\n");
        responseBody.append("PIRSensor.sensitivity=10").append("\n");
        responseBody.append("PIRSensor.enabled=0").append("\n");
        responseBody.append("LightCTL.level=").append(String.valueOf(illuminationLevel)).append("\n");
        responseBody.append("LightCTL.method=1").append("\n");
        responseBody.append("AudioDetection.enabled=0").append("\n");
        responseBody.append("AudioDetection.sensitivity=").append(String.valueOf(audioDetectionSensitivity)).append("\n");
        responseBody.append("END").append("\n");
        return this.prepareResponse(result, responseBody);
    }
}

