/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice.brickcom;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.containserserver.landevice.brickcom.CameraBrickcomGenericTests;
import pl.smartapps.containserserver.landevice.brickcom.CameraBrikcomGenericInternal;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraBrickcomGeneric.class})
public class CameraBrickcomGenericCheckConfigurationTests
extends CameraBrikcomGenericInternal {
    @Test
    public void testCheckConfigurationTestConfigurationIncorrectForNullVideo() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "10", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "10", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoFpsForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "10", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "1", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "20", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIorrectVideoFpsForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "20", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationinCorrectVideoQualityForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "2", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoFpsForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "3", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "40", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationInorrectVideoFpsForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "40", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "4", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "20", "60", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationInorrectVideoFpsForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "60", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationincorrectVideoQualityForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "20", "6", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForH264VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectH264VideoEncodingCodeType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", CameraBrickcomGenericTests.VideoEncoding.MJPEG, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectH264VideoEncodingTransportType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "2", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.MJPEG, "2", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectMjpegVideoEncodingCodeType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "2", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectMjpegVideoEncodingTransportType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", CameraBrickcomGenericTests.VideoEncoding.MJPEG, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoClipNotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, true, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoClipNotSupportedByMissingParam() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, true, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForEnabledAlarmVideoclipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, true, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectMotionDetectionVideoclipForEnabledAlarmVideoclipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectAudioDetectionVideoclipForEnabledAlarmVideoclipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, true, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectMotionDetectionVideoclipForDisabledAlarmVideoclipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectAudioDetectionVideoclipForDisabledAlarmVideoclipAndEnabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, true, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForEnabledAlarmVideoclipAndEnabledMotionDetectionAndDisabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, false, true, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForEnabledAlarmVideoclipAndDisabledMotionDetectionAndEnabledAudioDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoClipDuration() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, true, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationInorrectForVideoClipDuration() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, true, 24, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpa2AesWithInfrastructureWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpa2TkipWithAdhocWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.AD_HOC, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.TKIP, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpaTkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA, CameraBrickcomGenericTests.Algorithm.TKIP, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep64Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, null, CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.HEX_64, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep64Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_64, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep128Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.HEX_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep128Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiDisabled() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "Brickcom", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.OPEN, null, null, null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectPrivacyButtonOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectPrivacyButtonOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", false, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectLedoffOnOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", false, true, true, false, false, 25, false, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectLedoffOnOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", false, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectViewerUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlarmUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlarmPassword() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectMotionDetectionOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectMotionDetectionOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectIlluminationOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectIlluminationOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, false, true, false, false, 25, true, 10, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, false, false, false, 25, true, 10, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionSensitivity() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectSsid() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlgorithm() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectSharedKey() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium2", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 10, 3, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WPA2, CameraBrickcomGenericTests.Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectAuthMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"AUTO", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectKeyLength() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectKeyType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key11", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key22", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key33", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key44", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKeyIndex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("H264");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"has_videoclip_recording", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_video_clip", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"videoclip_duration", (String)"30", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", CameraBrickcomGenericTests.VideoEncoding.H264, "0", true, true, true, false, false, 25, true, 0, 5, "smart-apps", CameraBrickcomGenericTests.WlanMode.INFRASTRUCTURE, 0, CameraBrickcomGenericTests.Encryption.WEP, null, "", CameraBrickcomGenericTests.WepAuthenticationType.OPEN, CameraBrickcomGenericTests.WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }
}

