/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.allen_sauer.gwt.log.client.Log;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandler;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.UpdatedSettingsListener;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekSettings;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekSettings.class})
public class CameraVivotekSettingsTests {
    private CameraVivotekSettings vivotekSettings;
    private LanDeviceService lanDeviceService;
    private UpdateSettingsHandlerFactory updateSettingsHandlerFactory;
    private LanDeviceEntity device;
    private HTTPClientService httpClientService;
    private ContainerserverServiceFactory serviceFactory;

    @Before
    public void setUp() {
        this.vivotekSettings = new CameraVivotekSettings();
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.vivotekSettings.setLanDeviceService(this.lanDeviceService);
        this.updateSettingsHandlerFactory = (UpdateSettingsHandlerFactory)PowerMock.createMock(UpdateSettingsHandlerFactory.class);
        this.vivotekSettings.setUpdateHandlerFactory(this.updateSettingsHandlerFactory);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.vivotekSettings.setServiceFactory(this.serviceFactory);
        this.httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        this.device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        this.device.setParam("viewer_user", "viewer", "viewer");
        this.device.setParam("viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.device.setParam("wireless_ssid", "default", "default");
        this.device.setParam("system_ledoff", "ON", "OFF");
        this.device.setParam("privacy_button", "OFF", "ON");
        this.device.setParam("motion_detection", "ON", "OFF");
        this.device.setParam("alarm_limit", "15", "15");
        this.device.setParam("record_video", "OFF", "OFF");
        this.device.setParam("video_recording_duration", "30", "30");
        this.device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        this.device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
    }

    @Test
    public void testUpdateSomeParams() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewer", "viewer");
        device.setParam("viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        device.setParam("wifi_ssid", "default", "default");
        device.setParam("system_ledoff", "ON", "OFF");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_limit", "5", "10");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "30", "30");
        device.setParam("email_notification_0", "q1@mail.com", "q1@mail.com");
        device.setParam("email_notification_1", "q2@mail.com", "q2@mail.com");
        String agregatedUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi?system_ledoff=1&event_i0_delay=720&event_i1_delay=720";
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity alarmLimitParam = new LanDeviceParamEntity("alarm_limit", "5", "10");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{ledOffParam, alarmLimitParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity();
        privacyButtonParam.setName("privacy_button");
        privacyButtonParam.setValue("OFF");
        privacyButtonParam.setRemoteValue("ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAcceptableVideoQualityForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "ACCEPTABLE", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mjpeg_maxframe=2");
        agregatedUrl.append("&videoin_c0_s0_mjpeg_quant=1");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_maxframe=2");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_quant=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "ACCEPTABLE", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateModetateVideoQualityForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "MODERATE", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mjpeg_maxframe=3");
        agregatedUrl.append("&videoin_c0_s0_mjpeg_quant=2");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_maxframe=3");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_quant=2");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "MODERATE", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGoodVideoQualityForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "GOOD", "BEST");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mjpeg_maxframe=5");
        agregatedUrl.append("&videoin_c0_s0_mjpeg_quant=3");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_maxframe=5");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_quant=3");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "GOOD", "BEST");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateVeryGoodVideoQualityForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "VERY_GOOD", "BEST");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mjpeg_maxframe=10");
        agregatedUrl.append("&videoin_c0_s0_mjpeg_quant=4");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_maxframe=10");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_quant=4");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "VERY_GOOD", "BEST");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateBestVideoQualityForMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "BEST", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mjpeg_maxframe=20");
        agregatedUrl.append("&videoin_c0_s0_mjpeg_quant=5");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_maxframe=20");
        agregatedUrl.append("&videoin_c0_s1_mjpeg_quant=5");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "BEST", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAcceptableVideoQualityForMpeg4VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "ACCEPTABLE", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mpeg4_maxframe=2");
        agregatedUrl.append("&videoin_c0_s0_mpeg4_quant=1");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_maxframe=2");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_quant=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "ACCEPTABLE", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateModetateVideoQualityForMpeg4VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "MODERATE", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mpeg4_maxframe=3");
        agregatedUrl.append("&videoin_c0_s0_mpeg4_quant=2");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_maxframe=3");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_quant=2");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "MODERATE", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateGoodVideoQualityForMpeg4VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "GOOD", "BEST");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mpeg4_maxframe=5");
        agregatedUrl.append("&videoin_c0_s0_mpeg4_quant=3");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_maxframe=5");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_quant=3");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "GOOD", "BEST");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateVeryGoodVideoQualityForMpeg4VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "VERY_GOOD", "BEST");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mpeg4_maxframe=10");
        agregatedUrl.append("&videoin_c0_s0_mpeg4_quant=4");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_maxframe=10");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_quant=4");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "VERY_GOOD", "BEST");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateBestVideoQualityForMpeg4VideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "ON");
        device.setParam("video_quality", "BEST", "GOOD");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?videoin_c0_s0_mpeg4_maxframe=20");
        agregatedUrl.append("&videoin_c0_s0_mpeg4_quant=5");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_maxframe=20");
        agregatedUrl.append("&videoin_c0_s1_mpeg4_quant=5");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoQualityParam = new LanDeviceParamEntity("video_quality", "BEST", "GOOD");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQualityParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        String singleUrl = "http://root:rootPass@192.168.21.138/cgi-bin/admin/privacybutton.cgi?enable=0";
        UpdateSettingsHandler singleSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService).times(2);
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, singleUrl, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, privacyButtonParam)).andReturn((Object)singleSettingsHandler);
        singleSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableMotionDetectionWithEnabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "OFF");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=1");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableMotionDetectionWithDisabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "OFF");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableMotionDetectionWithEnabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "ON");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableMotionDetectionWithDisabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "ON");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableVideoClipWithEnabledMotionDetectio() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_video_clip", "ON", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=1");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoClipParam = new LanDeviceParamEntity("alarm_video_clip", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoClipParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableVideoClipWithDisabledMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_video_clip", "ON", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoClipParam = new LanDeviceParamEntity("alarm_video_clip", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoClipParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableVideoClipWithEnabledMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_video_clip", "OFF", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoClipParam = new LanDeviceParamEntity("alarm_video_clip", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoClipParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableVideoClipWithDisabledMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_video_clip", "OFF", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity videoClipParam = new LanDeviceParamEntity("alarm_video_clip", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoClipParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableMotionDetectionAndEnableVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "OFF");
        device.setParam("alarm_video_clip", "ON", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=1");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        LanDeviceParamEntity alarmVideoClipParam = new LanDeviceParamEntity("alarm_video_clip", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{alarmVideoClipParam, motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableMotionDetectionAndDisableVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "ON", "OFF");
        device.setParam("alarm_video_clip", "OFF", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        LanDeviceParamEntity alarmVideoClipParam = new LanDeviceParamEntity("alarm_video_clip", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{alarmVideoClipParam, motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableMotionDetectionAndEnableVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "ON");
        device.setParam("alarm_video_clip", "ON", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        LanDeviceParamEntity alarmVideoClipParam = new LanDeviceParamEntity("alarm_video_clip", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{alarmVideoClipParam, motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableMotionDetectionAndDisableVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("motion_detection", "OFF", "ON");
        device.setParam("alarm_video_clip", "OFF", "ON");
        device.setParam("has_videoclip_recording", "ON");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i1_enable=0");
        agregatedUrl.append("&event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        LanDeviceParamEntity alarmVideoClipParam = new LanDeviceParamEntity("alarm_video_clip", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{alarmVideoClipParam, motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableMotionDetectionWithVideoClipNotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("motion_detection", "ON", "OFF");
        device.setParam("has_videoclip_recording", "OFF");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i0_enable=1");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableMotionDetectionWithVideoClipNotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MJPEG");
        device.setParam("motion_detection", "OFF", "ON");
        device.setParam("has_videoclip_recording", "OFF");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i0_enable=0");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAlarmLimit() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setVideoEncoding("MPEG4");
        device.setParam("alarm_limit", "5", "10");
        StringBuilder agregatedUrl = new StringBuilder();
        agregatedUrl.append("http://root:rootPass@192.168.21.138/cgi-bin/admin/setparam.cgi");
        agregatedUrl.append("?event_i0_delay=720");
        agregatedUrl.append("&event_i1_delay=720");
        UpdateSettingsHandler agregatedSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        LanDeviceParamEntity alarmLimitParam = new LanDeviceParamEntity("alarm_limit", "5", "10");
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance(this.httpClientService, agregatedUrl.toString(), HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this.vivotekSettings, Utils.wrap((Object[])new LanDeviceParamEntity[]{alarmLimitParam}))).andReturn((Object)agregatedSettingsHandler);
        agregatedSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseAgregatedParamsWithCorrectStatus() throws MalformedURLException {
        LanDeviceParamEntity systemLedoff = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity motionDetection = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("system_ledoff=1 event_i0_enable=1".getBytes());
        LanDeviceParamEntity savedSystemLedoff = new LanDeviceParamEntity("system_ledoff", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "motion_detection", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetection, systemLedoff}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseAgregatedParamsWithCorrectStatusForWifiAlgorithmEmptyAndOpenEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("wifi_alghoritm", "NONE", "WEP");
        device.setParam("wifi_encryption", "OPEN", "WEP");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "NONE", "WEP");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "OPEN", "WEP");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("wireless_encrypt=0 wireless_algorithm=".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_encryption", "OPEN", "OPEN")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_alghoritm", "NONE", "NONE")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiAlgorithm, wifiEncryption}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseAgregatedParamsWithCorrectStatusForWifiAlgorithmEmptyAndWepEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("wifi_alghoritm", "WEP", "NONE");
        device.setParam("wifi_encryption", "WEP", "OPEN");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "WEP", "NONE");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WEP", "OPEN");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("wireless_encrypt=1 wireless_algorithm=".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_encryption", "WEP", "WEP")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_alghoritm", "WEP", "WEP")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiAlgorithm, wifiEncryption}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseAgregatedParamsWithIncorrectStatus() throws MalformedURLException {
        LanDeviceParamEntity systemLedoff = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity motionDetection = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.NOANSWER);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "OFF", "OFF")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "motion_detection", "OFF", "OFF")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{systemLedoff, motionDetection}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseSingleParamWithCorrectStatus() throws MalformedURLException {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("ok".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "privacy_button", "OFF", "OFF")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceParamEntity processPrivacyButton = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{processPrivacyButton}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateResponseSingleParamWithIncorrectStatus() throws MalformedURLException {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.NOANSWER);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "privacy_button", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceParamEntity processPrivacyButton = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{processPrivacyButton}));
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableWifi() {
        LanDeviceEntity device = this.prepareDevice();
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "OFF", "ON");
        LanDeviceParamEntity wifiSsid = new LanDeviceParamEntity("wifi_ssid", "linksys", "linksys");
        LanDeviceParamEntity wifiWlanMode = new LanDeviceParamEntity("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        LanDeviceParamEntity wifiChannl = new LanDeviceParamEntity("wifi_channel", "6", "6");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WPA", "WPA");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        LanDeviceParamEntity wifiWepAuthMode = new LanDeviceParamEntity("wifi_wep_auth_mode", "", "");
        LanDeviceParamEntity wifiWepKeyLength = new LanDeviceParamEntity("wifi_wep_key_length", "", "");
        LanDeviceParamEntity wifiWepKeyFormat = new LanDeviceParamEntity("wifi_wep_key_format", "", "");
        LanDeviceParamEntity wifiWepKey1 = new LanDeviceParamEntity("wifi_wep_key1", "", "");
        LanDeviceParamEntity wifiWepKey2 = new LanDeviceParamEntity("wifi_wep_key2", "", "");
        LanDeviceParamEntity wifiWepKey3 = new LanDeviceParamEntity("wifi_wep_key3", "", "");
        LanDeviceParamEntity wifiWepKey4 = new LanDeviceParamEntity("wifi_wep_key4", "", "");
        LanDeviceParamEntity wifiWepDefaultKey = new LanDeviceParamEntity("wifi_wep_default_key", "", "");
        LanDeviceParamEntity wifiPreSharedKey = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "wifipassword");
        ArrayList<LanDeviceParamEntity> wifiParams = new ArrayList<LanDeviceParamEntity>();
        wifiParams.add(wifiEnabled);
        wifiParams.add(wifiWepDefaultKey);
        wifiParams.add(wifiEncryption);
        wifiParams.add(wifiWepKeyLength);
        wifiParams.add(wifiSsid);
        wifiParams.add(wifiPreSharedKey);
        wifiParams.add(wifiWepKey3);
        wifiParams.add(wifiWepAuthMode);
        wifiParams.add(wifiWepKey2);
        wifiParams.add(wifiWepKey4);
        wifiParams.add(wifiWlanMode);
        wifiParams.add(wifiWepKey1);
        wifiParams.add(wifiChannl);
        wifiParams.add(wifiAlgorithm);
        wifiParams.add(wifiWepKeyFormat);
        device.getLanDeviceParams().addAll(wifiParams);
        String updateWifiSettingsUrl = "http://admin:admin@127.0.0.1/cgi-bin/admin/setparam.cgi?wireless_keylength=&wireless_encrypt=0&wireless_keyselect=&wireless_ssid=default&wireless_presharedkey=wifipassword&wireless_key3=&wireless_authmode=&wireless_key2=&wireless_key4=&wireless_wlmode=Infra&wireless_key1=&wireless_channel=6&wireless_algorithm=AES&wireless_keyformat=";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        UpdateSettingsHandler updateSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        Capture paramsCampture = new Capture();
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService3), (String)EasyMock.eq((Object)updateWifiSettingsUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.GET), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.vivotekSettings), (List)EasyMock.capture((Capture)paramsCampture))).andReturn((Object)updateSettingsHandler);
        updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        Assert.assertTrue((boolean)this.verifyParams(wifiParams, paramsCampture));
        PowerMock.verifyAll();
    }

    private boolean verifyParams(List<LanDeviceParamEntity> expectedParams, Capture<List<LanDeviceParamEntity>> capturedParams) {
        if (expectedParams.size() != ((List)capturedParams.getValue()).size()) {
            return false;
        }
        for (LanDeviceParamEntity param : expectedParams) {
            if (this.containParam(expectedParams, param)) continue;
            Log.debug((String)("Missing param: " + param + "."));
            return false;
        }
        return true;
    }

    private boolean containParam(List<LanDeviceParamEntity> params, LanDeviceParamEntity param) {
        for (LanDeviceParamEntity p : params) {
            if (!p.equals((Object)param)) continue;
            return true;
        }
        return false;
    }

    private LanDeviceEntity prepareDevice() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setGatewayClient(TestDataUtils.prepareGatewaClientEntity());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", null);
        return device;
    }

    @Test
    public void testEnableWifi() {
        LanDeviceEntity device = this.prepareDevice();
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "ON", "OFF");
        LanDeviceParamEntity wifiSsid = new LanDeviceParamEntity("wifi_ssid", "linksys", "linksys");
        LanDeviceParamEntity wifiWlanMode = new LanDeviceParamEntity("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        LanDeviceParamEntity wifiChannl = new LanDeviceParamEntity("wifi_channel", "6", "6");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WPA", "WPA");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        LanDeviceParamEntity wifiWepAuthMode = new LanDeviceParamEntity("wifi_wep_auth_mode", "", "");
        LanDeviceParamEntity wifiWepKeyLength = new LanDeviceParamEntity("wifi_wep_key_length", "", "");
        LanDeviceParamEntity wifiWepKeyFormat = new LanDeviceParamEntity("wifi_wep_key_format", "", "");
        LanDeviceParamEntity wifiWepKey1 = new LanDeviceParamEntity("wifi_wep_key1", "", "");
        LanDeviceParamEntity wifiWepKey2 = new LanDeviceParamEntity("wifi_wep_key2", "", "");
        LanDeviceParamEntity wifiWepKey3 = new LanDeviceParamEntity("wifi_wep_key3", "", "");
        LanDeviceParamEntity wifiWepKey4 = new LanDeviceParamEntity("wifi_wep_key4", "", "");
        LanDeviceParamEntity wifiWepDefaultKey = new LanDeviceParamEntity("wifi_wep_default_key", "", "");
        LanDeviceParamEntity wifiPreSharedKey = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "wifipassword");
        ArrayList<LanDeviceParamEntity> wifiParams = new ArrayList<LanDeviceParamEntity>();
        wifiParams.add(wifiEnabled);
        wifiParams.add(wifiWepDefaultKey);
        wifiParams.add(wifiEncryption);
        wifiParams.add(wifiWepKeyLength);
        wifiParams.add(wifiSsid);
        wifiParams.add(wifiPreSharedKey);
        wifiParams.add(wifiWepKey3);
        wifiParams.add(wifiWepAuthMode);
        wifiParams.add(wifiWepKey2);
        wifiParams.add(wifiWepKey4);
        wifiParams.add(wifiWlanMode);
        wifiParams.add(wifiWepKey1);
        wifiParams.add(wifiChannl);
        wifiParams.add(wifiAlgorithm);
        wifiParams.add(wifiWepKeyFormat);
        device.getLanDeviceParams().addAll(wifiParams);
        String updateWifiSettingsUrl = "http://admin:admin@127.0.0.1/cgi-bin/admin/setparam.cgi?wireless_keylength=&wireless_encrypt=2&wireless_keyselect=&wireless_ssid=linksys&wireless_presharedkey=wifipassword&wireless_key3=&wireless_authmode=&wireless_key2=&wireless_key4=&wireless_wlmode=Infra&wireless_key1=&wireless_channel=6&wireless_algorithm=AES&wireless_keyformat=";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        UpdateSettingsHandler updateSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        Capture paramsCampture = new Capture();
        EasyMock.expect((Object)this.updateSettingsHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService3), (String)EasyMock.eq((Object)updateWifiSettingsUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.GET), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.vivotekSettings), (List)EasyMock.capture((Capture)paramsCampture))).andReturn((Object)updateSettingsHandler);
        updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.update(device, false);
        Assert.assertTrue((boolean)this.verifyParams(wifiParams, paramsCampture));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessSuccessfulyDisabledWifi() throws MalformedURLException {
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "OFF", "ON");
        LanDeviceParamEntity wifiSsid = new LanDeviceParamEntity("wifi_ssid", "linksys", "linksys");
        LanDeviceParamEntity wifiWlanMode = new LanDeviceParamEntity("wifi_wlan_mode", "wifi_wlan_mode", "INFRASTRUCTURE");
        LanDeviceParamEntity wifiChannl = new LanDeviceParamEntity("wifi_channel", "6", "6");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WPA", "WPA");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        LanDeviceParamEntity wifiWepAuthMode = new LanDeviceParamEntity("wifi_wep_auth_mode", "", "");
        LanDeviceParamEntity wifiWepKeyLength = new LanDeviceParamEntity("wifi_wep_key_length", "", "");
        LanDeviceParamEntity wifiWepKeyFormat = new LanDeviceParamEntity("wifi_wep_key_format", "", "");
        LanDeviceParamEntity wifiWepKey1 = new LanDeviceParamEntity("wifi_wep_key1", "", "");
        LanDeviceParamEntity wifiWepKey2 = new LanDeviceParamEntity("wifi_wep_key2", "", "");
        LanDeviceParamEntity wifiWepKey3 = new LanDeviceParamEntity("wifi_wep_key3", "", "");
        LanDeviceParamEntity wifiWepKey4 = new LanDeviceParamEntity("wifi_wep_key4", "", "");
        LanDeviceParamEntity wifiWepDefaultKey = new LanDeviceParamEntity("wifi_wep_default_key", "", "");
        LanDeviceParamEntity wifiPreSharedKey = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "wifipassword");
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(ledOffParam);
        params.add(motionDetectionParam);
        params.add(wifiEnabled);
        params.add(wifiWepDefaultKey);
        params.add(wifiEncryption);
        params.add(wifiWepKeyLength);
        params.add(wifiSsid);
        params.add(wifiPreSharedKey);
        params.add(wifiWepKey3);
        params.add(wifiWepAuthMode);
        params.add(wifiWepKey2);
        params.add(wifiWepKey4);
        params.add(wifiWlanMode);
        params.add(wifiWepKey1);
        params.add(wifiChannl);
        params.add(wifiAlgorithm);
        params.add(wifiWepKeyFormat);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_enabled", "OFF", "OFF")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "motion_detection", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("wireless_ssid=default wireless_wlmode=Infra wireless_channel=6 wireless_encrypt=0 system_ledoff=1 event_i0_enable=1".getBytes());
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessSuccessfulyEnabledWifi() throws MalformedURLException {
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "ON", "OFF");
        LanDeviceParamEntity wifiSsid = new LanDeviceParamEntity("wifi_ssid", "linksys", "linksys");
        LanDeviceParamEntity wifiWlanMode = new LanDeviceParamEntity("wifi_wlan_mode", "wifi_wlan_mode", "INFRASTRUCTURE");
        LanDeviceParamEntity wifiChannl = new LanDeviceParamEntity("wifi_channel", "6", "6");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WPA", "WPA");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        LanDeviceParamEntity wifiWepAuthMode = new LanDeviceParamEntity("wifi_wep_auth_mode", "", "");
        LanDeviceParamEntity wifiWepKeyLength = new LanDeviceParamEntity("wifi_wep_key_length", "", "");
        LanDeviceParamEntity wifiWepKeyFormat = new LanDeviceParamEntity("wifi_wep_key_format", "", "");
        LanDeviceParamEntity wifiWepKey1 = new LanDeviceParamEntity("wifi_wep_key1", "", "");
        LanDeviceParamEntity wifiWepKey2 = new LanDeviceParamEntity("wifi_wep_key2", "", "");
        LanDeviceParamEntity wifiWepKey3 = new LanDeviceParamEntity("wifi_wep_key3", "", "");
        LanDeviceParamEntity wifiWepKey4 = new LanDeviceParamEntity("wifi_wep_key4", "", "");
        LanDeviceParamEntity wifiWepDefaultKey = new LanDeviceParamEntity("wifi_wep_default_key", "", "");
        LanDeviceParamEntity wifiPreSharedKey = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "wifipassword");
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        params.add(ledOffParam);
        params.add(motionDetectionParam);
        params.add(wifiEnabled);
        params.add(wifiWepDefaultKey);
        params.add(wifiEncryption);
        params.add(wifiWepKeyLength);
        params.add(wifiSsid);
        params.add(wifiPreSharedKey);
        params.add(wifiWepKey3);
        params.add(wifiWepAuthMode);
        params.add(wifiWepKey2);
        params.add(wifiWepKey4);
        params.add(wifiWlanMode);
        params.add(wifiWepKey1);
        params.add(wifiChannl);
        params.add(wifiAlgorithm);
        params.add(wifiWepKeyFormat);
        LanDeviceParamEntity wifiEnabledSaved = new LanDeviceParamEntity("wifi_enabled", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_enabled", "ON", "ON")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_ssid", "linksys", "linksys")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wlan_mode", "wifi_wlan_mode", "INFRASTRUCTURE")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_channel", "6", "6")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_encryption", "WPA", "WPA")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key3", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_alghoritm", "AES_CCMP", "AES_CCMP")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_auth_mode", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key_length", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key_format", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key1", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key2", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_key4", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_wep_default_key", "", "")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "wifi_pre_shared_key", "wifipassword", "wifipassword")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "motion_detection", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("wireless_ssid=linksys wireless_wlmode=Infra wireless_channel=6 wireless_txrate=0 wireless_encrypt=2 wireless_authmode= wireless_keylength= wireless_keyformat= wireless_keyselect= wireless_key1= wireless_key2= wireless_key3= wireless_key4= wireless_domain=0 wireless_algorithm=AES wireless_presharedkey=1%24millennium system_ledoff=1 event_i0_enable=1".getBytes());
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, params);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateVideoQualitySuccessfuly() throws MalformedURLException {
        LanDeviceParamEntity videoQuality = new LanDeviceParamEntity("video_quality", "MODERATE", "GOOD");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("videoin_c0_s0_mjpeg_maxframe=3 videoin_c0_s0_mjpeg_quant=2 videoin_c0_s1_mjpeg_maxframe=3 videoin_c0_s1_mjpeg_quant=2".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "video_quality", "MODERATE", "MODERATE")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQuality}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateVideoQualityInvalidResponseValue() throws MalformedURLException {
        LanDeviceParamEntity videoQuality = new LanDeviceParamEntity("video_quality", "MODERATE", "GOOD");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("videoin_c0_s0_mjpeg_maxframe=2 videoin_c0_s0_mjpeg_quant=2 videoin_c0_s1_mjpeg_maxframe=5 videoin_c0_s1_mjpeg_quant=2".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "video_quality", "GOOD", "GOOD")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQuality}));
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessUpdateVideoQualityMissingResponseValue() throws MalformedURLException {
        LanDeviceParamEntity videoQuality = new LanDeviceParamEntity("video_quality", "MODERATE", "GOOD");
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(HTTPClientServiceResult.Result.OK);
        response.setBody("videoin_c0_s0_mjpeg_quant=2 videoin_c0_s1_mjpeg_maxframe=5 videoin_c0_s1_mjpeg_quant=2".getBytes());
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "video_quality", "GOOD", "GOOD")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.vivotekSettings.processUpdatedSettingsResponse(this.device, response, Utils.wrap((Object[])new LanDeviceParamEntity[]{videoQuality}));
        PowerMock.verifyAll();
    }
}

