/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.SettingParam;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;
import pl.smartapps.containerserver.landevice.multipart.Multipart;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericInternal;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericTests;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekGeneric.class})
public class CameraVivotekGenericTests
extends CameraVivotekGenericInternal {
    @Test
    public void testVerifySuccesfully() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("system_hostname='Wireless Network Camera'").append("\n");
        responseBody.append("system_ledoff='1'").append("\n");
        responseBody.append("system_date='2011/04/22'").append("\n");
        responseBody.append("system_time='12:38:36'").append("\n");
        responseBody.append("system_info_modelname='TC5633'").append("\n");
        responseBody.append("system_info_serialnumber='0002D106CD80'").append("\n");
        responseBody.append("system_info_firmwareversion='TC5633-TCSW-0100h'").append("\n");
        responseBody.append("security_user_i0_name='root'").append("\n");
        responseBody.append("security_user_i0_pass=''").append("\n");
        responseBody.append("security_user_i0_privilege='admin'").append("\n");
        responseBody.append("security_user_i1_name=''").append("\n");
        responseBody.append("security_user_i1_privilege=''").append("\n");
        responseBody.append("capability_protocol_rtp_http='1'").append("\n");
        responseBody.append("capability_protocol_spush_mjpeg='1'").append("\n");
        clientResponse.setBody(responseBody.toString().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        HashMap<String, HashMap<String, String>> capabilities = new HashMap<String, HashMap<String, String>>();
        capabilities.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(null);
        this.authUtils.storeData("device_cababilities", capabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifySuccesfullyModelIP7142() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("system_hostname='Wireless Network Camera'").append("\n");
        responseBody.append("system_ledoff='1'").append("\n");
        responseBody.append("system_date='2011/04/22'").append("\n");
        responseBody.append("system_time='12:38:36'").append("\n");
        responseBody.append("system_info_modelname='IP7142'").append("\n");
        responseBody.append("system_info_serialnumber='0002D106CD80'").append("\n");
        responseBody.append("system_info_firmwareversion='TC5633-TCSW-0100h'").append("\n");
        responseBody.append("security_user_i0_name='root'").append("\n");
        responseBody.append("security_user_i0_pass=''").append("\n");
        responseBody.append("security_user_i0_privilege='admin'").append("\n");
        responseBody.append("security_user_i1_name=''").append("\n");
        responseBody.append("security_user_i1_privilege=''").append("\n");
        responseBody.append("capability_protocol_rtp_http='1'").append("\n");
        responseBody.append("capability_protocol_spush_mjpeg='1'").append("\n");
        responseBody.append("capability_ptzenabled='63'").append("\n");
        clientResponse.setBody(responseBody.toString().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "IP7142");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        deviceCapabilities.put("capability_ptzenabled", "0");
        HashMap<String, HashMap<String, String>> capabilities = new HashMap<String, HashMap<String, String>>();
        capabilities.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(null);
        this.authUtils.storeData("device_cababilities", capabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyDeviceNotSupported() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("system_hostname='Wireless Network Camera'").append("\n");
        responseBody.append("system_ledoff='1'").append("\n");
        responseBody.append("system_date='2011/04/22'").append("\n");
        responseBody.append("system_time='12:38:36'").append("\n");
        responseBody.append("system_info_modelname='TC5633'").append("\n");
        responseBody.append("system_info_serialnumber='0002D106CD80'").append("\n");
        responseBody.append("system_info_firmwareversion='TC5633-TCSW-0100h'").append("\n");
        responseBody.append("security_user_i0_name='root'").append("\n");
        responseBody.append("security_user_i0_pass=''").append("\n");
        responseBody.append("security_user_i0_privilege='admin'").append("\n");
        responseBody.append("security_user_i1_name=''").append("\n");
        responseBody.append("security_user_i1_privilege=''").append("\n");
        responseBody.append("capability_protocol_rtp_http='1'").append("\n");
        responseBody.append("capability_protocol_spush_mjpeg='0'").append("\n");
        clientResponse.setBody(responseBody.toString().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "0");
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOT_SUPPORTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyNoAccessFailure() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOACCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyIncorrectResponseBody() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    protected LanDeviceEntity prepareDeviceToInit() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setName("TC5633-TCSW-0100h");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setPort(Integer.valueOf(80));
        device.setUsername("root");
        device.setPass("rootPass");
        device.setVersion("TC5633-TCSW-0100h");
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("alarm_user", "alarmUser");
        device.setParam("alarm_pass", "alarmPass");
        device.setGatewayClient(TestDataUtils.prepareGatewaClientEntity());
        device.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        device.setModel("TC5633");
        return device;
    }

    private void testInitSuccesfullWithoutUserRegistrationAndWithWifi(Map<String, String> deviceCapabilities, LanDeviceEntity expectedDevice) throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map<String, String>> devicesCapabilites = new HashMap<String, Map<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        System.out.println("1>>>>>>>> " + expectedDevice);
        System.out.println("2>>>>>>>> " + device);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    protected boolean verifyDevice(LanDeviceEntity expectedDevice, LanDeviceEntity device) {
        if (!expectedDevice.equals((Object)device)) {
            System.out.println("Device are not equals");
            return false;
        }
        1 paramComparator = new /* Unavailable Anonymous Inner Class!! */;
        List expectedParams = expectedDevice.getLanDeviceParams();
        List params = device.getLanDeviceParams();
        Collections.sort(expectedParams, paramComparator);
        System.out.println("expectedParams: " + expectedParams);
        Collections.sort(params, paramComparator);
        System.out.println("params:         " + params);
        return expectedParams.equals(params);
    }

    @Test
    public void testInitFailureWithoutUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> devicesCapabilites = new HashMap<String, Map>();
        devicesCapabilites.put("00:02:D1:06:CD:80", this.prepareDeviceCapabilitiesWithoutWifi(true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        StringBuilder confResponse = new StringBuilder();
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(confResponse.toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDeviceWithoutWifi(true), device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPtzNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "0");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, false, false, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "OFF", null);
        expectedDevice.setParam("has_pan", "OFF", null);
        expectedDevice.setParam("has_tilt", "OFF", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPanNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "379");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, false, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "OFF", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithTiltNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "375");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, false, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "OFF", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithZoomNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithLedoffNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, false, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, false, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirSupportedAndMdSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("motion_c0_enable", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, false, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, false, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirNotsupportedAndMdSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "0");
        capabilities.put("motion_c0_enable", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, false, MotionDetection.MD, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, false, MotionDetection.MD, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirNotSupportedAndMdNotSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, false, MotionDetection.NONE, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, false, MotionDetection.NONE, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUnexpectedResolution() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,352x288,704x576,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "352x288", "704x576", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "352x288", "704x576").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "704x576", null);
        expectedDevice.setParam("resolution_low", "352x288", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=704x576", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=352x288", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithCifResolution() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "QCIF, CIF, 4CIF");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "CIF", "4CIF", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "CIF", "4CIF").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "704x576", null);
        expectedDevice.setParam("resolution_low", "352x288", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=704x576", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=352x288", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUser");
        registerUserUrl.append("&userpass=viewerPass");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name='viewerUser'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(false, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(false, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistrationUnexpectedResponseBody() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUser");
        registerUserUrl.append("&userpass=viewerPass");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistrationIncorrectUserRegisrationStatus() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUser");
        registerUserUrl.append("&userpass=viewerPass");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        HTTPClientServiceResult registerUserResponse = new HTTPClientServiceResult();
        registerUserResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)registerUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithIncorrectUserRegistrationVerificationStatus() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUser");
        registerUserUrl.append("&userpass=viewerPass");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name='viewerUser'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitUnexpectedConfigurePrivacyButtonResponse() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "heh"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureConfigurePrivacyButtonResponse() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, "ok"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUnsupportedPrivacyButton() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, Integer.valueOf(404), ""));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitSuccesfullWithSomeParamsNotSet() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", false).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.MANUAL, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithoutWifiSupport() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap devicesCapabilites = new HashMap();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i3_name", "viewerUser");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(this.prepareConfigurationResponse(true, true, true, true, MotionDetection.PIR, "320x240", "640x480", true).toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationRequest(true, true, true, true, MotionDetection.PIR, "320x240", "640x480").toString(), (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithOpenWifiWithInfrastructureWlanMode() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi(true, "smart-apps", "INFRASTRUCTURE", "6", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithOpenWifiWithAdHocWlanMode() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.AD_HOC, Integer.valueOf(6));
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi(true, "smart-apps", "AD_HOC", "6", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithOpenAuthModeAndAsciiKeyFormatAnd64BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(8), WepAuthMode.OPEN, "64", "ASCII", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, "smart-apps", "INFRASTRUCTURE", "8", "OPEN", "LENGTH_64_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithSharedAuthModeAndAsciiKeyFormatAnd128BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(8), WepAuthMode.SHARED, "128", "ASCII", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, "smart-apps", "INFRASTRUCTURE", "8", "SHARED", "LENGTH_128_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithOpenAuthModeAndHexKeyFormatAnd64BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(8), WepAuthMode.OPEN, "64", "HEX", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, "smart-apps", "INFRASTRUCTURE", "8", "OPEN", "LENGTH_64_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithSharedAuthModeAndHexKeyFormatAnd128BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(8), WepAuthMode.SHARED, "128", "HEX", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, "smart-apps", "INFRASTRUCTURE", "8", "SHARED", "LENGTH_128_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpaWifiWithTkipAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(3), Encryption.WPA, Algorithm.TKIP, "test%24password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, "smart-apps", "INFRASTRUCTURE", "3", "WPA", "TKIP", "test$password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitSuccesfullWithoutUserRegistrationAndWithWpaWifiWithAesAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(3), Encryption.WPA, Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, "smart-apps", "INFRASTRUCTURE", "3", "WPA", "AES_CCMP", "test%password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpa2WifiWithTkipAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(3), Encryption.WPA2, Algorithm.TKIP, "test%24password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, "smart-apps", "INFRASTRUCTURE", "3", "WPA2", "TKIP", "test$password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpa2WifiWithAesAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(3), Encryption.WPA2, Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, "smart-apps", "INFRASTRUCTURE", "3", "WPA2", "AES_CCMP", "test%password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithDisableWifi() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "default", WlanMode.INFRASTRUCTURE, Integer.valueOf(6), Encryption.OPEN, Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, "", "", "", "", "", "", "OFF");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testGetControlParams() {
        ControlParams controlParams = new ControlParams();
        controlParams.setPanLeft("/cgi-bin/viewer/camctrl.cgi?move=left");
        controlParams.setPanRight("/cgi-bin/viewer/camctrl.cgi?move=right");
        controlParams.setPanUp("/cgi-bin/viewer/camctrl.cgi?move=up");
        controlParams.setPanDown("/cgi-bin/viewer/camctrl.cgi?move=down");
        controlParams.setPanCenter("/cgi-bin/viewer/camctrl.cgi?move=home");
        controlParams.setZoomIn("/cgi-bin/viewer/camctrl.cgi?zoom=tele");
        controlParams.setZoomOut("/cgi-bin/viewer/camctrl.cgi?zoom=wide");
        Assert.assertEquals((Object)controlParams, (Object)this.cameraVivotekGeneric.getControlParams());
    }

    @Test
    public void testGetCurrentSnapshot() throws MalformedURLException {
        URL url = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/viewer/video.jpg?resolution=320x240");
        HTTPClientServiceResult clientServiceResponse = new HTTPClientServiceResult();
        clientServiceResponse.setResult(HTTPClientServiceResult.Result.OK);
        clientServiceResponse.setBody("test".getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientServiceResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] response = this.cameraVivotekGeneric.getCurrentSnapshot(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true), "320x240");
        Assert.assertArrayEquals((byte[])"test".getBytes(), (byte[])response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusSuccesfully() throws MalformedURLException {
        URL url = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system_info_serialnumber");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        clientResponse.setBody("system_info_serialnumber='0002D106CD80'".getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.checkStatus(TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusOtherCameraResponse() throws MalformedURLException {
        URL url = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system_info_serialnumber");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        clientResponse.setBody("system_info_serialnumber='0002D109D937'".getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.checkStatus(TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)AccessVerificationStatus.NOANSWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailure() throws MalformedURLException {
        URL url = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system_info_serialnumber");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.ERROR);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.checkStatus(TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)AccessVerificationStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testParseNullWirelessNetworks() {
        ArrayList expectedResponse = new ArrayList();
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.cameraVivotekGeneric.parseWirelessNetworks(null);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testParseEmptyWirelessNetworks() {
        ArrayList expectedResponse = new ArrayList();
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.cameraVivotekGeneric.parseWirelessNetworks("");
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testParseWirelessNetworks() {
        StringBuilder wifiData = new StringBuilder();
        wifiData.append("\n");
        wifiData.append("01 00 linksys                          07 00:1A:70:9A:6D:18 06 00 61").append("\n");
        wifiData.append("01 00 linksys                          09 00:1A:70:9A:6D:18 06 00 61").append("\n");
        wifiData.append("01 00   linksys                        09 00:1A:70:9A:6D:18 06 00 61").append("\n");
        wifiData.append("02 00 sa                               02 D8:5D:4C:86:6C:A2 01 33 51").append("\n");
        wifiData.append("\n");
        wifiData.append("03 00 sa-tc                            05 00:1F:F3:C3:60:24 10 33 75").append("\n");
        wifiData.append("04 00 Astimar                          07 00:1E:2A:50:ED:40 11 11 55").append("\n");
        wifiData.append("04 00 Astimar                          07 00:1E:2A:50:ED:40 11 44 55").append("\n");
        wifiData.append("04 02 Astimar                          07 00:1E:2A:50:ED:40 11 22 55").append("\n");
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<WlanAccessPoint> expectedResponse = new ArrayList<WlanAccessPoint>();
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"linksys", (String)"00:1A:70:9A:6D:18", (int)6, (int)61, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.OPEN}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"linksys  ", (String)"00:1A:70:9A:6D:18", (int)6, (int)61, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.OPEN}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"  linksys", (String)"00:1A:70:9A:6D:18", (int)6, (int)61, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.OPEN}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa", (String)"D8:5D:4C:86:6C:A2", (int)1, (int)51, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP, TestDataUtils.WPA_AES, TestDataUtils.WPA2_TKIP, TestDataUtils.WPA2_AES}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa-tc", (String)"00:1F:F3:C3:60:24", (int)10, (int)75, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP, TestDataUtils.WPA_AES, TestDataUtils.WPA2_TKIP, TestDataUtils.WPA2_AES}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"Astimar", (String)"00:1E:2A:50:ED:40", (int)11, (int)55, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"Astimar", (String)"00:1E:2A:50:ED:40", (int)11, (int)55, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WEP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.AD_HOC, (String)"Astimar", (String)"00:1E:2A:50:ED:40", (int)11, (int)55, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA2_AES}));
        List response = this.cameraVivotekGeneric.parseWirelessNetworks(wifiData.toString());
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingSuccessfuly() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "system_ledoff=1"));
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("system_ledoff", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.SUCCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingUnsupportedParam() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(1);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "test", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_PARAMUNSUPPORTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingErrorResponse() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, null));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingNoAnswerResponse() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOANSWER, null));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_NOANSEWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingNoAccessResponse() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOACCESS, null));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_NOACCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingFailureDatabaseUpdate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "system_ledoff=1"));
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("system_ledoff", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingNotFoundParam() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getLanDeviceParams().clear();
        HashMap<String, SettingParam> supportedSettings = new HashMap<String, SettingParam>();
        SettingParam systemledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        supportedSettings.put("system_ledoff", systemledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        supportedSettings.put("privacy_button", privacyButton);
        EasyMock.expect((Object)this.cameraVivotekSettings.getCameraSettings()).andReturn(supportedSettings).times(2);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        String url = "http://127.0.0.1/cgi-bin/admin/setparam.cgi?system_ledoff=1";
        EasyMock.expect((Object)this.cameraVivotekSettings.createSendSingleSettingRequest(device, "system_ledoff", "ON")).andReturn((Object)url);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", new URL(url))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "system_ledoff=1"));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraVivotekGeneric.updateSingleSetting(device, "system_ledoff", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_PARAMNOTFOUND, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetConnCheckUrl() {
        Assert.assertEquals((Object)"/cgi-bin/admin/getparam.cgi?system_info_serialnumber", (Object)this.cameraVivotekGeneric.getConnCheckUrl());
    }

    protected void expectSendRequest(String deviceId, String url, HTTPClientServiceResult response) throws MalformedURLException {
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        EasyMock.expect((Object)httpClientService.get(deviceId, new URL(url))).andReturn((Object)response);
    }

    @Test
    public void testCheckConfigurationCorrectWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectForModelIP7142() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "2", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectForIP7142() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "2", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "1", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "2", "3", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "3", "2", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationInorrectVideoFpsWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "1", "2", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "3", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "1", "3", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "4", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "1", "4", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "5", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "1", "5", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectHighResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "704x576", "320x240", "30", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifHighResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "16CIF", "320x240", "30", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectLowResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "352x288", "30", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifLowResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "4CIF", "QCIF", "30", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifResolutions() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "4CIF", "CIF", "30", "1", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithPirMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "5", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithMdMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "5", true, true, false, true, MotionDetection.MD, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithNoneMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "5", true, true, false, false, MotionDetection.NONE, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "5", "5");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 720, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "10", "10");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 360, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 240, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "30", "30");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 120, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase7() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "HEX", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase8() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "ASCII", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "5", "5");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA2", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 720, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "10", "10");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA2", "WPA2");
        device.setParam("wifi_alghoritm", "TKIP", "TKIP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 360, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA2, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA", "WPA");
        device.setParam("wifi_alghoritm", "TKIP", "TKIP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 240, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "30", "30");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key_format", "HEX", "HEX");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 120, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "AD_HOC", "AD_HOC");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key_format", "ASCII", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "smart-apps", WlanMode.AD_HOC, 3, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase7() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key_format", "HEX", "HEX");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "HEX", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase8() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key_format", "ASCII", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", false, false, true, true, MotionDetection.PIR, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "ASCII", "1", "key1", "key2", "key3", "key4");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationViewerUserNonRegisterd() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername2", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername2", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmPassword() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword2", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectLedOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmLimit() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "5", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectSsid() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps2", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "AD_HOC", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiChannel() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.OPEN, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiAlgorithm() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiSharedKey() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiAuthMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "AUTO", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiKeyLength() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiKeyFormat() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key11", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key22", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key31", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key41", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKeyIndex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "3", "1", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "2", "1", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "2", "1", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "MODERATE", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "2", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "3", "2", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "3", "2", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "VERY_GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "20", "4", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "10", "4", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "10", "4", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "30", "5", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithCifResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "640x480", "320x240", "30", "5", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithPirMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "640x480", "320x240", "30", "5", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithMdMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "QCIF, CIF, 4CIF", "640x480", "320x240", "30", "5", true, true, false, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.MD, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.MD, "4CIF", "CIF", "20", "5", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("alarm_limit", "5", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "AD_HOC", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", false, false, 720, "smart-apps", WlanMode.AD_HOC, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "HEX", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", false, false, 720, "smart-apps", WlanMode.AD_HOC, 4, Encryption.WEP, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "128", "HEX", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "10", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 360, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 360, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "15", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 240, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 240, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "30", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 120, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 120, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.TKIP, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWifiDisabled() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "10", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "default", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureDonloadDeviceCapabilities() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.ERROR, null));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.ERROR, (Object)this.cameraVivotekGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureConfigurePrivacyButton() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, "ok"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureSendConfiguration() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON");
        device.setParam("viewer_user", "viewerUsername");
        device.setParam("viewer_pass", "viewerPassword");
        device.setParam("alarm_user", "alarmUsername");
        device.setParam("alarm_pass", "alarmPassword");
        device.setParam("motion_detection", "ON");
        device.setParam("system_ledoff", "ON");
        device.setParam("alarm_limit", "60");
        device.setParam("video_quality", "GOOD");
        device.setParam("has_home", "ON");
        device.setParam("has_pan", "ON");
        device.setParam("has_tilt", "ON");
        device.setParam("has_zoom", "ON");
        device.setParam("need_restart_after_network_changes", "ON");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("wifi_enabled", "ON");
        device.setParam("wifi_ssid", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "");
        device.setParam("wifi_channel", "4");
        device.setParam("wifi_encryption", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "");
        device.setParam("wifi_wep_key_length", "");
        device.setParam("wifi_wep_key_format", "");
        device.setParam("wifi_wep_key1", "");
        device.setParam("wifi_wep_key2", "");
        device.setParam("wifi_wep_key3", "");
        device.setParam("wifi_wep_key4", "");
        device.setParam("wifi_wep_default_key", "");
        device.setParam("wifi_pre_shared_key", "sharedKey");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.NOANSWER);
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureSomeSettingsHasNotBeenApply() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON");
        device.setParam("viewer_user", "viewerUsername");
        device.setParam("viewer_pass", "viewerPassword");
        device.setParam("alarm_user", "alarmUsername");
        device.setParam("alarm_pass", "alarmPassword");
        device.setParam("motion_detection", "ON");
        device.setParam("system_ledoff", "ON");
        device.setParam("alarm_limit", "60");
        device.setParam("video_quality", "GOOD");
        device.setParam("has_home", "ON");
        device.setParam("has_pan", "ON");
        device.setParam("has_tilt", "ON");
        device.setParam("has_zoom", "ON");
        device.setParam("need_restart_after_network_changes", "ON");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("wifi_enabled", "ON");
        device.setParam("wifi_ssid", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "");
        device.setParam("wifi_channel", "4");
        device.setParam("wifi_encryption", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "");
        device.setParam("wifi_wep_key_length", "");
        device.setParam("wifi_wep_key_format", "");
        device.setParam("wifi_wep_key1", "");
        device.setParam("wifi_wep_key2", "");
        device.setParam("wifi_wep_key3", "");
        device.setParam("wifi_wep_key4", "");
        device.setParam("wifi_wep_default_key", "");
        device.setParam("wifi_pre_shared_key", "sharedKey");
        String url = "http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        String responseBody = this.prepareDeviceSettingsResponseBody("viewerUsername", "alarmUsername", "alarmPassword", "00:02:D1:06:CD:80", "640x480", "320x240", "5", "3", true, true, true, true, MotionDetection.PIR, 1, "smart-apps", WlanMode.INFRASTRUCTURE, 3, Encryption.WPA, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key1", "key1", "key1");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, responseBody));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        String confResponseBody = this.prepareDeviceConfigurationResponseBody("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "10", "3", "00:02:D1:06:CD:80", false, true, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(confResponseBody.getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.MANUAL, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareDeviceConfigurationUrl("viewerUsername", "alarmUsername", "alarmPassword", MotionDetection.PIR, "640x480", "320x240", "5", "3", "00:02:D1:06:CD:80", true, true, 60, "smart-apps", WlanMode.INFRASTRUCTURE, 4, Encryption.WPA2, Algorithm.AES, "sharedKey", WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4"), (Capture)configureDeviceUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionSuccessfully() {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "system_info_serialnumber='0002D109D937\nsystem_info_firmwareversion='1.1'"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"1.1", (Object)this.cameraVivotekGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionFailureMissingVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "system_info_serialnumber='0002D109D937"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionFailureEmptyResponseBody() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, ""));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionNoAnswer() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOANSWER, ""));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionNoAccess() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOACCESS, ""));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDate() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("123");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.cameraVivotekGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareObsolete() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("1234");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.cameraVivotekGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDateNullFirmwareVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDateEmptyFirmwareVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraVivotekGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore
    public void testUpgradeFirmwareOldSuccessfully() throws Exception {
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/octet-stream");
        firmwareBody.setContentDisposition("form-data", "fimage", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        byte[] multipartBody = new byte[10];
        EasyMock.expect((Object)multipart.getBytes()).andReturn((Object)multipartBody);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setTimeout(Integer.valueOf(900));
        URL upgradeFirmwareUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/upgrade.cgi");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "multipart/form-data; boundary=--boundry1234");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", upgradeFirmwareUrl, headers, multipartBody)).andReturn((Object)this.prepareUpgradeFirmwareResponse(true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    private HTTPClientServiceResult prepareUpgradeFirmwareResponse(boolean correct) {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        StringBuilder body = new StringBuilder();
        if (correct) {
            body.append("Update system image success").append("\n");
            body.append("Write new image complete").append("\n");
            body.append("Update armboot env success").append("\n");
            body.append("Reboot system now !!").append("\n");
            body.append("This connection will close").append("\n");
        }
        response.setBody(body.toString().getBytes());
        return response;
    }

    @Test
    @Ignore(value="Test for old version on firmware upgrade use tcpproxy instead gdtserver")
    public void testUpgradeFirmwareFailureCameraResponse() throws Exception {
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/octet-stream");
        firmwareBody.setContentDisposition("form-data", "fimage", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        byte[] multipartBody = new byte[10];
        EasyMock.expect((Object)multipart.getBytes()).andReturn((Object)multipartBody);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setTimeout(Integer.valueOf(900));
        URL upgradeFirmwareUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/upgrade.cgi");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "multipart/form-data; boundary=--boundry1234");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", upgradeFirmwareUrl, headers, multipartBody)).andReturn((Object)this.prepareUpgradeFirmwareResponse(false));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore(value="Test for old version on firmware upgrade use tcpproxy instead gdtserver")
    public void testUpgradeFirmwareOldEmptyMultipartBody() throws Exception {
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/octet-stream");
        firmwareBody.setContentDisposition("form-data", "fimage", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        EasyMock.expect((Object)multipart.getBytes()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore(value="Test for old version on firmware upgrade use tcpproxy instead gdtserver")
    public void testUpgradeFirmwareEmptyFirmware() throws Exception {
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/octet-stream");
        firmwareBody.setContentDisposition("form-data", "fimage", "new_firmware.bin");
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssi() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        StringBuilder execCmdResponse = new StringBuilder();
        execCmdResponse.append("Tx success = 463").append("\n");
        execCmdResponse.append("Tx success without retry = 425").append("\n");
        execCmdResponse.append("Tx success after retry = 38").append("\n");
        execCmdResponse.append("Tx fail to Rcv ACK after retry = 0").append("\n");
        execCmdResponse.append("RTS Success Rcv CTS = 0").append("\n");
        execCmdResponse.append("RTS Fail Rcv CTS = 0").append("\n");
        execCmdResponse.append("Rx success = 11425").append("\n");
        execCmdResponse.append("Rx with CRC = 3236").append("\n");
        execCmdResponse.append("Rx drop due to out of resource = 0").append("\n");
        execCmdResponse.append("Rx duplicate frame = 4").append("\n");
        execCmdResponse.append("False CCA (one second) = 0").append("\n");
        execCmdResponse.append("RSSI-A = -43").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(execCmdResponse.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)77, (Object)response);
    }

    @Test
    public void testCheckRssiLessThanMinus78() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        StringBuilder execCmdResponse = new StringBuilder();
        execCmdResponse.append("Tx success = 463").append("\n");
        execCmdResponse.append("Tx success without retry = 425").append("\n");
        execCmdResponse.append("Tx success after retry = 38").append("\n");
        execCmdResponse.append("Tx fail to Rcv ACK after retry = 0").append("\n");
        execCmdResponse.append("RTS Success Rcv CTS = 0").append("\n");
        execCmdResponse.append("RTS Fail Rcv CTS = 0").append("\n");
        execCmdResponse.append("Rx success = 11425").append("\n");
        execCmdResponse.append("Rx with CRC = 3236").append("\n");
        execCmdResponse.append("Rx drop due to out of resource = 0").append("\n");
        execCmdResponse.append("Rx duplicate frame = 4").append("\n");
        execCmdResponse.append("False CCA (one second) = 0").append("\n");
        execCmdResponse.append("RSSI-A = -79").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(execCmdResponse.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)10, (Object)response);
    }

    @Test
    public void testCheckRssiMoreThanMinus25() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        StringBuilder execCmdResponse = new StringBuilder();
        execCmdResponse.append("Tx success = 463").append("\n");
        execCmdResponse.append("Tx success without retry = 425").append("\n");
        execCmdResponse.append("Tx success after retry = 38").append("\n");
        execCmdResponse.append("Tx fail to Rcv ACK after retry = 0").append("\n");
        execCmdResponse.append("RTS Success Rcv CTS = 0").append("\n");
        execCmdResponse.append("RTS Fail Rcv CTS = 0").append("\n");
        execCmdResponse.append("Rx success = 11425").append("\n");
        execCmdResponse.append("Rx with CRC = 3236").append("\n");
        execCmdResponse.append("Rx drop due to out of resource = 0").append("\n");
        execCmdResponse.append("Rx duplicate frame = 4").append("\n");
        execCmdResponse.append("False CCA (one second) = 0").append("\n");
        execCmdResponse.append("RSSI-A = -24").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(execCmdResponse.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)100, (Object)response);
    }

    @Test
    public void testCheckRssiMissingRssiLine() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        StringBuilder execCmdResponse = new StringBuilder();
        execCmdResponse.append("Tx success = 463").append("\n");
        execCmdResponse.append("Tx success without retry = 425").append("\n");
        execCmdResponse.append("Tx success after retry = 38").append("\n");
        execCmdResponse.append("Tx fail to Rcv ACK after retry = 0").append("\n");
        execCmdResponse.append("RTS Success Rcv CTS = 0").append("\n");
        execCmdResponse.append("RTS Fail Rcv CTS = 0").append("\n");
        execCmdResponse.append("Rx success = 11425").append("\n");
        execCmdResponse.append("Rx with CRC = 3236").append("\n");
        execCmdResponse.append("Rx drop due to out of resource = 0").append("\n");
        execCmdResponse.append("Rx duplicate frame = 4").append("\n");
        execCmdResponse.append("False CCA (one second) = 0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(execCmdResponse.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
    }

    @Test
    public void testCheckRssiUnexpectedRssiLineForm() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        StringBuilder execCmdResponse = new StringBuilder();
        execCmdResponse.append("Tx success = 463").append("\n");
        execCmdResponse.append("Tx success without retry = 425").append("\n");
        execCmdResponse.append("Tx success after retry = 38").append("\n");
        execCmdResponse.append("Tx fail to Rcv ACK after retry = 0").append("\n");
        execCmdResponse.append("RTS Success Rcv CTS = 0").append("\n");
        execCmdResponse.append("RTS Fail Rcv CTS = 0").append("\n");
        execCmdResponse.append("Rx success = 11425").append("\n");
        execCmdResponse.append("Rx with CRC = 3236").append("\n");
        execCmdResponse.append("Rx drop due to out of resource = 0").append("\n");
        execCmdResponse.append("Rx duplicate frame = 4").append("\n");
        execCmdResponse.append("False CCA (one second) = 0").append("\n");
        execCmdResponse.append("RSSI-A -35").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(execCmdResponse.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
    }

    @Test
    public void testCheckRssiEmptyExecCmdResponse() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        CommandResult result = new CommandResult();
        result.setOutput("");
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)-1, (Object)response);
    }

    @Test
    public void testCheckRssiNullExecCmdResponse() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan.sh")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraVivotekGeneric.checkRSSI(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
    }

    protected String prepareConfigurationPrivacyButtonRequest(boolean enabled) {
        StringBuilder request = new StringBuilder();
        request.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?");
        request.append("enable=").append(enabled ? "1" : "0");
        return request.toString();
    }

    private String prepareDeviceSettingsResponseBody(String viewerUsername, String alarmUsername, String alarmPassword, String deviceMacAddress, String highResolution, String lowResolution, String videoFps, String videoQuality, boolean ledOffEnabled, boolean motionDetectionEnabled, boolean pirSupported, boolean mdSupported, MotionDetection motionDetection, int alarmLimit, String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String prepsharedKey, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        String supportedResolutions = "176x144,320x240,640x480,800x600,1280x1024";
        return this.prepareDeviceSettingsResponseBody(viewerUsername, alarmUsername, alarmPassword, deviceMacAddress, supportedResolutions, highResolution, lowResolution, videoFps, videoQuality, ledOffEnabled, motionDetectionEnabled, pirSupported, mdSupported, motionDetection, alarmLimit, ssid, wlanMode, channel, encryption, algorithm, prepsharedKey, wepAuthMode, wepKeyLength, wepKeyFormat, wepKeyIndex, key1, key2, key3, key4);
    }

    private String prepareDeviceSettingsResponseBody(String viewerUsername, String alarmUsername, String alarmPassword, String deviceMacAddress, String supportedResolutions, String highResolution, String lowResolution, String videoFps, String videoQuality, boolean ledOffEnabled, boolean motionDetectionEnabled, boolean pirSupported, boolean mdSupported, MotionDetection motionDetection, int alarmLimit, String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String prepsharedKey, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        StringBuilder settings = new StringBuilder();
        settings.append("system_hostname='Wireless Network Camera'").append("\n");
        settings.append("system_ledoff='").append(ledOffEnabled ? "1" : "0").append("'").append("\n");
        settings.append("system_date='2011/04/22'").append("\n");
        settings.append("system_time='12:38:36'").append("\n");
        settings.append("system_info_modelname='TC5633'").append("\n");
        settings.append("system_info_serialnumber='0002D106CD80'").append("\n");
        settings.append("system_info_firmwareversion='TC5633-TCSW-0100h'").append("\n");
        settings.append("system_ntp='ntp.homemonitor.ch'").append("\n");
        settings.append("system_timezoneindex='00'").append("\n");
        settings.append("system_updateinterval='3600'").append("\n");
        settings.append("security_user_i0_name='root'").append("\n");
        settings.append("security_user_i0_pass='rootPass'").append("\n");
        settings.append("security_user_i0_privilege='admin'").append("\n");
        settings.append("security_user_i1_name='test'").append("\n");
        settings.append("security_user_i1_privilege='view'").append("\n");
        settings.append("security_user_i1_name='").append(viewerUsername).append("'").append("\n");
        settings.append("security_user_i1_privilege='view'").append("\n");
        settings.append("capability_protocol_rtp_http='1'").append("\n");
        settings.append("capability_protocol_spush_mjpeg='0'").append("\n");
        settings.append("capability_videoin_resolution='").append(supportedResolutions).append("'").append("\n");
        settings.append("capability_ptzenabled='383'").append("\n");
        settings.append("capability_network_wireless='1'").append("\n");
        settings.append("capability_npir='").append(pirSupported ? "1" : "0").append("'").append("\n");
        if (mdSupported) {
            settings.append("motion_c0_enable='0'").append("\n");
        }
        settings.append("camctrl_c0_panspeed='3'").append("\n");
        settings.append("camctrl_c0_tiltspeed='3'").append("\n");
        settings.append("network_http_authmode='basic'").append("\n");
        settings.append("network_http_alternateport=''").append("\n");
        settings.append("videoin_c0_s0_codectype='mjpeg'").append("\n");
        settings.append("videoin_c0_s0_resolution='").append(lowResolution).append("'").append("\n");
        settings.append("videoin_c0_s0_mjpeg_maxframe='").append(videoFps).append("'").append("\n");
        settings.append("videoin_c0_s0_mjpeg_quant='").append(videoQuality).append("'").append("\n");
        settings.append("videoin_c0_s1_codectype='mjpeg'").append("\n");
        settings.append("videoin_c0_s1_resolution='").append(highResolution).append("'").append("\n");
        settings.append("videoin_c0_s1_mjpeg_maxframe='").append(videoFps).append("'").append("\n");
        settings.append("videoin_c0_s1_mjpeg_quant='").append(videoQuality).append("'").append("\n");
        settings.append("event_i0_enable='").append(motionDetectionEnabled ? "1" : "0").append("'\n");
        if (motionDetection != MotionDetection.NONE) {
            settings.append("server_i0_name='HOMEMONITOR'").append("\n");
            settings.append("server_i0_type='http'").append("\n");
            settings.append("server_i0_http_url='http://homemonitor.ch:8080/app/events/motion/vivotek?id=0002D106CD80'").append("\n");
            settings.append("server_i0_http_username='alarmUsername'").append("\n");
            settings.append("server_i0_http_passwd='alarmPassword'").append("\n");
            settings.append("media_i0_name='HOMEMONITOR'").append("\n");
            settings.append("media_i0_type='snapshot'").append("\n");
            settings.append("media_i0_snapshot_source='1'").append("\n");
            settings.append("media_i0_snapshot_prefix='0002D106CD80_'").append("\n");
            settings.append("media_i0_snapshot_datesuffix='1'").append("\n");
            settings.append("media_i0_snapshot_preevent='0'").append("\n");
            settings.append("media_i0_snapshot_postevent='0'").append("\n");
            settings.append("event_i0_priority='1'").append("\n");
            settings.append("event_i0_delay='").append(alarmLimit).append("'").append("\n");
            settings.append("event_i0_di='2'").append("\n");
            settings.append("event_i0_weekday='127'").append("\n");
            settings.append("event_i0_begintime='00:00'").append("\n");
            settings.append("event_i0_endtime='24:00'").append("\n");
            settings.append("event_i0_action_server_i0_enable='1'").append("\n");
            settings.append("event_i0_action_server_i0_media='0'").append("\n");
        }
        if (motionDetection == MotionDetection.MD) {
            settings.append("event_i0_name='HOMEMONITOR_MD'").append("\n");
            settings.append("event_i0_trigger='motion'").append("\n");
            settings.append("event_i0_mdwin='1'").append("\n");
            settings.append("motion_c0_enable='1'").append("\n");
            settings.append("motion_c0_win_i0_enable='1'").append("\n");
            settings.append("motion_c0_win_i0_name='HOMEMONITOR'").append("\n");
            settings.append("motion_c0_win_i0_left='0'").append("\n");
            settings.append("motion_c0_win_i0_top='0'").append("\n");
            settings.append("motion_c0_win_i0_width='320'").append("\n");
            settings.append("motion_c0_win_i0_height='240'").append("\n");
            settings.append("motion_c0_win_i0_objsize='20'").append("\n");
            settings.append("motion_c0_win_i0_sensitivity='80'").append("\n");
        } else if (motionDetection == MotionDetection.PIR) {
            settings.append("event_i0_name='HOMEMONITOR_PIR'").append("\n");
            settings.append("event_i0_trigger='di'").append("\n");
        }
        settings.append("wireless_ssid='").append(ssid).append("'\n");
        settings.append("wireless_wlmode='").append(wlanMode.getCode()).append("'\n");
        settings.append("wireless_channel='").append(channel).append("'\n");
        settings.append("wireless_txrate='0'").append("\n");
        settings.append("wireless_encrypt='").append(encryption.getCode()).append("'\n");
        settings.append("wireless_authmode='").append(wepAuthMode.getCode()).append("'\n");
        settings.append("wireless_keylength='").append(wepKeyLength).append("'\n");
        settings.append("wireless_keyformat='").append(wepKeyFormat).append("'\n");
        settings.append("wireless_keyselect='").append(wepKeyIndex).append("'\n");
        settings.append("wireless_key1='").append(key1).append("'\n");
        settings.append("wireless_key2='").append(key2).append("'\n");
        settings.append("wireless_key3='").append(key3).append("'\n");
        settings.append("wireless_key4='").append(key4).append("'\n");
        settings.append("wireless_domain='0'").append("\n");
        settings.append("wireless_algorithm='").append(algorithm.name()).append("'\n");
        settings.append("wireless_presharedkey='").append(prepsharedKey).append("'\n");
        return settings.toString();
    }

    protected HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, String body) {
        return this.prepareResponse(result, null, body);
    }

    protected HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, Integer statusCode, String body) {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(result);
        response.setStatusCode(statusCode);
        if (body != null) {
            response.setBody(body.toString().getBytes());
        }
        return response;
    }

    private LanDeviceEntity prepareExpectedDeviceWithOpenWifi(boolean supportedPrivacyButton, String ssid, String wlanMode, String channel, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, true, ssid, wlanMode, channel, "OPEN", "NONE", "", "", "", "", "", "", "", "", "", wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDeviceWithWepWifi(boolean supportedPrivacyButton, String ssid, String wlanMode, String channel, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, true, ssid, wlanMode, channel, "WEP", "WEP", authAuthMode, wepKeyLength, wepKeyFormat, key1, key2, key3, key4, keyIndex, "", wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDeviceWithWpaWifi(boolean supportedPrivacyButton, String ssid, String wlanMode, String channel, String encryption, String algorithm, String preSharedKey, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, true, ssid, wlanMode, channel, encryption, algorithm, "", "", "", "", "", "", "", "", preSharedKey, wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDeviceWithoutWifi(boolean supportedPrivacyButton) {
        return this.prepareExpectedDevice(supportedPrivacyButton, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private LanDeviceEntity prepareExpectedDevice(boolean supportedPrivacyButton, boolean supportedWifi, String ssid, String wlanMode, String channel, String encryption, String algorithm, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String preSharedKey, String wifiEnabled) {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("record_video", "OFF", null);
        device.setParam("video_recording_duration", "15", null);
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        if (supportedPrivacyButton) {
            device.setParam("privacy_button", "ON", "ON");
        }
        if (supportedWifi) {
            device.setParam("need_restart_after_network_changes", "ON", null);
            device.setParam("wifi_enabled", wifiEnabled, wifiEnabled);
            device.setParam("wifi_ssid", ssid, ssid);
            device.setParam("wifi_wlan_mode", wlanMode, wlanMode);
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", channel, channel);
            device.setParam("wifi_encryption", encryption, encryption);
            device.setParam("wifi_alghoritm", algorithm, algorithm);
            device.setParam("wifi_wep_auth_mode", authAuthMode, authAuthMode);
            device.setParam("wifi_wep_key_length", wepKeyLength, wepKeyLength);
            device.setParam("wifi_wep_key_format", wepKeyFormat, wepKeyFormat);
            device.setParam("wifi_wep_key1", key1, key1);
            device.setParam("wifi_wep_key2", key2, key2);
            device.setParam("wifi_wep_key3", key3, key3);
            device.setParam("wifi_wep_key4", key4, key4);
            device.setParam("wifi_wep_default_key", keyIndex, keyIndex);
            device.setParam("wifi_pre_shared_key", preSharedKey, preSharedKey);
        }
        return device;
    }

    private Map<String, String> prepareDeviceCapabilitiesWithNoneSecuredWifi(boolean registeredViewerUser, String ssid, WlanMode wlanMode, Integer channel) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, Encryption.OPEN, WepAuthMode.OPEN, "64", "HEX", "", "", "", "", "", Algorithm.AES, "");
    }

    private Map<String, String> prepareDeviceCapabilitiesWithWepSecuredWifi(boolean registeredViewerUser, String ssid, WlanMode wlanMode, Integer channel, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, Encryption.WEP, wepAuthMode, wepKeyLength, wepKeyFormat, wepKeyIndex, key1, key2, key3, key4, Algorithm.AES, "");
    }

    private Map<String, String> prepareDeviceCapabilitiesWithWpaSecuredWifi(boolean registeredViewerUser, String ssid, WlanMode wlanMode, Integer channel, Encryption encryption, Algorithm algorithm, String preSharedKey) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, encryption, WepAuthMode.OPEN, "64", "HEX", "", "", "", "", "", algorithm, preSharedKey);
    }

    private Map<String, String> prepareDeviceCapabilities(boolean registeredViewerUser, boolean wifiSupport, String ssid, WlanMode wlanMode, Integer channel, Encryption encryption, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4, Algorithm algorithm, String preSharedKey) {
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        if (registeredViewerUser) {
            deviceCapabilities.put("security_user_i3_name", "viewerUser");
        }
        deviceCapabilities.put("capability_network_wireless", wifiSupport ? "1" : "0");
        deviceCapabilities.put("capability_npir", "1");
        deviceCapabilities.put("capability_ptzenabled", "383");
        deviceCapabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        if (wifiSupport) {
            deviceCapabilities.put("wireless_ssid", ssid);
            deviceCapabilities.put("wireless_wlmode", wlanMode.getCode());
            deviceCapabilities.put("wireless_channel", String.valueOf(channel));
            deviceCapabilities.put("wireless_txrate", "0");
            deviceCapabilities.put("wireless_encrypt", encryption.getCode());
            deviceCapabilities.put("wireless_authmode", wepAuthMode.getCode());
            deviceCapabilities.put("wireless_keylength", wepKeyLength);
            deviceCapabilities.put("wireless_keyformat", wepKeyFormat);
            deviceCapabilities.put("wireless_keyselect", String.valueOf(wepKeyIndex));
            deviceCapabilities.put("wireless_key1", key1);
            deviceCapabilities.put("wireless_key2", key2);
            deviceCapabilities.put("wireless_key3", key3);
            deviceCapabilities.put("wireless_key4", key4);
            deviceCapabilities.put("wireless_domain", "0");
            deviceCapabilities.put("wireless_algorithm", algorithm.name());
            deviceCapabilities.put("wireless_presharedkey", preSharedKey);
        }
        return deviceCapabilities;
    }

    private StringBuilder prepareConfigurationRequest(boolean updateViewerUser, boolean configurePanSpeed, boolean configureTiltSpeed, boolean configureLedoff, MotionDetection motionDetection, String lowResolution, String highResolution) {
        StringBuilder confRequest = new StringBuilder();
        confRequest.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/setparam.cgi?");
        confRequest.append("system_updateinterval=3600&");
        confRequest.append("system_ntp=ntp.homemonitor.ch&");
        if (configureLedoff) {
            confRequest.append("system_ledoff=0&");
        }
        confRequest.append("system_timezoneindex=00&");
        if (configurePanSpeed) {
            confRequest.append("camctrl_c0_panspeed=3&");
        }
        if (configureTiltSpeed) {
            confRequest.append("camctrl_c0_tiltspeed=3&");
        }
        confRequest.append("network_http_alternateport=&");
        confRequest.append("network_http_authmode=basic&");
        confRequest.append("videoin_c0_s0_codectype=mjpeg&");
        confRequest.append("videoin_c0_s0_resolution=").append(lowResolution).append("&");
        confRequest.append("videoin_c0_s0_mjpeg_maxframe=5&");
        confRequest.append("videoin_c0_s0_mjpeg_quant=3&");
        confRequest.append("videoin_c0_s1_codectype=mjpeg&");
        confRequest.append("videoin_c0_s1_resolution=").append(highResolution).append("&");
        confRequest.append("videoin_c0_s1_mjpeg_maxframe=5&");
        confRequest.append("videoin_c0_s1_mjpeg_quant=3&");
        if (motionDetection != MotionDetection.NONE) {
            confRequest.append("server_i0_name=HOMEMONITOR&");
            confRequest.append("server_i0_type=http&");
            confRequest.append("server_i0_http_url=http://homemonitor.ch/events/motion/vivotek?id=0002D106CD80&");
            confRequest.append("server_i0_http_username=alarmUser&");
            confRequest.append("server_i0_http_passwd=alarmPass&");
            confRequest.append("media_i0_name=HOMEMONITOR&");
            confRequest.append("media_i0_type=snapshot&");
            confRequest.append("media_i0_snapshot_source=1&");
            confRequest.append("media_i0_snapshot_prefix=0002D106CD80_&");
            confRequest.append("media_i0_snapshot_datesuffix=1&");
            confRequest.append("media_i0_snapshot_preevent=0&");
            confRequest.append("media_i0_snapshot_postevent=0&");
            confRequest.append("event_i0_enable=0&");
            confRequest.append("event_i0_priority=1&");
            confRequest.append("event_i0_delay=1&");
            confRequest.append("event_i0_weekday=127&");
            confRequest.append("event_i0_begintime=00:00&");
            confRequest.append("event_i0_endtime=24:00&");
            confRequest.append("event_i0_action_server_i0_enable=1&");
            confRequest.append("event_i0_action_server_i0_media=0&");
        }
        if (motionDetection == MotionDetection.MD) {
            confRequest.append("event_i0_name=HOMEMONITOR_MD&");
            confRequest.append("event_i0_trigger=motion&");
            confRequest.append("event_i0_mdwin=1&");
            confRequest.append("motion_c0_enable=1&");
            confRequest.append("motion_c0_win_i0_enable=1&");
            confRequest.append("motion_c0_win_i0_name=HOMEMONITOR&");
            confRequest.append("motion_c0_win_i0_left=0&");
            confRequest.append("motion_c0_win_i0_top=0&");
            confRequest.append("motion_c0_win_i0_width=320&");
            confRequest.append("motion_c0_win_i0_height=240&");
            confRequest.append("motion_c0_win_i0_objsize=20&");
            confRequest.append("motion_c0_win_i0_sensitivity=80&");
        } else if (motionDetection == MotionDetection.PIR) {
            confRequest.append("event_i0_name=HOMEMONITOR_PIR&");
            confRequest.append("event_i0_trigger=di&");
            confRequest.append("event_i0_di=2&");
        }
        confRequest.append("security_user_i0_pass=rootPass");
        if (updateViewerUser) {
            confRequest.append("&security_user_i3_pass=viewerPass&");
            confRequest.append("security_user_i3_privilege=view");
        }
        return confRequest;
    }

    private StringBuilder prepareConfigurationResponse(boolean updateViewerUser, boolean configurePanSpeed, boolean configureTiltSpeed, boolean configureLedoff, MotionDetection motionDetection, String lowResolution, String highResolution, boolean completeResponse) {
        StringBuilder confResponse = new StringBuilder();
        if (configureLedoff) {
            confResponse.append("system_ledoff=0 ");
        }
        confResponse.append("system_timezoneindex=00 ");
        confResponse.append("system_updateinterval=3600 ");
        confResponse.append("system_ntp=ntp.homemonitor.ch ");
        if (configurePanSpeed) {
            confResponse.append("camctrl_c0_panspeed=3 ");
        }
        if (configureTiltSpeed) {
            confResponse.append("camctrl_c0_tiltspeed=3 ");
        }
        confResponse.append("network_http_alternateport= ");
        if (completeResponse) {
            confResponse.append("network_http_authmode=basic ");
        }
        confResponse.append("videoin_c0_s0_codectype=mjpeg ");
        confResponse.append("videoin_c0_s0_resolution=").append(lowResolution).append(" ");
        confResponse.append("videoin_c0_s0_mjpeg_maxframe=5 ");
        confResponse.append("videoin_c0_s0_mjpeg_quant=3 ");
        confResponse.append("videoin_c0_s1_codectype=mjpeg ");
        confResponse.append("videoin_c0_s1_resolution=").append(highResolution).append(" ");
        confResponse.append("videoin_c0_s1_mjpeg_maxframe=5 ");
        confResponse.append("videoin_c0_s1_mjpeg_quant=3 ");
        if (motionDetection != MotionDetection.NONE) {
            confResponse.append("server_i0_name=HOMEMONITOR ");
            confResponse.append("server_i0_type=http ");
            confResponse.append("server_i0_http_url=http://homemonitor.ch/events/motion/vivotek?id=0002D106CD80 ");
            confResponse.append("server_i0_http_username=alarmUser ");
            confResponse.append("server_i0_http_passwd=alarmPass ");
            confResponse.append("media_i0_name=HOMEMONITOR ");
            confResponse.append("media_i0_type=snapshot ");
            confResponse.append("media_i0_snapshot_source=1 ");
            confResponse.append("media_i0_snapshot_prefix=0002D106CD80_ ");
            confResponse.append("media_i0_snapshot_datesuffix=1 ");
            confResponse.append("media_i0_snapshot_preevent=0 ");
            confResponse.append("media_i0_snapshot_postevent=0 ");
            confResponse.append("event_i0_enable=0 ");
            confResponse.append("event_i0_priority=1 ");
            confResponse.append("event_i0_delay=1 ");
            confResponse.append("event_i0_weekday=127 ");
            confResponse.append("event_i0_begintime=00:00 ");
            confResponse.append("event_i0_endtime=24:00 ");
            confResponse.append("event_i0_action_server_i0_enable=1 ");
            confResponse.append("event_i0_action_server_i0_media=0 ");
        }
        if (motionDetection == MotionDetection.MD) {
            confResponse.append("event_i0_name=HOMEMONITOR_MD ");
            confResponse.append("event_i0_trigger=motion ");
            confResponse.append("event_i0_mdwin=1 ");
            confResponse.append("motion_c0_enable=1 ");
            confResponse.append("motion_c0_win_i0_enable=1 ");
            confResponse.append("motion_c0_win_i0_name=HOMEMONITOR ");
            confResponse.append("motion_c0_win_i0_left=0 ");
            confResponse.append("motion_c0_win_i0_top=0 ");
            confResponse.append("motion_c0_win_i0_width=320 ");
            confResponse.append("motion_c0_win_i0_height=240 ");
            confResponse.append("motion_c0_win_i0_objsize=20 ");
            confResponse.append("motion_c0_win_i0_sensitivity=80 ");
        } else if (motionDetection == MotionDetection.PIR) {
            confResponse.append("event_i0_name=HOMEMONITOR_PIR ");
            confResponse.append("event_i0_trigger=di ");
            confResponse.append("event_i0_di=2 ");
        }
        confResponse.append("security_user_i0_pass=rootPass ");
        if (updateViewerUser) {
            confResponse.append("security_user_i3_pass=viewerPass ");
            confResponse.append("security_user_i3_privilege=view ");
        }
        return confResponse;
    }

    private String prepareDeviceConfigurationUrl(String viewerUsername, String alarmUsername, String alarmPassword, MotionDetection motionDetection, String highResolution, String lowResolution, String videoFps, String videoQuality, String deviceMacAddress, boolean ledOffEnabled, boolean motionDetectionEnabled, int alarmLimit, String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String prepsharedKey, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        StringBuilder settings = new StringBuilder();
        settings.append("http://root:rootPass@192.168.21.138:80/cgi-bin/admin/setparam.cgi?");
        settings.append("system_ledoff=").append(ledOffEnabled ? "1" : "0");
        settings.append("&security_user_i0_pass=rootPass");
        settings.append("&security_user_i1_pass=viewerPassword");
        settings.append("&security_user_i1_privilege=view");
        settings.append("&camctrl_c0_panspeed=3");
        settings.append("&camctrl_c0_tiltspeed=3");
        settings.append("&system_ntp=ntp.homemonitor.ch");
        settings.append("&system_timezoneindex=00");
        settings.append("&system_updateinterval=3600");
        settings.append("&network_http_authmode=basic");
        settings.append("&network_http_alternateport=");
        settings.append("&videoin_c0_s0_codectype=mjpeg");
        settings.append("&videoin_c0_s0_resolution=").append(lowResolution);
        settings.append("&videoin_c0_s0_mjpeg_maxframe=").append(videoFps);
        settings.append("&videoin_c0_s0_mjpeg_quant=").append(videoQuality);
        settings.append("&videoin_c0_s1_codectype=mjpeg");
        settings.append("&videoin_c0_s1_resolution=").append(highResolution);
        settings.append("&videoin_c0_s1_mjpeg_maxframe=").append(videoFps);
        settings.append("&videoin_c0_s1_mjpeg_quant=").append(videoQuality);
        if (motionDetection != MotionDetection.NONE) {
            settings.append("&server_i0_name=HOMEMONITOR");
            settings.append("&server_i0_type=http");
            settings.append("&server_i0_http_url=http://homemonitor.ch:8080/app/events/motion/vivotek?id=0002D106CD80");
            settings.append("&server_i0_http_username=alarmUsername");
            settings.append("&server_i0_http_passwd=alarmPassword");
            settings.append("&media_i0_name=HOMEMONITOR");
            settings.append("&media_i0_type=snapshot");
            settings.append("&media_i0_snapshot_source=1");
            settings.append("&media_i0_snapshot_prefix=0002D106CD80_");
            settings.append("&media_i0_snapshot_datesuffix=1");
            settings.append("&media_i0_snapshot_preevent=0");
            settings.append("&media_i0_snapshot_postevent=0");
            settings.append("&event_i0_enable=").append(motionDetectionEnabled ? "1" : "0");
            settings.append("&event_i0_priority=1");
            settings.append("&event_i0_delay=").append(alarmLimit).append("");
            settings.append("&event_i0_weekday=127");
            settings.append("&event_i0_begintime=00:00");
            settings.append("&event_i0_endtime=24:00");
            settings.append("&event_i0_action_server_i0_enable=1");
            settings.append("&event_i0_action_server_i0_media=0");
        }
        if (motionDetection == MotionDetection.MD) {
            settings.append("&event_i0_name=HOMEMONITOR_MD");
            settings.append("&event_i0_trigger=motion");
            settings.append("&event_i0_mdwin=1");
            settings.append("&motion_c0_enable=1");
            settings.append("&motion_c0_win_i0_enable=1");
            settings.append("&motion_c0_win_i0_name=HOMEMONITOR");
            settings.append("&motion_c0_win_i0_left=0");
            settings.append("&motion_c0_win_i0_top=0");
            settings.append("&motion_c0_win_i0_width=320");
            settings.append("&motion_c0_win_i0_height=240");
            settings.append("&motion_c0_win_i0_objsize=20");
            settings.append("&motion_c0_win_i0_sensitivity=80");
        } else if (motionDetection == MotionDetection.PIR) {
            settings.append("&event_i0_name=HOMEMONITOR_PIR");
            settings.append("&event_i0_trigger=di");
            settings.append("&event_i0_di=2");
        }
        settings.append("&wireless_ssid=").append(ssid);
        settings.append("&wireless_wlmode=").append(wlanMode.getCode());
        settings.append("&wireless_channel=").append(channel);
        settings.append("&wireless_txrate=0");
        settings.append("&wireless_encrypt=").append(encryption.getCode());
        if (encryption != Encryption.OPEN) {
            if (encryption == Encryption.WEP) {
                settings.append("&wireless_authmode=").append(wepAuthMode.getCode());
                settings.append("&wireless_keylength=").append(wepKeyLength);
                settings.append("&wireless_keyformat=").append(wepKeyFormat);
                settings.append("&wireless_keyselect=").append(wepKeyIndex);
                settings.append("&wireless_key1=").append(key1);
                settings.append("&wireless_key2=").append(key2);
                settings.append("&wireless_key3=").append(key3);
                settings.append("&wireless_key4=").append(key4);
            } else {
                settings.append("&wireless_algorithm=").append(algorithm.name());
                settings.append("&wireless_presharedkey=").append(prepsharedKey);
            }
        }
        return settings.toString();
    }

    private String prepareDeviceConfigurationResponseBody(String viewerUsername, String alarmUsername, String alarmPassword, MotionDetection motionDetection, String highResolution, String lowResolution, String videoFps, String videoQuality, String deviceMacAddress, boolean ledOffEnabled, boolean motionDetectionEnabled, int alarmLimit, String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String prepsharedKey, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        StringBuilder settings = new StringBuilder();
        settings.append("system_ledoff=").append(ledOffEnabled ? "1" : "0");
        settings.append(" security_user_i0_pass=rootPass");
        settings.append(" security_user_i1_pass=viewerPassword");
        settings.append(" security_user_i1_privilege=view");
        settings.append(" camctrl_c0_panspeed=3");
        settings.append(" camctrl_c0_tiltspeed=3");
        settings.append(" system_ntp=ntp.homemonitor.ch");
        settings.append(" system_timezoneindex=00");
        settings.append(" system_updateinterval=3600");
        settings.append(" network_http_authmode=basic");
        settings.append(" network_http_alternateport=");
        settings.append(" videoin_c0_s0_codectype=mjpeg");
        settings.append(" videoin_c0_s0_resolution=").append(lowResolution);
        settings.append(" videoin_c0_s0_mjpeg_maxframe=").append(videoFps);
        settings.append(" videoin_c0_s0_mjpeg_quant=").append(videoQuality);
        settings.append(" videoin_c0_s1_codectype=mjpeg");
        settings.append(" videoin_c0_s1_resolution=").append(highResolution);
        settings.append(" videoin_c0_s1_mjpeg_maxframe=").append(videoFps);
        settings.append(" videoin_c0_s1_mjpeg_quant=").append(videoQuality);
        if (motionDetection != MotionDetection.NONE) {
            settings.append(" server_i0_name=HOMEMONITOR");
            settings.append(" server_i0_type=http");
            settings.append(" server_i0_http_url=http://homemonitor.ch:8080/app/events/motion/vivotek?id=0002D106CD80");
            settings.append(" server_i0_http_username=alarmUsername");
            settings.append(" server_i0_http_passwd=alarmPassword");
            settings.append(" media_i0_name=HOMEMONITOR");
            settings.append(" media_i0_type=snapshot");
            settings.append(" media_i0_snapshot_source=1");
            settings.append(" media_i0_snapshot_prefix=0002D106CD80_");
            settings.append(" media_i0_snapshot_datesuffix=1");
            settings.append(" media_i0_snapshot_preevent=0");
            settings.append(" media_i0_snapshot_postevent=0");
            settings.append(" event_i0_enable=").append(motionDetectionEnabled ? "1" : "0");
            settings.append(" event_i0_priority=1");
            settings.append(" event_i0_delay=").append(alarmLimit);
            settings.append(" event_i0_di=2");
            settings.append(" event_i0_weekday=127");
            settings.append(" event_i0_begintime=00:00");
            settings.append(" event_i0_endtime=24:00");
            settings.append(" event_i0_action_server_i0_enable=1");
            settings.append(" event_i0_action_server_i0_media=0");
        }
        if (motionDetection == MotionDetection.MD) {
            settings.append(" event_i0_name=HOMEMONITOR_MD");
            settings.append(" event_i0_trigger=motion");
            settings.append(" event_i0_mdwin=1");
            settings.append(" motion_c0_enable=1");
            settings.append(" motion_c0_win_i0_enable=1");
            settings.append(" motion_c0_win_i0_name=HOMEMONITOR");
            settings.append(" motion_c0_win_i0_left=0");
            settings.append(" motion_c0_win_i0_top=0");
            settings.append(" motion_c0_win_i0_width=320");
            settings.append(" motion_c0_win_i0_height=240");
            settings.append(" motion_c0_win_i0_objsize=20");
            settings.append(" motion_c0_win_i0_sensitivity=80");
        } else if (motionDetection == MotionDetection.PIR) {
            settings.append(" event_i0_name=HOMEMONITOR_PIR");
            settings.append(" event_i0_trigger=di");
        }
        settings.append(" wireless_ssid=").append(ssid);
        settings.append(" wireless_wlmode=").append(wlanMode.getCode());
        settings.append(" wireless_channel=").append(channel);
        settings.append(" wireless_txrate=0");
        settings.append(" wireless_encrypt=").append(encryption.getCode());
        if (encryption != Encryption.OPEN) {
            if (encryption == Encryption.WEP) {
                settings.append(" wireless_authmode=").append(wepAuthMode.getCode());
                settings.append(" wireless_keylength=").append(wepKeyLength);
                settings.append(" wireless_keyformat=").append(wepKeyFormat);
                settings.append(" wireless_keyselect=").append(wepKeyIndex);
                settings.append(" wireless_key1=").append(key1);
                settings.append(" wireless_key2=").append(key2);
                settings.append(" wireless_key3=").append(key3);
                settings.append(" wireless_key4=").append(key4);
            } else {
                settings.append(" wireless_algorithm=").append(algorithm.name());
                settings.append(" wireless_presharedkey=").append(prepsharedKey);
            }
        }
        return settings.toString();
    }
}

