/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containserserver.landevice.CameraVivotekConfigurationBuilder;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericInternal;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekGeneric.class})
public class CameraVivotekGenericReconfigurationTests
extends CameraVivotekGenericInternal {
    @Test
    public void testReconfigureSuccessfulyWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "MODERATE", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 2);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 3, 2);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "VERY_GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 4);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 4);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 30, 5);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithCifResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 2);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("QCIF, CIF, 4CIF");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "CIF", "4CIF", 20, 5);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithPirMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 30, 5);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("QCIF, CIF, 4CIF");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "CIF", "4CIF", 20, 5);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithMdMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "BEST", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 30, 5);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("QCIF, CIF, 4CIF");
        currentConfiguration.setPirSupported(false);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "CIF", "4CIF", 20, 5);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.MD, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirSupported(true);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "OFF", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("alarm_limit", "5", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "AD_HOC", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("0");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 720, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.AD_HOC, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "128", "HEX", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "10", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 360, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "sharedKey");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "15", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 240, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "30", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 120, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "sharedKey");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON");
        device.setParam("max_videoclip_duration", "10");
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 60, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWifiDisabled() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 60, true, false, 10);
        correctConfiguration.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithMjpegVideoEncoding() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoClipNotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("has_videoclip_recording", "OFF", null);
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, false, true, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoClipNotSupportedDueToMissingParam() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, false, true, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithEnabedVideoClipAndEnabledMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, true, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithEnabedVideoClipAndDisabledMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MJPEG");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "ACCEPTABLE", "");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        storedCapabilities.put("00:1A:B6:00:0B:B5", currentConfiguration.getConfiguration());
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 2, 1);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        correctConfiguration.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "2", "key1", "key2", "key3", "key4");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureDownloadDeviceCapabilities() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.ERROR, null));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.ERROR, (Object)this.cameraVivotekGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureConfigurePrivacyButton() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "60", "");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "live.sdp", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA2", "");
        device.setParam("wifi_alghoritm", "AES_CCMP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 3, 1);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, "ok"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureSendConfiguration() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON");
        device.setParam("viewer_user", "viewerUsername");
        device.setParam("viewer_pass", "viewerPassword");
        device.setParam("alarm_user", "alarmUsername");
        device.setParam("alarm_pass", "alarmPassword");
        device.setParam("motion_detection", "ON");
        device.setParam("system_ledoff", "ON");
        device.setParam("alarm_limit", "60");
        device.setParam("video_quality", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON");
        device.setParam("has_pan", "ON");
        device.setParam("has_tilt", "ON");
        device.setParam("has_zoom", "ON");
        device.setParam("need_restart_after_network_changes", "ON");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("wifi_enabled", "ON");
        device.setParam("wifi_ssid", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "");
        device.setParam("wifi_channel", "4");
        device.setParam("wifi_encryption", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "");
        device.setParam("wifi_wep_key_length", "");
        device.setParam("wifi_wep_key_format", "");
        device.setParam("wifi_wep_key1", "");
        device.setParam("wifi_wep_key2", "");
        device.setParam("wifi_wep_key3", "");
        device.setParam("wifi_wep_key4", "");
        device.setParam("wifi_wep_default_key", "");
        device.setParam("wifi_pre_shared_key", "sharedKey");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.NOANSWER);
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 60, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureSomeSettingsHasNotBeenApply() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON");
        device.setParam("viewer_user", "viewerUsername");
        device.setParam("viewer_pass", "viewerPassword");
        device.setParam("alarm_user", "alarmUsername");
        device.setParam("alarm_pass", "alarmPassword");
        device.setParam("motion_detection", "ON");
        device.setParam("system_ledoff", "ON");
        device.setParam("alarm_limit", "60");
        device.setParam("video_quality", "GOOD");
        device.setParam("has_home", "ON");
        device.setParam("has_pan", "ON");
        device.setParam("has_tilt", "ON");
        device.setParam("has_zoom", "ON");
        device.setParam("need_restart_after_network_changes", "ON");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("wifi_enabled", "ON");
        device.setParam("wifi_ssid", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "");
        device.setParam("wifi_channel", "4");
        device.setParam("wifi_encryption", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "");
        device.setParam("wifi_wep_key_length", "");
        device.setParam("wifi_wep_key_format", "");
        device.setParam("wifi_wep_key1", "");
        device.setParam("wifi_wep_key2", "");
        device.setParam("wifi_wep_key3", "");
        device.setParam("wifi_wep_key4", "");
        device.setParam("wifi_wep_default_key", "");
        device.setParam("wifi_pre_shared_key", "sharedKey");
        String url = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
        CameraVivotekConfigurationBuilder currentConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        currentConfiguration.setSystemLedOff("1");
        currentConfiguration.setParam("system_timezoneindex", "00");
        currentConfiguration.setParam("system_updateinterval", "3600");
        currentConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        currentConfiguration.setParam("network_http_alternateport", "");
        currentConfiguration.setParam("network_http_authmode", "basic");
        currentConfiguration.setPanSpeed(3);
        currentConfiguration.setTiltSpeed(3);
        currentConfiguration.setAdminUser("rootPassword");
        currentConfiguration.setViewerUser("viewerUsername", null);
        currentConfiguration.setWifiSupported(true);
        currentConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        currentConfiguration.setAudioMuteEnabled(true);
        currentConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        currentConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        currentConfiguration.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        currentConfiguration.setPirCount(1);
        currentConfiguration.setModel("TC5633");
        currentConfiguration.setPtzSupport("15");
        this.expectSendRequest("00:1A:B6:00:0B:B5", url, this.prepareResponse(HTTPClientServiceResult.Result.OK, currentConfiguration.getConfigurationText()));
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(1)));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        HTTPClientService configurePrivacButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacButtonClient);
        Capture configurePrivacyButtonUrl = new Capture();
        EasyMock.expect((Object)configurePrivacButtonClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrl))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder correctConfiguration = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        correctConfiguration.setSystemLedOff("1");
        correctConfiguration.setParam("system_timezoneindex", "00");
        correctConfiguration.setParam("system_updateinterval", "3600");
        correctConfiguration.setParam("system_ntp", "ntp.homemonitor.ch");
        correctConfiguration.setParam("network_http_alternateport", "");
        correctConfiguration.setParam("network_http_authmode", "basic");
        correctConfiguration.setPanSpeed(3);
        correctConfiguration.setTiltSpeed(3);
        correctConfiguration.setAdminUser("rootPassword");
        correctConfiguration.setViewerUser("viewerUsername", "viewerPassword");
        correctConfiguration.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        correctConfiguration.setAudioMuteEnabled(true);
        correctConfiguration.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 60, true, false, 10);
        correctConfiguration.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        String configurationUrl = correctConfiguration.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        correctConfiguration.removeParam("system_timezoneindex");
        deviceConfResponse.setBody(correctConfiguration.getUpdateResponse(" ").getBytes());
        HTTPClientService configureDeviceClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureDeviceClient);
        Capture configureDeviceUrl = new Capture();
        EasyMock.expect((Object)configureDeviceClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureDeviceUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.MANUAL, (Object)this.cameraVivotekGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrl));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)configureDeviceUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }
}

