/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.Before;
import org.powermock.api.easymock.PowerMock;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekSettings;
import pl.smartapps.containserserver.landevice.CameraVivotekConfigurationBuilder;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericInternal;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;

public class CameraVivotekGenericInternal {
    protected CameraVivotekGeneric cameraVivotekGeneric;
    protected CameraVivotekSettings cameraVivotekSettings;
    protected HTTPClientService httpClientService;
    protected AuthenticationUtils authUtils;
    protected DeviceDescDAO deviceDescDAO;
    protected LanDeviceService lanDeviceService;
    protected SystemSupport systemSupport;
    protected ContainerserverServiceFactory serviceFactory;
    protected ParameterService parameterService;

    @Before
    public void setUp() {
        this.cameraVivotekGeneric = new CameraVivotekGeneric();
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        this.cameraVivotekSettings = (CameraVivotekSettings)PowerMock.createMock(CameraVivotekSettings.class);
        this.cameraVivotekGeneric.setCameraVivotekSettings(this.cameraVivotekSettings);
        this.httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.cameraVivotekGeneric.setAuthUtils(this.authUtils);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.cameraVivotekGeneric.setDeviceDescDAO(this.deviceDescDAO);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.cameraVivotekGeneric.setLanDeviceService(this.lanDeviceService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.cameraVivotekGeneric.setSystemSupport(this.systemSupport);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.cameraVivotekGeneric.setServiceFactory(this.serviceFactory);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.cameraVivotekGeneric.setParameterService(this.parameterService);
    }

    protected LanDeviceEntity prepareDeviceToInit() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setName("TC5633-TCSW-0100h");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setPort(Integer.valueOf(80));
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVersion("TC5633-TCSW-0100h");
        device.setParam("viewer_user", "viewerUsername");
        device.setParam("viewer_pass", "viewerPassword");
        device.setParam("alarm_user", "alarmUsername");
        device.setParam("alarm_pass", "alarmPassword");
        device.setGatewayClient(TestDataUtils.prepareGatewaClientEntity());
        device.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        device.setModel("TC5633");
        return device;
    }

    protected boolean verifyDevice(LanDeviceEntity expectedDevice, LanDeviceEntity device) {
        if (!expectedDevice.equals((Object)device)) {
            System.out.println("Device are not equals");
            System.out.println("device:         " + device);
            System.out.println("expectedDevice: " + expectedDevice);
            return false;
        }
        1 paramComparator = new /* Unavailable Anonymous Inner Class!! */;
        List expectedParams = expectedDevice.getLanDeviceParams();
        List params = device.getLanDeviceParams();
        Collections.sort(expectedParams, paramComparator);
        Collections.sort(params, paramComparator);
        if (!expectedParams.equals(params)) {
            System.out.println("Params are not equals");
            System.out.println("params:         " + params);
            System.out.println("expectedParams: " + expectedParams);
            return false;
        }
        return true;
    }

    protected String prepareConfigurationPrivacyButtonRequest(boolean enabled) {
        StringBuilder request = new StringBuilder();
        request.append("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?");
        request.append("enable=").append(enabled ? "1" : "0");
        return request.toString();
    }

    protected String prepareDeviceSettingsResponseBody(String viewerUsername, String alarmUsername, String alarmPassword, String deviceMacAddress, String highResolution, String lowResolution, String videoFps, String videoQuality, boolean ledOffEnabled, boolean motionDetectionEnabled, boolean pirSupported, boolean mdSupported, CameraVivotekConfigurationBuilder.MotionDetection motionDetection, int alarmLimit, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, int channel, CameraVivotekConfigurationBuilder.Encryption encryption, CameraVivotekConfigurationBuilder.Algorithm algorithm, String prepsharedKey, CameraVivotekConfigurationBuilder.WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        String supportedResolutions = "176x144,320x240,640x480,800x600,1280x1024";
        return this.prepareDeviceSettingsResponseBody(viewerUsername, alarmUsername, alarmPassword, deviceMacAddress, supportedResolutions, highResolution, lowResolution, videoFps, videoQuality, ledOffEnabled, motionDetectionEnabled, pirSupported, mdSupported, motionDetection, alarmLimit, ssid, wlanMode, channel, encryption, algorithm, prepsharedKey, wepAuthMode, wepKeyLength, wepKeyFormat, wepKeyIndex, key1, key2, key3, key4);
    }

    protected String prepareDeviceSettingsResponseBody(String viewerUsername, String alarmUsername, String alarmPassword, String deviceMacAddress, String supportedResolutions, String highResolution, String lowResolution, String videoFps, String videoQuality, boolean ledOffEnabled, boolean motionDetectionEnabled, boolean pirSupported, boolean mdSupported, CameraVivotekConfigurationBuilder.MotionDetection motionDetection, int alarmLimit, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, int channel, CameraVivotekConfigurationBuilder.Encryption encryption, CameraVivotekConfigurationBuilder.Algorithm algorithm, String prepsharedKey, CameraVivotekConfigurationBuilder.WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        StringBuilder settings = new StringBuilder();
        settings.append("system_hostname='Wireless Network Camera'").append("\n");
        settings.append("system_ledoff='").append(ledOffEnabled ? "1" : "0").append("'").append("\n");
        settings.append("system_date='2011/04/22'").append("\n");
        settings.append("system_time='12:38:36'").append("\n");
        settings.append("system_info_modelname='TC5633'").append("\n");
        settings.append("system_info_serialnumber='0002D106CD80'").append("\n");
        settings.append("system_info_firmwareversion='TC5633-TCSW-0100h'").append("\n");
        settings.append("system_ntp='ntp.homemonitor.ch'").append("\n");
        settings.append("system_timezoneindex='00'").append("\n");
        settings.append("system_updateinterval='3600'").append("\n");
        settings.append("security_user_i0_name='root'").append("\n");
        settings.append("security_user_i0_pass='rootPassword'").append("\n");
        settings.append("security_user_i0_privilege='admin'").append("\n");
        settings.append("security_user_i1_name='test'").append("\n");
        settings.append("security_user_i1_privilege='view'").append("\n");
        settings.append("security_user_i1_name='").append(viewerUsername).append("'").append("\n");
        settings.append("security_user_i1_privilege='view'").append("\n");
        settings.append("capability_protocol_rtp_http='1'").append("\n");
        settings.append("capability_protocol_spush_mjpeg='0'").append("\n");
        settings.append("capability_videoin_resolution='").append(supportedResolutions).append("'").append("\n");
        settings.append("capability_ptzenabled='383'").append("\n");
        settings.append("capability_network_wireless='1'").append("\n");
        settings.append("capability_npir='").append(pirSupported ? "1" : "0").append("'").append("\n");
        if (mdSupported) {
            settings.append("motion_c0_enable='0'").append("\n");
        }
        settings.append("camctrl_c0_panspeed='3'").append("\n");
        settings.append("camctrl_c0_tiltspeed='3'").append("\n");
        settings.append("network_http_authmode='basic'").append("\n");
        settings.append("network_http_alternateport=''").append("\n");
        settings.append("videoin_c0_s0_codectype='mjpeg'").append("\n");
        settings.append("videoin_c0_s0_resolution='").append(lowResolution).append("'").append("\n");
        settings.append("videoin_c0_s0_mjpeg_maxframe='").append(videoFps).append("'").append("\n");
        settings.append("videoin_c0_s0_mjpeg_quant='").append(videoQuality).append("'").append("\n");
        settings.append("videoin_c0_s1_codectype='mjpeg'").append("\n");
        settings.append("videoin_c0_s1_resolution='").append(highResolution).append("'").append("\n");
        settings.append("videoin_c0_s1_mjpeg_maxframe='").append(videoFps).append("'").append("\n");
        settings.append("videoin_c0_s1_mjpeg_quant='").append(videoQuality).append("'").append("\n");
        settings.append("event_i0_enable='").append(motionDetectionEnabled ? "1" : "0").append("'\n");
        if (motionDetection != CameraVivotekConfigurationBuilder.MotionDetection.NONE) {
            settings.append("server_i0_name='HOMEMONITOR'").append("\n");
            settings.append("server_i0_type='http'").append("\n");
            settings.append("server_i0_http_url='http://homemonitor.ch:8080/app/events/motion/vivotek?id=0002D106CD80'").append("\n");
            settings.append("server_i0_http_username='alarmUsername'").append("\n");
            settings.append("server_i0_http_passwd='alarmPassword'").append("\n");
            settings.append("media_i0_name='HOMEMONITOR'").append("\n");
            settings.append("media_i0_type='snapshot'").append("\n");
            settings.append("media_i0_snapshot_source='1'").append("\n");
            settings.append("media_i0_snapshot_prefix='0002D106CD80_'").append("\n");
            settings.append("media_i0_snapshot_datesuffix='1'").append("\n");
            settings.append("media_i0_snapshot_preevent='0'").append("\n");
            settings.append("media_i0_snapshot_postevent='0'").append("\n");
            settings.append("event_i0_priority='1'").append("\n");
            settings.append("event_i0_delay='").append(alarmLimit).append("'").append("\n");
            settings.append("event_i0_di='2'").append("\n");
            settings.append("event_i0_weekday='127'").append("\n");
            settings.append("event_i0_begintime='00:00'").append("\n");
            settings.append("event_i0_endtime='24:00'").append("\n");
            settings.append("event_i0_action_server_i0_enable='1'").append("\n");
            settings.append("event_i0_action_server_i0_media='0'").append("\n");
        }
        if (motionDetection == CameraVivotekConfigurationBuilder.MotionDetection.MD) {
            settings.append("event_i0_name='HOMEMONITOR_MD'").append("\n");
            settings.append("event_i0_trigger='motion'").append("\n");
            settings.append("event_i0_mdwin='1'").append("\n");
            settings.append("motion_c0_enable='1'").append("\n");
            settings.append("motion_c0_win_i0_enable='1'").append("\n");
            settings.append("motion_c0_win_i0_name='HOMEMONITOR'").append("\n");
            settings.append("motion_c0_win_i0_left='0'").append("\n");
            settings.append("motion_c0_win_i0_top='0'").append("\n");
            settings.append("motion_c0_win_i0_width='320'").append("\n");
            settings.append("motion_c0_win_i0_height='240'").append("\n");
            settings.append("motion_c0_win_i0_objsize='20'").append("\n");
            settings.append("motion_c0_win_i0_sensitivity='80'").append("\n");
        } else if (motionDetection == CameraVivotekConfigurationBuilder.MotionDetection.PIR) {
            settings.append("event_i0_name='HOMEMONITOR_PIR'").append("\n");
            settings.append("event_i0_trigger='di'").append("\n");
        }
        settings.append("wireless_ssid='").append(ssid).append("'\n");
        settings.append("wireless_wlmode='").append(wlanMode.getCode()).append("'\n");
        settings.append("wireless_channel='").append(channel).append("'\n");
        settings.append("wireless_txrate='0'").append("\n");
        settings.append("wireless_encrypt='").append(encryption.getCode()).append("'\n");
        settings.append("wireless_authmode='").append(wepAuthMode.getCode()).append("'\n");
        settings.append("wireless_keylength='").append(wepKeyLength).append("'\n");
        settings.append("wireless_keyformat='").append(wepKeyFormat).append("'\n");
        settings.append("wireless_keyselect='").append(wepKeyIndex).append("'\n");
        settings.append("wireless_key1='").append(key1).append("'\n");
        settings.append("wireless_key2='").append(key2).append("'\n");
        settings.append("wireless_key3='").append(key3).append("'\n");
        settings.append("wireless_key4='").append(key4).append("'\n");
        settings.append("wireless_domain='0'").append("\n");
        settings.append("wireless_algorithm='").append(algorithm.name()).append("'\n");
        settings.append("wireless_presharedkey='").append(prepsharedKey).append("'\n");
        return settings.toString();
    }

    protected HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, String body) {
        return this.prepareResponse(result, null, body);
    }

    protected HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, Integer statusCode, String body) {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(result);
        response.setStatusCode(statusCode);
        if (body != null) {
            response.setBody(body.toString().getBytes());
        }
        return response;
    }

    protected LanDeviceEntity prepareExpectedDeviceWithOpenWifi(boolean supportedPrivacyButton, CameraVivotekConfigurationBuilder.VideoEncoding videoEncoding, String ssid, String wlanMode, String channel, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, videoEncoding, true, ssid, wlanMode, channel, "OPEN", "NONE", "", "", "", "", "", "", "", "", "", wifiEnabled);
    }

    protected LanDeviceEntity prepareExpectedDeviceWithWepWifi(boolean supportedPrivacyButton, CameraVivotekConfigurationBuilder.VideoEncoding videoEncoding, String ssid, String wlanMode, String channel, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, videoEncoding, true, ssid, wlanMode, channel, "WEP", "WEP", authAuthMode, wepKeyLength, wepKeyFormat, key1, key2, key3, key4, keyIndex, "", wifiEnabled);
    }

    protected LanDeviceEntity prepareExpectedDeviceWithWpaWifi(boolean supportedPrivacyButton, CameraVivotekConfigurationBuilder.VideoEncoding videoEncoding, String ssid, String wlanMode, String channel, String encryption, String algorithm, String preSharedKey, String wifiEnabled) {
        return this.prepareExpectedDevice(supportedPrivacyButton, videoEncoding, true, ssid, wlanMode, channel, encryption, algorithm, "", "", "", "", "", "", "", "", preSharedKey, wifiEnabled);
    }

    protected LanDeviceEntity prepareExpectedDeviceWithoutWifi(boolean supportedPrivacyButton, CameraVivotekConfigurationBuilder.VideoEncoding videoEncoding) {
        return this.prepareExpectedDevice(supportedPrivacyButton, videoEncoding, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected LanDeviceEntity prepareExpectedDevice(boolean supportedPrivacyButton, CameraVivotekConfigurationBuilder.VideoEncoding videoEncoding, boolean supportedWifi, String ssid, String wlanMode, String channel, String encryption, String algorithm, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String preSharedKey, String wifiEnabled) {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        device.setVideoEncoding(videoEncoding.name());
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("record_video", "OFF", null);
        device.setParam("video_recording_duration", "15", null);
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("path", "live2.sdp", null);
        device.setParam("path_low", "live.sdp", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        device.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        device.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        device.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        device.setParam("rtsp_port", "554", null);
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        if (supportedPrivacyButton) {
            device.setParam("privacy_button", "ON", "ON");
        }
        if (supportedWifi) {
            device.setParam("need_restart_after_network_changes", "ON", null);
            device.setParam("wifi_enabled", wifiEnabled, wifiEnabled);
            device.setParam("wifi_ssid", ssid, ssid);
            device.setParam("wifi_wlan_mode", wlanMode, wlanMode);
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", channel, channel);
            device.setParam("wifi_encryption", encryption, encryption);
            device.setParam("wifi_alghoritm", algorithm, algorithm);
            device.setParam("wifi_wep_auth_mode", authAuthMode, authAuthMode);
            device.setParam("wifi_wep_key_length", wepKeyLength, wepKeyLength);
            device.setParam("wifi_wep_key_format", wepKeyFormat, wepKeyFormat);
            device.setParam("wifi_wep_key1", key1, key1);
            device.setParam("wifi_wep_key2", key2, key2);
            device.setParam("wifi_wep_key3", key3, key3);
            device.setParam("wifi_wep_key4", key4, key4);
            device.setParam("wifi_wep_default_key", keyIndex, keyIndex);
            device.setParam("wifi_pre_shared_key", preSharedKey, preSharedKey);
        }
        return device;
    }

    protected Map<String, String> prepareDeviceCapabilitiesWithoutWifi(boolean registeredViewerUser) {
        return this.prepareDeviceCapabilities(registeredViewerUser, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    protected Map<String, String> prepareDeviceCapabilitiesWithNoneSecuredWifi(boolean registeredViewerUser, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, Integer channel) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, CameraVivotekConfigurationBuilder.Encryption.OPEN, CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "", "", "", "", "", CameraVivotekConfigurationBuilder.Algorithm.AES, "");
    }

    protected Map<String, String> prepareDeviceCapabilitiesWithWepSecuredWifi(boolean registeredViewerUser, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, Integer channel, CameraVivotekConfigurationBuilder.WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, CameraVivotekConfigurationBuilder.Encryption.WEP, wepAuthMode, wepKeyLength, wepKeyFormat, wepKeyIndex, key1, key2, key3, key4, CameraVivotekConfigurationBuilder.Algorithm.AES, "");
    }

    protected Map<String, String> prepareDeviceCapabilitiesWithWpaSecuredWifi(boolean registeredViewerUser, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, Integer channel, CameraVivotekConfigurationBuilder.Encryption encryption, CameraVivotekConfigurationBuilder.Algorithm algorithm, String preSharedKey) {
        return this.prepareDeviceCapabilities(registeredViewerUser, true, ssid, wlanMode, channel, encryption, CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "", "", "", "", "", algorithm, preSharedKey);
    }

    protected Map<String, String> prepareDeviceCapabilities(boolean registeredViewerUser, boolean wifiSupport, String ssid, CameraVivotekConfigurationBuilder.WlanMode wlanMode, Integer channel, CameraVivotekConfigurationBuilder.Encryption encryption, CameraVivotekConfigurationBuilder.WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4, CameraVivotekConfigurationBuilder.Algorithm algorithm, String preSharedKey) {
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        if (registeredViewerUser) {
            deviceCapabilities.put("security_user_i1_name", "viewerUsername");
        }
        deviceCapabilities.put("capability_network_wireless", wifiSupport ? "1" : "0");
        deviceCapabilities.put("capability_npir", "1");
        deviceCapabilities.put("capability_ptzenabled", "383");
        deviceCapabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        if (wifiSupport) {
            deviceCapabilities.put("wireless_ssid", ssid);
            deviceCapabilities.put("wireless_wlmode", wlanMode.getCode());
            deviceCapabilities.put("wireless_channel", String.valueOf(channel));
            deviceCapabilities.put("wireless_txrate", "0");
            deviceCapabilities.put("wireless_encrypt", encryption.getCode());
            deviceCapabilities.put("wireless_authmode", wepAuthMode.getCode());
            deviceCapabilities.put("wireless_keylength", wepKeyLength);
            deviceCapabilities.put("wireless_keyformat", wepKeyFormat);
            deviceCapabilities.put("wireless_keyselect", String.valueOf(wepKeyIndex));
            deviceCapabilities.put("wireless_key1", key1);
            deviceCapabilities.put("wireless_key2", key2);
            deviceCapabilities.put("wireless_key3", key3);
            deviceCapabilities.put("wireless_key4", key4);
            deviceCapabilities.put("wireless_domain", "0");
            deviceCapabilities.put("wireless_algorithm", algorithm.name());
            deviceCapabilities.put("wireless_presharedkey", preSharedKey);
        }
        return deviceCapabilities;
    }

    protected void expectSendRequest(String deviceId, String url, HTTPClientServiceResult response) throws MalformedURLException {
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        EasyMock.expect((Object)httpClientService.get(deviceId, new URL(url))).andReturn((Object)response);
    }
}

