/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containserserver.landevice.CameraVivotekConfigurationBuilder;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericInternal;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekGeneric.class})
public class CameraVivotekGenericConfigurationTests
extends CameraVivotekGenericInternal {
    @Test
    public void testVerifySuccesfully() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_hostname", "Wireless Network Camera");
        builder.setParam("system_ledoff", "1");
        builder.setParam("system_date", "2011/04/22");
        builder.setParam("system_time", "12:38:36");
        builder.setParam("system_info_modelname", "TC5633");
        builder.setParam("system_info_serialnumber", "0002D106CD80");
        builder.setParam("system_info_firmwareversion", "TC5633-TCSW-0100h");
        builder.setParam("security_user_i0_name", "root");
        builder.setParam("security_user_i0_pass", "");
        builder.setParam("security_user_i0_privilege", "admin");
        builder.setParam("security_user_i1_name", "");
        builder.setParam("security_user_i1_privilege", "");
        builder.setParam("capability_protocol_rtp_http", "1");
        builder.setParam("capability_protocol_spush_mjpeg", "1");
        clientResponse.setBody(builder.getConfigurationText().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        HashMap<String, HashMap<String, String>> capabilities = new HashMap<String, HashMap<String, String>>();
        capabilities.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(null);
        this.authUtils.storeData("device_cababilities", capabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifySuccesfullyModelIP7142() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_hostname", "Wireless Network Camera");
        builder.setParam("system_ledoff", "1");
        builder.setParam("system_date", "2011/04/22");
        builder.setParam("system_time", "12:38:36");
        builder.setParam("system_info_modelname", "IP7142");
        builder.setParam("system_info_serialnumber", "0002D106CD80");
        builder.setParam("system_info_firmwareversion", "TC5633-TCSW-0100h");
        builder.setParam("security_user_i0_name", "root");
        builder.setParam("security_user_i0_pass", "");
        builder.setParam("security_user_i0_privilege", "admin");
        builder.setParam("security_user_i1_name", "");
        builder.setParam("security_user_i1_privilege", "");
        builder.setParam("capability_protocol_rtp_http", "1");
        builder.setParam("capability_protocol_spush_mjpeg", "1");
        builder.setParam("capability_ptzenabled", "63");
        clientResponse.setBody(builder.getConfigurationText().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "IP7142");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "1");
        deviceCapabilities.put("capability_ptzenabled", "0");
        HashMap<String, HashMap<String, String>> capabilities = new HashMap<String, HashMap<String, String>>();
        capabilities.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(null);
        this.authUtils.storeData("device_cababilities", capabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyDeviceNotSupported() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_hostname", "Wireless Network Camera");
        builder.setParam("system_ledoff", "1");
        builder.setParam("system_date", "2011/04/22");
        builder.setParam("system_time", "12:38:36");
        builder.setParam("system_info_modelname", "TC5633");
        builder.setParam("system_info_serialnumber", "0002D106CD80");
        builder.setParam("system_info_firmwareversion", "TC5633-TCSW-0100h");
        builder.setParam("security_user_i0_name", "root");
        builder.setParam("security_user_i0_pass", "");
        builder.setParam("security_user_i0_privilege", "admin");
        builder.setParam("security_user_i1_name", "");
        builder.setParam("security_user_i1_privilege", "");
        builder.setParam("capability_protocol_rtp_http", "1");
        builder.setParam("capability_protocol_spush_mjpeg", "0");
        clientResponse.setBody(builder.getConfigurationText().getBytes());
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("system_hostname", "Wireless Network Camera");
        deviceCapabilities.put("system_ledoff", "1");
        deviceCapabilities.put("system_date", "2011/04/22");
        deviceCapabilities.put("system_time", "12:38:36");
        deviceCapabilities.put("system_info_modelname", "TC5633");
        deviceCapabilities.put("system_info_serialnumber", "0002D106CD80");
        deviceCapabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        deviceCapabilities.put("security_user_i0_name", "root");
        deviceCapabilities.put("security_user_i0_pass", "");
        deviceCapabilities.put("security_user_i0_privilege", "admin");
        deviceCapabilities.put("security_user_i1_name", "");
        deviceCapabilities.put("security_user_i1_privilege", "");
        deviceCapabilities.put("capability_protocol_rtp_http", "1");
        deviceCapabilities.put("capability_protocol_spush_mjpeg", "0");
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOT_SUPPORTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyNoAccessFailure() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOACCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyIncorrectResponseBody() throws MalformedURLException {
        URL url = new URL("http://root:root@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion");
        HTTPClientServiceResult clientResponse = new HTTPClientServiceResult();
        clientResponse.setResult(HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)this.httpClientService);
        EasyMock.expect((Object)this.httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)clientResponse);
        LanDevice device = new LanDevice();
        device.setName("testName");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("192.168.21.138");
        device.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraVivotekGeneric.verify(device);
        Assert.assertEquals((Object)AccessVerificationStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    private void testInitSuccesfullWithoutUserRegistrationAndWithWifi(Map<String, String> deviceCapabilities, LanDeviceEntity expectedDevice) throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map<String, String>> devicesCapabilites = new HashMap<String, Map<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", deviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureWithoutUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> devicesCapabilites = new HashMap<String, Map>();
        devicesCapabilites.put("00:02:D1:06:CD:80", this.prepareDeviceCapabilitiesWithoutWifi(true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        StringBuilder confResponse = new StringBuilder();
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        deviceConfResponse.setBody(confResponse.toString().getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDeviceWithoutWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4), device));
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistrationWithRtspStreamingDisabled() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"OFF").times(2);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MJPEG, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, false, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MJPEG");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "video2.mjpg", null);
        expectedDevice.setParam("path_low", "video.mjpg", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("has_videoclip_recording", "OFF", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPtzNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "0");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "OFF", null);
        expectedDevice.setParam("has_pan", "OFF", null);
        expectedDevice.setParam("has_tilt", "OFF", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPanNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "379");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "OFF", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithTiltNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "375");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "OFF", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithZoomNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithLedoffNotsupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirSupportedAndMdSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("motion_c0_enable", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirNotsupportedAndMdSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "0");
        capabilities.put("motion_c0_enable", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.MD, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithPirNotSupportedAndMdNotSupported() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "0");
        capabilities.put("capability_ptzenabled", "367");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.NONE, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "OFF", null);
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUnexpectedResolution() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,352x288,704x576,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "352x288", "704x576", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "704x576", null);
        expectedDevice.setParam("resolution_low", "352x288", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=704x576", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=352x288", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithCifResolution() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "QCIF, CIF, 4CIF");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "CIF", "4CIF", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "704x576", null);
        expectedDevice.setParam("resolution_low", "352x288", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=704x576", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=352x288", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUsername");
        registerUserUrl.append("&userpass=viewerPassword");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name='viewerUsername'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistrationUnexpectedResponseBody() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUsername");
        registerUserUrl.append("&userpass=viewerPassword");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.OK);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUserRegistrationIncorrectUserRegisrationStatus() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUsername");
        registerUserUrl.append("&userpass=viewerPassword");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        HTTPClientServiceResult registerUserResponse = new HTTPClientServiceResult();
        registerUserResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)registerUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithIncorrectUserRegistrationVerificationStatus() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        StringBuilder registerUserUrl = new StringBuilder();
        registerUserUrl.append("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/editaccount.cgi");
        registerUserUrl.append("?method=add");
        registerUserUrl.append("&username=viewerUsername");
        registerUserUrl.append("&userpass=viewerPassword");
        registerUserUrl.append("&privilege=view");
        registerUserUrl.append("&return=/cgi-bin/admin/getparam.cgi?security");
        URL registerUserRequest = new URL(registerUserUrl.toString());
        HTTPClientService registerViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClientService);
        EasyMock.expect((Object)registerViewerUserClientService.get("00:1A:B6:00:0B:B5", registerUserRequest)).andReturn((Object)new HTTPClientServiceResult());
        URL verifyRegisterUserRequest = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?security");
        HTTPClientService verifyViewerUserClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)verifyViewerUserClientService);
        HTTPClientServiceResult verifyRegisterUserResponse = new HTTPClientServiceResult();
        verifyRegisterUserResponse.setResult(HTTPClientServiceResult.Result.NOACCESS);
        StringBuilder verifyRegiserUserResponseBody = new StringBuilder();
        verifyRegiserUserResponseBody.append("security_user_i0_name='root'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_pass=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i0_privilege='admin'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_name='viewerUsernae'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i1_privilege='view'").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_name=''").append("\n");
        verifyRegiserUserResponseBody.append("security_user_i2_privilege=''").append("\n");
        verifyRegisterUserResponse.setBody(verifyRegiserUserResponseBody.toString().getBytes());
        EasyMock.expect((Object)verifyViewerUserClientService.get("00:1A:B6:00:0B:B5", verifyRegisterUserRequest)).andReturn((Object)verifyRegisterUserResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitUnexpectedConfigurePrivacyButtonResponse() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON");
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "heh"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureConfigurePrivacyButtonResponse() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON");
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, "ok"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraVivotekGeneric.init(device, ""));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithUnsupportedPrivacyButton() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.ERROR, Integer.valueOf(404), ""));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitSuccesfullWithSomeParamsNotSet() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        HashMap<String, HashMap<String, String>> devicesCapabilites = new HashMap<String, HashMap<String, String>>();
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.MANUAL, (Object)this.cameraVivotekGeneric.init(device, ""));
        CameraVivotekConfigurationBuilder expectedRequest = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        expectedRequest.setSystemLedOff("0");
        expectedRequest.setParam("system_timezoneindex", "00");
        expectedRequest.setParam("system_updateinterval", "3600");
        expectedRequest.setParam("system_ntp", "ntp.homemonitor.ch");
        expectedRequest.setParam("network_http_alternateport", "");
        expectedRequest.setParam("network_http_authmode", "basic");
        expectedRequest.setPanSpeed(3);
        expectedRequest.setTiltSpeed(3);
        expectedRequest.setAdminUser("rootPassword");
        expectedRequest.setViewerUser("viewerUsername", "viewerPassword");
        expectedRequest.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        expectedRequest.setAudioMuteEnabled(true);
        expectedRequest.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        String configurationUrl = expectedRequest.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithoutWifiSupport() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap devicesCapabilites = new HashMap();
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("system_info_modelname", "TC5633");
        capabilities.put("system_info_serialnumber", "0002D106CD80");
        capabilities.put("system_info_firmwareversion", "TC5633-TCSW-0100h");
        capabilities.put("system_ledoff", "0");
        capabilities.put("security_user_i0_name", "root");
        capabilities.put("security_user_i0_pass", "");
        capabilities.put("security_user_i0_privilege", "admin");
        capabilities.put("security_user_i1_name", "viewerUsername");
        capabilities.put("capability_network_wireless", "0");
        capabilities.put("capability_npir", "1");
        capabilities.put("capability_ptzenabled", "383");
        capabilities.put("capability_videoin_resolution", "176x144,320x240,640x480,800x600,1280x1024");
        devicesCapabilites.put("00:02:D1:06:CD:80", capabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(devicesCapabilites);
        DeviceDescEntity deviceDesc = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Vivotek", "TC5633")).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING)).andReturn((Object)"ON").times(2);
        HTTPClientService getMaxVideoClipDurationClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getMaxVideoClipDurationClientService);
        URL getMaxVideoClipDurationUrl = new URL("http://root:rootPassword@192.168.21.138:80/setup/media.html");
        String maxDurationHtml = this.prepareSetupMediaHtml(10);
        EasyMock.expect((Object)getMaxVideoClipDurationClientService.get("00:1A:B6:00:0B:B5", getMaxVideoClipDurationUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, maxDurationHtml));
        HTTPClientService testPrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)testPrivacyButtonHttpClientService);
        URL privacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi");
        EasyMock.expect((Object)testPrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", privacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "error format"));
        HTTPClientService configurePrivacyButtonHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonHttpClientService);
        URL configurePrivacyButtonUrl = new URL("http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/privacybutton.cgi?enable=1");
        EasyMock.expect((Object)configurePrivacyButtonHttpClientService.get("00:1A:B6:00:0B:B5", configurePrivacyButtonUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, "ok"));
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        HTTPClientServiceResult deviceConfResponse = new HTTPClientServiceResult();
        deviceConfResponse.setResult(HTTPClientServiceResult.Result.OK);
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", "viewerPassword");
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        deviceConfResponse.setBody(builder.getUpdateResponse(" ").getBytes());
        HTTPClientService initHttpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)initHttpClientService);
        Capture capturedUrl = new Capture();
        EasyMock.expect((Object)initHttpClientService.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)capturedUrl))).andReturn((Object)deviceConfResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraVivotekGeneric.init(device, ""));
        String configurationUrl = builder.getConfigurationUrl("root", "rootPassword", "192.168.21.138", 80);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configurationUrl, (String)((URL)capturedUrl.getValue()).toString()));
        LanDeviceEntity expectedDevice = this.prepareDeviceToInit();
        expectedDevice.setVideoEncoding("MPEG4");
        expectedDevice.setParam("alarm_limit", "0", "0");
        expectedDevice.setParam("has_home", "ON", null);
        expectedDevice.setParam("has_pan", "ON", null);
        expectedDevice.setParam("has_tilt", "ON", null);
        expectedDevice.setParam("has_zoom", "ON", null);
        expectedDevice.setParam("motion_detection", "OFF", "OFF");
        expectedDevice.setParam("path", "live2.sdp", null);
        expectedDevice.setParam("path_low", "live.sdp", null);
        expectedDevice.setParam("privacy_button", "ON", "ON");
        expectedDevice.setParam("record_video", "OFF", null);
        expectedDevice.setParam("resolution", "640x480", null);
        expectedDevice.setParam("resolution_low", "320x240", null);
        expectedDevice.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        expectedDevice.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        expectedDevice.setParam("system_ledoff", "OFF", "OFF");
        expectedDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDevice.setParam("video_recording_duration", "15", null);
        expectedDevice.setParam("path_low_rtsp_over_http_get", "live.sdp", null);
        expectedDevice.setParam("path_low_rtsp_over_http_post", "live.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_get", "live2.sdp", null);
        expectedDevice.setParam("path_rtsp_over_http_post", "live2.sdp", null);
        expectedDevice.setParam("rtsp_port", "554", null);
        expectedDevice.setParam("alarm_video_clip", "OFF", "OFF");
        expectedDevice.setParam("has_videoclip_recording", "ON", null);
        expectedDevice.setParam("max_videoclip_duration", "10", null);
        expectedDevice.setParam("videoclip_duration", "10", "10");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithOpenWifiWithInfrastructureWlanMode() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "6", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithOpenWifiWithAdHocWlanMode() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithNoneSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.AD_HOC, Integer.valueOf(6));
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "AD_HOC", "6", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithOpenAuthModeAndAsciiKeyFormatAnd64BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(8), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "8", "OPEN", "LENGTH_64_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithSharedAuthModeAndAsciiKeyFormatAnd128BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(8), CameraVivotekConfigurationBuilder.WepAuthMode.SHARED, "128", "ASCII", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "8", "SHARED", "LENGTH_128_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithOpenAuthModeAndHexKeyFormatAnd64BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(8), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "8", "OPEN", "LENGTH_64_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWepWifiWithSharedAuthModeAndHexKeyFormatAnd128BitsKeyLength() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWepSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(8), CameraVivotekConfigurationBuilder.WepAuthMode.SHARED, "128", "HEX", "1", "1234567890", "2345678901", "3456789012", "4567890123");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "8", "SHARED", "LENGTH_128_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpaWifiWithTkipAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "test%24password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "3", "WPA", "TKIP", "test$password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitSuccesfullWithoutUserRegistrationAndWithWpaWifiWithAesAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "3", "WPA", "AES_CCMP", "test%password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpa2WifiWithTkipAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "test%24password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "3", "WPA2", "TKIP", "test$password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithWpa2WifiWithAesAlgorithm() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "smart-apps", "INFRASTRUCTURE", "3", "WPA2", "AES_CCMP", "test%password", "ON");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    @Test
    public void testInitWithoutUserRegistrationAndWithDisableWifi() throws MalformedURLException {
        Map deviceCapabilities = this.prepareDeviceCapabilitiesWithWpaSecuredWifi(true, "default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6), CameraVivotekConfigurationBuilder.Encryption.OPEN, CameraVivotekConfigurationBuilder.Algorithm.AES, "test%25password");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi(true, CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "", "", "", "", "", "", "OFF");
        this.testInitSuccesfullWithoutUserRegistrationAndWithWifi(deviceCapabilities, expectedDevice);
    }

    private String prepareSetupMediaHtml(int maxDuration) {
        StringBuilder builder = new StringBuilder();
        builder.append("<dl>").append("\n");
        builder.append("\t\t<dt>").append("\n");
        builder.append("\t\t\t<dd>").append("\n");
        builder.append("\t\t\t\t<span title=\"\">Maximum duration</span>:").append("\n");
        builder.append("\t\t\t\t<input name=\"media_index_videoclip_maxduration\" id=\"videoclip_maxduration\" title=\"param,num,10,1\" value=\"5\" size=\"3\" maxlength=\"3\" type=\"text\">").append("\n");
        builder.append("\t\t\t\t<span title=\"\">seconds</span> [1~").append(String.valueOf(maxDuration)).append("]\t\t\t</dd>").append("\n");
        builder.append("</dl>").append("\n");
        return builder.toString();
    }
}

