/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containserserver.landevice.CameraVivotekConfigurationBuilder;
import pl.smartapps.containserserver.landevice.CameraVivotekGenericInternal;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekGeneric.class})
public class CameraVivotekGenericCheckConfigurationTests
extends CameraVivotekGenericInternal {
    private String downloadConfiguratonUrl = "http://root:rootPassword@192.168.21.138:80/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion&audioin";

    @Test
    public void testCheckConfigurationCorrectWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectForModelIP7142() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setModel("IP7142");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "OFF", null);
        device.setParam("has_pan", "OFF", null);
        device.setParam("has_tilt", "OFF", null);
        device.setParam("has_zoom", "OFF", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setModel("IP7142");
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 2, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        builder.setPtzSupport("63");
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 2, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 1, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithAcceptableVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "ACCEPTABLE", "ACCEPTABLE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 2, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 3, 2);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationInorrectVideoFpsWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 1, 2);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithModerateVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "MODERATE", "MODERATE");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 3, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 1, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 4);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 1, 4);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithVeryGoodVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "VERY_GOOD", "VERY_GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 10, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoFpsWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 1, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectVideoQualityWithBestVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectHighResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "704x576", 30, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifHighResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "16CIF", 30, 1);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("QCIF, CIF, 4CIF");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectLowResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "352x288", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("640x480,320x240,352x288");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifLowResolution() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "4CIF", "QCIF", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("QCIF, CIF, 4CIF");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectCifResolutions() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "704x576", null);
        device.setParam("resolution_low", "352x288", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "4CIF", "CIF", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("QCIF, CIF, 4CIF");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithPirMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithMdMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.MD, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(false);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithNoneMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.NONE, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithVideoClipotSupported() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("has_videoclip_recording", "OFF", null);
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, false, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithVideoClipotSupportedDueToMissingParam() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, false, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledMotionDetectionAndEnabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, true, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledMotionDetectionAndEnabledVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationInorrectVideoClip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, true, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationInorrectVideoClipDuration() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "BEST", "BEST");
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("alarm_video_clip", "ON", "ON");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "5", "5");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "INFRASTRUCTURE");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "wifiPassword", "wifiPassword");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 20, 5);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 1, true, true, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "ON", "ON");
        device.setParam("system_ledoff", "ON", "ON");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "5", "5");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 720, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "10", "10");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 360, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 240, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "30", "30");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 120, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase7() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithDisabledWifiCase8() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "OFF");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "OPEN", "OPEN");
        device.setParam("wifi_alghoritm", "NONE", "NONE");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(6));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "5", "5");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA2", "WPA2");
        device.setParam("wifi_alghoritm", "AES_CCMP", "AES_CCMP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 720, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "10", "10");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA2", "WPA2");
        device.setParam("wifi_alghoritm", "TKIP", "TKIP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 360, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA2, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "sharedKey");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "15", "15");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WPA", "WPA");
        device.setParam("wifi_alghoritm", "TKIP", "TKIP");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "sharedKey");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 240, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "sharedKey");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase5() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "30", "30");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key_format", "HEX", "HEX");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 120, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase6() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "AD_HOC", "AD_HOC");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key_format", "ASCII", "LENGTH_64_BITS");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.AD_HOC, Integer.valueOf(3), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase7() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key_format", "HEX", "HEX");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "128", "HEX", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationCorrectWithEnabledWifiCase8() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("viewer_user", "viewerUsername", null);
        device.setParam("viewer_pass", "viewerPassword", null);
        device.setParam("alarm_user", "alarmUsername", null);
        device.setParam("alarm_pass", "alarmPassword", null);
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("alarm_limit", "60", "60");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "ON");
        device.setParam("wifi_ssid", "smart-apps", "smart-apps");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "3");
        device.setParam("wifi_encryption", "WEP", "WEP");
        device.setParam("wifi_alghoritm", "WEP", "WEP");
        device.setParam("wifi_wep_auth_mode", "OPEN", "OPEN");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key_format", "ASCII", "LENGTH_128_BITS");
        device.setParam("wifi_wep_key1", "key1", "key1");
        device.setParam("wifi_wep_key2", "key2", "key2");
        device.setParam("wifi_wep_key3", "key3", "key3");
        device.setParam("wifi_wep_key4", "key4", "key4");
        device.setParam("wifi_wep_default_key", "1", "1");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("0");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, false, "alarmUsername", "alarmPassword", 60, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "128", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirSupported(true);
        builder.setMotionDetectionSupported(true);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationViewerUserNonRegisterd() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername2", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "OFF", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("default", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername2", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmPassword() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword2", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectMotionDetection() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "OFF", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectLedOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "OFF", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectAlarmLimit() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "5", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectSsid() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps2", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "AD_HOC", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "3", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiChannel() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(3));
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "OPEN", "");
        device.setParam("wifi_alghoritm", "NONE", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setNoneSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4));
        builder.setWifiEncryption(CameraVivotekConfigurationBuilder.Encryption.WPA);
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiAlgorithm() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "", "");
        device.setParam("wifi_wep_key2", "", "");
        device.setParam("wifi_wep_key3", "", "");
        device.setParam("wifi_wep_key4", "", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.AES, "sharedKey");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiSharedKey() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WPA", "");
        device.setParam("wifi_alghoritm", "TKIP", "");
        device.setParam("wifi_wep_auth_mode", "", "");
        device.setParam("wifi_wep_key_length", "", "");
        device.setParam("wifi_wep_key_format", "", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWpaSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.Encryption.WPA, CameraVivotekConfigurationBuilder.Algorithm.TKIP, "sharedKey");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiAuthMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.SHARED, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiKeyLength() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_128_BITS", "");
        device.setParam("wifi_wep_key_format", "HEX", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiKeyFormat() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "HEX", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key11", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key22", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key31", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKey4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key41", "");
        device.setParam("wifi_wep_default_key", "1", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setWifiSupported(true);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationIncorrectWifiWepKeyIndex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setUsername("root");
        device.setPass("rootPassword");
        device.setVideoEncoding("MPEG4");
        device.setParam("privacy_button", "ON", "");
        device.setParam("viewer_user", "viewerUsername", "");
        device.setParam("viewer_pass", "viewerPassword", "");
        device.setParam("alarm_user", "alarmUsername", "");
        device.setParam("alarm_pass", "alarmPassword", "");
        device.setParam("motion_detection", "ON", "");
        device.setParam("system_ledoff", "ON", "");
        device.setParam("alarm_limit", "0", "");
        device.setParam("video_quality", "GOOD", "");
        device.setParam("alarm_video_clip", "OFF", "OFF");
        device.setParam("has_videoclip_recording", "ON", null);
        device.setParam("max_videoclip_duration", "10", null);
        device.setParam("videoclip_duration", "10", "10");
        device.setParam("has_home", "ON", null);
        device.setParam("has_pan", "ON", null);
        device.setParam("has_tilt", "ON", null);
        device.setParam("has_zoom", "ON", null);
        device.setParam("need_restart_after_network_changes", "ON", null);
        device.setParam("path", "video2.mjpg", null);
        device.setParam("path_low", "video.mjpg", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480", null);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240", null);
        device.setParam("wifi_enabled", "ON", "");
        device.setParam("wifi_ssid", "smart-apps", "");
        device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "");
        device.setParam("wifi_bssid", "", "");
        device.setParam("wifi_channel", "4", "");
        device.setParam("wifi_encryption", "WEP", "");
        device.setParam("wifi_alghoritm", "WEP", "");
        device.setParam("wifi_wep_auth_mode", "OPEN", "");
        device.setParam("wifi_wep_key_length", "LENGTH_64_BITS", "");
        device.setParam("wifi_wep_key_format", "ASCII", "");
        device.setParam("wifi_wep_key1", "key1", "");
        device.setParam("wifi_wep_key2", "key2", "");
        device.setParam("wifi_wep_key3", "key3", "");
        device.setParam("wifi_wep_key4", "key4", "");
        device.setParam("wifi_wep_default_key", "2", "");
        device.setParam("wifi_pre_shared_key", "sharedKey2", "");
        CameraVivotekConfigurationBuilder builder = new CameraVivotekConfigurationBuilder(CameraVivotekConfigurationBuilder.ConfigurationType.EMPTY);
        builder.setSystemLedOff("1");
        builder.setParam("system_timezoneindex", "00");
        builder.setParam("system_updateinterval", "3600");
        builder.setParam("system_ntp", "ntp.homemonitor.ch");
        builder.setParam("network_http_alternateport", "");
        builder.setParam("network_http_authmode", "basic");
        builder.setPanSpeed(3);
        builder.setTiltSpeed(3);
        builder.setAdminUser("rootPassword");
        builder.setViewerUser("viewerUsername", null);
        builder.setVideoQuality(CameraVivotekConfigurationBuilder.VideoEncoding.MPEG4, "320x240", "640x480", 5, 3);
        builder.setAudioMuteEnabled(true);
        builder.setMotionDetection(CameraVivotekConfigurationBuilder.MotionDetection.PIR, true, "alarmUsername", "alarmPassword", 1, true, false, 10);
        builder.setWifiSupported(true);
        builder.setWepSecuredWifi("smart-apps", CameraVivotekConfigurationBuilder.WlanMode.INFRASTRUCTURE, Integer.valueOf(4), CameraVivotekConfigurationBuilder.WepAuthMode.OPEN, "64", "ASCII", "1", "key1", "key2", "key3", "key4");
        builder.setSupportedResolutions("176x144,320x240,640x480,800x600,1280x1024");
        builder.setPirCount(1);
        this.expectSendRequest("00:1A:B6:00:0B:B5", this.downloadConfiguratonUrl, this.prepareResponse(HTTPClientServiceResult.Result.OK, builder.getConfigurationText()));
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus configurationStatus = this.cameraVivotekGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)configurationStatus);
        PowerMock.verifyAll();
    }
}

