/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containserserver.landevice;

import java.util.HashMap;
import java.util.Map;
import pl.smartapps.containserserver.landevice.CameraVivotekConfigurationBuilder;

public class CameraVivotekConfigurationBuilder {
    private Map<String, String> configuration;

    public CameraVivotekConfigurationBuilder(ConfigurationType configurationType) {
        block0: {
            if (configurationType != ConfigurationType.EMPTY) break block0;
            this.configuration = new HashMap();
        }
    }

    public void setParam(String name, String value) {
        this.configuration.put(name, value);
    }

    public String getParam(String name) {
        return (String)this.configuration.get(name);
    }

    public void removeParam(String name) {
        this.configuration.remove(name);
    }

    public void setMotionDetection(MotionDetection motionDetection, boolean enabled, String alarmUsername, String alarmPassword, int alarmLimit, boolean videoClipSupported, boolean videoClipEnabled, int videoClipDuration) {
        if (motionDetection != MotionDetection.NONE) {
            this.configuration.put("server_i0_name", "HOMEMONITOR");
            this.configuration.put("server_i0_type", "http");
            this.configuration.put("server_i0_http_url", "http://homemonitor.ch:8080/app/events/motion/vivotek?id=0002D106CD80");
            this.configuration.put("server_i0_http_username", alarmUsername);
            this.configuration.put("server_i0_http_passwd", alarmPassword);
            this.configuration.put("media_i0_name", "HOMEMONITOR");
            this.configuration.put("media_i0_type", "snapshot");
            this.configuration.put("media_i0_snapshot_source", "1");
            this.configuration.put("media_i0_snapshot_prefix", "0002D106CD80_");
            this.configuration.put("media_i0_snapshot_datesuffix", "1");
            this.configuration.put("media_i0_snapshot_preevent", "0");
            this.configuration.put("media_i0_snapshot_postevent", "0");
            this.configuration.put("event_i0_enable", enabled ? "1" : "0");
            this.configuration.put("event_i0_priority", "1");
            this.configuration.put("event_i0_delay", String.valueOf(alarmLimit));
            this.configuration.put("event_i0_weekday", "127");
            this.configuration.put("event_i0_begintime", "00:00");
            this.configuration.put("event_i0_endtime", "24:00");
            this.configuration.put("event_i0_action_server_i0_enable", "1");
            this.configuration.put("event_i0_action_server_i0_media", "0");
            if (videoClipSupported) {
                this.configuration.put("event_i1_name", "HOMEMONITOR_VIDEOCLIP");
                this.configuration.put("event_i1_enable", videoClipEnabled ? "1" : "0");
                this.configuration.put("event_i1_priority", "1");
                this.configuration.put("event_i1_delay", String.valueOf(alarmLimit));
                this.configuration.put("event_i1_inter", "1");
                this.configuration.put("event_i1_weekday", "127");
                this.configuration.put("event_i1_begintime", "00:00");
                this.configuration.put("event_i1_endtime", "24:00");
                this.configuration.put("event_i1_action_server_i0_enable", "1");
                this.configuration.put("event_i1_action_server_i0_media", "1");
                this.configuration.put("media_i1_name", "HOMEMONITOR_VIDEOCLIP");
                this.configuration.put("media_i1_type", "videoclip");
                this.configuration.put("media_i1_videoclip_source", "1");
                this.configuration.put("media_i1_videoclip_preevent", "3");
                this.configuration.put("media_i1_videoclip_maxduration", String.valueOf(videoClipDuration));
                this.configuration.put("media_i1_videoclip_maxsize", "800");
                this.configuration.put("media_i1_videoclip_prefix", "0002D106CD80_");
            }
        }
        if (motionDetection == MotionDetection.MD) {
            this.configuration.put("event_i0_name", "HOMEMONITOR_MD");
            this.configuration.put("event_i0_trigger", "motion");
            this.configuration.put("event_i0_mdwin", "1");
            if (videoClipSupported) {
                this.configuration.put("event_i1_trigger", "motion");
                this.configuration.put("event_i1_mdwin", "1");
            }
            this.configuration.put("motion_c0_enable", "1");
            this.configuration.put("motion_c0_win_i0_enable", "1");
            this.configuration.put("motion_c0_win_i0_name", "HOMEMONITOR");
            this.configuration.put("motion_c0_win_i0_left", "0");
            this.configuration.put("motion_c0_win_i0_top", "0");
            this.configuration.put("motion_c0_win_i0_width", "320");
            this.configuration.put("motion_c0_win_i0_height", "240");
            this.configuration.put("motion_c0_win_i0_objsize", "20");
            this.configuration.put("motion_c0_win_i0_sensitivity", "80");
        } else if (motionDetection == MotionDetection.PIR) {
            this.configuration.put("event_i0_name", "HOMEMONITOR_PIR");
            this.configuration.put("event_i0_trigger", "di");
            this.configuration.put("event_i0_di", "2");
            if (videoClipSupported) {
                this.configuration.put("event_i1_trigger", "di");
                this.configuration.put("event_i1_di", "2");
            }
        }
    }

    public void setVideoQuality(VideoEncoding videoEncoding, String lowRes, String highRes, int fps, int quant) {
        this.configuration.put("videoin_c0_s0_codectype", videoEncoding.getCode());
        this.configuration.put("videoin_c0_s0_resolution", lowRes);
        this.configuration.put("videoin_c0_s1_codectype", videoEncoding.getCode());
        this.configuration.put("videoin_c0_s1_resolution", highRes);
        if (videoEncoding == VideoEncoding.MJPEG) {
            this.configuration.put("videoin_c0_s0_mjpeg_maxframe", String.valueOf(fps));
            this.configuration.put("videoin_c0_s0_mjpeg_quant", String.valueOf(quant));
            this.configuration.put("videoin_c0_s1_mjpeg_maxframe", String.valueOf(fps));
            this.configuration.put("videoin_c0_s1_mjpeg_quant", String.valueOf(quant));
        } else {
            this.configuration.put("videoin_c0_s0_mpeg4_maxframe", String.valueOf(fps));
            this.configuration.put("videoin_c0_s0_mpeg4_intraperiod", "1000");
            this.configuration.put("videoin_c0_s0_mpeg4_ratecontrolmode", "vbr");
            this.configuration.put("videoin_c0_s0_mpeg4_quant", String.valueOf(quant));
            this.configuration.put("videoin_c0_s1_mpeg4_maxframe", String.valueOf(fps));
            this.configuration.put("videoin_c0_s1_mpeg4_intraperiod", "1000");
            this.configuration.put("videoin_c0_s1_mpeg4_ratecontrolmode", "vbr");
            this.configuration.put("videoin_c0_s1_mpeg4_quant", String.valueOf(quant));
        }
    }

    public void setNoneSecuredWifi(String ssid, WlanMode wlanMode, Integer channel) {
        this.configuration.put("wireless_ssid", ssid);
        this.configuration.put("wireless_wlmode", wlanMode.getCode());
        this.configuration.put("wireless_channel", String.valueOf(channel));
        this.configuration.put("wireless_txrate", "0");
        this.configuration.put("wireless_encrypt", Encryption.OPEN.getCode());
    }

    public void setWepSecuredWifi(String ssid, WlanMode wlanMode, Integer channel, WepAuthMode wepAuthMode, String wepKeyLength, String wepKeyFormat, String wepKeyIndex, String key1, String key2, String key3, String key4) {
        this.configuration.put("wireless_ssid", ssid);
        this.configuration.put("wireless_wlmode", wlanMode.getCode());
        this.configuration.put("wireless_channel", String.valueOf(channel));
        this.configuration.put("wireless_txrate", "0");
        this.configuration.put("wireless_encrypt", Encryption.WEP.getCode());
        this.configuration.put("wireless_authmode", wepAuthMode.getCode());
        this.configuration.put("wireless_keylength", wepKeyLength);
        this.configuration.put("wireless_keyformat", wepKeyFormat);
        this.configuration.put("wireless_keyselect", String.valueOf(wepKeyIndex));
        this.configuration.put("wireless_key1", key1);
        this.configuration.put("wireless_key2", key2);
        this.configuration.put("wireless_key3", key3);
        this.configuration.put("wireless_key4", key4);
    }

    public void setWpaSecuredWifi(String ssid, WlanMode wlanMode, Integer channel, Encryption encryption, Algorithm algorithm, String preSharedKey) {
        this.configuration.put("wireless_ssid", ssid);
        this.configuration.put("wireless_wlmode", wlanMode.getCode());
        this.configuration.put("wireless_channel", String.valueOf(channel));
        this.configuration.put("wireless_txrate", "0");
        this.configuration.put("wireless_encrypt", encryption.getCode());
        this.configuration.put("wireless_algorithm", algorithm.name());
        this.configuration.put("wireless_presharedkey", preSharedKey);
    }

    public void setWifiSsid(String ssid) {
        this.configuration.put("wireless_ssid", ssid);
    }

    public void setWifiWlanMode(WlanMode wlanMode) {
        this.configuration.put("wireless_wlmode", wlanMode.getCode());
    }

    public void setWifiWlanChannel(int channel) {
        this.configuration.put("wireless_channel", String.valueOf(channel));
    }

    public void setWifiEncryption(Encryption encryption) {
        this.configuration.put("wireless_encrypt", encryption.getCode());
    }

    public void setWifiAlgorithm(Algorithm algorithm) {
        this.configuration.put("wireless_algorithm", algorithm.name());
    }

    public void setWifiPreSharedKey(String preSharedKey) {
        this.configuration.put("wireless_presharedkey", preSharedKey);
    }

    public void setWifiSupported(boolean supported) {
        this.configuration.put("capability_network_wireless", supported ? "1" : "0");
    }

    public void setSystemLedOff(String value) {
        this.configuration.put("system_ledoff", value);
    }

    public void setPanSpeed(int value) {
        this.configuration.put("camctrl_c0_panspeed", String.valueOf(value));
    }

    public void setTiltSpeed(int value) {
        this.configuration.put("camctrl_c0_tiltspeed", String.valueOf(value));
    }

    public void setAdminUser(String password) {
        this.configuration.put("security_user_i0_name", "root");
        this.configuration.put("security_user_i0_pass", password);
        this.configuration.put("security_user_i0_privilege", "admin");
    }

    public void setViewerUser(String username, String password) {
        this.configuration.put("security_user_i1_name", username);
        if (password != null) {
            this.configuration.put("security_user_i1_pass", password);
        }
        this.configuration.put("security_user_i1_privilege", "view");
    }

    public void setSupportedResolutions(String resolutions) {
        this.configuration.put("capability_videoin_resolution", resolutions);
    }

    public void setPirCount(int count) {
        this.configuration.put("capability_npir", String.valueOf(count));
    }

    public void setPtzSupport(String support) {
        this.configuration.put("capability_ptzenabled", support);
    }

    public void setPirSupported(boolean supported) {
        this.setPirCount(supported ? 1 : 0);
    }

    public void setMotionDetectionSupported(boolean supported) {
        if (supported) {
            this.configuration.put("motion_c0_enable", "0");
        } else {
            this.configuration.remove("motion_c0_enable");
        }
    }

    public void setModel(String model) {
        this.configuration.put("system_info_modelname", model);
    }

    public void setAudioMuteEnabled(boolean enabled) {
        this.configuration.put("audioin_c0_mute", enabled ? "1" : "0");
    }

    public String getConfigurationText() {
        StringBuilder body = new StringBuilder();
        for (Map.Entry entry : this.configuration.entrySet()) {
            body.append((String)entry.getKey()).append("='").append((String)entry.getValue()).append("'\n");
        }
        return body.toString();
    }

    public Map<String, String> getConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.configuration);
        return map;
    }

    public String getUpdateResponse(String separator) {
        StringBuilder body = new StringBuilder();
        for (Map.Entry entry : this.configuration.entrySet()) {
            body.append((String)entry.getKey()).append("='").append((String)entry.getValue()).append("'").append(separator);
        }
        return body.toString();
    }

    public String getConfigurationUrl(String username, String password, String ip, int port) {
        this.configuration.remove("security_user_i0_name");
        this.configuration.remove("security_user_i0_privilege");
        this.configuration.remove("security_user_i1_name");
        StringBuilder body = new StringBuilder();
        body.append("http://").append(username).append(":").append(password).append("@");
        body.append(ip).append(":").append(port).append("/cgi-bin/admin/setparam.cgi?");
        for (Map.Entry entry : this.configuration.entrySet()) {
            body.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        body.delete(body.length() - 1, body.length());
        return body.toString();
    }
}

