/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.vivotek;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.landevice.SettingParam;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandler;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.UpdatedSettingsListener;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.containerserver.landevice.WepKeyLength;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekSettings;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.service.LanDeviceService;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="prototype")
public class CameraVivotekSettings
implements UpdatedSettingsListener {
    private static Logger log = Logger.getLogger(CameraVivotekSettings.class);
    private Map<String, SettingParam> cameraSettings = this.prepareCameraSettings();
    private LanDeviceService lanDeviceService;
    private UpdateSettingsHandlerFactory updateHandlerFactory;
    private ContainerserverServiceFactory serviceFactory;
    private TaskExecutor taskExecutor;

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setUpdateHandlerFactory(UpdateSettingsHandlerFactory updateHandlerFactory) {
        this.updateHandlerFactory = updateHandlerFactory;
    }

    @Autowired
    @Required
    public void setServiceFactory(ContainerserverServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Map<String, SettingParam> getCameraSettings() {
        return this.cameraSettings;
    }

    private Map<String, SettingParam> prepareCameraSettings() {
        HashMap<String, SettingParam> config = new HashMap<String, SettingParam>();
        SettingParam ledOff = new SettingParam("system_ledoff", "system_ledoff", null, true);
        config.put(ledOff.getName(), ledOff);
        SettingParam privacyButton = new SettingParam("privacy_button", null, "/cgi-bin/admin/privacybutton.cgi?enable", true);
        config.put(privacyButton.getName(), privacyButton);
        SettingParam muteAudio = new SettingParam("mute_audio", "audioin_c0_mute", null, true);
        config.put(muteAudio.getName(), muteAudio);
        SettingParam motionDetection = new SettingParam("motion_detection", "event_i0_enable", null, true);
        config.put(motionDetection.getName(), motionDetection);
        SettingParam alarmVideoclip = new SettingParam("alarm_video_clip", "event_i1_enable", null, true);
        config.put(alarmVideoclip.getName(), alarmVideoclip);
        SettingParam videoDuration = new SettingParam("videoclip_duration", "media_i1_videoclip_maxduration", null, false);
        config.put(videoDuration.getName(), videoDuration);
        SettingParam videoOrientationFlip = new SettingParam("video_orientation_flip", "videoin_c0_flip", null, true);
        config.put(videoOrientationFlip.getName(), videoOrientationFlip);
        SettingParam videoOrientationMirror = new SettingParam("video_orientation_mirror", "videoin_c0_mirror", null, true);
        config.put(videoOrientationMirror.getName(), videoOrientationMirror);
        SettingParam alarmLimit = new SettingParam("alarm_limit", "event_i0_delay", null, true);
        HashMap<String, String> alarmLimitMapping = new HashMap<String, String>();
        alarmLimitMapping.put("5", "720");
        alarmLimitMapping.put("10", "360");
        alarmLimitMapping.put("15", "240");
        alarmLimitMapping.put("30", "120");
        alarmLimitMapping.put("60", "60");
        alarmLimitMapping.put("0", "1");
        alarmLimit.setMapping(alarmLimitMapping);
        config.put(alarmLimit.getName(), alarmLimit);
        SettingParam ssid = new SettingParam("wifi_ssid", "wireless_ssid", null, false);
        config.put(ssid.getName(), ssid);
        SettingParam wlmode = new SettingParam("wifi_wlan_mode", "wireless_wlmode", null, true);
        HashMap<String, String> wlmodeMapping = new HashMap<String, String>();
        wlmodeMapping.put("INFRASTRUCTURE", "Infra");
        wlmodeMapping.put("AD_HOC", "Adhoc");
        wlmode.setMapping(wlmodeMapping);
        config.put(wlmode.getName(), wlmode);
        SettingParam channel = new SettingParam("wifi_channel", "wireless_channel", null, false);
        config.put(channel.getName(), channel);
        SettingParam encryption = new SettingParam("wifi_encryption", "wireless_encrypt", null, true);
        HashMap<String, String> encryptionMapping = new HashMap<String, String>();
        encryptionMapping.put("OPEN", "0");
        encryptionMapping.put("WEP", "1");
        encryptionMapping.put("WPA", "2");
        encryptionMapping.put("WPA2", "3");
        encryption.setMapping(encryptionMapping);
        config.put(encryption.getName(), encryption);
        SettingParam algorithm = new SettingParam("wifi_alghoritm", "wireless_algorithm", null, true);
        HashMap<String, String> algorithmMapping = new HashMap<String, String>();
        algorithmMapping.put("NONE", "");
        algorithmMapping.put("WEP", "");
        algorithmMapping.put("TKIP", "TKIP");
        algorithmMapping.put("AES_CCMP", "AES");
        algorithm.setMapping(algorithmMapping);
        config.put(algorithm.getName(), algorithm);
        SettingParam presharedkey = new SettingParam("wifi_pre_shared_key", "wireless_presharedkey", null, false);
        config.put(presharedkey.getName(), presharedkey);
        SettingParam wepAuthMode = new SettingParam("wifi_wep_auth_mode", "wireless_authmode", null, false);
        config.put(wepAuthMode.getName(), wepAuthMode);
        SettingParam wepKeyLength = new SettingParam("wifi_wep_key_length", "wireless_keylength", null, true);
        HashMap<String, String> keyLengthMapping = new HashMap<String, String>();
        keyLengthMapping.put(WepKeyLength.LENGTH_64_BITS.name(), "64");
        keyLengthMapping.put(WepKeyLength.LENGTH_128_BITS.name(), "128");
        keyLengthMapping.put("", "");
        wepKeyLength.setMapping(keyLengthMapping);
        config.put(wepKeyLength.getName(), wepKeyLength);
        SettingParam wepKeyFormat = new SettingParam("wifi_wep_key_format", "wireless_keyformat", null, false);
        config.put(wepKeyFormat.getName(), wepKeyFormat);
        SettingParam wepKey1 = new SettingParam("wifi_wep_key1", "wireless_key1", null, false);
        config.put(wepKey1.getName(), wepKey1);
        SettingParam wepKey2 = new SettingParam("wifi_wep_key2", "wireless_key2", null, false);
        config.put(wepKey2.getName(), wepKey2);
        SettingParam wepKey3 = new SettingParam("wifi_wep_key3", "wireless_key3", null, false);
        config.put(wepKey3.getName(), wepKey3);
        SettingParam wepKey4 = new SettingParam("wifi_wep_key4", "wireless_key4", null, false);
        config.put(wepKey4.getName(), wepKey4);
        SettingParam wepDefaultKey = new SettingParam("wifi_wep_default_key", "wireless_keyselect", null, false);
        config.put(wepDefaultKey.getName(), wepDefaultKey);
        SettingParam videoQuality = new SettingParam("video_quality", "", null, false);
        config.put(videoQuality.getName(), videoQuality);
        return config;
    }

    public void update(LanDeviceEntity device, boolean force) {
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateSetting(String request, HttpCommand.SendMethod method, LanDeviceEntity device, LanDeviceParamEntity param) {
        UpdateSettingsHandler updateHandler = this.updateHandlerFactory.getInstance(this.getHttpClientService(), request, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this, param);
        updateHandler.run();
    }

    private void updateSettings(String request, HttpCommand.SendMethod method, LanDeviceEntity device, List<LanDeviceParamEntity> params) {
        UpdateSettingsHandler updateHandler = this.updateHandlerFactory.getInstance(this.getHttpClientService(), request, HttpCommand.SendMethod.GET, device, (UpdatedSettingsListener)this, params);
        updateHandler.run();
    }

    private SettingsRequest createSendSettingsRequest(LanDeviceEntity device, Set<LanDeviceParamEntity> params) {
        ArrayList<LanDeviceParamEntity> processingParams = new ArrayList<LanDeviceParamEntity>();
        StringBuilder request = new StringBuilder(1000);
        request.append("http://");
        request.append(device.getUsername()).append(":").append(device.getPass()).append("@");
        request.append(device.getIpAddress());
        request.append("/cgi-bin/admin/setparam.cgi?");
        HashSet<LanDeviceParamEntity> tamperedParams = new HashSet<LanDeviceParamEntity>(params);
        Boolean wifiEnabled = this.isWifiEnabled(params);
        if (wifiEnabled != null) {
            processingParams.add(this.getParam(tamperedParams, "wifi_enabled"));
        }
        HashSet<String> remainsParams = new HashSet<String>();
        for (LanDeviceParamEntity param : tamperedParams) {
            remainsParams.add(param.getName());
        }
        for (LanDeviceParamEntity param : tamperedParams) {
            log.debug((Object)("processing param: " + param));
            log.debug((Object)("remainsParams1: " + remainsParams));
            if (!remainsParams.contains(param.getName())) {
                log.debug((Object)("Param " + param + " has been processed already"));
                continue;
            }
            log.debug((Object)("remainsParams2: " + remainsParams));
            if (param.getName().equals("video_quality")) {
                VideoQuality videoQuality = CameraVivotekGeneric.getVideoQuality((String)param.getValue());
                String videoEncoding = device.getVideoEncoding();
                int fps = videoQuality.getFps(videoEncoding);
                if (videoEncoding.equals("MJPEG")) {
                    int quality = videoQuality.getQualityMjpeg();
                    request.append("videoin_c0_s0_mjpeg_maxframe=").append(String.valueOf(fps)).append("&");
                    request.append("videoin_c0_s0_mjpeg_quant=").append(String.valueOf(quality)).append("&");
                    request.append("videoin_c0_s1_mjpeg_maxframe=").append(String.valueOf(fps)).append("&");
                    request.append("videoin_c0_s1_mjpeg_quant=").append(String.valueOf(quality)).append("&");
                } else {
                    String codecType = device.getVideoEncoding().toLowerCase();
                    request.append("videoin_c0_s0_" + codecType + "_maxframe=").append(String.valueOf(fps)).append("&");
                    request.append("videoin_c0_s0_" + codecType + "_ratecontrolmode=").append("cbr").append("&");
                    request.append("videoin_c0_s0_" + codecType + "_bitrate=").append(String.valueOf(videoQuality.getBitrateLow(videoEncoding))).append("&");
                    request.append("videoin_c0_s1_" + codecType + "_maxframe=").append(String.valueOf(fps)).append("&");
                    request.append("videoin_c0_s1_" + codecType + "_ratecontrolmode=").append("cbr").append("&");
                    request.append("videoin_c0_s1_" + codecType + "_bitrate=").append(String.valueOf(videoQuality.getBitrate(videoEncoding))).append("&");
                }
                processingParams.add(param);
                continue;
            }
            SettingParam settingParam = (SettingParam)this.cameraSettings.get(param.getName());
            if (settingParam != null && !settingParam.isSelfSendable()) {
                String rawValue;
                if (wifiEnabled != null && !wifiEnabled.booleanValue()) {
                    if (settingParam.getName().equals("wifi_ssid")) {
                        rawValue = settingParam.rawValue("default");
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                    } else if (settingParam.getName().equals("wifi_wlan_mode")) {
                        rawValue = settingParam.rawValue("INFRASTRUCTURE");
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                    } else if (settingParam.getName().equals("wifi_encryption")) {
                        rawValue = settingParam.rawValue("OPEN");
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                    } else if (settingParam.getName().equals("wifi_channel")) {
                        rawValue = settingParam.rawValue("6");
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                    } else {
                        rawValue = settingParam.rawValue(param.getValue());
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                    }
                    processingParams.add(param);
                } else {
                    rawValue = settingParam.rawValue(param.getValue());
                    if (settingParam.getName().equals("alarm_video_clip") || settingParam.getName().equals("motion_detection")) {
                        if (remainsParams.contains("alarm_video_clip")) {
                            remainsParams.remove("alarm_video_clip");
                            processingParams.add(this.getParam(tamperedParams, "alarm_video_clip"));
                        }
                        if (remainsParams.contains("motion_detection")) {
                            remainsParams.remove("motion_detection");
                            processingParams.add(this.getParam(tamperedParams, "motion_detection"));
                        }
                        boolean enabledMotionDetection = device.getParamValue("motion_detection").equals("ON");
                        if (this.supportVideoClipRecording(device)) {
                            boolean enabledVideoClip = device.getParamValue("alarm_video_clip").equals("ON");
                            String videoClipRawValue = enabledMotionDetection && enabledVideoClip ? "1" : "0";
                            request.append(CameraVivotekSettings.escape((String)"event_i1_enable")).append("=").append(CameraVivotekSettings.escape((String)videoClipRawValue)).append("&");
                        }
                        String motionDetectionRawValue = enabledMotionDetection ? "1" : "0";
                        request.append(CameraVivotekSettings.escape((String)"event_i0_enable")).append("=").append(CameraVivotekSettings.escape((String)motionDetectionRawValue)).append("&");
                    } else if (settingParam.getName().equals("alarm_limit")) {
                        remainsParams.remove("alarm_limit");
                        processingParams.add(this.getParam(tamperedParams, "alarm_limit"));
                        String alarmLimitvalue = device.getParamValue("alarm_limit");
                        String alarmLimitRawValue = settingParam.rawValue(alarmLimitvalue);
                        request.append(CameraVivotekSettings.escape((String)"event_i0_delay")).append("=").append(CameraVivotekSettings.escape((String)alarmLimitRawValue)).append("&");
                        request.append(CameraVivotekSettings.escape((String)"event_i1_delay")).append("=").append(CameraVivotekSettings.escape((String)alarmLimitRawValue)).append("&");
                    } else {
                        request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
                        processingParams.add(param);
                    }
                }
            }
            remainsParams.remove(param.getName());
        }
        request.delete(request.length() - 1, request.length());
        return new SettingsRequest(this, request.toString(), processingParams);
    }

    private Boolean isWifiEnabled(Collection<LanDeviceParamEntity> params) {
        LanDeviceParamEntity wifiEnabledParam = this.getParam(params, "wifi_enabled");
        if (wifiEnabledParam == null) {
            return null;
        }
        return wifiEnabledParam.getValue().equals("ON");
    }

    private LanDeviceParamEntity getParam(Collection<LanDeviceParamEntity> params, String paramName) {
        if (params == null || params.isEmpty() || paramName == null) {
            return null;
        }
        for (LanDeviceParamEntity param : params) {
            if (!param.getName().equals(paramName)) continue;
            return param;
        }
        return null;
    }

    public String createSendSingleSettingRequest(LanDeviceEntity device, String paramName, String paramValue) {
        StringBuilder request = new StringBuilder(100);
        request.append("http://");
        request.append(device.getUsername()).append(":").append(device.getPass()).append("@");
        request.append(device.getIpAddress());
        request.append("/cgi-bin/admin/setparam.cgi?");
        if (paramName.equals("video_quality")) {
            VideoQuality videoQuality = CameraVivotekGeneric.getVideoQuality((String)paramValue);
            int fps = videoQuality.getFps(device.getVideoEncoding());
            int quality = videoQuality.getQualityMjpeg();
            request.append("videoin_c0_s0_mjpeg_maxframe=").append(String.valueOf(fps)).append("&");
            request.append("videoin_c0_s0_mjpeg_quant=").append(String.valueOf(quality)).append("&");
            request.append("videoin_c0_s1_mjpeg_maxframe=").append(String.valueOf(fps)).append("&");
            request.append("videoin_c0_s1_mjpeg_quant=").append(String.valueOf(quality)).append("&");
        } else {
            SettingParam settingParam = (SettingParam)this.cameraSettings.get(paramName);
            String rawValue = settingParam.rawValue(paramValue);
            request.append(CameraVivotekSettings.escape((String)settingParam.getCommand())).append("=").append(CameraVivotekSettings.escape((String)rawValue)).append("&");
        }
        return request.toString();
    }

    public String createDedicatedSendSettingsRequest(LanDeviceEntity device, SettingParam settingParam, LanDeviceParamEntity param) {
        return this.createDedicatedSendSettingsRequest(device, settingParam, param.getValue());
    }

    public String createDedicatedSendSettingsRequest(LanDeviceEntity device, SettingParam settingParam, String paramValue) {
        StringBuilder request = new StringBuilder(1000);
        request.append("http://");
        request.append(device.getUsername()).append(":").append(device.getPass()).append("@");
        request.append(device.getIpAddress());
        request.append(settingParam.getSendQuery()).append("=").append(settingParam.rawValue(paramValue));
        return request.toString();
    }

    private Set<LanDeviceParamEntity> getParamsToUpdate(LanDeviceEntity device, boolean force) {
        if (device == null || device.getLanDeviceParams() == null || device.getLanDeviceParams().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<LanDeviceParamEntity> params = new HashSet<LanDeviceParamEntity>();
        boolean wifiUpdateRequired = this.isWifiUpdateRequired(device);
        log.debug((Object)("wifiUpdateRequired: " + wifiUpdateRequired));
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!this.cameraSettings.containsKey(param.getName()) && !param.getName().equals("wifi_enabled") && !param.getName().equals("video_quality")) continue;
            if (force) {
                params.add(param);
                continue;
            }
            if (wifiUpdateRequired && param.getName().startsWith("wifi_")) {
                params.add(param);
                continue;
            }
            if (param.getValue().equals(param.getRemoteValue())) continue;
            params.add(param);
        }
        log.debug((Object)("params to update: " + params));
        return params;
    }

    private boolean isWifiUpdateRequired(LanDeviceEntity device) {
        boolean wifiEnabled = false;
        boolean ssidEmpty = false;
        boolean wifiStateSwitched = false;
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (param.getName().equals("wifi_enabled")) {
                wifiStateSwitched = !param.getValue().equals(param.getRemoteValue());
                wifiEnabled = "ON".equals(param.getValue());
            }
            if (param.getName().equals("wifi_ssid") && (param.getValue() == null || param.getValue().isEmpty())) {
                ssidEmpty = true;
            }
            if (wifiEnabled && ssidEmpty) {
                return false;
            }
            if (!param.getName().startsWith("wifi_") || param.getName().equals("wifi_bssid") || param.getName().equals("wifi_enabled") || param.getValue().equals(param.getRemoteValue())) continue;
            return true;
        }
        return wifiStateSwitched;
    }

    private Map<String, String> parseResponse(String text) {
        String[] params;
        if (text == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        text = text.replace("\r\n", " ");
        text = text.replace("'", "");
        String[] stringArray = params = text.split(" ");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] elements = param.split("=");
            String key = null;
            String value = null;
            if (elements.length > 0) {
                key = elements[0].trim();
            }
            if (elements.length > 1) {
                value = elements[1].trim();
            }
            settings.put(key, value);
            ++n2;
        }
        return settings;
    }

    private LanDeviceParamEntity getParam(List<LanDeviceParamEntity> params, String name) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        for (LanDeviceParamEntity param : params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public void processUpdatedSettingsResponse(LanDeviceEntity device, HTTPClientServiceResult response, List<LanDeviceParamEntity> processingParams) {
        log.debug((Object)("start processUpdateResponse(response=" + response + ", processingParams=" + processingParams));
        if (response.getResult() == HTTPClientServiceResult.Result.OK) {
            if (processingParams.size() == 1 && response.getBodyAsText().trim().equals("ok")) {
                LanDeviceParamEntity processingParam = processingParams.get(0);
                String value = processingParam.getValue();
                this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), processingParam.getName(), value, value);
            } else {
                VideoQuality videoQuality;
                LanDeviceParamEntity videoQualityParam;
                Map params = this.parseResponse(response.getBodyAsText());
                Boolean wifiEnabled = this.isWifiEnabled(processingParams);
                if (wifiEnabled != null) {
                    LanDeviceParamEntity wifiEnabledParam = this.getParam(processingParams, "wifi_enabled");
                    String value = wifiEnabledParam.getValue();
                    String remoteValue = wifiEnabledParam.getRemoteValue();
                    if (!wifiEnabled.booleanValue()) {
                        if ("default".equals(params.get("wireless_ssid")) && "0".equals(params.get("wireless_encrypt"))) {
                            remoteValue = wifiEnabledParam.getValue();
                        } else {
                            wifiEnabledParam.setValue(wifiEnabledParam.getRemoteValue());
                            value = wifiEnabledParam.getRemoteValue();
                        }
                    } else {
                        remoteValue = wifiEnabledParam.getValue();
                    }
                    if (value == null) {
                        log.warn((Object)"wifi_enabled value is null.");
                    } else {
                        this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), "wifi_enabled", value, remoteValue);
                    }
                }
                String codecType = device.getVideoEncoding().toLowerCase();
                if (params.containsKey("videoin_c0_s0_mjpeg_maxframe") || params.containsKey("videoin_c0_s0_mjpeg_quant") || params.containsKey("videoin_c0_s1_mjpeg_maxframe") || params.containsKey("videoin_c0_s1_mjpeg_quant")) {
                    videoQualityParam = this.getParam(processingParams, "video_quality");
                    videoQuality = CameraVivotekGeneric.getVideoQuality((String)videoQualityParam.getValue());
                    if (this.isCorectVideoQualityUpdate(params, videoQuality, codecType)) {
                        this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), "video_quality", videoQualityParam.getValue(), videoQualityParam.getValue());
                    } else {
                        this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), "video_quality", videoQualityParam.getRemoteValue(), videoQualityParam.getRemoteValue());
                    }
                }
                if (params.containsKey("videoin_c0_s0_" + codecType + "_maxframe") || params.containsKey("videoin_c0_s0_" + codecType + "_bitrate") || params.containsKey("videoin_c0_s1_" + codecType + "_maxframe") || params.containsKey("videoin_c0_s1_" + codecType + "_bitrate")) {
                    videoQualityParam = this.getParam(processingParams, "video_quality");
                    videoQuality = CameraVivotekGeneric.getVideoQuality((String)videoQualityParam.getValue());
                    if (this.isCorectVideoQualityUpdate(params, videoQuality, codecType)) {
                        this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), "video_quality", videoQualityParam.getValue(), videoQualityParam.getValue());
                    } else {
                        this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), "video_quality", videoQualityParam.getRemoteValue(), videoQualityParam.getRemoteValue());
                    }
                }
                for (Map.Entry param : params.entrySet()) {
                    log.debug((Object)("Processing response value: " + (String)param.getKey() + "=" + (String)param.getValue()));
                    SettingParam settingParam = this.getSettingsParamByCommand((String)param.getKey());
                    if (settingParam == null || wifiEnabled != null && !wifiEnabled.booleanValue() && settingParam.getName().startsWith("wifi_")) continue;
                    LanDeviceParamEntity deviceParam = this.getLanDeviceParamByName(processingParams, settingParam.getName());
                    log.debug((Object)("landeviceparamentity: " + deviceParam));
                    if (deviceParam == null) continue;
                    String value = param.getValue() == null ? "" : (String)param.getValue();
                    String remoteValue = deviceParam.getRemoteValue();
                    if (settingParam.getName().equals("wifi_alghoritm") && value.trim().isEmpty()) {
                        log.debug((Object)"processing wifi_alghoritm param with empty value.");
                        LanDeviceParamEntity encryptionParam = this.getLanDeviceParamByName(processingParams, "wifi_encryption");
                        if (encryptionParam.getValue().equals("OPEN")) {
                            remoteValue = "NONE";
                        } else if (encryptionParam.getValue().equals("WEP")) {
                            remoteValue = "WEP";
                        }
                    } else {
                        remoteValue = CameraVivotekSettings.unescape((String)settingParam.mapValue(value.trim()));
                    }
                    this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), deviceParam.getName(), deviceParam.getValue(), remoteValue);
                }
            }
        }
    }

    private boolean isCorectVideoQualityUpdate(Map<String, String> params, VideoQuality videoQuality, String codecType) {
        String quality2;
        String quality1;
        String fps2;
        String fps1;
        String qualityLow;
        String quality;
        if (params == null || params.isEmpty()) {
            log.debug((Object)"Params are null.");
            return false;
        }
        if (videoQuality == null) {
            log.debug((Object)"Video quality is null.");
            return false;
        }
        String fps = String.valueOf(videoQuality.getFps(codecType));
        if ("mjpeg".equals(codecType)) {
            qualityLow = quality = String.valueOf(videoQuality.getQualityMjpeg());
            fps1 = params.get("videoin_c0_s0_mjpeg_maxframe");
            fps2 = params.get("videoin_c0_s1_mjpeg_maxframe");
            quality1 = params.get("videoin_c0_s0_mjpeg_quant");
            quality2 = params.get("videoin_c0_s1_mjpeg_quant");
        } else {
            quality = String.valueOf(videoQuality.getBitrate(codecType));
            qualityLow = String.valueOf(videoQuality.getBitrateLow(codecType));
            fps1 = params.get("videoin_c0_s0_" + codecType + "_maxframe");
            fps2 = params.get("videoin_c0_s1_" + codecType + "_maxframe");
            quality1 = params.get("videoin_c0_s0_" + codecType + "_bitrate");
            quality2 = params.get("videoin_c0_s1_" + codecType + "_bitrate");
        }
        return fps1 != null && fps2 != null && quality1 != null && quality2 != null && fps1.equals(fps) && fps2.equals(fps) && quality1.equals(qualityLow) && quality2.equals(quality);
    }

    private SettingParam getSettingsParamByCommand(String command) {
        log.debug((Object)("start getSettingsParamByCommand(" + command + ")"));
        for (SettingParam settingParam : this.cameraSettings.values()) {
            if (settingParam.isSelfSendable() || !settingParam.getCommand().equals(command)) continue;
            return settingParam;
        }
        log.debug((Object)("exit getSettingsParamByCommand(" + command + "): null"));
        return null;
    }

    private LanDeviceParamEntity getLanDeviceParamByName(Collection<LanDeviceParamEntity> params, String name) {
        log.debug((Object)("start getLanDeviceParamByName(" + name + ")"));
        for (LanDeviceParamEntity param : params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    private HTTPClientService getHttpClientService() {
        HTTPClientService service = this.serviceFactory.getHttpClientService();
        service.setTimeout(Integer.valueOf(120));
        return service;
    }

    private static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder response = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (CameraVivotekSettings.isAllowedChar((char)currentChar)) {
                response.append(currentChar);
            } else {
                response.append(CameraVivotekSettings.escape((char)currentChar));
            }
            ++i;
        }
        return response.toString();
    }

    private static String escape(char c) {
        return "%25" + CameraVivotekSettings.charToHex((char)c);
    }

    private static String charToHex(char c) {
        return Integer.toHexString(c);
    }

    private static boolean isAllowedChar(char c) {
        return c == '=' || c == '_' || c == '@' || c == '*' || c == '-' || c == '+' || c == '/' || c == '.' || Character.isLetterOrDigit(c);
    }

    public static String unescape(String text) {
        if (!text.contains("%")) {
            return text;
        }
        Pattern pattern = Pattern.compile("(%[0-9]{2})");
        Matcher matcher = pattern.matcher(text);
        HashSet<String> replacements = new HashSet<String>();
        while (matcher.find()) {
            replacements.add(text.substring(matcher.start(), matcher.end()));
        }
        for (String replacement : replacements) {
            int charCode = Integer.parseInt(replacement.replace("%", ""), 16);
            text = text.replace(replacement, String.valueOf((char)charCode));
        }
        return text;
    }

    private boolean supportVideoClipRecording(LanDeviceEntity device) {
        String hasVideoclipRecording = device.getParamValue("has_videoclip_recording");
        return hasVideoclipRecording != null && hasVideoclipRecording.equals("ON");
    }

    static /* synthetic */ Set access$0(CameraVivotekSettings cameraVivotekSettings, LanDeviceEntity lanDeviceEntity, boolean bl) {
        return cameraVivotekSettings.getParamsToUpdate(lanDeviceEntity, bl);
    }

    static /* synthetic */ SettingsRequest access$1(CameraVivotekSettings cameraVivotekSettings, LanDeviceEntity lanDeviceEntity, Set set) {
        return cameraVivotekSettings.createSendSettingsRequest(lanDeviceEntity, set);
    }

    static /* synthetic */ Logger access$2() {
        return log;
    }

    static /* synthetic */ void access$3(CameraVivotekSettings cameraVivotekSettings, String string, HttpCommand.SendMethod sendMethod, LanDeviceEntity lanDeviceEntity, List list) {
        cameraVivotekSettings.updateSettings(string, sendMethod, lanDeviceEntity, list);
    }

    static /* synthetic */ Map access$4(CameraVivotekSettings cameraVivotekSettings) {
        return cameraVivotekSettings.cameraSettings;
    }

    static /* synthetic */ void access$5(CameraVivotekSettings cameraVivotekSettings, String string, HttpCommand.SendMethod sendMethod, LanDeviceEntity lanDeviceEntity, LanDeviceParamEntity lanDeviceParamEntity) {
        cameraVivotekSettings.updateSetting(string, sendMethod, lanDeviceEntity, lanDeviceParamEntity);
    }
}

