/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.vivotek;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.VivotekCameraDiscoveryService;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.Resolution;
import pl.smartapps.containerserver.landevice.SettingParam;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.containerserver.landevice.WepAuthenticationType;
import pl.smartapps.containerserver.landevice.WepKeyFormat;
import pl.smartapps.containerserver.landevice.WepKeyLength;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;
import pl.smartapps.containerserver.landevice.multipart.Multipart;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekSettings;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CameraVivotekGeneric")
@Scope(value="prototype")
public class CameraVivotekGeneric
extends GenericCamera {
    private static final String PAN_LEFT = "/cgi-bin/viewer/camctrl.cgi?move=left";
    private static final String PAN_RIGHT = "/cgi-bin/viewer/camctrl.cgi?move=right";
    private static final String PAN_UP = "/cgi-bin/viewer/camctrl.cgi?move=up";
    private static final String PAN_DOWN = "/cgi-bin/viewer/camctrl.cgi?move=down";
    private static final String PAN_CENTER = "/cgi-bin/viewer/camctrl.cgi?move=home";
    private static final String ZOOM_IN = "/cgi-bin/viewer/camctrl.cgi?zoom=tele";
    private static final String ZOOM_OUT = "/cgi-bin/viewer/camctrl.cgi?zoom=wide";
    private static final String PRIVACY_CMD = "/cgi-bin/admin/privacybutton.cgi";
    private static final String DOWNLOAD_CONFIGURATION_CMD = "/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion&audioin";
    private static final String DOWNLOAD_CAPABILITIES_CMD = "/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion";
    private static final String CONFIGURE_CMD = "/cgi-bin/admin/setparam.cgi";
    private static final String UPGRADE_FIRMWARE_CMD = "/cgi-bin/admin/upgrade.cgi";
    private static final String EDIT_ACCOUNT_CMD = "/cgi-bin/admin/editaccount.cgi";
    protected static final String DEFAULT_USER = "root";
    protected static final String DEFAULT_PASSWORD = "";
    static Map<VideoQualityLevel, VideoQuality> videoQualities = new /* Unavailable Anonymous Inner Class!! */;
    private static Logger log = Logger.getLogger(CameraVivotekGeneric.class);
    private CameraVivotekSettings cameraVivotekSettings;
    private int userIndex;
    private static Map<Integer, Integer> rssiConversion = new /* Unavailable Anonymous Inner Class!! */;
    private static Map<String, String> videoFormat = new /* Unavailable Anonymous Inner Class!! */;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;

    public CameraVivotekGeneric() {
        this.user = "root";
        this.pass = "";
        this.cameraProducer = "Vivotek";
        this.capabilitiesCommands = new String[]{"/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion"};
        this.firmwareVersionParam = "system_info_firmwareversion";
        this.modelParam = "system_info_modelname";
    }

    @Autowired
    @Required
    public void setCameraVivotekSettings(CameraVivotekSettings cameraVivotekSettings) {
        this.cameraVivotekSettings = cameraVivotekSettings;
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        parsedResponse.put(key, CameraVivotekSettings.unescape((String)value));
        return true;
    }

    public Map<String, String> parseResponse(String response) {
        String model;
        Map parsedResponse = super.parseResponse(response);
        if (!parsedResponse.isEmpty() && "IP7142".equals(model = (String)parsedResponse.get("system_info_modelname"))) {
            parsedResponse.put("capability_ptzenabled", "0");
        }
        return parsedResponse;
    }

    protected boolean isDeviceSupported(Map<String, String> deviceCapabilities) {
        String protocol = deviceCapabilities.get("capability_protocol_spush_mjpeg");
        return protocol != null && protocol.equals("1");
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return this.checkStatus(device, "/cgi-bin/admin/getparam.cgi?system_info_serialnumber");
    }

    public String getMacAddress(LanDeviceEntity device) {
        String url = String.valueOf(this.cameraBaseUrl(device)) + "/cgi-bin/admin/getparam.cgi?system_info_serialnumber";
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), url, HttpCommand.SendMethod.GET);
        return response == null ? null : (String)this.parseResponse(response.getBodyAsText()).get("system_info_serialnumber");
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        String serialnumber = (String)this.parseResponse(response.getBodyAsText()).get("system_info_serialnumber");
        if (serialnumber == null || !serialnumber.equals(device.getMac().replace(":", ""))) {
            return AccessVerificationStatus.NOANSWER;
        }
        return response.getBodyAsText().length() == 0 ? AccessVerificationStatus.ERROR : AccessVerificationStatus.OK;
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        Map configurationParams;
        HTTPClientServiceResult configureDeviceResponse;
        boolean isRtspStreaming = this.isRtspStreaming();
        MotionDetectionType motionDetectionType = this.getMotionDetectionType(this.deviceCapabilities);
        if (!reconfiguration) {
            Boolean supportPrivacyButton;
            if (this.isSystemLedOffSupported(this.deviceCapabilities)) {
                device.setParam("system_ledoff", "OFF", "OFF");
            }
            if (this.isMuteAudioSupported(device)) {
                device.setParam("mute_audio", "OFF", "OFF");
            }
            String resolution = this.getResolution(this.deviceCapabilities, "640x480");
            device.setParam("resolution", resolution);
            device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=" + resolution);
            String resolutionLow = this.getResolution(this.deviceCapabilities, "320x240");
            device.setParam("resolution_low", resolutionLow);
            device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=" + resolutionLow);
            device.setParam("has_home", this.isPtzSupported(this.deviceCapabilities) ? "ON" : "OFF");
            device.setParam("has_pan", this.isPanSupported(this.deviceCapabilities) ? "ON" : "OFF");
            device.setParam("has_tilt", this.isTiltSupported(this.deviceCapabilities) ? "ON" : "OFF");
            device.setParam("has_zoom", this.isZoomSupported(this.deviceCapabilities) ? "ON" : "OFF");
            if (motionDetectionType != null) {
                device.setParam("motion_detection", "OFF", "OFF");
                device.setParam("alarm_limit", "0", "0");
                device.setParam("record_video", "OFF", null);
                device.setParam("video_recording_duration", "15", null);
                if (this.isVideoClipSupported(device)) {
                    device.setParam("alarm_video_clip", "OFF", "OFF");
                    String maxVideoClipDuration = this.getMaxVideoClipDuration(device);
                    device.setParam("videoclip_duration", maxVideoClipDuration, maxVideoClipDuration);
                }
            }
            if ((supportPrivacyButton = this.isPrivacyButtonSupport(device)) == null) {
                log.warn((Object)("Failed to test privacy button support for device with lanDeviceId=" + device.getLanDeviceId() + " and mac=" + device.getMac() + "."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            if (supportPrivacyButton.booleanValue()) {
                device.setParam("privacy_button", "ON", "ON");
            }
            if (this.isWifiSupported(this.deviceCapabilities)) {
                device.setParam("need_restart_after_network_changes", "ON");
                if (!this.restoreWifiSettings(device, this.deviceCapabilities)) {
                    log.warn((Object)("Failed to restore wifi settings from device with mac='" + device.getMac() + "'."));
                    return GenericLanDevice.ConfigurationStatus.MANUAL;
                }
            }
            if ("PT8133".equals(device.getModel())) {
                device.setParam("has_video_orientation", "ON", null);
                device.setParam("video_orientation_flip", "ON", "ON");
                device.setParam("video_orientation_mirror", "ON", "ON");
            }
        }
        if (device.getVideoEncoding().equals("MJPEG")) {
            device.setParam("has_mute_audio", "OFF");
            device.setParam("mute_audio", "ON", "ON");
        } else if (device.getVideoEncoding().equals("H264") || device.getVideoEncoding().equals("MPEG4")) {
            device.setParam("has_mute_audio", "ON");
            if (!device.hasParam("mute_audio")) {
                device.setParam("mute_audio", "OFF", "OFF");
            }
        }
        if (motionDetectionType != null) {
            if (isRtspStreaming && this.hasGatewayClientWithMPEG4Support(device)) {
                device.setParam("has_videoclip_recording", "ON");
                if (!device.hasParam("alarm_video_clip")) {
                    device.setParam("alarm_video_clip", "OFF", "OFF");
                }
                String maxDuration = this.getMaxVideoClipDuration(device);
                if (!device.hasParam("videoclip_duration")) {
                    device.setParam("videoclip_duration", maxDuration, maxDuration);
                }
                if (!device.hasParam("max_videoclip_duration")) {
                    device.setParam("max_videoclip_duration", maxDuration);
                }
                if (!device.hasParam("min_videoclip_duration")) {
                    device.setParam("min_videoclip_duration", "4");
                }
            } else {
                device.setParam("has_videoclip_recording", "OFF");
            }
        }
        if (isRtspStreaming && this.hasGatewayClientWithMPEG4Support(device)) {
            device.setParam("path", "live2.sdp");
            device.setParam("path_low", "live.sdp");
            device.setParam("path_rtsp_over_http_get", "live2.sdp");
            device.setParam("path_low_rtsp_over_http_get", "live.sdp");
            device.setParam("path_rtsp_over_http_post", "live2.sdp");
            device.setParam("path_low_rtsp_over_http_post", "live.sdp");
            device.setParam("rtsp_port", "554");
            device.setParam("rtsp_over_http_port", "80");
        } else {
            device.setParam("path", "video2.mjpg");
            device.setParam("path_low", "video.mjpg");
        }
        String privacyButton = device.getParamValue("privacy_button");
        if (privacyButton != null) {
            boolean enablePrivacyButton = privacyButton.equals("ON");
            HTTPClientServiceResult configurePrivacyButtonResponse = this.configurePrivacyButton(device, enablePrivacyButton);
            if (!this.isCorrectPrivacyButtonConfigureResponse(configurePrivacyButtonResponse)) {
                log.warn((Object)("Failed to configure privacy button: " + configurePrivacyButtonResponse + "."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            this.applyValueToRemoteValue(device, "privacy_button");
        }
        if (!this.isCorrectResponse(configureDeviceResponse = this.sendCommand(device, "/cgi-bin/admin/setparam.cgi", configurationParams = this.prepareConfigurationParameters(device, this.userIndex, reconfiguration, true, this.deviceCapabilities), HttpCommand.SendMethod.GET))) {
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "video_quality");
        this.applyValueToRemoteValue(device, "motion_detection");
        this.applyValueToRemoteValue(device, "audio_detection");
        this.applyValueToRemoteValue(device, "audio_detection_sensitivity");
        this.applyValueToRemoteValue(device, "alarm_video_clip");
        this.applyValueToRemoteValue(device, "videoclip_duration");
        this.applyValueToRemoteValue(device, "alarm_limit");
        this.applyValueToRemoteValue(device, "system_ledoff");
        this.applyValueToRemoteValue(device, "mute_audio");
        if (reconfiguration && this.isWifiSupported(this.deviceCapabilities)) {
            this.applyValueToRemoteValue(device, "wifi_alghoritm");
            this.applyValueToRemoteValue(device, "wifi_bssid");
            this.applyValueToRemoteValue(device, "wifi_channel");
            this.applyValueToRemoteValue(device, "wifi_enabled");
            this.applyValueToRemoteValue(device, "wifi_encryption");
            this.applyValueToRemoteValue(device, "wifi_pre_shared_key");
            this.applyValueToRemoteValue(device, "wifi_ssid");
            this.applyValueToRemoteValue(device, "wifi_wep_auth_mode");
            this.applyValueToRemoteValue(device, "wifi_wep_default_key");
            this.applyValueToRemoteValue(device, "wifi_wep_key1");
            this.applyValueToRemoteValue(device, "wifi_wep_key2");
            this.applyValueToRemoteValue(device, "wifi_wep_key3");
            this.applyValueToRemoteValue(device, "wifi_wep_key4");
            this.applyValueToRemoteValue(device, "wifi_wep_key_format");
            this.applyValueToRemoteValue(device, "wifi_wep_key_length");
            this.applyValueToRemoteValue(device, "wifi_wlan_mode");
        }
        return this.verifyConfiguration(configurationParams, configureDeviceResponse.getBodyAsText()) ? GenericLanDevice.ConfigurationStatus.OK : GenericLanDevice.ConfigurationStatus.MANUAL;
    }

    private void applyValueToRemoteValue(LanDeviceEntity device, String paramName) {
        LanDeviceParamEntity lanDeviceParam = device.getParam(paramName);
        if (lanDeviceParam == null) {
            return;
        }
        lanDeviceParam.setRemoteValue(lanDeviceParam.getValue());
    }

    private boolean isVideoClipSupported(LanDeviceEntity device) {
        return this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device);
    }

    private boolean isCorrectPrivacyButtonConfigureResponse(HTTPClientServiceResult response) {
        return this.isCorrectResponse(response) && response.getBodyAsText().trim().equalsIgnoreCase("ok");
    }

    private Map<String, String> parseConfigurationResponse(String response) {
        String[] params;
        if (response == null || response.trim().length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parsedResponse = new HashMap<String, String>();
        response = this.removeHtmlBody(response);
        response = response.replace("\r\n", " ");
        response = response.replace("'", "");
        String[] stringArray = params = response.split(" ");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            int delimPos = param.indexOf("=");
            if (delimPos == -1) {
                log.debug((Object)("Unexpected device param representation: " + param + "."));
            } else {
                String paramName = param.substring(0, delimPos).trim();
                String paramValue = param.substring(delimPos + 1).trim();
                parsedResponse.put(paramName, paramValue);
            }
            ++n2;
        }
        String model = (String)parsedResponse.get("system_info_modelname");
        if ("IP7142".equals(model)) {
            parsedResponse.put("capability_ptzenabled", "0");
        }
        return parsedResponse;
    }

    private boolean verifyConfiguration(Map<String, String> expectedConfiguration, String configurationResopnse) {
        log.debug((Object)"start verifyConfiguration");
        Map responseParams = this.parseConfigurationResponse(configurationResopnse);
        if (expectedConfiguration.equals(responseParams)) {
            return true;
        }
        boolean result = true;
        for (Map.Entry<String, String> requestParam : expectedConfiguration.entrySet()) {
            log.debug((Object)("processing configuration param: " + requestParam.getKey() + " -> " + requestParam.getValue()));
            String responseParamValue = (String)responseParams.get(requestParam.getKey());
            if (responseParamValue == null) {
                log.warn((Object)("Missing parameter in camera response: <" + requestParam.getKey() + ", " + requestParam.getValue() + ">."));
                result = false;
                continue;
            }
            if (requestParam.getValue().equals(responseParamValue)) continue;
            log.warn((Object)("Unexpected parameter value for parameter name '" + requestParam.getKey() + "'. Expected value is '" + requestParam.getValue() + "' but was '" + responseParamValue + "."));
            result = false;
        }
        return result;
    }

    private int extractUserIndex(Map<String, String> deviceCapabilities, String username) {
        log.debug((Object)("start extractUserIndex(deviceCapabilities=..., username=" + username + ")"));
        if (deviceCapabilities == null || deviceCapabilities.isEmpty()) {
            return -1;
        }
        if (username == null || username.trim().length() == 0) {
            return -1;
        }
        for (Map.Entry<String, String> entry : deviceCapabilities.entrySet()) {
            if (!entry.getKey().startsWith("security_user_i") || !entry.getValue().equals(username)) continue;
            String key = entry.getKey();
            String index = key.substring("security_user_i".length(), key.lastIndexOf("_"));
            return Integer.parseInt(index);
        }
        return -1;
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        this.userIndex = this.extractUserIndex(this.deviceCapabilities, device.getParamValue("viewer_user"));
        if (this.userIndex == -1 && !this.registerViewerUser(device)) {
            log.warn((Object)("Failed to register viewer user on device with lanDeviceId=" + device.getLanDeviceId() + " and mac=" + device.getMac() + "."));
            return false;
        }
        return true;
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        log.debug((Object)("start registerUser(device=" + device + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/editaccount.cgi", params, HttpCommand.SendMethod.GET);
        log.debug((Object)("update viewer user response: " + response.toString()));
        if (this.isCorrectPostResponse(response)) {
            boolean result = this.verifyRegistredUser(device);
            log.debug((Object)("register user veryfication result: " + result));
            return result;
        }
        return false;
    }

    private boolean registerViewerUser(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("method", "add");
        params.put("username", device.getParamValue("viewer_user"));
        params.put("password", device.getParamValue("viewer_pass"));
        params.put("privilege", "view");
        params.put("return", "/cgi-bin/admin/getparam.cgi?security");
        return this.registerUser(device, params);
    }

    private boolean verifyRegistredUser(LanDeviceEntity device) {
        log.debug((Object)("start verify verifyRegistredUser(device=" + device + ")"));
        String url = this.createConfigurationRequest(device, "/cgi-bin/admin/getparam.cgi?security");
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), url, HttpCommand.SendMethod.GET);
        log.debug((Object)("verify register viewer user response: " + response.toString()));
        if (this.isCorrectResponse(response)) {
            Map credentials = this.parseResponse(response.getBodyAsText());
            return credentials.values().contains(device.getParamValue("viewer_user"));
        }
        return false;
    }

    private String createConfigurationRequest(LanDeviceEntity device, String cmd) {
        log.debug((Object)("start createBaseConfigurationRequest(device=" + device + ")"));
        StringBuilder request = new StringBuilder(200);
        request.append("http://");
        String username = device.getUsername() == null ? "" : device.getUsername();
        String password = device.getPass() == null ? "" : device.getPass();
        request.append(username);
        if (password != null && password.length() > 0) {
            request.append(":").append(password);
        }
        request.append("@");
        request.append(device.getIpAddress());
        if (device.getPort() != null) {
            request.append(":");
            request.append(device.getPort());
        }
        if (cmd != null) {
            request.append(cmd);
        }
        return request.toString();
    }

    private Map<String, String> prepareConfigurationParameters(LanDeviceEntity device, int viewerUserIndex, boolean configureWifi, boolean configureViewerUserPassword, Map<String, String> capabilities) {
        String muteAudio;
        String ledOff;
        HashMap<String, String> params = new HashMap<String, String>();
        if (viewerUserIndex != -1) {
            params.put("security_user_i" + String.valueOf(viewerUserIndex) + "_privilege", "view");
            if (configureViewerUserPassword) {
                String viewerUserPassword = device.getParamValue("viewer_pass");
                params.put("security_user_i" + String.valueOf(viewerUserIndex) + "_pass", viewerUserPassword);
            }
        }
        if ((ledOff = device.getParamValue("system_ledoff")) != null) {
            params.put("system_ledoff", ledOff.equals("OFF") ? "0" : "1");
        }
        if (this.isPanSupported(capabilities)) {
            params.put("camctrl_c0_panspeed", "3");
        }
        if (this.isTiltSupported(capabilities)) {
            params.put("camctrl_c0_tiltspeed", "3");
        }
        params.put("system_ntp", "ntp.homemonitor.ch");
        params.put("system_timezoneindex", "00");
        params.put("system_updateinterval", "3600");
        params.put("network_http_authmode", "basic");
        params.put("network_http_alternateport", "");
        VideoQuality videoQuality = CameraVivotekGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        if (videoEncoding.equals("MJPEG")) {
            int quality = videoQuality.getQualityMjpeg();
            params.put("videoin_c0_s0_codectype", "mjpeg");
            params.put("videoin_c0_s0_resolution", this.mapResolution(capabilities, device.getParamValue("resolution_low")));
            params.put("videoin_c0_s0_mjpeg_maxframe", String.valueOf(fps));
            params.put("videoin_c0_s0_mjpeg_quant", String.valueOf(quality));
            params.put("videoin_c0_s1_codectype", "mjpeg");
            params.put("videoin_c0_s1_resolution", this.mapResolution(capabilities, device.getParamValue("resolution")));
            params.put("videoin_c0_s1_mjpeg_maxframe", String.valueOf(fps));
            params.put("videoin_c0_s1_mjpeg_quant", String.valueOf(quality));
        } else {
            String codecType = this.getAVCVideoCodec(device).toLowerCase();
            params.put("videoin_c0_s0_codectype", codecType);
            params.put("videoin_c0_s0_resolution", this.mapResolution(capabilities, device.getParamValue("resolution_low")));
            params.put("videoin_c0_s0_" + codecType + "_maxframe", String.valueOf(fps));
            params.put("videoin_c0_s0_" + codecType + "_intraperiod", "1000");
            params.put("videoin_c0_s0_" + codecType + "_ratecontrolmode", "cbr");
            params.put("videoin_c0_s0_" + codecType + "_bitrate", String.valueOf(videoQuality.getBitrateLow(videoEncoding)));
            params.put("videoin_c0_s1_codectype", codecType);
            params.put("videoin_c0_s1_resolution", this.mapResolution(capabilities, device.getParamValue("resolution")));
            params.put("videoin_c0_s1_" + codecType + "_maxframe", String.valueOf(fps));
            params.put("videoin_c0_s1_" + codecType + "_intraperiod", "1000");
            params.put("videoin_c0_s1_" + codecType + "_ratecontrolmode", "cbr");
            params.put("videoin_c0_s1_" + codecType + "_bitrate", String.valueOf(videoQuality.getBitrate(videoEncoding)));
        }
        if ("PT8133".equals(device.getModel())) {
            String flipValue = "ON".equals(device.getParamValue("video_orientation_flip")) ? "1" : "0";
            String mirrorValue = "ON".equals(device.getParamValue("video_orientation_mirror")) ? "1" : "0";
            params.put("videoin_c0_flip", flipValue);
            params.put("videoin_c0_mirror", mirrorValue);
        }
        String muteAudioValue = "OFF".equals(muteAudio = device.getParamValue("mute_audio")) ? "0" : "1";
        params.put("audioin_c0_mute", muteAudioValue);
        params.put("audioin_c0_gain", "25");
        params.put("audioin_c0_s0_codectype", "gamr");
        params.put("audioin_c0_s0_gamr_bitrate", "12200");
        String motionDetection = device.getParamValue("motion_detection");
        if (motionDetection != null) {
            MotionDetectionType motionDetectionType;
            String alarmPass;
            params.put("server_i0_name", "HOMEMONITOR");
            params.put("server_i0_type", "http");
            params.put("server_i0_http_url", String.valueOf(this.serverUrl) + "/events/motion/vivotek?id=" + device.getMac().replace(":", ""));
            String alarmUser = device.getParamValue("alarm_user");
            if (alarmUser != null) {
                params.put("server_i0_http_username", alarmUser);
            }
            if ((alarmPass = device.getParamValue("alarm_pass")) != null) {
                params.put("server_i0_http_passwd", alarmPass);
            }
            params.put("media_i0_name", "HOMEMONITOR");
            params.put("media_i0_type", "snapshot");
            params.put("media_i0_snapshot_source", "1");
            params.put("media_i0_snapshot_prefix", String.valueOf(device.getMac().replace(":", "")) + "_");
            params.put("media_i0_snapshot_datesuffix", "1");
            params.put("media_i0_snapshot_preevent", "0");
            params.put("media_i0_snapshot_postevent", "0");
            String mediaPrefix = String.valueOf(device.getMac().replace(":", "")) + "_";
            params.put("media_i0_name", "HOMEMONITOR");
            params.put("media_i0_type", "snapshot");
            params.put("media_i0_snapshot_source", "1");
            params.put("media_i0_snapshot_prefix", mediaPrefix);
            params.put("media_i0_snapshot_datesuffix", "1");
            params.put("media_i0_snapshot_preevent", "0");
            params.put("media_i0_snapshot_postevent", "0");
            boolean motionDetectionEnabled = motionDetection.equals("ON");
            params.put("event_i0_enable", motionDetectionEnabled ? "1" : "0");
            params.put("event_i0_priority", "1");
            String eventDelay = this.getEventDelay(device.getParamValue("alarm_limit"));
            params.put("event_i0_delay", eventDelay);
            params.put("event_i0_weekday", "127");
            params.put("event_i0_begintime", "00:00");
            params.put("event_i0_endtime", "24:00");
            params.put("event_i0_action_server_i0_enable", "1");
            params.put("event_i0_action_server_i0_media", "0");
            if (this.supportVideoClipRecording(device)) {
                params.put("media_i1_name", "HOMEMONITOR_VIDEOCLIP");
                params.put("media_i1_type", "videoclip");
                params.put("media_i1_videoclip_source", "1");
                params.put("media_i1_videoclip_preevent", "3");
                params.put("media_i1_videoclip_maxduration", device.getParamValue("videoclip_duration"));
                params.put("media_i1_videoclip_maxsize", "800");
                params.put("media_i1_videoclip_prefix", mediaPrefix);
                params.put("event_i1_name", "HOMEMONITOR_VIDEOCLIP");
                boolean videoclipEnabled = device.getParamValue("alarm_video_clip").equals("ON");
                params.put("event_i1_enable", motionDetectionEnabled && videoclipEnabled ? "1" : "0");
                params.put("event_i1_priority", "1");
                params.put("event_i1_delay", eventDelay);
                params.put("event_i1_inter", "1");
                params.put("event_i1_weekday", "127");
                params.put("event_i1_begintime", "00:00");
                params.put("event_i1_endtime", "24:00");
                params.put("event_i1_action_server_i0_enable", "1");
                params.put("event_i1_action_server_i0_media", "1");
            }
            if ((motionDetectionType = this.getMotionDetectionType(capabilities)) == MotionDetectionType.PIR) {
                params.put("event_i0_name", "HOMEMONITOR_PIR");
                params.put("event_i0_trigger", "di");
                params.put("event_i0_di", "2");
                if (this.supportVideoClipRecording(device)) {
                    params.put("event_i1_trigger", "di");
                    params.put("event_i1_di", "2");
                }
            } else {
                params.put("event_i0_name", "HOMEMONITOR_MD");
                params.put("event_i0_trigger", "motion");
                params.put("event_i0_mdwin", "1");
                if (this.supportVideoClipRecording(device)) {
                    params.put("event_i1_trigger", "motion");
                    params.put("event_i1_mdwin", "1");
                }
                params.put("motion_c0_enable", "1");
                params.put("motion_c0_win_i0_enable", "1");
                params.put("motion_c0_win_i0_name", "HOMEMONITOR");
                params.put("motion_c0_win_i0_left", "0");
                params.put("motion_c0_win_i0_top", "0");
                params.put("motion_c0_win_i0_width", "320");
                params.put("motion_c0_win_i0_height", "240");
                params.put("motion_c0_win_i0_objsize", "20");
                params.put("motion_c0_win_i0_sensitivity", "80");
            }
        }
        if (configureWifi && this.isWifiSupported(capabilities)) {
            if (this.isWifiEnabled(device)) {
                params.put("wireless_ssid", device.getParamValue("wifi_ssid"));
                String wlanMode = device.getParamValue("wifi_wlan_mode");
                params.put("wireless_wlmode", wlanMode.equals("INFRASTRUCTURE") ? "Infra" : "Adhoc");
                params.put("wireless_channel", device.getParamValue("wifi_channel"));
                params.put("wireless_txrate", "0");
                String encryption = device.getParamValue("wifi_encryption");
                params.put("wireless_encrypt", this.mapWifiEncryptionType(encryption));
                if (!"OPEN".equals(encryption)) {
                    if ("WEP".equals(encryption)) {
                        params.put("wireless_authmode", "OPEN");
                        String keyength = device.getParamValue("wifi_wep_key_length");
                        params.put("wireless_keylength", "LENGTH_128_BITS".equals(keyength) ? "128" : "64");
                        params.put("wireless_keyformat", device.getParamValue("wifi_wep_key_format"));
                        params.put("wireless_keyselect", device.getParamValue("wifi_wep_default_key"));
                        params.put("wireless_key1", device.getParamValue("wifi_wep_key1"));
                        params.put("wireless_key2", device.getParamValue("wifi_wep_key2"));
                        params.put("wireless_key3", device.getParamValue("wifi_wep_key3"));
                        params.put("wireless_key4", device.getParamValue("wifi_wep_key4"));
                    } else {
                        String algorithm = device.getParamValue("wifi_alghoritm");
                        params.put("wireless_algorithm", this.mapWifiAlgorithm(algorithm));
                        params.put("wireless_presharedkey", device.getParamValue("wifi_pre_shared_key"));
                    }
                }
            } else {
                params.put("wireless_ssid", "default");
                params.put("wireless_wlmode", "Infra");
                params.put("wireless_channel", "6");
                params.put("wireless_encrypt", "0");
                params.put("wireless_txrate", "0");
            }
        }
        return params;
    }

    private Integer getPtzEnabled(Map<String, String> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return null;
        }
        String ptzEnabled = capabilities.get("capability_ptzenabled");
        if (ptzEnabled == null || ptzEnabled.trim().isEmpty()) {
            return null;
        }
        return Integer.parseInt(ptzEnabled);
    }

    private boolean isPtzSupported(Map<String, String> capabilities) {
        Integer ptzEnabled = this.getPtzEnabled(capabilities);
        if (ptzEnabled == null) {
            return false;
        }
        return (ptzEnabled & 1) == 1;
    }

    private boolean isPanSupported(Map<String, String> capabilities) {
        Integer ptzEnabled = this.getPtzEnabled(capabilities);
        if (ptzEnabled == null) {
            return false;
        }
        return (ptzEnabled & 5) == 5;
    }

    private boolean isTiltSupported(Map<String, String> capabilities) {
        Integer ptzEnabled = this.getPtzEnabled(capabilities);
        if (ptzEnabled == null) {
            return false;
        }
        return (ptzEnabled & 9) == 9;
    }

    private boolean isZoomSupported(Map<String, String> capabilities) {
        Integer ptzEnabled = this.getPtzEnabled(capabilities);
        if (ptzEnabled == null) {
            return false;
        }
        return (ptzEnabled & 0x11) == 17;
    }

    private boolean isPirSupported(Map<String, String> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return false;
        }
        String npir = capabilities.get("capability_npir");
        if (npir == null) {
            return "TC5633".equals(capabilities.get("system_info_modelname"));
        }
        return npir.trim().isEmpty() ? false : Integer.parseInt(npir.trim()) > 0;
    }

    private boolean isWifiSupported(Map<String, String> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return false;
        }
        String networkWireless = capabilities.get("capability_network_wireless");
        if (networkWireless == null || networkWireless.trim().isEmpty()) {
            return false;
        }
        return networkWireless.equals("1");
    }

    private String getEventDelay(String alarmLimit) {
        if ("0".equals(alarmLimit)) {
            return "1";
        }
        if ("5".equals(alarmLimit)) {
            return "720";
        }
        if ("10".equals(alarmLimit)) {
            return "360";
        }
        if ("15".equals(alarmLimit)) {
            return "240";
        }
        if ("30".equals(alarmLimit)) {
            return "120";
        }
        if ("60".equals(alarmLimit)) {
            return "60";
        }
        return "";
    }

    private String mapWifiEncryptionType(String encryption) {
        if ("OPEN".equals(encryption)) {
            return "0";
        }
        if ("WEP".equals(encryption)) {
            return "1";
        }
        if ("WPA".equals(encryption)) {
            return "2";
        }
        if ("WPA2".equals(encryption)) {
            return "3";
        }
        return "";
    }

    private String mapWifiAlgorithm(String algorithm) {
        if ("TKIP".equals(algorithm)) {
            return "TKIP";
        }
        if ("AES_CCMP".equals(algorithm)) {
            return "AES";
        }
        return "";
    }

    public ControlParams getControlParams() {
        ControlParams controlParams = new ControlParams();
        controlParams.setPanLeft("/cgi-bin/viewer/camctrl.cgi?move=left");
        controlParams.setPanRight("/cgi-bin/viewer/camctrl.cgi?move=right");
        controlParams.setPanUp("/cgi-bin/viewer/camctrl.cgi?move=up");
        controlParams.setPanDown("/cgi-bin/viewer/camctrl.cgi?move=down");
        controlParams.setPanCenter("/cgi-bin/viewer/camctrl.cgi?move=home");
        controlParams.setZoomIn("/cgi-bin/viewer/camctrl.cgi?zoom=tele");
        controlParams.setZoomOut("/cgi-bin/viewer/camctrl.cgi?zoom=wide");
        return controlParams;
    }

    public void updateSettings(LanDeviceEntity device) {
        log.debug((Object)("start updateSettings(device=" + device + ")"));
        this.cameraVivotekSettings.update(device, false);
    }

    public Set<String> getSupportedSettings() {
        CameraVivotekSettings cameraVivotekSettings = new CameraVivotekSettings();
        return cameraVivotekSettings.getCameraSettings().keySet();
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        String url = String.valueOf(this.cameraBaseUrl(device)) + "/cgi-bin/viewer/video.jpg?resolution=" + resolution;
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), url, HttpCommand.SendMethod.GET);
        return response == null ? null : response.getBody();
    }

    public List<WlanAccessPoint> parseWirelessNetworks(String wifiData) {
        String[] rows;
        if (wifiData == null || wifiData.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<WlanAccessPoint> result = new ArrayList<WlanAccessPoint>();
        String[] stringArray = rows = wifiData.split("\n");
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            if (row.trim().length() != 0) {
                result.add(this.parseWirelessNetwork(row));
            }
            ++n2;
        }
        return result;
    }

    private WirelessRawParameters parseWirelessParameters(String parameters) {
        if (parameters == null || parameters.length() != 68) {
            return null;
        }
        WirelessRawParameters rawParams = new WirelessRawParameters(this, null);
        rawParams.ordinalNumber = parameters.substring(0, 2);
        rawParams.wlanMode = parameters.substring(3, 5);
        rawParams.ssid = parameters.substring(6, 38);
        rawParams.ssidLength = parameters.substring(39, 41);
        rawParams.bssid = parameters.substring(42, 59);
        rawParams.channel = parameters.substring(60, 62);
        rawParams.encryptionMode = parameters.substring(63, 65);
        rawParams.signalStrength = parameters.substring(66, 68);
        return rawParams;
    }

    private WlanAccessPoint parseWirelessNetwork(String text) {
        WlanAccessPoint wirelessNetwork = new WlanAccessPoint();
        WirelessRawParameters params = this.parseWirelessParameters(text);
        wirelessNetwork.setWlanMode(this.processWlanMode(params.wlanMode));
        wirelessNetwork.setSsid(this.processSsid(params.ssid, params.ssidLength));
        wirelessNetwork.setBssid(params.bssid);
        wirelessNetwork.setChannel(Integer.valueOf(Integer.parseInt(params.channel)));
        wirelessNetwork.setEncryptionModes(this.parseEncryptionMode(params.encryptionMode));
        wirelessNetwork.setSignalStrength(Integer.valueOf(Integer.parseInt(params.signalStrength)));
        return wirelessNetwork;
    }

    private WlanAccessPoint.WlanMode processWlanMode(String wlanMode) {
        return wlanMode.equals("00") ? WlanAccessPoint.WlanMode.INFRASTRUCTURE : WlanAccessPoint.WlanMode.AD_HOC;
    }

    private String processSsid(String ssid, String ssidLength) {
        if (ssid == null || ssid.trim().length() == 0) {
            return null;
        }
        if (ssidLength == null || ssidLength.trim().length() == 0) {
            return null;
        }
        int len = Integer.parseInt(ssidLength);
        return ssid.substring(0, len);
    }

    private List<EncryptionMode> parseEncryptionMode(String encryptionMode) {
        if (encryptionMode == null || encryptionMode.length() != 2) {
            return Collections.emptyList();
        }
        ArrayList<EncryptionMode> modes = new ArrayList<EncryptionMode>();
        if (encryptionMode.equals("00")) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
            return modes;
        }
        if (encryptionMode.equals("44")) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP));
            return modes;
        }
        ArrayList<EncryptionMode.Encryption> encryptions = new ArrayList<EncryptionMode.Encryption>();
        int encryptionModeEncoded = encryptionMode.charAt(0) - 48;
        if ((encryptionModeEncoded & 2) == 2) {
            encryptions.add(EncryptionMode.Encryption.WPA2);
        }
        if ((encryptionModeEncoded & 1) == 1) {
            encryptions.add(EncryptionMode.Encryption.WPA);
        }
        ArrayList<EncryptionMode.Algorithm> algorithms = new ArrayList<EncryptionMode.Algorithm>();
        int encryptionAlgEncoded = encryptionMode.charAt(1) - 48;
        if ((encryptionAlgEncoded & 2) == 2) {
            algorithms.add(EncryptionMode.Algorithm.AES_CCMP);
        }
        if ((encryptionAlgEncoded & 1) == 1) {
            algorithms.add(EncryptionMode.Algorithm.TKIP);
        }
        if (encryptions.contains(EncryptionMode.Encryption.WPA)) {
            if (algorithms.contains(EncryptionMode.Algorithm.TKIP)) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
            }
            if (algorithms.contains(EncryptionMode.Algorithm.AES_CCMP)) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP));
            }
        }
        if (encryptions.contains(EncryptionMode.Encryption.WPA2)) {
            if (algorithms.contains(EncryptionMode.Algorithm.TKIP)) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.TKIP));
            }
            if (algorithms.contains(EncryptionMode.Algorithm.AES_CCMP)) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP));
            }
        }
        return modes;
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        return this.parseWirelessNetworks(this.searchWlanAccessPoints(device));
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        log.debug((Object)("start updateSingleSetting(device with lanDeviceId=" + device.getLanDeviceId() + ", paramName=" + paramName + ", paramValue=" + paramValue + ")"));
        UpdateSettingStatus updateSettingStatus = this.doUpdateSingleSetting(device, paramName, paramValue);
        if ("motion_detection".equals(paramName)) {
            LanDeviceParamEntity videoClipParam = device.getParam("alarm_video_clip");
            UpdateSettingStatus updateVideoClipSettingStatus = this.doUpdateSingleSetting(device, videoClipParam.getName(), videoClipParam.getValue());
            if (updateSettingStatus.equals((Object)updateVideoClipSettingStatus)) {
                return updateSettingStatus;
            }
            if (!updateSettingStatus.equals((Object)UpdateSettingStatus.SUCCESS) && updateVideoClipSettingStatus.equals((Object)UpdateSettingStatus.SUCCESS)) {
                return updateSettingStatus;
            }
            if (updateSettingStatus.equals((Object)UpdateSettingStatus.SUCCESS) && !updateVideoClipSettingStatus.equals((Object)UpdateSettingStatus.SUCCESS)) {
                return updateVideoClipSettingStatus;
            }
            return UpdateSettingStatus.ERROR;
        }
        return updateSettingStatus;
    }

    private UpdateSettingStatus doUpdateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        if (!this.cameraVivotekSettings.getCameraSettings().keySet().contains(paramName)) {
            log.debug((Object)("Device not supported setting with name " + paramName + "."));
            return UpdateSettingStatus.FAILED_PARAMUNSUPPORTED;
        }
        SettingParam settingParam = (SettingParam)this.cameraVivotekSettings.getCameraSettings().get(paramName);
        String request = null;
        if (settingParam.isSelfSendable()) {
            log.debug((Object)"Praparing request for self sendable parameter");
            request = this.cameraVivotekSettings.createDedicatedSendSettingsRequest(device, settingParam, paramValue);
        } else {
            log.debug((Object)"Praparing request for non self sendable parameter");
            request = this.cameraVivotekSettings.createSendSingleSettingRequest(device, paramName, paramValue);
        }
        log.debug((Object)("prepared request: " + request));
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.GET);
        boolean isCorrectResponse = false;
        isCorrectResponse = paramName.equals("video_quality") ? this.isCorrectResponse(response) : this.verifyChangedSetting(response, settingParam, settingParam.getCommand(), paramValue);
        if (isCorrectResponse) {
            LanDeviceParamEntity processingParam = device.getParam(paramName);
            if (processingParam == null) {
                return UpdateSettingStatus.FAILED_PARAMNOTFOUND;
            }
            if (this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), paramName, paramValue, paramValue)) {
                return UpdateSettingStatus.SUCCESS;
            }
            log.warn((Object)("Setting " + paramName + " has not been updated in database"));
            return UpdateSettingStatus.ERROR;
        }
        return this.prepareUpdateSettingStatus(response);
    }

    private boolean verifyChangedSetting(HTTPClientServiceResult response, SettingParam settingParam, String paramName, String paramValue) {
        if (!this.isCorrectResponse(response)) {
            return false;
        }
        if (settingParam.isSelfSendable()) {
            return response.getBodyAsText().equalsIgnoreCase("ok");
        }
        String[] updatedParams = response.getBodyAsText().split(" ");
        if (updatedParams == null || updatedParams.length == 0) {
            return false;
        }
        String[] stringArray = updatedParams;
        int n = updatedParams.length;
        int n2 = 0;
        while (n2 < n) {
            String updatedValue;
            String updatedParam = stringArray[n2];
            if (updatedParam.startsWith(paramName) && settingParam.mapValue(updatedValue = updatedParam.substring(updatedParam.indexOf("=") + 1).trim()).equals(paramValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private UpdateSettingStatus prepareUpdateSettingStatus(HTTPClientServiceResult response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Boolean isPrivacyButtonSupport(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/privacybutton.cgi", HttpCommand.SendMethod.GET);
        if (response == null) {
            return null;
        }
        return response.getStatusCode() == null || !response.getStatusCode().equals(404);
    }

    private HTTPClientServiceResult configurePrivacyButton(LanDeviceEntity device, boolean enable) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("enable", enable ? "1" : "0");
        return this.sendCommand(device, "/cgi-bin/admin/privacybutton.cgi", params, HttpCommand.SendMethod.GET);
    }

    private boolean restoreWifiSettings(LanDeviceEntity device, Map<String, String> deviceCapabilities) {
        String ssid = this.getWirelessSSID(deviceCapabilities);
        if (ssid == null) {
            log.warn((Object)("Not found ssid for device with mac=" + device.getMac() + "."));
            return false;
        }
        WlanAccessPoint.WlanMode wlanMode = this.getWlanMode(deviceCapabilities);
        if (wlanMode == null) {
            log.warn((Object)("Not found wlan mode for device with mac=" + device.getMac() + "."));
            return false;
        }
        Integer wifiChannel = this.getWirelessChannel(deviceCapabilities);
        if (wifiChannel == null) {
            log.warn((Object)("Not found channel for device with mac=" + device.getMac() + "."));
            return false;
        }
        EncryptionMode encryptionMode = this.getEncryptionMode(deviceCapabilities);
        if (encryptionMode.getEncryption() == null) {
            log.warn((Object)("Not found encryption for device with mac=" + device.getMac() + "."));
            return false;
        }
        String encryptionText = encryptionMode.getEncryption().toString();
        if (encryptionMode.getAlgorithm() == null) {
            log.warn((Object)("Not found algorithm for device with mac=" + device.getMac() + "."));
            return false;
        }
        String algorithmText = encryptionMode.getAlgorithm().name();
        if (ssid.equals("default") && encryptionMode.getEncryption() == EncryptionMode.Encryption.OPEN) {
            device.setParam("wifi_enabled", "OFF", "OFF");
            device.setParam("wifi_ssid", "", "");
            device.setParam("wifi_wlan_mode", "", "");
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", "", "");
            device.setParam("wifi_encryption", "", "");
            device.setParam("wifi_alghoritm", "", "");
            device.setParam("wifi_wep_auth_mode", "", "");
            device.setParam("wifi_wep_key_length", "", "");
            device.setParam("wifi_wep_key_format", "", "");
            device.setParam("wifi_wep_key1", "", "");
            device.setParam("wifi_wep_key2", "", "");
            device.setParam("wifi_wep_key3", "", "");
            device.setParam("wifi_wep_key4", "", "");
            device.setParam("wifi_wep_default_key", "", "");
            device.setParam("wifi_pre_shared_key", "", "");
        } else {
            device.setParam("wifi_enabled", "ON", "ON");
            device.setParam("wifi_ssid", ssid, ssid);
            device.setParam("wifi_wlan_mode", wlanMode.name(), wlanMode.name());
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", wifiChannel.toString(), wifiChannel.toString());
            device.setParam("wifi_encryption", encryptionText, encryptionText);
            device.setParam("wifi_alghoritm", algorithmText, algorithmText);
            if (encryptionMode.getEncryption() == EncryptionMode.Encryption.OPEN) {
                device.setParam("wifi_wep_auth_mode", "", "");
                device.setParam("wifi_wep_key_length", "", "");
                device.setParam("wifi_wep_key_format", "", "");
                device.setParam("wifi_wep_key1", "", "");
                device.setParam("wifi_wep_key2", "", "");
                device.setParam("wifi_wep_key3", "", "");
                device.setParam("wifi_wep_key4", "", "");
                device.setParam("wifi_wep_default_key", "", "");
                device.setParam("wifi_pre_shared_key", "", "");
            } else if (encryptionMode.getEncryption() == EncryptionMode.Encryption.WEP) {
                WepAuthenticationType authType = this.extractWepAuthenticationType(deviceCapabilities);
                if (authType == null) {
                    log.warn((Object)("Not found wep autentication type for device with mac=" + device.getMac() + "."));
                    return false;
                }
                device.setParam("wifi_wep_auth_mode", authType.name(), authType.name());
                WepKeyLength wepKeyLength = this.extractWepKeyLength(deviceCapabilities);
                if (wepKeyLength == null) {
                    log.warn((Object)("Not found wep key length for device with mac=" + device.getMac() + "."));
                    return false;
                }
                device.setParam("wifi_wep_key_length", wepKeyLength.name(), wepKeyLength.name());
                WepKeyFormat wepKeyFormat = this.extractWepKeyFormat(deviceCapabilities);
                if (wepKeyFormat == null) {
                    log.warn((Object)("Not found wep key format for device with mac=" + device.getMac() + "."));
                    return false;
                }
                device.setParam("wifi_wep_key_format", wepKeyFormat.name(), wepKeyFormat.name());
                String key1 = CameraVivotekSettings.unescape((String)deviceCapabilities.get("wireless_key1"));
                device.setParam("wifi_wep_key1", key1, key1);
                String key2 = CameraVivotekSettings.unescape((String)deviceCapabilities.get("wireless_key2"));
                device.setParam("wifi_wep_key2", key2, key2);
                String key3 = CameraVivotekSettings.unescape((String)deviceCapabilities.get("wireless_key3"));
                device.setParam("wifi_wep_key3", key3, key3);
                String key4 = CameraVivotekSettings.unescape((String)deviceCapabilities.get("wireless_key4"));
                device.setParam("wifi_wep_key4", key4, key4);
                String defaultKey = deviceCapabilities.get("wireless_keyselect");
                if (defaultKey == null) {
                    log.warn((Object)("Not found default wep key for device with mac=" + device.getMac() + "."));
                    return false;
                }
                device.setParam("wifi_wep_default_key", defaultKey, defaultKey);
                device.setParam("wifi_pre_shared_key", "", "");
            } else {
                device.setParam("wifi_wep_auth_mode", "", "");
                device.setParam("wifi_wep_key_length", "", "");
                device.setParam("wifi_wep_key_format", "", "");
                device.setParam("wifi_wep_key1", "", "");
                device.setParam("wifi_wep_key2", "", "");
                device.setParam("wifi_wep_key3", "", "");
                device.setParam("wifi_wep_key4", "", "");
                device.setParam("wifi_wep_default_key", "", "");
                String password = CameraVivotekSettings.unescape((String)deviceCapabilities.get("wireless_presharedkey"));
                device.setParam("wifi_pre_shared_key", password, password);
            }
        }
        return true;
    }

    private WlanAccessPoint.WlanMode getWlanMode(Map<String, String> deviceCapabilities) {
        String wlanMode = deviceCapabilities.get("wireless_wlmode");
        if (wlanMode == null || wlanMode.trim().length() == 0) {
            return null;
        }
        if (wlanMode.equals("Infra")) {
            return WlanAccessPoint.WlanMode.INFRASTRUCTURE;
        }
        if (wlanMode.equals("Adhoc")) {
            return WlanAccessPoint.WlanMode.AD_HOC;
        }
        return null;
    }

    private String getWirelessSSID(Map<String, String> deviceCapabilities) {
        return deviceCapabilities.get("wireless_ssid");
    }

    private Integer getWirelessChannel(Map<String, String> deviceCapabilities) {
        String channel = deviceCapabilities.get("wireless_channel");
        if (channel == null || channel.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(channel);
    }

    private EncryptionMode getEncryptionMode(Map<String, String> deviceCapabilities) {
        EncryptionMode.Encryption encryption = this.getEncryption(deviceCapabilities);
        if (encryption == null) {
            return null;
        }
        if (encryption == EncryptionMode.Encryption.OPEN) {
            return new EncryptionMode(encryption, EncryptionMode.Algorithm.NONE);
        }
        if (encryption == EncryptionMode.Encryption.WEP) {
            return new EncryptionMode(encryption, EncryptionMode.Algorithm.WEP);
        }
        return new EncryptionMode(encryption, this.getAlgorithm(deviceCapabilities));
    }

    private EncryptionMode.Encryption getEncryption(Map<String, String> deviceCapabilities) {
        String encryption = deviceCapabilities.get("wireless_encrypt");
        if (encryption == null) {
            return null;
        }
        if (encryption.equals("0")) {
            return EncryptionMode.Encryption.OPEN;
        }
        if (encryption.equals("1")) {
            return EncryptionMode.Encryption.WEP;
        }
        if (encryption.equals("2")) {
            return EncryptionMode.Encryption.WPA;
        }
        if (encryption.equals("3")) {
            return EncryptionMode.Encryption.WPA2;
        }
        return null;
    }

    private EncryptionMode.Algorithm getAlgorithm(Map<String, String> deviceCapabilities) {
        String algorithm = deviceCapabilities.get("wireless_algorithm");
        if (algorithm == null) {
            return null;
        }
        if (algorithm.equals("AES")) {
            return EncryptionMode.Algorithm.AES_CCMP;
        }
        if (algorithm.equals("TKIP")) {
            return EncryptionMode.Algorithm.TKIP;
        }
        return null;
    }

    private WepAuthenticationType extractWepAuthenticationType(Map<String, String> deviceCapabilities) {
        String authmode = deviceCapabilities.get("wireless_authmode");
        if ("OPEN".equals(authmode)) {
            return WepAuthenticationType.OPEN;
        }
        if ("SHARED".equals(authmode)) {
            return WepAuthenticationType.SHARED;
        }
        log.warn((Object)("Unexpected wep authentication type: '" + authmode + "'."));
        return null;
    }

    private WepKeyLength extractWepKeyLength(Map<String, String> deviceCapabilities) {
        String wepKeyLength = deviceCapabilities.get("wireless_keylength");
        if ("64".equals(wepKeyLength)) {
            return WepKeyLength.LENGTH_64_BITS;
        }
        if ("128".equals(wepKeyLength)) {
            return WepKeyLength.LENGTH_128_BITS;
        }
        log.warn((Object)("Unexpected wep key length value: '" + wepKeyLength + "'."));
        return null;
    }

    private WepKeyFormat extractWepKeyFormat(Map<String, String> deviceCapabilities) {
        String keyFormat = deviceCapabilities.get("wireless_keyformat");
        if ("HEX".equals(keyFormat)) {
            return WepKeyFormat.HEX;
        }
        if ("ASCII".equals(keyFormat)) {
            return WepKeyFormat.ASCII;
        }
        log.warn((Object)("Unexpected wep key format value: '" + keyFormat + "'."));
        return null;
    }

    public String getConnCheckUrl() {
        return "/cgi-bin/admin/getparam.cgi?system_info_serialnumber";
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        String viewerUsername;
        if (device.getParam("video_quality") == null) {
            log.debug((Object)"Video quality param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        if ("PT8133".equals(device.getModel()) && !device.hasParam("has_video_orientation")) {
            log.debug((Object)"Video orientation param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) && (!device.getVideoEncoding().equals("MPEG4") || !device.hasParam("rtsp_port"))) {
            log.debug((Object)"RTSP port param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (!(this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) || !device.getVideoEncoding().equals("MPEG4"))) {
            log.debug((Object)"old GDClient configured with MPEG4");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (device.getVideoEncoding().equals("MJPEG") && "ON".equals(device.getParamValue("has_mute_audio"))) {
            log.debug((Object)"mute audio enabled for MJPEG - need to reconfigure to disable it");
            return CheckConfigurationStatus.INCORRECT;
        }
        if ((device.getVideoEncoding().equals("MPEG4") || device.getVideoEncoding().equals("H264")) && "OFF".equals(device.getParamValue("has_mute_audio"))) {
            log.debug((Object)("mute audio disabled for " + device.getVideoEncoding() + " - need to reconfigure to enable it"));
            return CheckConfigurationStatus.INCORRECT;
        }
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&media&camctrl&event&network&server&videoin&motion&audioin", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            if (response.getResult() == HTTPClientServiceResult.Result.NOACCESS) {
                return CheckConfigurationStatus.FAILED_NOACCESS;
            }
            if (response.getResult() == HTTPClientServiceResult.Result.NOANSWER) {
                return CheckConfigurationStatus.FAILED_NOANSWER;
            }
            return CheckConfigurationStatus.ERROR;
        }
        Map settings = this.parseResponse(response.getBodyAsText());
        int userIndex = this.extractUserIndex(settings, viewerUsername = device.getParamValue("viewer_user"));
        if (userIndex == -1) {
            log.debug((Object)("Not found viewer user on device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return CheckConfigurationStatus.INCORRECT;
        }
        Map expectedSettings = this.prepareConfigurationParameters(device, userIndex, true, false, settings);
        return this.verifySettings(settings, expectedSettings) ? CheckConfigurationStatus.CORRECT : CheckConfigurationStatus.INCORRECT;
    }

    private boolean isWifiEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("wifi_enabled"));
    }

    protected boolean verifySettings(Map<String, String> actualSettings, Map<String, String> expectedSettings) {
        for (Map.Entry<String, String> expectedSetting : expectedSettings.entrySet()) {
            if (this.verifySetting(actualSettings, expectedSetting.getKey(), expectedSetting.getValue())) continue;
            log.debug((Object)("Unexpected camera setting '" + expectedSetting.getKey() + "'. Expected value is '" + expectedSetting.getValue() + "' but was '" + actualSettings.get(expectedSetting.getKey()) + "'"));
            return false;
        }
        return true;
    }

    private boolean verifySetting(Map<String, String> settings, String settingName, String expectedSettingValue) {
        String settingValue = settings.get(settingName);
        return settingValue != null && settingValue.equals(expectedSettingValue);
    }

    public GenericLanDevice.ConfigurationStatus reconfigure(LanDeviceEntity device) {
        log.debug((Object)("start reconfigure(device wit lanDeviceId=" + device.getLanDeviceId() + "."));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/getparam.cgi?system&capability&security&wireless&motion", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            log.warn((Object)("Failed to download capabilities for device with lanDeviceId=" + device.getLanDeviceId() + ": " + response.getResult() + "."));
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        Map deviceCapabilities = this.parseResponse(response.getBodyAsText());
        this.storeDeviceCapabilities(device.getGatewayClient().getMac(), deviceCapabilities);
        return this.init(device, device.getPass(), true);
    }

    public String getVersion(LanDeviceEntity device) {
        log.debug((Object)("start getVersion(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/getparam.cgi?system", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            log.warn((Object)("Failed to download firmware version for device with lanDeviceId=" + device.getLanDeviceId() + ": " + response.getResult()));
            return null;
        }
        return (String)this.parseResponse(response.getBodyAsText()).get("system_info_firmwareversion");
    }

    public boolean upgradeFirmwareOld(LanDeviceEntity device) {
        byte[] body;
        HashMap<String, String> additionalRequestHeaders;
        block4: {
            log.debug((Object)("start upgradeFirmwareOld(landDevice with lanDeviceId=" + device.getLanDeviceId() + "."));
            try {
                additionalRequestHeaders = new HashMap<String, String>();
                String boundry = "--boundry1234";
                additionalRequestHeaders.put("Content-Type", "multipart/form-data; boundary=" + boundry);
                body = this.encodeMuptipart(device, boundry);
                if (body != null) break block4;
                log.warn((Object)"Failed to create firmware upgrade body.");
                return false;
            }
            catch (IOException e) {
                log.warn((Object)("Failed to upgrade firmware for device with lanDeviceId=" + device.getLanDeviceId() + ":" + e.getMessage()));
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return this.isFirmwareUpgrated(this.sendCommand(device, "/cgi-bin/admin/upgrade.cgi", additionalRequestHeaders, body, 900));
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        HttpResponse response;
        DefaultHttpClient httpclient;
        block8: {
            File firmware;
            HttpPost httppost;
            block7: {
                log.debug((Object)("start upgradeFirmware(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
                httpclient = new DefaultHttpClient();
                httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
                httppost = new HttpPost(this.getUpgradeFirmwareUrl("/cgi-bin/admin/upgrade.cgi"));
                httppost.addHeader("Cookie", this.getUpgradeFirmwareCookie(device));
                httppost.addHeader("Authorization", this.getAuthorizationHeader(device));
                firmware = this.systemSupport.getFile(String.valueOf(this.firmwares) + "/" + device.getDeviceDesc().getFirmwareFile());
                if (this.isFileReadable(firmware)) break block7;
                log.warn((Object)("Can not read firmware file for device with lanDeviceId=" + device.getLanDeviceId() + "."));
                return false;
            }
            MultipartEntity multipart = new MultipartEntity();
            FileBody fileBody = new FileBody(firmware, "application/octet-stream");
            multipart.addPart("fimage", (ContentBody)fileBody);
            httppost.setEntity((HttpEntity)multipart);
            response = httpclient.execute((HttpUriRequest)httppost);
            if (response.getEntity() != null) break block8;
            log.warn((Object)("Missing entity in upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        try {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            log.debug((Object)("Upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + ": " + responseBuffer.toString()));
            if (!this.isCompleteFirmwareUpgradeResponse(responseBuffer.toString())) {
                int tryCount = 0;
                while (tryCount < 5) {
                    log.debug((Object)("Waiting for full response. Try " + ++tryCount));
                    Thread.sleep(1000L);
                    responseBuffer.append(EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (this.isCompleteFirmwareUpgradeResponse(responseBuffer.toString())) break;
                }
            }
            log.debug((Object)("Full upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + ": " + responseBuffer.toString()));
            httpclient.getConnectionManager().shutdown();
            return this.isFirmwareUpgraded(responseBuffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)("Failed to upgrade firmware for device with lanDeviceId=" + device.getLanDeviceId() + ": " + e.getMessage() + "."));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private HTTPClientServiceResult sendCommand(LanDeviceEntity device, String cmd, Map<String, String> additionalRequestHeaders, byte[] body, int timeout) {
        String request = this.createBaseRequest(device.getIpAddress(), device.getPort(), device.getUsername(), device.getPass(), cmd);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, additionalRequestHeaders, body, timeout);
    }

    private byte[] encodeMuptipart(LanDeviceEntity device, String boundry) throws IOException {
        BodyPart firmwareBody = new BodyPart();
        firmwareBody.setContentType("application/octet-stream");
        firmwareBody.setContentDisposition("form-data", "fimage", this.extractFirmwareFilename(device));
        byte[] firmware = this.systemSupport.readFile(String.valueOf(this.firmwares) + "/" + device.getDeviceDesc().getFirmwareFile());
        if (firmware == null) {
            return null;
        }
        firmwareBody.setBody(firmware);
        Multipart multipart = new Multipart(boundry);
        multipart.addPart(firmwareBody);
        return multipart.getBytes();
    }

    private String extractFirmwareFilename(LanDeviceEntity device) {
        String filename = device.getDeviceDesc().getFirmwareFile();
        if (filename == null) {
            return null;
        }
        int lastSlashPos = filename.lastIndexOf("/");
        return lastSlashPos == -1 ? filename : filename.substring(lastSlashPos + 1);
    }

    private boolean isFirmwareUpgrated(HTTPClientServiceResult response) {
        if (response == null) {
            log.debug((Object)"Firmware upgrade response is empty.");
            return false;
        }
        if (response.getBodyAsText().isEmpty()) {
            log.debug((Object)"Firmware upgrade message is empty.");
            return false;
        }
        String[] keyElements = new String[]{"Update system image success", "Write new image complete", "Update armboot env success", "Reboot system now !!", "This connection will close"};
        String bodyText = response.getBodyAsText();
        String[] stringArray = keyElements;
        int n = keyElements.length;
        int n2 = 0;
        while (n2 < n) {
            String keyElement = stringArray[n2];
            if (!bodyText.contains(keyElement)) {
                log.debug((Object)("Firmware upgrade message does not key element '" + keyElement + "'."));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        ExecCmdService execCmdService = this.serviceFactory.getExecCmdService();
        CommandResult cmdResult = null;
        cmdResult = Utils.isAtMinimalVersion((String)device.getGatewayClient().getVersion(), (String)this.getUsesScriptsDirectoryMinimalVersion()) ? execCmdService.executeCommand(device.getGatewayClient().getSerialNumber(), "scanwlan-rssi.sh") : execCmdService.executeCommand(device.getGatewayClient().getSerialNumber(), "iwpriv wlan0 stat");
        if (cmdResult == null) {
            return null;
        }
        if (cmdResult.getOutput() == null) {
            log.info((Object)("checkRSSI timeout: device mac: " + device.getMac() + " gd mac: " + device.getGatewayClient().getSerialNumber()));
            return -1;
        }
        if (cmdResult.getOutput().trim().equals("")) {
            return -1;
        }
        String rssi = this.extractRssi(cmdResult.getOutput());
        return this.mapRssi(rssi);
    }

    private String extractRssi(String text) {
        String[] rows;
        if (text == null || text.isEmpty()) {
            return null;
        }
        String[] stringArray = rows = text.split("\n");
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            if (row.startsWith("RSSI-A")) {
                int equalSignPos = row.indexOf("=");
                if (equalSignPos == -1) {
                    return null;
                }
                return row.substring(equalSignPos + 2).trim();
            }
            ++n2;
        }
        return null;
    }

    private Integer mapRssi(String rawRssiText) {
        if (rawRssiText == null || rawRssiText.trim().isEmpty()) {
            return null;
        }
        Integer rawRssi = Integer.parseInt(rawRssiText);
        if (rawRssi > -25) {
            return 100;
        }
        if (rawRssi < -78) {
            return 10;
        }
        return (Integer)rssiConversion.get(rawRssi);
    }

    String getResolution(Map<String, String> capabilities, String desiredResolution) {
        if (capabilities == null) {
            return null;
        }
        return this.getResolution(capabilities.get("capability_videoin_resolution"), desiredResolution);
    }

    String getResolution(String supportedResolutions, String desiredResolution) {
        if (supportedResolutions == null || supportedResolutions.trim().isEmpty()) {
            return null;
        }
        if (supportedResolutions.contains(desiredResolution)) {
            return desiredResolution;
        }
        String[] resolutions = supportedResolutions.split(",");
        if (resolutions == null || resolutions.length == 0) {
            return null;
        }
        HashMap<String, String> supportedFormats = new HashMap<String, String>();
        if (supportedResolutions.toUpperCase().contains("CIF")) {
            int i = 0;
            while (i < resolutions.length) {
                String format = resolutions[i].trim();
                resolutions[i] = (String)videoFormat.get(resolutions[i].toUpperCase().trim());
                supportedFormats.put(resolutions[i], format);
                ++i;
            }
        }
        Resolution chosenResolution = null;
        String[] stringArray = resolutions;
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            String resolution = stringArray[n2];
            chosenResolution = chosenResolution == null ? new Resolution(resolution) : this.getClosestResolution(new Resolution(desiredResolution), chosenResolution, new Resolution(resolution));
            ++n2;
        }
        return chosenResolution.getWidth() + "x" + chosenResolution.getHeight();
    }

    private String mapResolution(Map<String, String> capabilities, String resolution) {
        String supportedResolutions = capabilities.get("capability_videoin_resolution");
        if (supportedResolutions.toUpperCase().contains("CIF")) {
            HashMap<String, String> supportedFormats = new HashMap<String, String>();
            String[] resolutions = supportedResolutions.split(",");
            int i = 0;
            while (i < resolutions.length) {
                String format = resolutions[i].trim();
                resolutions[i] = (String)videoFormat.get(resolutions[i].toUpperCase().trim());
                supportedFormats.put(resolutions[i], format);
                ++i;
            }
            return (String)supportedFormats.get(resolution);
        }
        return resolution;
    }

    private Resolution getClosestResolution(Resolution desiredResolution, Resolution resolution1, Resolution resolution2) {
        return Math.abs(resolution1.getWidth() - desiredResolution.getWidth()) < Math.abs(resolution2.getWidth() - desiredResolution.getWidth()) ? resolution1 : resolution2;
    }

    private boolean isSystemLedOffSupported(Map<String, String> capabilities) {
        return capabilities.containsKey("system_ledoff");
    }

    private boolean isMuteAudioSupported(LanDeviceEntity device) {
        return device.getVideoEncoding().equals("H264") || device.getVideoEncoding().equals("MPEG4");
    }

    private MotionDetectionType getMotionDetectionType(Map<String, String> capabilities) {
        if (this.isPirSupported(capabilities)) {
            return MotionDetectionType.PIR;
        }
        if (this.isMotionDetectionSupported(capabilities)) {
            return MotionDetectionType.MD;
        }
        return null;
    }

    private boolean isCompleteFirmwareUpgradeResponse(String response) throws ParseException, IOException {
        if (response == null) {
            log.debug((Object)"Empty http response.");
            return false;
        }
        return response.contains("This connection will close");
    }

    private boolean isFirmwareUpgraded(String text) {
        String[] keyElements;
        if (text == null || text.isEmpty()) {
            log.debug((Object)"Firmware upgrade response is empty.");
            return false;
        }
        String[] stringArray = keyElements = new String[]{"Update system image success", "Write new image complete", "Update armboot env success", "Reboot system now !!", "This connection will close"};
        int n = keyElements.length;
        int n2 = 0;
        while (n2 < n) {
            String keyElement = stringArray[n2];
            if (!text.contains(keyElement)) {
                log.debug((Object)("Firmware upgrade message does not contain key element '" + keyElement + "'."));
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String getMaxVideoClipDuration(LanDeviceEntity device) {
        String url = String.valueOf(this.cameraBaseUrl(device)) + "/setup/media.html";
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), url, HttpCommand.SendMethod.GET);
        if (response.getResult() != HTTPClientServiceResult.Result.OK || response.getBodyAsText() == null) {
            return null;
        }
        String text = response.getBodyAsText();
        int startPos = text.indexOf("<input name=\"media_index_videoclip_maxduration\"");
        if (startPos == -1) {
            return null;
        }
        int endPos = text.indexOf("</dd>", startPos);
        if (endPos == -1) {
            return null;
        }
        int tildePos = (text = text.substring(startPos, endPos)).indexOf("~");
        if (tildePos == -1) {
            return null;
        }
        int closeBracketPos = text.indexOf("]", tildePos + 1);
        if (closeBracketPos == -1) {
            return null;
        }
        return text.substring(tildePos + 1, closeBracketPos);
    }

    private boolean supportVideoClipRecording(LanDeviceEntity device) {
        String hasVideoclipRecording = device.getParamValue("has_videoclip_recording");
        return hasVideoclipRecording != null && hasVideoclipRecording.equals("ON");
    }

    private boolean isMotionDetectionSupported(Map<String, String> capabilities) {
        return capabilities.containsKey("motion_c0_enable");
    }

    public static VideoQuality getVideoQuality(String value) {
        return CameraVivotekGeneric.getVideoQuality((String)value, (Map)videoQualities);
    }

    public LanDevice getLanDevice(GatewayDevice gatewayDevice, String lanDeviceMac) {
        LanDevice lanDevice = super.getLanDevice(gatewayDevice, lanDeviceMac);
        VivotekCameraDiscoveryService cameraDiscovery = this.serviceFactory.getVivotekCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayDevice.getMac());
        for (DiscoveredLanDevice device : devices) {
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            log.debug((Object)("Found Vivotek camera " + device.getIpAddress() + ":" + device.getPort()));
            lanDevice.setIpAddress(device.getIpAddress());
            lanDevice.setPort(Integer.valueOf(device.getPort()));
            break;
        }
        return lanDevice;
    }

    public String getIpAddress(String gatewayClientMac, String lanDeviceMac) {
        VivotekCameraDiscoveryService cameraDiscovery = this.serviceFactory.getVivotekCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayClientMac);
        for (DiscoveredLanDevice device : devices) {
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            log.debug((Object)("Found Vivotek camera " + device.getIpAddress() + ":" + device.getPort()));
            return device.getIpAddress();
        }
        return null;
    }

    public CameraDiscoveryService getCameraDiscoveryService() {
        return this.serviceFactory.getVivotekCameraDiscoveryService();
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        return this.isCorrectResponse(response);
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        Map capabilities = this.getDeviceCapabilities(device.getGatewayClient().getMac());
        String supportedEncoders = (String)capabilities.get("capability_videoin_codec");
        if (supportedEncoders != null && supportedEncoders.contains("h264")) {
            return "H264";
        }
        return "MPEG4";
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
        }
        int[] nArray = new int[HTTPClientServiceResult.Result.values().length];
        try {
            nArray[HTTPClientServiceResult.Result.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result = nArray;
        return nArray;
    }
}

