/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.nipca;

import codec.Base64;
import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.TrendNetCameraDiscoveryService;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CameraNipcaGeneric")
@Scope(value="prototype")
public class CameraNipcaGeneric
extends GenericCamera {
    static Map<VideoQualityLevel, VideoQuality> videoQualities = new /* Unavailable Anonymous Inner Class!! */;
    private static final String RESOLUTION = "640x400";
    private static final String RESOLUTION_LOW = "320x192";
    private static final String COMMON_INFO_PATH = "/common/info.cgi";
    private static final String STREAM_INFO_PATH = "/config/stream_info.cgi";
    private static final String PTZ_INFO_PATH = "/config/ptz_info.cgi";
    private static final String PTZ_STEP_INFO_PATH = "/config/ptz_step.cgi";
    private static final String NETWORK_INFO_PATH = "/config/network.cgi";
    private static final String MOTION_INFO_PATH = "/config/motion.cgi";
    private static final String LED_INFO_PATH = "/config/led.cgi";
    private static final String SNAPSHOT_PATH = "/image/jpeg.cgi";
    private static final String USER_MOD_PATH = "/config/user_mod.cgi";
    private static final String USERS_PATH = "/config/user_list.cgi";
    private static final String VERIFY_PATH = "/config/camera_info.cgi";
    private static final String VIDEO_CONFIG_PATH = "/config/video.cgi";
    private static final String RTSP_CONFIG_PATH = "/config/rtspurl.cgi";
    private static final String RECORDER_CONFIG_PATH = "/cgi/admin/recorder.cgi";
    private static final String WLAN_SIGNAL_PATH = "/config/wlansignal.cgi";
    private static final String SPEAKER_CONFIG_PATH = "/config/speaker.cgi";
    private static final String UPGRADE_FIRMWARE_CMD = "/config/firmwareupgrade.cgi";
    private static final String PAN_CENTER = "/config/ptz_home.cgi?act=go";
    private static final String PTZ_MOVE_REL = "/config/ptz_move_rel.cgi";
    private static final String LED_CMD = "/config/led.cgi";
    protected static final String DEFAULT_USER = "admin";
    protected static final String DEFAULT_PASSWORD = "admin";
    private static final String USERS_GROUP_NAME = "Users";
    private ContainerserverServiceFactory containerserverServiceFactory;
    private int profile;
    private int profileLow;
    private int pStep;
    private int tStep;
    private int zStep;

    public CameraNipcaGeneric() {
        this.user = "admin";
        this.pass = "admin";
        this.cameraProducer = "Trendnet";
        this.capabilitiesCommands = new String[]{"/config/user_list.cgi", "/common/info.cgi", "/config/stream_info.cgi", "/config/network.cgi", "/config/motion.cgi"};
        this.firmwareVersionParam = "version";
        this.modelParam = "model";
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        String viewerUsername;
        if (device.getParam("video_quality") == null) {
            this.log.debug((Object)"Video quality param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        HTTPClientServiceResult response = this.sendCommand(device, "/config/user_list.cgi", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            return this.prepareCheckConfigurationStatus(response);
        }
        Map users = this.parseResponse(response.getBodyAsText());
        if (!users.containsKey(viewerUsername = device.getParamValue("viewer_user"))) {
            this.log.debug((Object)("Not found viewer user on device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return CheckConfigurationStatus.INCORRECT;
        }
        return CheckConfigurationStatus.CORRECT;
    }

    protected GenericLanDevice.ConfigurationStatus configure1(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        GenericLanDevice.ConfigurationStatus status = this.configureVideoProfiles(device);
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            return status;
        }
        status = this.configureAudio(device);
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            return status;
        }
        if (!reconfiguration) {
            device.setParam("snapshot_path", "/image/jpeg.cgi");
            device.setParam("snapshot_path_low", "/image/jpeg.cgi");
            device.setParam("rtsp_port", (String)this.deviceCapabilities.get("rtspport"));
            device.setParam("rtsp_over_http_port", (String)this.deviceCapabilities.get("httpport"));
            this.configurePTZ(device);
            device.setParam("need_restart_after_network_changes", "OFF");
            device.setParam("privacy_button", "OFF", "OFF");
            device.setParam("illumination", "OFF", "OFF");
            device.setParam("audio_detection", "OFF", "OFF");
            device.setParam("audio_detection_sensitivity", "50", "50");
            device.setParam("record_video", "OFF", "OFF");
            device.setParam("video_recording_duration", "15", "15");
            device.setParam("event_led_light", "OFF", "OFF");
            if (this.deviceCapabilities.containsKey("wireless") && ((String)this.deviceCapabilities.get("wireless")).equals("yes")) {
                device.setParam("wifi_enabled", "ON", "ON");
            } else {
                device.setParam("wifi_enabled", "OFF", "OFF");
            }
            if (this.deviceCapabilities.containsKey("led") && ((String)this.deviceCapabilities.get("led")).equals("yes")) {
                device.setParam("system_ledoff", "ON", "ON");
            } else {
                device.setParam("system_ledoff", "OFF", "OFF");
            }
            if (this.deviceCapabilities.containsKey("enable") && ((String)this.deviceCapabilities.get("enable")).equals("yes")) {
                device.setParam("motion_detection", "ON", "ON");
            } else {
                device.setParam("motion_detection", "OFF", "OFF");
            }
            if (this.deviceCapabilities.containsKey("inputs") && this.deviceCapabilities.containsKey("outputs")) {
                int inputAlarmLimit = Integer.parseInt((String)this.deviceCapabilities.get("inputs"));
                int outputAlarmLimit = Integer.parseInt((String)this.deviceCapabilities.get("outputs"));
                String limit = String.valueOf(Math.min(inputAlarmLimit, outputAlarmLimit));
                device.setParam("alarm_limit", limit, limit);
            } else {
                device.setParam("alarm_limit", "0", "0");
            }
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        GenericLanDevice.ConfigurationStatus status = this.configureVideoProfiles(device);
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            return status;
        }
        status = this.configureAudio(device);
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            return status;
        }
        if (!reconfiguration) {
            device.setParam("snapshot_path", "/image/jpeg.cgi");
            device.setParam("snapshot_path_low", "/image/jpeg.cgi");
            device.setParam("rtsp_port", (String)this.deviceCapabilities.get("rtspport"));
            device.setParam("rtsp_over_http_port", (String)this.deviceCapabilities.get("httpport"));
            this.configurePTZ(device);
            this.configureLed(device);
            this.configureMotionDetection(device);
            this.configureAlarms(device);
            this.configureWifi(device);
            device.setParam("need_restart_after_network_changes", "OFF");
            device.setParam("privacy_button", "OFF", "OFF");
            device.setParam("illumination", "OFF", "OFF");
            device.setParam("record_video", "OFF", "OFF");
            device.setParam("video_recording_duration", "15", "15");
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    private GenericLanDevice.ConfigurationStatus configureVideoProfiles(LanDeviceEntity device) {
        int profileNum = Integer.parseInt((String)this.deviceCapabilities.get("vprofilenum"));
        int i = 1;
        GenericLanDevice.ConfigurationStatus status = GenericLanDevice.ConfigurationStatus.ERROR;
        while (i <= profileNum && status != GenericLanDevice.ConfigurationStatus.OK) {
            status = this.configureVideoProfile(device, i, false);
            if (status == GenericLanDevice.ConfigurationStatus.OK) {
                this.profile = i;
            }
            ++i;
        }
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            return status;
        }
        status = GenericLanDevice.ConfigurationStatus.ERROR;
        while (i <= profileNum && status != GenericLanDevice.ConfigurationStatus.OK) {
            status = this.configureVideoProfile(device, i, true);
            if (status == GenericLanDevice.ConfigurationStatus.OK) {
                this.profileLow = i;
            }
            ++i;
        }
        if (status != GenericLanDevice.ConfigurationStatus.OK) {
            this.profileLow = this.profile;
            device.setParam("path_low", device.getParamValue("path"));
            device.setParam("resolution_low", device.getParamValue("resolution"));
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    private GenericLanDevice.ConfigurationStatus configureVideoProfile(LanDeviceEntity device, int profileId, boolean isLow) {
        GenericLanDevice.ConfigurationStatus status = this.setVideoConfig(device, profileId, isLow);
        if (status == GenericLanDevice.ConfigurationStatus.OK) {
            String path;
            String string = path = this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) ? this.getRTSPPath(device, profileId) : this.getVideoPath(device, profileId);
            if (path != null) {
                if (isLow) {
                    device.setParam("path_low", path);
                    device.setParam("resolution_low", "320x192");
                    device.setParam("path_low_rtsp_over_http_get", path);
                    device.setParam("path_low_rtsp_over_http_post", path);
                } else {
                    device.setParam("path", path);
                    device.setParam("path_rtsp_over_http_get", path);
                    device.setParam("path_rtsp_over_http_post", path);
                    device.setParam("resolution", "640x400");
                }
            } else {
                status = GenericLanDevice.ConfigurationStatus.ERROR;
            }
        }
        return status;
    }

    private GenericLanDevice.ConfigurationStatus setVideoConfig(LanDeviceEntity device, int profileid, boolean isLow) {
        this.log.debug((Object)("start setVideoConfig(device=" + device + ", profileid=" + profileid + ")"));
        String resolution = isLow ? "320x192" : "640x400";
        HashMap<String, String> params = new HashMap<String, String>();
        VideoQuality videoQuality = CameraNipcaGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String codec = device.getVideoEncoding();
        params.put("profileid", String.valueOf(profileid));
        params.put("codec", codec);
        params.put("resolution", resolution);
        String bitrate = String.valueOf(isLow ? videoQuality.getBitrateLow(codec) : videoQuality.getBitrate(codec));
        params.put("bitrate", bitrate);
        if (codec.equals("MPEG4") || codec.equals("H264")) {
            params.put("framerate", String.valueOf(videoQuality.getFps(codec)));
        } else if (codec.equals("MJPEG")) {
            params.put("quality", String.valueOf(videoQuality.getQualityMjpeg()));
        }
        HTTPClientServiceResult response = this.sendCommand(device, "/config/video.cgi", params, HttpCommand.SendMethod.GET);
        this.log.debug((Object)("setVideoConfig response: " + response.toString()));
        return this.prepareConfigurationStatus(response);
    }

    private String getVideoPath(LanDeviceEntity device, int profileId) {
        return this.getCommandResult(device, "/config/stream_info.cgi", "vprofileurl" + profileId);
    }

    private String getRTSPPath(LanDeviceEntity device, int profileId) {
        return this.getCommandResult(device, "/config/rtspurl.cgi?profileid=" + profileId, "urlentry");
    }

    private GenericLanDevice.ConfigurationStatus configureAudio(LanDeviceEntity device) {
        device.setParam("audio_detection", "OFF", "OFF");
        device.setParam("audio_detection_sensitivity", "50", "50");
        return this.setSpeaker(device, false, 0);
    }

    private GenericLanDevice.ConfigurationStatus setSpeaker(LanDeviceEntity device, boolean enable, int volume) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("enable", enable ? "yes" : "no");
        params.put("volume", String.valueOf(volume));
        HTTPClientServiceResult response = this.sendCommand(device, "/config/speaker.cgi", params, HttpCommand.SendMethod.GET);
        this.log.debug((Object)("setSpeaker response: " + response.toString()));
        return this.prepareConfigurationStatus(response);
    }

    private void configurePTZ(LanDeviceEntity device) {
        device.setParam("has_home", "OFF");
        device.setParam("has_pan", "OFF");
        device.setParam("has_tilt", "OFF");
        device.setParam("has_zoom", "OFF");
        Map params = this.getCommandResult(device, "/config/ptz_info.cgi");
        if (params != null && !params.isEmpty() && ((String)params.get("customizedHome")).equals("yes")) {
            device.setParam("has_home", "ON");
        }
        if (this.deviceCapabilities.containsKey("ptz")) {
            if (((String)this.deviceCapabilities.get("ptz")).contains("P")) {
                device.setParam("has_pan", "ON");
            }
            if (((String)this.deviceCapabilities.get("ptz")).contains("T")) {
                device.setParam("has_tilt", "ON");
            }
            if (((String)this.deviceCapabilities.get("ptz")).contains("Z")) {
                device.setParam("has_zoom", "ON");
            }
            if ((params = this.getCommandResult(device, "/config/ptz_step.cgi")) != null && !params.isEmpty()) {
                this.pStep = Integer.parseInt((String)params.get("p"));
                this.tStep = Integer.parseInt((String)params.get("t"));
                this.zStep = Integer.parseInt((String)params.get("z"));
            }
        }
    }

    private void configureLed(LanDeviceEntity device) {
        device.setParam("event_led_light", "OFF", "OFF");
        if (this.deviceCapabilities.containsKey("led") && ((String)this.deviceCapabilities.get("led")).equals("yes")) {
            device.setParam("system_ledoff", "ON", "ON");
        } else {
            device.setParam("system_ledoff", "OFF", "OFF");
        }
    }

    private void configureMotionDetection(LanDeviceEntity device) {
        if (this.deviceCapabilities.containsKey("enable") && ((String)this.deviceCapabilities.get("enable")).equals("yes")) {
            device.setParam("motion_detection", "ON", "ON");
        } else {
            device.setParam("motion_detection", "OFF", "OFF");
        }
    }

    private void configureWifi(LanDeviceEntity device) {
        if (this.deviceCapabilities.containsKey("wireless") && ((String)this.deviceCapabilities.get("wireless")).equals("yes")) {
            device.setParam("wifi_enabled", "ON", "ON");
            device.setParam("need_restart_after_network_changes", "ON");
        } else {
            device.setParam("wifi_enabled", "OFF", "OFF");
            device.setParam("need_restart_after_network_changes", "OFF");
        }
    }

    private void configureAlarms(LanDeviceEntity device) {
        if (this.deviceCapabilities.containsKey("inputs") && this.deviceCapabilities.containsKey("outputs")) {
            int inputAlarmLimit = Integer.parseInt((String)this.deviceCapabilities.get("inputs"));
            int outputAlarmLimit = Integer.parseInt((String)this.deviceCapabilities.get("outputs"));
            String limit = String.valueOf(Math.min(inputAlarmLimit, outputAlarmLimit));
            device.setParam("alarm_limit", limit, limit);
        } else {
            device.setParam("alarm_limit", "0", "0");
        }
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        this.log.debug((Object)("start registerUser(device=" + device + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/config/user_mod.cgi", params, HttpCommand.SendMethod.GET);
        this.log.debug((Object)("registerUser response: " + response.toString()));
        if (!this.isCorrectResponse(response)) {
            return false;
        }
        Map responseParams = this.parseResponse(response.getBodyAsText());
        for (String key : params.keySet()) {
            if (responseParams.containsKey(key) && params.get(key).equals(responseParams.get(key))) continue;
            return false;
        }
        return true;
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        String name = device.getParamValue("viewer_user");
        params.put("name", name);
        params.put("password", Base64.encode((byte[])device.getParamValue("viewer_pass").getBytes()));
        params.put("group", "Users");
        return this.registerUser(device, params);
    }

    public String getIpAddress(String gatewayClientMac, String lanDeviceMac) {
        TrendNetCameraDiscoveryService cameraDiscovery = this.containerserverServiceFactory.getTrendNetCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayClientMac);
        for (DiscoveredLanDevice device : devices) {
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            return device.getIpAddress();
        }
        return null;
    }

    public LanDevice getLanDevice(GatewayDevice gatewayDevice, String lanDeviceMac) {
        LanDevice lanDevice = super.getLanDevice(gatewayDevice, lanDeviceMac);
        TrendNetCameraDiscoveryService cameraDiscovery = this.containerserverServiceFactory.getTrendNetCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayDevice.getMac());
        for (DiscoveredLanDevice device : devices) {
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            lanDevice.setIpAddress(device.getIpAddress());
            lanDevice.setPort(Integer.valueOf(device.getPort()));
            break;
        }
        return lanDevice;
    }

    @Autowired
    @Required
    public void setContainerserverServiceFactory(ContainerserverServiceFactory containerserverServiceFactory) {
        this.containerserverServiceFactory = containerserverServiceFactory;
    }

    public CameraDiscoveryService getCameraDiscoveryService() {
        return this.containerserverServiceFactory.getTrendNetCameraDiscoveryService();
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        return this.isCorrectResponse(response);
    }

    public ControlParams getControlParams() {
        ControlParams controlParams = new ControlParams();
        return controlParams;
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        String path = "/image/jpeg.cgi" + (resolution.equals("320x192") ? this.profileLow : this.profile);
        HTTPClientServiceResult response = this.sendCommand(device, path, HttpCommand.SendMethod.GET);
        return response == null ? null : response.getBody();
    }

    public void updateSettings(LanDeviceEntity device) {
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        return UpdateSettingStatus.FAILED_PARAMUNSUPPORTED;
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return this.checkStatus(device, "/config/camera_info.cgi");
    }

    public Set<String> getSupportedSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        return supportedSettings;
    }

    public String getMacAddress(LanDeviceEntity device) {
        return (String)this.deviceCapabilities.get("macaddr");
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        return null;
    }

    public String getVersion(LanDeviceEntity device) {
        return this.getCommandResult(device, "/common/info.cgi", "version");
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        return false;
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        return Integer.parseInt(this.getCommandResult(device, "/config/wlansignal.cgi", "signal"));
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        return AccessVerificationStatus.OK;
    }

    public String getConnCheckUrl() {
        return "/config/camera_info.cgi";
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        return false;
    }

    public boolean hasNativeRtspOverHttpSupport() {
        return false;
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        return "H264";
    }
}

