/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.multipart;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;
import pl.smartapps.containerserver.landevice.multipart.Multipart;

@RunWith(value=PowerMockRunner.class)
public class MultipartTests {
    @Test
    public void testGetBytesNoneParts() {
        Multipart multipart = new Multipart("123");
        Assert.assertEquals(null, (Object)multipart.getBytes());
    }

    @Test
    public void testGetBytesNullBoundry() {
        Multipart multipart = new Multipart(null);
        Assert.assertEquals(null, (Object)multipart.getBytes());
    }

    @Test
    public void testGetBytesEmptyBoundry() {
        Multipart multipart = new Multipart("");
        Assert.assertEquals(null, (Object)multipart.getBytes());
    }

    @Test
    public void test() {
        BodyPart part1 = new BodyPart();
        part1.setContentType("application/macbinary");
        part1.setContentDisposition("form-data", "file", "image.jpg");
        part1.setBody("image content".getBytes());
        BodyPart part2 = new BodyPart();
        part2.setContentDisposition("form-data", "send", null);
        Multipart multipart = new Multipart("--boundry1234");
        multipart.addPart(part1);
        multipart.addPart(part2);
        StringBuilder expected = new StringBuilder();
        expected.append("----boundry1234\r\n");
        expected.append("Content-Disposition: form-data; name=\"file\"; filename=\"image.jpg\"\r\n");
        expected.append("Content-Type: application/macbinary\r\n");
        expected.append("\r\n");
        expected.append("image content\r\n");
        expected.append("----boundry1234\r\n");
        expected.append("Content-Disposition: form-data; name=\"send\"");
        expected.append("\r\n");
        expected.append("\r\n\r\n");
        expected.append("----boundry1234--\r\n");
        Assert.assertEquals((Object)expected.toString(), (Object)new String(multipart.getBytes()));
    }
}

