/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.multipart;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;

public class Multipart {
    private static final String SEPARATOR = "\r\n";
    private static Logger log = Logger.getLogger(Multipart.class);
    private List<BodyPart> parts = new ArrayList();
    private String boundry;

    public Multipart(String boundry) {
        this.boundry = boundry;
    }

    public List<BodyPart> getParts() {
        return this.parts;
    }

    public void setParts(List<BodyPart> parts) {
        this.parts = parts;
    }

    public void addPart(BodyPart part) {
        this.parts.add(part);
    }

    public String getBoundry() {
        return this.boundry;
    }

    public void setBoundry(String boundry) {
        this.boundry = boundry;
    }

    public byte[] getBytes() {
        if (this.parts.isEmpty()) {
            log.debug((Object)"There is no body parts to build body");
            return null;
        }
        if (this.boundry == null || this.boundry.isEmpty()) {
            log.debug((Object)"Boundry can not be empty");
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean first = true;
        for (BodyPart part : this.parts) {
            log.debug((Object)("processing part: " + part));
            StringBuilder partHeaders = new StringBuilder();
            if (!first) {
                partHeaders.append(SEPARATOR);
            }
            first = false;
            partHeaders.append("--").append(this.boundry).append(SEPARATOR);
            for (Map.Entry header : part.getHeaders().entrySet()) {
                partHeaders.append((String)header.getKey()).append(": ").append((String)header.getValue()).append(SEPARATOR);
            }
            partHeaders.append(SEPARATOR);
            log.debug((Object)("prepared headers:\n" + partHeaders.toString()));
            byte[] hdr = partHeaders.toString().getBytes();
            outputStream.write(hdr, 0, hdr.length);
            if (part.getBody() == null) continue;
            outputStream.write(part.getBody(), 0, part.getBody().length);
        }
        String endBoundry = "\r\n--" + this.boundry + "--" + SEPARATOR;
        outputStream.write(endBoundry.getBytes(), 0, endBoundry.getBytes().length);
        return outputStream.toByteArray();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundry == null ? 0 : this.boundry.hashCode());
        result = 31 * result + (this.parts == null ? 0 : this.parts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Multipart other = (Multipart)obj;
        if (this.boundry == null ? other.boundry != null : !this.boundry.equals(other.boundry)) {
            return false;
        }
        return !(this.parts == null ? other.parts != null : !this.parts.equals(other.parts));
    }

    public String toString() {
        return "Multipart [parts=" + this.parts + ", boundry=" + this.boundry + "]";
    }
}

