/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.multipart;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;

@RunWith(value=PowerMockRunner.class)
public class BodyPartTests {
    @Test
    public void testEmptyBodyPart() {
        BodyPart part = new BodyPart();
        Assert.assertEquals(null, (Object)part.getBody());
        Assert.assertEquals(null, (Object)part.getContentDisposition());
        Assert.assertEquals(null, (Object)part.getContentType());
        Assert.assertTrue((boolean)part.getHeaders().isEmpty());
    }

    @Test
    public void testAddHeader() {
        BodyPart part = new BodyPart();
        String headerName = "headerName";
        String headerValue = "headerValue";
        Assert.assertTrue((boolean)part.getHeaders().isEmpty());
        Assert.assertEquals(null, (Object)part.getHeader(headerName));
        part.addHeader(headerName, headerValue);
        Assert.assertEquals((Object)headerValue, (Object)part.getHeader(headerName));
        Assert.assertEquals((long)1L, (long)part.getHeaders().size());
    }

    @Test
    public void testRemoveHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "value1");
        headers.put("header2", "value2");
        headers.put("header3", "value3");
        BodyPart part = new BodyPart();
        part.setHeaders(headers);
        Assert.assertEquals((long)3L, (long)part.getHeaders().size());
        Assert.assertEquals((Object)"value1", (Object)part.getHeader("header1"));
        Assert.assertEquals((Object)"value2", (Object)part.getHeader("header2"));
        Assert.assertEquals((Object)"value3", (Object)part.getHeader("header3"));
        part.removeHeader("header2");
        Assert.assertEquals((long)2L, (long)part.getHeaders().size());
        Assert.assertEquals((Object)"value1", (Object)part.getHeader("header1"));
        Assert.assertEquals(null, (Object)part.getHeader("header2"));
        Assert.assertEquals((Object)"value3", (Object)part.getHeader("header3"));
    }

    @Test
    public void testSetAndGetContentType() {
        BodyPart part = new BodyPart();
        Assert.assertEquals((long)0L, (long)part.getHeaders().size());
        Assert.assertEquals(null, (Object)part.getContentType());
        Assert.assertEquals(null, (Object)part.getHeader("Content-Type"));
        part.setContentType("plain/text");
        Assert.assertEquals((long)1L, (long)part.getHeaders().size());
        Assert.assertEquals((Object)"plain/text", (Object)part.getContentType());
        Assert.assertEquals((Object)"plain/text", (Object)part.getHeader("Content-Type"));
    }

    @Test
    public void testSetContentDispositionCase1() {
        BodyPart part = new BodyPart();
        Assert.assertEquals((long)0L, (long)part.getHeaders().size());
        Assert.assertEquals(null, (Object)part.getContentDisposition());
        Assert.assertEquals(null, (Object)part.getHeader("Content-Disposition"));
        part.setContentDisposition("form-data", "file", "image.jpg");
        Assert.assertEquals((long)1L, (long)part.getHeaders().size());
        String expectedContentDisposition = "form-data; name=\"file\"; filename=\"image.jpg\"";
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getContentDisposition());
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getHeader("Content-Disposition"));
    }

    @Test
    public void testSetContentDispositionCase2() {
        BodyPart part = new BodyPart();
        Assert.assertEquals((long)0L, (long)part.getHeaders().size());
        Assert.assertEquals(null, (Object)part.getContentDisposition());
        Assert.assertEquals(null, (Object)part.getHeader("Content-Disposition"));
        part.setContentDisposition("form-data", null, null);
        Assert.assertEquals((long)1L, (long)part.getHeaders().size());
        String expectedContentDisposition = "form-data";
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getContentDisposition());
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getHeader("Content-Disposition"));
    }

    @Test
    public void testSetContentDispositionCase3() {
        BodyPart part = new BodyPart();
        Assert.assertEquals((long)0L, (long)part.getHeaders().size());
        Assert.assertEquals(null, (Object)part.getContentDisposition());
        Assert.assertEquals(null, (Object)part.getHeader("Content-Disposition"));
        part.setContentDisposition("form-data", "file", null);
        Assert.assertEquals((long)1L, (long)part.getHeaders().size());
        String expectedContentDisposition = "form-data; name=\"file\"";
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getContentDisposition());
        Assert.assertEquals((Object)expectedContentDisposition, (Object)part.getHeader("Content-Disposition"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetContentDispositionCase4() {
        BodyPart part = new BodyPart();
        Assert.assertEquals((long)0L, (long)part.getHeaders().size());
        Assert.assertEquals(null, (Object)part.getContentDisposition());
        Assert.assertEquals(null, (Object)part.getHeader("Content-Disposition"));
        part.setContentDisposition(null, null, null);
    }
}

