/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.multipart;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BodyPart {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private Map<String, String> headers = new HashMap();
    private byte[] body;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void setContentType(String contentType) {
        this.addHeader(CONTENT_TYPE, contentType);
    }

    public String getContentType() {
        return this.getHeader(CONTENT_TYPE);
    }

    public void setContentDisposition(String contentDisposition, String name, String filename) {
        if (contentDisposition == null || contentDisposition.isEmpty()) {
            throw new IllegalArgumentException("ContentDisposition can not be empty");
        }
        StringBuilder content = new StringBuilder();
        content.append(contentDisposition);
        if (name != null) {
            content.append("; name=\"").append(name).append("\"");
        }
        if (filename != null) {
            content.append("; filename=\"").append(filename).append("\"");
        }
        this.addHeader(CONTENT_DISPOSITION, content.toString());
    }

    public String getContentDisposition() {
        return this.getHeader(CONTENT_DISPOSITION);
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BodyPart other = (BodyPart)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    public String toString() {
        return "BodyPart [headers=" + this.headers + ", body with length=" + (this.body == null ? "null" : Integer.valueOf(this.body.length)) + "]";
    }
}

