/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.edimax;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CameraEdimaxGeneric")
@Scope(value="prototype")
public class CameraEdimaxGeneric
extends GenericCamera {
    static Map<VideoQualityLevel, VideoQuality> videoQualities = new /* Unavailable Anonymous Inner Class!! */;
    private static final String SNAPSHOT_PATH = "/snapshot.jpg";
    private static final String UPDATE_CONFIG_PATH = "/form/enet";
    private static final String LIST_CONFIG_PATH = "/camera-cgi/admin/param.cgi";
    private static final String MODEL_NAME_PATH = "/camera-cgi/admin/param.cgi?action=list&group=Properties.Firmware";
    private static final String MAC_ADDRESS_PATH = "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress";
    private static final String CONN_CHECK_URL = "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress";
    private static final String MJPEG_STREAM_PATH = "mjpg/video.mjpg";
    private static final String H264_STREAM_PATH = "ipcam_h264.sdp";
    private static final String CONFIG_UPDATE_PATH = "/camera-cgi/admin/param.cgi";
    private static final String CONFIG_STREAM_TYPE_PATH = "/form/enet?enet_avs_default_dual_mode=";
    private static final String RESOLUTION = "640x480";
    private static final String RESOLUTION_LOW = "640x480";

    public CameraEdimaxGeneric() {
        this.user = "admin";
        this.pass = "1234";
        this.cameraProducer = "Edimax";
        this.capabilitiesCommands = new String[]{"/camera-cgi/admin/param.cgi?action=list&group=Properties.Firmware", "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress"};
        this.modelParam = "Properties.Firmware.ModelID";
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        HTTPClientServiceResult response = this.sendCommand(device, "/snapshot.jpg", HttpCommand.SendMethod.GET);
        return response == null ? null : response.getBody();
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        String viewerUsername = device.getParamValue("viewer_user");
        this.removeUser(device, viewerUsername);
        String viewerPassword = device.getParamValue("viewer_pass");
        HTTPClientServiceResult response = this.sendCommand(device, "/form/enet", HttpCommand.SendMethod.GET, new String[]{"umaction", "add", "user_login", viewerUsername, "user_passwd", viewerPassword, "confirm_user_passwd", viewerPassword, "user_authority", "1"});
        return response != null;
    }

    private void removeUser(LanDeviceEntity device, String username) {
        this.sendCommand(device, "/form/enet", HttpCommand.SendMethod.GET, new String[]{"user_oldname", username, "umaction", "remove"});
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        return this.registerUser(device, null);
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        if (!reconfiguration) {
            device.setParam("resolution", "640x480");
            device.setParam("snapshot_path", "/snapshot.jpg");
            device.setParam("resolution_low", "640x480");
            device.setParam("snapshot_path_low", "/snapshot.jpg");
        }
        if (!device.getVideoEncoding().equals("MJPEG")) {
            device.setParam("path", "ipcam_h264.sdp");
            device.setParam("path_low", "ipcam_h264.sdp");
            device.setParam("path_rtsp_over_http_get", "ipcam_h264.sdp");
            device.setParam("path_low_rtsp_over_http_get", "ipcam_h264.sdp");
            device.setParam("path_rtsp_over_http_post", "ipcam_h264.sdp");
            device.setParam("path_low_rtsp_over_http_post", "ipcam_h264.sdp");
            device.setParam("rtsp_port", "554");
            device.setParam("rtsp_over_http_port", "8088");
        } else {
            device.setParam("path", "mjpg/video.mjpg");
            device.setParam("path_low", "mjpg/video.mjpg");
        }
        if (!this.configureVideoProfiles(device)) {
            this.log.warn((Object)"cannot configure video profiles");
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    private boolean configureVideoProfiles(LanDeviceEntity device) {
        VideoQuality videoQuality = CameraEdimaxGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        return this.configureVideoProfile(device, "640x480", Integer.valueOf(videoQuality.getBitrate(videoEncoding)), Integer.valueOf(fps));
    }

    private boolean configureVideoProfile(LanDeviceEntity device, String resolution, Integer bitrateIndex, Integer fps) {
        String videoEncoding = device.getVideoEncoding();
        try {
            String videoStreamId = videoEncoding.equalsIgnoreCase("MJPEG") ? "0" : "2";
            this.uploadConfiguration(device, "/form/enet?enet_avs_default_dual_mode=" + videoStreamId);
            this.uploadConfiguration(device, "/camera-cgi/admin/param.cgi", new String[]{"action", "update", "Image.I" + videoStreamId + ".Appearance.Resolution", resolution});
            this.uploadConfiguration(device, "/camera-cgi/admin/param.cgi", new String[]{"action", "update", "Image.I" + videoStreamId + ".Stream.FPS", fps.toString()});
            this.uploadConfiguration(device, "/camera-cgi/admin/param.cgi", new String[]{"action", "update", "Image.I" + videoStreamId + ".Appearance.Compression", bitrateIndex.toString()});
            return true;
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"failed to upload video stream configuration");
            return false;
        }
    }

    private void uploadConfiguration(LanDeviceEntity device, String command) {
        HTTPClientServiceResult response = this.sendCommand(device, command, HttpCommand.SendMethod.GET);
        if (response == null || response.getStatusCode() != 200 && response.getStatusCode() != 302) {
            this.log.debug((Object)("cannot send command: " + command));
            throw new RuntimeException();
        }
    }

    private void uploadConfiguration(LanDeviceEntity device, String path, String ... arguments) {
        HTTPClientServiceResult response = this.sendCommand(device, path, HttpCommand.SendMethod.GET, arguments);
        if (response == null || response.getStatusCode() != 200) {
            this.log.debug((Object)("cannot send command to path: " + path));
            throw new RuntimeException();
        }
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        return response != null && response.getResult() == HTTPClientServiceResult.Result.OK;
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        return false;
    }

    public ControlParams getControlParams() {
        ControlParams controlParams = new ControlParams();
        return controlParams;
    }

    public void updateSettings(LanDeviceEntity device) {
        Set paramsToUpdate = this.getParamsToUpdate(device);
        if (this.hasSettingsToUpdate(paramsToUpdate, this.getSupportedVideoSettings()) && this.configureVideoProfiles(device)) {
            this.synchronizeSettings(device, this.getSupportedVideoSettings());
        }
    }

    private void synchronizeSettings(LanDeviceEntity device, Set<String> settings) {
        for (String setting : settings) {
            String value = device.getParamValue(setting);
            if (value == null) continue;
            this.synchronizeSetting(device, setting, value);
        }
    }

    private boolean hasSettingsToUpdate(Set<String> paramsToUpdate, Set<String> supportedSettings) {
        for (String paramToUpdate : paramsToUpdate) {
            for (String supportedSetting : supportedSettings) {
                if (!paramToUpdate.equals(supportedSetting)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getParamsToUpdate(LanDeviceEntity device) {
        if (device == null || device.getLanDeviceParams() == null || device.getLanDeviceParams().isEmpty()) {
            return Collections.emptySet();
        }
        Set supportedSettings = this.getSupportedSettings();
        HashSet<String> params = new HashSet<String>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!supportedSettings.contains(param.getName()) || param.getValue().equals(param.getRemoteValue())) continue;
            params.add(param.getName());
        }
        this.log.debug((Object)("params to update: " + params));
        return params;
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        if (!this.getSupportedSettings().contains(paramName)) {
            this.log.debug((Object)("trying to update unsupported parameter " + paramName));
            return UpdateSettingStatus.FAILED_PARAMUNSUPPORTED;
        }
        UpdateSettingStatus status = UpdateSettingStatus.SUCCESS;
        if (this.getSupportedVideoSettings().contains(paramName) && !this.configureVideoProfiles(device)) {
            status = UpdateSettingStatus.ERROR;
        }
        if (status == UpdateSettingStatus.SUCCESS) {
            if (!this.synchronizeSetting(device, paramName, paramValue)) {
                this.log.warn((Object)("Setting " + paramName + " has not been updated in database"));
                status = UpdateSettingStatus.ERROR;
            }
        } else {
            this.log.warn((Object)("error setting parameter " + paramName + " to value " + paramValue));
        }
        return status;
    }

    private boolean synchronizeSetting(LanDeviceEntity device, String paramName, String paramValue) {
        this.log.debug((Object)("synchronizing options for device " + device.getMac() + ": " + paramName + "=" + paramValue));
        return this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), paramName, paramValue, paramValue);
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return this.checkStatus(device, "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress");
    }

    public Set<String> getSupportedSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.addAll(this.getSupportedVideoSettings());
        return supportedSettings;
    }

    private Set<String> getSupportedVideoSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.add("video_quality");
        return supportedSettings;
    }

    public String getMacAddress(LanDeviceEntity device) {
        try {
            HTTPClientServiceResult response = this.sendCommand(device, "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress", HttpCommand.SendMethod.GET);
            return (String)this.parseResponse(response.getBodyAsText()).get("Network.Interface.I0.Active.MACAddress");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getConnCheckUrl() {
        return "/camera-cgi/admin/param.cgi?action=list&group=Network.Interface.I0.Active.MACAddress";
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        if (device.getParam("video_quality") == null) {
            this.log.debug((Object)"Video quality param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        try {
            this.checkVideoProfiles(device);
        }
        catch (RuntimeException e) {
            return CheckConfigurationStatus.INCORRECT;
        }
        return CheckConfigurationStatus.CORRECT;
    }

    private void checkVideoProfiles(LanDeviceEntity device) {
        VideoQuality videoQuality = CameraEdimaxGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        this.checkVideoProfile(device, "640x480", Integer.valueOf(fps), Integer.valueOf(videoQuality.getBitrate(videoEncoding)), videoEncoding);
    }

    private void checkVideoProfile(LanDeviceEntity device, String expectedResolution, Integer expectedFps, Integer expectedBitrate, String videoEncoding) {
        String parameterPrefix = "Image.I" + (videoEncoding.equalsIgnoreCase("MJPEG") ? "0" : "2") + ".";
        Map result = this.downloadConfiguration(device, String.valueOf(parameterPrefix) + "Stream");
        this.checkParamValue(result, String.valueOf(parameterPrefix) + "Stream.Fps", expectedFps.toString());
        result = this.downloadConfiguration(device, String.valueOf(parameterPrefix) + "Appearance");
        this.checkParamValue(result, String.valueOf(parameterPrefix) + "Appearance.Resolution", expectedResolution);
        this.checkParamValue(result, String.valueOf(parameterPrefix) + "Appearance.Compression", expectedBitrate.toString());
    }

    private void checkParamValue(Map<String, String> params, String key, String expectedValue) {
        String value = params.get(key);
        if (!expectedValue.equalsIgnoreCase(value)) {
            this.log.debug((Object)("configuration values mismatch: received " + value + ", expected " + expectedValue));
            throw new RuntimeException();
        }
    }

    private String downloadConfigurationText(LanDeviceEntity device, String group) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("action", "list");
        params.put("group", group);
        HTTPClientServiceResult response = this.sendCommand(device, "/camera-cgi/admin/param.cgi", params, HttpCommand.SendMethod.GET);
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"error getting configuration");
            throw new RuntimeException();
        }
        return response.getBodyAsText();
    }

    private Map<String, String> downloadConfiguration(LanDeviceEntity device, String group) {
        return this.parseResponse(this.downloadConfigurationText(device, group));
    }

    public String getVersion(LanDeviceEntity device) {
        try {
            Map params = this.downloadConfiguration(device, "Properties.Firmware");
            return (String)params.get("Properties.Firmware.Version");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        return false;
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        return null;
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        return response.getBodyAsText().length() == 0 ? AccessVerificationStatus.ERROR : AccessVerificationStatus.OK;
    }

    public boolean hasNativeRtspOverHttpSupport() {
        return false;
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        return "H264";
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        return null;
    }
}

