/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.compro;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.HttpClientFactory;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.containerserver.landevice.compro.CameraComproGeneric;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CameraComproGeneric")
@Scope(value="prototype")
public class CameraComproGeneric
extends GenericCamera {
    private HttpClientFactory httpClientFactory;
    static Map<VideoQualityLevel, VideoQuality> videoQualities = new /* Unavailable Anonymous Inner Class!! */;
    private static final String SNAPSHOT_GENERATE_PATH = "/cgi-bin/view/ss.cgi";
    private static final String SNAPSHOT_PATH = "/snapshot.jpg?v=1";
    private static final String UPDATE_CONFIG_PATH = "/cgi-bin/admin/param.cgi";
    private static final String LIST_CONFIG_PATH = "/cgi-bin/view/list_param.cgi";
    private static final String MODEL_NAME_PATH = "/cgi-bin/view/list_param.cgi?Action=List&Group=Product&Info=Model";
    private static final String MAC_ADDRESS_PATH = "/cgi-bin/view/list_param.cgi?Action=List&Group=MACaddress";
    private static final String USER_ADD_PATH = "/cgi-bin/admin/adduser.cgi";
    private static final String USER_REMOVE_PATH = "/cgi-bin/admin/removeuser.cgi";
    private static final String EVENT_REMOVE_PATH = "/cgi-bin/event/delevent.cgi";
    private static final String AUDIO_DETECTION_SETUP_PATH = "/cgi-bin/event/audiodetectionsetup.cgi";
    private static final String MOTION_DETECTION_REGION_SETTINGS_PATH = "/cgi-bin/event/mdsetting.cgi";
    private static final String CONN_CHECK_URL = "/cgi-bin/view/list_param.cgi?Action=List&Group=MACaddress";
    private static final String WIRELESS_SETTINGS_PATH = "/cgi-bin/admin/wireless.cgi";
    private static final String WIRELESS_CONFIG_PATH = "/cgi-bin/admin/wireless_setting.cgi";
    private static final String EVENT_OLD_ADD_PATH = "/cgi-bin/event/eventsetting.cgi";
    private static final String TWA_HTTP_PATH = "/cgi-bin/fifo.cgi";
    private static final String KILL_PROCESS_CMD = "/cgi-bin/support/killps.cgi";
    private static final String UPGRADE_FIRMWARE_CMD = "/cgi-bin/support/upload.cgi";
    private static final String UPLOAD_STATUS_CMD = "/cgi-bin/support/uploadStatus.cgi";
    private static final String SYSTEM_INFO_PATH = "/cgi-bin/support/sysinfo.cgi";
    private static final Integer TWA_HTTP_MAX_CONTENT_LENGTH = 409600;
    private static final String RESOLUTION = "640x480";
    private static final String RESOLUTION_LOW = "320x240";
    private static final String DEFAULT_REGION_SENSITIVITY = "3";
    private static final String COMPRO_EVENT_SERVLET_PATH = "/events/motion/compro";
    private Pattern wirelessPattern;
    private static final String WIRELESS_PATTERN_REGEX = "^<tr><td align=\"center\"><span class=\"content\">(.+)</span></td><td align=\"center\"><span class=\"content\"(?: id=\".+\")?>-(\\d+) dBm</span></td><td align=\"center\"><span class=\"content\">Channel-(\\d+)</span></td><td align=\"center\"><span class=\"content\">(on|off)</span></td></tr>$";

    @Autowired
    @Required
    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public CameraComproGeneric() {
        this.user = "admin";
        this.pass = "admin";
        this.cameraProducer = "Compro";
        this.capabilitiesCommands = new String[]{"/cgi-bin/view/list_param.cgi?Action=List&Group=Product&Info=Model", "/cgi-bin/view/list_param.cgi?Action=List&Group=MACaddress"};
        this.modelParam = "ModelName";
        this.wirelessPattern = Pattern.compile("^<tr><td align=\"center\"><span class=\"content\">(.+)</span></td><td align=\"center\"><span class=\"content\"(?: id=\".+\")?>-(\\d+) dBm</span></td><td align=\"center\"><span class=\"content\">Channel-(\\d+)</span></td><td align=\"center\"><span class=\"content\">(on|off)</span></td></tr>$", 10);
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        HTTPClientServiceResult generateResponse = this.sendCommand(device, this.getSnapshotGeneratePath(device), HttpCommand.SendMethod.GET);
        if (generateResponse == null) {
            return null;
        }
        HTTPClientServiceResult snapshotResponse = this.sendCommand(device, this.getSnapshotPath(device), HttpCommand.SendMethod.GET);
        return snapshotResponse == null ? null : snapshotResponse.getBody();
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        this.removeUser(device, device.getParamValue("viewer_user"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/adduser.cgi", params, HttpCommand.SendMethod.GET);
        return response.getStatusCode() == 200;
    }

    private void removeUser(LanDeviceEntity device, String username) {
        this.sendCommand(device, "/cgi-bin/admin/removeuser.cgi", HttpCommand.SendMethod.GET, new String[]{"selectedUser", username});
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("username", device.getParamValue("viewer_user"));
        String password = device.getParamValue("viewer_pass");
        params.put("passwd1", password);
        params.put("passwd2", password);
        params.put("selectgroup", "viewer");
        return this.registerUser(device, params);
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        boolean useNewMotionDetectionApi = this.modelSupportsNewMotionDetectionApi(device.getModel());
        boolean configureAudioInput = this.modelSupportsAudioInput(device.getModel());
        boolean noAudioDetection = this.modelWithoutAudioDetectionSupport(device.getModel());
        if (!reconfiguration) {
            device.setParam("motion_detection", "OFF", "OFF");
            if (useNewMotionDetectionApi && configureAudioInput && !noAudioDetection) {
                device.setParam("audio_detection", "OFF", "OFF");
            }
            device.setParam("record_video", "OFF", "OFF");
            device.setParam("video_recording_duration", "15", "15");
            device.setParam("has_videoclip_recording", "OFF");
            device.setParam("alarm_limit", "0", "0");
            device.setParam("resolution", "640x480");
            device.setParam("snapshot_generate_path", this.getSnapshotGeneratePath(device));
            device.setParam("snapshot_path", this.getSnapshotPath(device));
            device.setParam("resolution_low", "320x240");
            device.setParam("snapshot_generate_path_low", this.getSnapshotGeneratePath(device));
            device.setParam("snapshot_path_low", this.getSnapshotPath(device));
            if (this.modelSupportsPanTilt(device.getModel())) {
                device.setParam("has_home", "ON");
                device.setParam("has_pan", "ON");
                device.setParam("has_tilt", "ON");
            }
            if (configureAudioInput && !device.getVideoEncoding().equals("MJPEG")) {
                device.setParam("mute_audio", "OFF", "OFF");
            }
            if (this.modelSupportsTwoWayAudio(device.getModel())) {
                device.setParam("has_two_way_audio", "ON");
                device.setParam("twa_http_path", "/cgi-bin/fifo.cgi");
                device.setParam("twa_http_max_content_length", TWA_HTTP_MAX_CONTENT_LENGTH.toString());
                device.setParam("twa_upload_type", this.getTwoWayAudioUploadType(device).toString());
                device.setParam("twa_sample_type", this.getTwoWayAudioSampleType(device).toString());
                device.setParam("twa_sample_rate", this.getTwoWayAudioSampleRate(device).toString());
                device.setParam("twa_channel_count", this.getTwoWayAudioChannelCount(device).toString());
                device.setParam("twa_codec", this.getTwoWayAudioCodec(device).toString());
            }
        }
        if (!device.getVideoEncoding().equals("MJPEG")) {
            device.setParam("path", "medias2");
            device.setParam("path_low", "medias1");
            device.setParam("path_rtsp_over_http_get", "medias2");
            device.setParam("path_low_rtsp_over_http_get", "medias1");
            device.setParam("path_rtsp_over_http_post", "medias2");
            device.setParam("path_low_rtsp_over_http_post", "medias1");
            device.setParam("rtsp_port", "554");
            device.setParam("rtsp_over_http_port", "8088");
            device.setParam("audio_output_filters", "lowpass");
        } else {
            device.setParam("path", "cgi-bin/push_mjpeg.cgi");
            device.setParam("path_low", "cgi-bin/push_mjpeg.cgi");
        }
        if (!configureAudioInput || device.getVideoEncoding().equals("MJPEG")) {
            device.setParam("has_mute_audio", "OFF");
            device.setParam("mute_audio", "ON", "ON");
        } else {
            device.setParam("has_mute_audio", "ON");
            if (!device.hasParam("mute_audio")) {
                device.setParam("mute_audio", "OFF", "OFF");
            }
        }
        if (!this.configureVideoProfiles(device)) {
            this.log.warn((Object)"cannot configure video profiles");
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        this.applyValueToRemoteValue(device, "video_quality");
        if (!this.configureMute(device)) {
            this.log.warn((Object)"cannot configure mute settings");
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        this.applyValueToRemoteValue(device, "mute_audio");
        if (!this.configureMotionDetection(device)) {
            this.log.warn((Object)"cannot configure motion detection");
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        this.applyValueToRemoteValue(device, "motion_detection");
        this.applyValueToRemoteValue(device, "audio_detection");
        if (!this.configureWirelessSettings(device)) {
            this.log.warn((Object)"cannot configure wireless network settings");
            return GenericLanDevice.ConfigurationStatus.ERROR;
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    private void applyValueToRemoteValue(LanDeviceEntity device, String paramName) {
        LanDeviceParamEntity lanDeviceParam = device.getParam(paramName);
        if (lanDeviceParam == null) {
            return;
        }
        lanDeviceParam.setRemoteValue(lanDeviceParam.getValue());
    }

    protected GenericCamera.TwoWayAudioCodec getTwoWayAudioCodec(LanDeviceEntity device) {
        return GenericCamera.TwoWayAudioCodec.MuLaw;
    }

    protected Integer getTwoWayAudioChannelCount(LanDeviceEntity device) {
        return 1;
    }

    protected Integer getTwoWayAudioSampleRate(LanDeviceEntity device) {
        return 8000;
    }

    protected GenericCamera.TwoWayAudioSampleType getTwoWayAudioSampleType(LanDeviceEntity device) {
        return GenericCamera.TwoWayAudioSampleType.SInt16;
    }

    protected GenericCamera.TwoWayAudioUploadType getTwoWayAudioUploadType(LanDeviceEntity device) {
        return GenericCamera.TwoWayAudioUploadType.HTTP;
    }

    private boolean modelSupportsTwoWayAudio(String model) {
        return this.modelSupportsFeature(ParameterService.ParameterCode.LANDEVICE_COMPRO_MODELS_WITH_TWO_WAY_AUDIO, model);
    }

    private boolean modelSupportsPanTilt(String model) {
        return this.modelSupportsFeature(ParameterService.ParameterCode.LANDEVICE_COMPRO_MODELS_WITH_PAN_TILT, model);
    }

    private String getSnapshotPath(LanDeviceEntity device) {
        return "/snapshot.jpg?v=1";
    }

    private String getSnapshotGeneratePath(LanDeviceEntity device) {
        return "/cgi-bin/view/ss.cgi";
    }

    private boolean modelSupportsAudioInput(String model) {
        return this.modelSupportsFeature(ParameterService.ParameterCode.LANDEVICE_COMPRO_MODELS_WITH_AUDIO_INPUT, model);
    }

    private boolean modelSupportsNewMotionDetectionApi(String model) {
        return this.modelSupportsAVCEncoding(model);
    }

    private boolean configureWirelessSettings(LanDeviceEntity device) {
        return true;
    }

    private boolean uploadWirelessConfiguration(LanDeviceEntity device, boolean wifiEnabled, String ssid, String passphrase) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("wmethod", "DHCP");
        params.put("ap", wifiEnabled ? ssid : "");
        params.put("inputkey", passphrase != null && wifiEnabled ? passphrase : "");
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/wireless_setting.cgi", params, HttpCommand.SendMethod.GET, 10);
        return response != null && response.getStatusCode() != null && response.getStatusCode() == 200;
    }

    private void configureMotionDetectionRegion(LanDeviceEntity device, boolean motionDetectionEnabled, boolean useNewMotionDetectionApi) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (useNewMotionDetectionApi) {
            params.put("rcInfo0Save", motionDetectionEnabled ? "0_0_320_240_3" : "0_0_0_0_1");
            params.put("rcInfo1Save", "0_0_0_0_1");
            params.put("rcInfo2Save", "0_0_0_0_1");
        } else {
            params.put("regionsInBits", "1111111111111111111111111");
            params.put("sensitivity", "3");
            params.put("rcInfo0Save", "");
            params.put("rcInfo1Save", "");
            params.put("rcInfo2Save", "");
        }
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/event/mdsetting.cgi", params, HttpCommand.SendMethod.GET);
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot configure motion detection region");
            throw new RuntimeException();
        }
    }

    private boolean configureMotionDetection(LanDeviceEntity device) {
        return this.configureMotionDetection(device, null, null);
    }

    private boolean configureMotionDetection(LanDeviceEntity device, String paramName, String paramValue) {
        boolean motionDetectionEnabled = "motion_detection".equals(paramName) ? "ON".equals(paramValue) : "ON".equals(device.getParamValue("motion_detection"));
        boolean audioDetectionEnabled = "audio_detection".equals(paramName) ? "ON".equals(paramValue) : "ON".equals(device.getParamValue("audio_detection"));
        boolean useNewMotionDetectionApi = this.modelSupportsNewMotionDetectionApi(device.getModel());
        boolean configureAudioInput = this.modelSupportsAudioInput(device.getModel());
        try {
            this.removeEventTriggers(device);
            if (motionDetectionEnabled || audioDetectionEnabled) {
                this.configureHttpNotificationServer(device);
            }
            if (motionDetectionEnabled) {
                this.configureMotionDetectionRegion(device, motionDetectionEnabled, useNewMotionDetectionApi);
                this.configureMotionDetectionEventTrigger(device, useNewMotionDetectionApi);
            }
            if (useNewMotionDetectionApi && audioDetectionEnabled && configureAudioInput) {
                this.configureAudioDetectionEventTrigger(device);
                this.configureAudioDetectionSensitivity(device);
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    private void configureAudioDetectionSensitivity(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/event/audiodetectionsetup.cgi", HttpCommand.SendMethod.GET, new String[]{"Sensitivity", "1", "Submit", "Save"});
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot set audio detection sensitivity");
            throw new RuntimeException();
        }
    }

    private void removeEventTriggers(LanDeviceEntity device) {
        List events = this.getEventTriggers(device);
        for (Event event : events) {
            this.removeEventTrigger(device, event.id);
        }
    }

    private String downloadConfigurationText(LanDeviceEntity device, String group) {
        return this.downloadConfigurationText(device, group, null, null);
    }

    private void removeEventTrigger(LanDeviceEntity device, String eventId) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/event/delevent.cgi", HttpCommand.SendMethod.GET, new String[]{"id", eventId.toString()});
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)("cannot remove event trigger: " + eventId));
            throw new RuntimeException();
        }
    }

    private List<Event> getEventTriggers(LanDeviceEntity device) {
        return this.parseEvents(this.downloadConfigurationText(device, "Event"));
    }

    private List<Event> parseEvents(String response) {
        String[] events;
        LinkedList<Event> result = new LinkedList<Event>();
        String[] stringArray = events = response.split(",");
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            String eventString = stringArray[n2];
            Map eventParams = this.parseResponse(eventString);
            Event event = new Event(this, (String)eventParams.get("EventID"), (String)eventParams.get("EventTrigger"), (String)eventParams.get("EventAction"));
            if (event.id == null || event.trigger == null || event.action == null) break;
            result.add(event);
            this.log.debug((Object)("found event id: " + event.id));
            ++n2;
        }
        return result;
    }

    private void configureAudioDetectionEventTrigger(LanDeviceEntity device) {
        this.configureEventTrigger(device, "audio_detection");
    }

    private void configureMotionDetectionEventTrigger(LanDeviceEntity device, boolean useNewMotionDetectionApi) {
        if (useNewMotionDetectionApi) {
            this.configureEventTrigger(device, "motion_detection0");
        } else {
            this.configureOldMotionDetectionEventTrigger(device);
        }
    }

    private void configureOldMotionDetectionEventTrigger(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/event/eventsetting.cgi", HttpCommand.SendMethod.GET, new String[]{"tri", "md", "id", "0", "http", "on"});
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot upload old motion event trigger configuration");
            throw new RuntimeException();
        }
    }

    private void configureEventTrigger(LanDeviceEntity device, String eventTrigger) {
        this.uploadConfiguration(device, "Event", new String[]{"EventTrigger", eventTrigger, "EventAction", "httpNotify"});
    }

    private void configureHttpNotificationServer(LanDeviceEntity device) {
        this.uploadConfiguration(device, "HttpServer", new String[]{"Url", this.getMotionDetectionServletURL(device)});
    }

    private String getMotionDetectionServletURL(LanDeviceEntity device) {
        return String.valueOf(this.serverUrl) + "/events/motion/compro" + "/" + device.getMac().replace(":", "");
    }

    private boolean configureVideoProfiles(LanDeviceEntity device) {
        VideoQuality videoQuality = CameraComproGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        return this.enableDualStreamMode(device) && this.configureVideoProfile(device, Integer.valueOf(1), "320x240", Integer.valueOf(videoQuality.getBitrateLow(videoEncoding)), Integer.valueOf(fps)) && this.configureVideoProfile(device, Integer.valueOf(2), "640x480", Integer.valueOf(videoQuality.getBitrate(videoEncoding)), Integer.valueOf(fps));
    }

    private boolean configureMute(LanDeviceEntity device) {
        boolean audioEnabled = this.deviceHasAudioEnabled(device);
        return this.configureMute(device, Integer.valueOf(1), Boolean.valueOf(audioEnabled)) && this.configureMute(device, Integer.valueOf(2), Boolean.valueOf(audioEnabled));
    }

    private boolean deviceHasAudioEnabled(LanDeviceEntity device) {
        return !"MJPEG".equals(device.getVideoEncoding()) && "ON".equals(device.getParamValue("has_mute_audio")) && !"ON".equals(device.getParamValue("mute_audio"));
    }

    private void uploadConfiguration(LanDeviceEntity device, String group, String ... arguments) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("Action", "Update");
        params.put("Group", group);
        int i = 0;
        while (i < arguments.length) {
            params.put(arguments[i], arguments[i + 1]);
            i += 2;
        }
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/param.cgi", params, HttpCommand.SendMethod.GET);
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot upload configuration");
            throw new RuntimeException();
        }
    }

    private boolean configureVideoProfile(LanDeviceEntity device, Integer streamId, String resolution, Integer bitrateIndex, Integer fps) {
        try {
            String streamIdString = "S" + streamId.toString();
            this.uploadConfiguration(device, "Video", new String[]{"Stream", streamIdString, "Resolution", resolution, "Compression", bitrateIndex.toString(), "FPS", fps.toString(), "Codec", device.getVideoEncoding(), "DynamicFPS", "100"});
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean configureMute(LanDeviceEntity device, Integer streamId, Boolean audioEnabled) {
        try {
            String streamIdString = "S" + streamId.toString();
            this.uploadConfiguration(device, "Audio", new String[]{"Stream", streamIdString, "Enable", audioEnabled != false ? "YES" : "NO"});
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean enableDualStreamMode(LanDeviceEntity device) {
        try {
            this.uploadConfiguration(device, "Camera", new String[]{"DualStreamMode", "YES"});
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        if (response == null || response.getResult() != HTTPClientServiceResult.Result.OK) {
            return false;
        }
        return "OK".equals(response.getBodyAsText());
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        return false;
    }

    public ControlParams getControlParams() {
        ControlParams controlParams = new ControlParams();
        controlParams.setPanLeft("/cgi-bin/view/cammove.cgi?move=left");
        controlParams.setPanRight("/cgi-bin/view/cammove.cgi?move=right");
        controlParams.setPanUp("/cgi-bin/view/cammove.cgi?move=up");
        controlParams.setPanDown("/cgi-bin/view/cammove.cgi?move=down");
        controlParams.setPanCenter("/cgi-bin/view/cammove.cgi?move=home");
        return controlParams;
    }

    public void updateSettings(LanDeviceEntity device) {
        Set paramsToUpdate = this.getParamsToUpdate(device);
        if (this.hasSettingsToUpdate(paramsToUpdate, this.getSupportedMotionDetectionSettings()) && this.configureMotionDetection(device)) {
            this.synchronizeSettings(device, this.getSupportedMotionDetectionSettings());
        }
        if (this.hasSettingsToUpdate(paramsToUpdate, this.getSupportedVideoSettings()) && this.configureVideoProfiles(device)) {
            this.synchronizeSettings(device, this.getSupportedVideoSettings());
        }
        if (this.hasSettingsToUpdate(paramsToUpdate, this.getSupportedMuteSettings()) && this.configureMute(device)) {
            this.synchronizeSettings(device, this.getSupportedMuteSettings());
        }
        if (this.hasSettingsToUpdate(paramsToUpdate, this.getSupportedWirelessSettings()) && this.configureWirelessSettings(device)) {
            this.synchronizeSettings(device, this.getSupportedWirelessSettings());
        }
    }

    private void synchronizeSettings(LanDeviceEntity device, Set<String> settings) {
        for (String setting : settings) {
            String value = device.getParamValue(setting);
            if (value == null) continue;
            this.synchronizeSetting(device, setting, value);
        }
    }

    private boolean hasSettingsToUpdate(Set<String> paramsToUpdate, Set<String> supportedSettings) {
        for (String paramToUpdate : paramsToUpdate) {
            for (String supportedSetting : supportedSettings) {
                if (!paramToUpdate.equals(supportedSetting)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getParamsToUpdate(LanDeviceEntity device) {
        if (device == null || device.getLanDeviceParams() == null || device.getLanDeviceParams().isEmpty()) {
            return Collections.emptySet();
        }
        Set supportedSettings = this.getSupportedSettings();
        HashSet<String> params = new HashSet<String>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!supportedSettings.contains(param.getName()) || param.getValue().equals(param.getRemoteValue())) continue;
            params.add(param.getName());
        }
        this.log.debug((Object)("params to update: " + params));
        return params;
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        if (!this.getSupportedSettings().contains(paramName)) {
            this.log.debug((Object)("trying to update unsupported parameter " + paramName));
            return UpdateSettingStatus.FAILED_PARAMUNSUPPORTED;
        }
        UpdateSettingStatus status = UpdateSettingStatus.SUCCESS;
        if (this.getSupportedMotionDetectionSettings().contains(paramName) && !this.configureMotionDetection(device, paramName, paramValue)) {
            status = UpdateSettingStatus.ERROR;
        }
        if (this.getSupportedVideoSettings().contains(paramName) && !this.configureVideoProfiles(device)) {
            status = UpdateSettingStatus.ERROR;
        }
        if (this.getSupportedMuteSettings().contains(paramName) && !this.configureMute(device)) {
            status = UpdateSettingStatus.ERROR;
        }
        if (this.getSupportedWirelessSettings().contains(paramName) && !this.configureWirelessSettings(device)) {
            status = UpdateSettingStatus.ERROR;
        }
        if (status == UpdateSettingStatus.SUCCESS) {
            if (!this.synchronizeSetting(device, paramName, paramValue)) {
                this.log.warn((Object)("Setting " + paramName + " has not been updated in database"));
                status = UpdateSettingStatus.ERROR;
            }
        } else {
            this.log.warn((Object)("error setting parameter " + paramName + " to value " + paramValue));
        }
        return status;
    }

    private boolean synchronizeSetting(LanDeviceEntity device, String paramName, String paramValue) {
        this.log.debug((Object)("synchronizing options for device " + device.getMac() + ": " + paramName + "=" + paramValue));
        return this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), paramName, paramValue, paramValue);
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return this.checkStatus(device, "/cgi-bin/view/list_param.cgi?Action=List&Group=MACaddress");
    }

    public Set<String> getSupportedSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.addAll(this.getSupportedMotionDetectionSettings());
        supportedSettings.addAll(this.getSupportedVideoSettings());
        supportedSettings.addAll(this.getSupportedMuteSettings());
        supportedSettings.addAll(this.getSupportedWirelessSettings());
        return supportedSettings;
    }

    private Set<String> getSupportedMotionDetectionSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.add("motion_detection");
        supportedSettings.add("audio_detection");
        return supportedSettings;
    }

    private Set<String> getSupportedVideoSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.add("video_quality");
        return supportedSettings;
    }

    private Set<String> getSupportedMuteSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.add("mute_audio");
        return supportedSettings;
    }

    private Set<String> getSupportedWirelessSettings() {
        return new HashSet<String>();
    }

    public String getMacAddress(LanDeviceEntity device) {
        try {
            return (String)this.downloadConfiguration(device, "MACaddress").get("MACaddress");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private Map<String, String> downloadConfiguration(LanDeviceEntity device, String group) {
        return this.downloadConfiguration(device, group, null, null);
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/admin/wireless.cgi", HttpCommand.SendMethod.GET);
        if (response == null || response.getStatusCode() == null || response.getStatusCode() != 200) {
            this.log.debug((Object)("cannot get wireless networks for LD " + device.getMac()));
            return new LinkedList<WlanAccessPoint>();
        }
        return this.parseWirelessNetworksHtml(response.getBodyAsText());
    }

    private List<WlanAccessPoint> parseWirelessNetworksHtml(String html) {
        LinkedList<WlanAccessPoint> result = new LinkedList<WlanAccessPoint>();
        Matcher matcher = this.wirelessPattern.matcher(html);
        while (matcher.find()) {
            WlanAccessPoint wap = new WlanAccessPoint();
            wap.setSsid(this.getWirelessMatcherValue(matcher, WirelessMatcherGroup.SSID));
            wap.setSignalStrength(this.getWirelessSignalStrength(this.getWirelessMatcherValue(matcher, WirelessMatcherGroup.STRENGTH_DB)));
            wap.setChannel(Integer.valueOf(Integer.parseInt(this.getWirelessMatcherValue(matcher, WirelessMatcherGroup.CHANNEL))));
            wap.setEncryptionModes(this.getWirelessModes(this.getWirelessMatcherValue(matcher, WirelessMatcherGroup.ENCRYPTION_BOOLEAN)));
            wap.setBssid("");
            wap.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
            this.log.debug((Object)("found wireless AP: " + wap.toString()));
            result.add(wap);
        }
        return result;
    }

    public String getFirmwareVersion(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/support/sysinfo.cgi", HttpCommand.SendMethod.GET);
        if (response == null || response.getStatusCode() == null || response.getStatusCode() != 200) {
            this.log.debug((Object)("cannot get firmware version for LD " + device.getMac()));
            return "";
        }
        return this.parseFirmwareVersion(response.getBodyAsText());
    }

    private String parseFirmwareVersion(String html) {
        String firmwareVersionKey = "var firmver=\"";
        Integer startIndex = html.indexOf(firmwareVersionKey) + firmwareVersionKey.length();
        Integer endIndex = html.indexOf("\";", (int)startIndex);
        String version = html.substring(startIndex, endIndex);
        return version;
    }

    private Integer getWirelessSignalStrength(String value) {
        Integer result = Integer.parseInt(value) * -1;
        result = 2 * (result + 100);
        return Utils.clamp((Integer)result, (int)0, (int)100);
    }

    private List<EncryptionMode> getWirelessModes(String value) {
        LinkedList<EncryptionMode> result = new LinkedList<EncryptionMode>();
        if ("ON".equalsIgnoreCase(value)) {
            result.add(new EncryptionMode(EncryptionMode.Encryption.PASSPHRASE, EncryptionMode.Algorithm.UNKNOWN));
        } else {
            result.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        }
        return result;
    }

    private String getWirelessMatcherValue(Matcher matcher, WirelessMatcherGroup field) {
        return matcher.group(field.ordinal());
    }

    public String getConnCheckUrl() {
        return "/cgi-bin/view/list_param.cgi?Action=List&Group=MACaddress";
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        if (device.getParam("video_quality") == null) {
            this.log.debug((Object)"Video quality param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        try {
            this.checkVideoProfiles(device);
            this.checkMotionDetection(device);
        }
        catch (RuntimeException e) {
            return CheckConfigurationStatus.INCORRECT;
        }
        return CheckConfigurationStatus.CORRECT;
    }

    private void checkMotionDetection(LanDeviceEntity device) {
        boolean useNewMotionDetectionApi = this.modelSupportsNewMotionDetectionApi(device.getModel());
        boolean motionDetectionEnabled = "ON".equals(device.getParamValue("motion_detection"));
        boolean audioDetectionEnabled = "ON".equals(device.getParamValue("audio_detection"));
        this.checkMotionDetectionRegion(device, motionDetectionEnabled, useNewMotionDetectionApi);
        this.checkEventTriggers(device, motionDetectionEnabled, audioDetectionEnabled && useNewMotionDetectionApi);
        if (motionDetectionEnabled || audioDetectionEnabled) {
            this.checkHttpNotificationServer(device);
        }
    }

    private void checkHttpNotificationServer(LanDeviceEntity device) {
        Map result = this.downloadConfiguration(device, "HttpServer");
        this.checkParamValue(result, "EnableHTTPServer", "YES");
        this.checkParamValue(result, "URL", this.getMotionDetectionServletURL(device));
    }

    private void checkEventTriggers(LanDeviceEntity device, boolean motionDetectionEnabled, boolean audioDetectionEnabled) {
        List events = this.getEventTriggers(device);
        for (Event event : events) {
            if (!(event.trigger.equalsIgnoreCase("Motion_Detection") && !motionDetectionEnabled || event.trigger.equalsIgnoreCase("Audio_Detection") && !audioDetectionEnabled) && event.action.equalsIgnoreCase("HTTP")) continue;
            this.log.debug((Object)"invalid event trigger configuration");
            throw new RuntimeException();
        }
    }

    private void checkMotionDetectionRegion(LanDeviceEntity device, boolean motionDetectionEnabled, boolean useNewMotionDetectionApi) {
        if (!useNewMotionDetectionApi) {
            throw new RuntimeException();
        }
        Map result = this.downloadConfiguration(device, "MotionDetect", "Region", "0");
        this.checkParamValue(result, "Region", "0");
        this.checkParamValue(result, "Sensitivity", "3");
        this.checkParamValue(result, "X0", "0");
        this.checkParamValue(result, "Y0", "0");
        String value = motionDetectionEnabled ? "100" : "0";
        this.checkParamValue(result, "X1", value);
        this.checkParamValue(result, "Y1", value);
    }

    private void checkVideoProfiles(LanDeviceEntity device) {
        VideoQuality videoQuality = CameraComproGeneric.getVideoQuality((LanDeviceEntity)device, (Map)videoQualities);
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        boolean audioEnabled = this.deviceHasAudioEnabled(device);
        this.checkVideoProfile(device, 1, "320x240", Integer.valueOf(fps), Integer.valueOf(videoQuality.getBitrateLow(videoEncoding)), Boolean.valueOf(audioEnabled));
        this.checkVideoProfile(device, 2, "640x480", Integer.valueOf(fps), Integer.valueOf(videoQuality.getBitrate(videoEncoding)), Boolean.valueOf(audioEnabled));
    }

    private void checkVideoProfile(LanDeviceEntity device, int profileId, String expectedResolution, Integer expectedFps, Integer expectedBitrate, Boolean audioEnabled) {
        String streamId = "S" + profileId;
        Map result = this.downloadConfiguration(device, "Video", "Stream", streamId);
        this.checkParamValue(result, "Video.Resolution", expectedResolution);
        this.checkParamValue(result, "Video.FPS", expectedFps.toString());
        this.checkParamValue(result, "Video.Compression", expectedBitrate.toString());
        this.checkParamValue(result, "Video.DualStream", "YES");
        Map audioResult = this.downloadConfiguration(device, "Audio", "Stream", streamId);
        this.checkParamValue(audioResult, "Audio.Enable", audioEnabled != false ? "YES" : "NO");
    }

    private void checkParamValue(Map<String, String> params, String key, String expectedValue) {
        String value = params.get(key);
        if (!expectedValue.equalsIgnoreCase(value)) {
            this.log.debug((Object)("configuration values mismatch: received " + value + ", expected " + expectedValue));
            throw new RuntimeException();
        }
    }

    private String downloadConfigurationText(LanDeviceEntity device, String group, String additionalKey, String additionalValue) {
        HTTPClientServiceResult response;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("Action", "List");
        params.put("Group", group);
        if (additionalKey != null && additionalValue != null) {
            params.put(additionalKey, additionalValue);
        }
        if ((response = this.sendCommand(device, "/cgi-bin/view/list_param.cgi", params, HttpCommand.SendMethod.GET)).getStatusCode() != 200) {
            this.log.debug((Object)"error getting configuration");
            throw new RuntimeException();
        }
        return response.getBodyAsText();
    }

    private Map<String, String> downloadConfiguration(LanDeviceEntity device, String group, String additionalKey, String additionalValue) {
        return this.parseResponse(this.downloadConfigurationText(device, group, additionalKey, additionalValue));
    }

    public String getVersion(LanDeviceEntity device) {
        return this.getFirmwareVersion(device);
    }

    public boolean upgradeFirmwareOld(LanDeviceEntity device) {
        return false;
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        HttpClient httpclient;
        block7: {
            block6: {
                this.log.debug((Object)("start upgradeFirmware(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
                try {
                    if (this.sendKillProcessRequest(device)) break block6;
                    return false;
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to upgrade firmware for device with lanDeviceId=" + device.getLanDeviceId() + ": " + e.getMessage() + "."));
                    if (this.log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            Thread.sleep(2000L);
            httpclient = this.httpClientFactory.getHttpClient();
            if (this.sendUploadFirmwareRequest(device, httpclient)) break block7;
            return false;
        }
        Integer status = this.waitForUploadComplete(device);
        this.shutdownConnection(httpclient);
        status = this.waitForUpgradeComplete(device);
        if (this.isUploadStatusSuccess(status)) {
            Thread.sleep(2000L);
            return this.sendReloadRequest(device);
        }
        return false;
    }

    private boolean sendKillProcessRequest(LanDeviceEntity device) throws ClientProtocolException, IOException {
        this.log.debug((Object)("start sendKillProcessRequest(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/support/killps.cgi", HttpCommand.SendMethod.GET);
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot kill process");
            return false;
        }
        return true;
    }

    private void shutdownConnection(HttpClient httpclient) {
        this.log.debug((Object)"start shutdownConnection");
        httpclient.getConnectionManager().shutdown();
    }

    private boolean sendUploadFirmwareRequest(LanDeviceEntity device, HttpClient httpclient) throws ClientProtocolException, IOException, InterruptedException {
        this.log.debug((Object)("start sendUploadFirmwareRequest(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        HttpPost httppost = new HttpPost(this.getUpgradeFirmwareUrl("/cgi-bin/support/upload.cgi"));
        httppost.addHeader("Cookie", this.getUpgradeFirmwareCookie(device));
        httppost.addHeader("Authorization", this.getAuthorizationHeader(device));
        httppost.setHeader("Connection", "close");
        File firmware = this.systemSupport.getFile(String.valueOf(this.firmwares) + "/" + device.getDeviceDesc().getFirmwareFile());
        if (!this.isFileReadable(firmware)) {
            this.log.warn((Object)("Can not read firmware file for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        MultipartEntity multipart = new MultipartEntity();
        FileBody fileBody = new FileBody(firmware, "application/macbinary");
        multipart.addPart("uploadfile", (ContentBody)fileBody);
        multipart.addPart("submit_button", (ContentBody)new StringBody(""));
        multipart.addPart("change_action", (ContentBody)new StringBody(""));
        multipart.addPart("action", (ContentBody)new StringBody(""));
        httppost.setEntity((HttpEntity)multipart);
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        if (response.getEntity() == null) {
            this.log.warn((Object)("Missing entity in upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        return true;
    }

    private boolean sendReloadRequest(LanDeviceEntity device) throws ClientProtocolException, IOException, InterruptedException {
        this.log.debug((Object)("start sendUploadFirmwareRequest(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("status", "2");
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/support/uploadStatus.cgi", params, HttpCommand.SendMethod.GET);
        if (response.getStatusCode() != 200) {
            this.log.debug((Object)"cannot kill process");
            return false;
        }
        return true;
    }

    private Integer checkUploadStatus(LanDeviceEntity device) {
        HTTPClientServiceResult response = this.sendUploadStatusRequest(device);
        String responseText = response.getBodyAsText();
        this.log.debug((Object)("uploadStatus response for " + device.getMac() + " = " + responseText));
        Integer status = null;
        try {
            status = Integer.parseInt(responseText);
        }
        catch (NumberFormatException e) {
            this.log.debug((Object)"cannot parse response");
            status = -1;
        }
        return status;
    }

    private boolean isUploadStatusSuccess(Integer status) {
        return UploadStatus.SUCCESS.equals(status);
    }

    private Integer waitForUploadComplete(LanDeviceEntity device) throws InterruptedException {
        ArrayList<Integer> expectedCodes = new ArrayList<Integer>();
        expectedCodes.add(UploadStatus.SUCCESS);
        expectedCodes.add(UploadStatus.UPLOAD_COMPLETE);
        expectedCodes.add(UploadStatus.VERIFY_COMPLETE);
        expectedCodes.add(UploadStatus.FLASH_COMPLETE);
        Integer code = null;
        do {
            Thread.sleep(1000L);
        } while (!expectedCodes.contains(code = this.checkUploadStatus(device)));
        return code;
    }

    private Integer waitForUpgradeComplete(LanDeviceEntity device) throws InterruptedException {
        ArrayList<Integer> expectedCodes = new ArrayList<Integer>();
        expectedCodes.add(UploadStatus.SUCCESS);
        expectedCodes.add(UploadStatus.WRONG_FIRMWARE);
        expectedCodes.add(UploadStatus.FILE_OVER_SIZE);
        expectedCodes.add(UploadStatus.UPLOAD_OVER_10_MINUTES);
        expectedCodes.add(UploadStatus.FAILED);
        ArrayList<Integer> pendingCodes = new ArrayList<Integer>();
        pendingCodes.add(UploadStatus.UPLOAD_COMPLETE);
        pendingCodes.add(UploadStatus.VERIFY_COMPLETE);
        pendingCodes.add(UploadStatus.FLASH_COMPLETE);
        int trial = 0;
        int maxTrial = 30;
        Integer code = null;
        do {
            Thread.sleep(1000L);
            code = this.checkUploadStatus(device);
            if (!pendingCodes.contains(code) && !expectedCodes.contains(code)) {
                ++trial;
            }
            if (trial < maxTrial) continue;
            return UploadStatus.ERROR;
        } while (!expectedCodes.contains(code));
        return code;
    }

    private HTTPClientServiceResult sendUploadStatusRequest(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rnd", String.valueOf(this.systemSupport.currentTimeMillis()));
        return this.sendCommand(device, "/cgi-bin/support/uploadStatus.cgi", params, HttpCommand.SendMethod.GET);
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        String ssid = device.getParamValue("wifi_ssid");
        if (ssid == null) {
            this.log.debug((Object)("cannot find configured WiFi SSID for device " + device.getMac()));
            return null;
        }
        List waps = this.getWirelessNetworks(device);
        if (waps == null) {
            this.log.debug((Object)("no wireless networks found during scanning for device " + device.getMac()));
        }
        for (WlanAccessPoint wap : waps) {
            if (!ssid.equals(wap.getSsid())) continue;
            return wap.getSignalStrength();
        }
        this.log.debug((Object)("configured SSID " + ssid + " network not found during scanning for device " + device.getMac()));
        return null;
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        return response.getBodyAsText().length() == 0 ? AccessVerificationStatus.ERROR : AccessVerificationStatus.OK;
    }

    public boolean hasNativeRtspOverHttpSupport() {
        return false;
    }

    public String getIpAddress(String gatewayClientMac, String lanDeviceMac) {
        CameraDiscoveryService cameraDiscovery = this.getCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayClientMac);
        for (DiscoveredLanDevice device : devices) {
            this.log.debug((Object)("comparing LD MAC " + lanDeviceMac + " with found " + device.getMac()));
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            return device.getIpAddress();
        }
        return null;
    }

    public LanDevice getLanDevice(GatewayDevice gatewayDevice, String lanDeviceMac) {
        LanDevice lanDevice = super.getLanDevice(gatewayDevice, lanDeviceMac);
        CameraDiscoveryService cameraDiscovery = this.serviceFactory.getComproCameraDiscoveryService();
        List devices = cameraDiscovery.discover(gatewayDevice.getMac());
        for (DiscoveredLanDevice device : devices) {
            if (!device.getMac().equalsIgnoreCase(lanDeviceMac)) continue;
            lanDevice.setIpAddress(device.getIpAddress());
            lanDevice.setPort(Integer.valueOf(device.getPort()));
            lanDevice.setUser("admin");
            lanDevice.setPass("admin");
            break;
        }
        return lanDevice;
    }

    public CameraDiscoveryService getCameraDiscoveryService() {
        return this.serviceFactory.getComproCameraDiscoveryService();
    }

    public GenericLanDevice.AuthType getAuthType() {
        return null;
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        return "H264";
    }

    protected boolean modelSupportsAVCEncoding(String model) {
        return this.modelSupportsFeature(ParameterService.ParameterCode.LANDEVICE_COMPRO_MODELS_WITH_AVC, model);
    }

    protected boolean modelWithoutAudioDetectionSupport(String model) {
        return this.modelSupportsFeature(ParameterService.ParameterCode.LANDEVICE_COMPRO_MODELS_WITHOUT_AUDIO_DETECTION, model);
    }

    private boolean modelSupportsFeature(ParameterService.ParameterCode parameter, String model) {
        String supportedModels = this.parameterService.getParameterValue(parameter);
        if (supportedModels == null) {
            this.log.warn((Object)("missing parameter entry for code: " + parameter));
            return false;
        }
        String[] supportedModelsArray = supportedModels.split(",");
        return Arrays.asList(supportedModelsArray).contains(model);
    }

    public boolean isRtcpOverRtspSupported() {
        return false;
    }
}

