/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.brickcom;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraBrickcomGeneric.class, HttpPost.class, DefaultHttpClient.class, EntityUtils.class, File.class})
public class UpgradeFirmwareTests {
    private CameraBrickcomGeneric cameraBrickcomGeneric;
    private AuthenticationUtils authUtils;
    private LanDeviceService lanDeviceService;
    private UpdateSettingsHandlerFactory updateHandlerFactory;
    private DeviceDescDAO deviceDescDAO;
    private ContainerserverServiceFactory serviceFactory;
    private SystemSupport systemSupport;

    @Before
    public void setUp() {
        this.cameraBrickcomGeneric = new CameraBrickcomGeneric();
        this.cameraBrickcomGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.cameraBrickcomGeneric.setAuthUtils(this.authUtils);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.cameraBrickcomGeneric.setLanDeviceService(this.lanDeviceService);
        this.updateHandlerFactory = (UpdateSettingsHandlerFactory)PowerMock.createMock(UpdateSettingsHandlerFactory.class);
        this.cameraBrickcomGeneric.setUpdateHandlerFactory(this.updateHandlerFactory);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.cameraBrickcomGeneric.setDeviceDescDAO(this.deviceDescDAO);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.cameraBrickcomGeneric.setServiceFactory(this.serviceFactory);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.cameraBrickcomGeneric.setSystemSupport(this.systemSupport);
    }

    @Test
    public void testUpgradeFirmwareSuccessfully() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/macbinary"}).andReturn((Object)fileBody);
        multipart.addPart("file", (ContentBody)fileBody);
        StringBody stringBody = (StringBody)PowerMock.createMock(StringBody.class);
        PowerMock.expectNew(StringBody.class, (Object[])new Object[]{""}).andReturn((Object)stringBody);
        multipart.addPart("send", (ContentBody)stringBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(2);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("version=1.0.0").append("\n");
        responseBody.append("requestURI=cgi-bin/upgradeFirmware.cgi").append("\n");
        responseBody.append("statusCode=0").append("\n");
        responseBody.append("statusString=successfully.").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)responseBody.toString());
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareSuccessfullyWithPartialResponse() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/macbinary"}).andReturn((Object)fileBody);
        multipart.addPart("file", (ContentBody)fileBody);
        StringBody stringBody = (StringBody)PowerMock.createMock(StringBody.class);
        PowerMock.expectNew(StringBody.class, (Object[])new Object[]{""}).andReturn((Object)stringBody);
        multipart.addPart("send", (ContentBody)stringBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(3);
        StringBuilder partialResponseBody1 = new StringBuilder();
        partialResponseBody1.append("version=1.0.0").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody1.toString()).times(1);
        StringBuilder partialResponseBody2 = new StringBuilder();
        partialResponseBody2.append("requestURI=cgi-bin/upgradeFirmware.cgi").append("\n");
        partialResponseBody2.append("statusCode=0").append("\n");
        partialResponseBody2.append("statusString=successfully.").append("\n");
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody2.toString()).times(1);
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureWithPartialResponse() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/macbinary"}).andReturn((Object)fileBody);
        multipart.addPart("file", (ContentBody)fileBody);
        StringBody stringBody = (StringBody)PowerMock.createMock(StringBody.class);
        PowerMock.expectNew(StringBody.class, (Object[])new Object[]{""}).andReturn((Object)stringBody);
        multipart.addPart("send", (ContentBody)stringBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(7);
        StringBuilder partialResponseBody = new StringBuilder();
        partialResponseBody.append("version=1.0.0").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody.toString()).times(1);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)"").times(5);
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailure() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/macbinary"}).andReturn((Object)fileBody);
        multipart.addPart("file", (ContentBody)fileBody);
        StringBody stringBody = (StringBody)PowerMock.createMock(StringBody.class);
        PowerMock.expectNew(StringBody.class, (Object[])new Object[]{""}).andReturn((Object)stringBody);
        multipart.addPart("send", (ContentBody)stringBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(2);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("version=1.0.0").append("\n");
        responseBody.append("requestURI=cgi-bin/upgradeFirmware.cgi").append("\n");
        responseBody.append("statusCode=1").append("\n");
        responseBody.append("statusString=failure.").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)responseBody.toString()).times(1);
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareCanNotReadFirmwareFile() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureFirmwareFileIsNotFile() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureFirmwareFileNotExists() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureEmptyResponseEntity() throws Exception {
        this.cameraBrickcomGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraBrickcomGeneric.setGdtServerPort(1443);
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/upgradeFirmware.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/macbinary"}).andReturn((Object)fileBody);
        multipart.addPart("file", (ContentBody)fileBody);
        StringBody stringBody = (StringBody)PowerMock.createMock(StringBody.class);
        PowerMock.expectNew(StringBody.class, (Object[])new Object[]{""}).andReturn((Object)stringBody);
        multipart.addPart("send", (ContentBody)stringBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        EasyMock.expect((Object)response.getEntity()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }
}

