/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.brickcom;

import com.allen_sauer.gwt.log.client.Log;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.SearchWlanAccessPointsService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandler;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.UpdatedSettingsListener;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGenericTests;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;
import pl.smartapps.containerserver.landevice.multipart.Multipart;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraBrickcomGeneric.class})
public class CameraBrickcomGenericTests {
    private CameraBrickcomGeneric cameraBrickcomGeneric;
    private AuthenticationUtils authUtils;
    private LanDeviceService lanDeviceService;
    private UpdateSettingsHandlerFactory updateHandlerFactory;
    private UpdateSettingsHandler updateSettingsHandler;
    private DeviceDescDAO deviceDescDAO;
    private ContainerserverServiceFactory serviceFactory;
    private SearchWlanAccessPointsService searchWlanAccessPointsService;
    private SystemSupport systemSupport;
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.cameraBrickcomGeneric = new CameraBrickcomGeneric();
        this.cameraBrickcomGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.cameraBrickcomGeneric.setAuthUtils(this.authUtils);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.cameraBrickcomGeneric.setLanDeviceService(this.lanDeviceService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.cameraBrickcomGeneric.setParameterService(this.parameterService);
        this.updateHandlerFactory = (UpdateSettingsHandlerFactory)PowerMock.createMock(UpdateSettingsHandlerFactory.class);
        this.cameraBrickcomGeneric.setUpdateHandlerFactory(this.updateHandlerFactory);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.cameraBrickcomGeneric.setDeviceDescDAO(this.deviceDescDAO);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.cameraBrickcomGeneric.setServiceFactory(this.serviceFactory);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.cameraBrickcomGeneric.setSystemSupport(this.systemSupport);
        this.updateSettingsHandler = (UpdateSettingsHandler)PowerMock.createMock(UpdateSettingsHandler.class);
        this.searchWlanAccessPointsService = (SearchWlanAccessPointsService)PowerMock.createMock(SearchWlanAccessPointsService.class);
    }

    @Test
    public void testVerifyFailureDeviceNull() {
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice device = null;
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureMacAddressNull() {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac(null);
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureIpAddressNull() {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress(null);
        device.setDeleted(Boolean.valueOf(false));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureGatewayClientNull() {
        LanDevice device = new LanDevice();
        device.setGatewayClient(null);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifySuccessfulyWithoutInitialUsernameAndPassword() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService channelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)channelsClient);
        URL channelsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?action=get");
        EasyMock.expect((Object)channelsClient.get("00:1A:B6:00:0B:B5", channelsUrl)).andReturn((Object)this.prepareChannelsResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService usersClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)usersClient);
        URL usersUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?action=getUsers");
        EasyMock.expect((Object)usersClient.get("00:1A:B6:00:0B:B5", usersUrl)).andReturn((Object)this.prepareUsersResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5", false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(null);
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDevice veryfiedDevice = new LanDevice();
        veryfiedDevice.setGatewayClient(TestDataUtils.prepareGatewaClient());
        veryfiedDevice.setMac("00:1A:B6:00:0B:B5");
        veryfiedDevice.setIpAddress("127.0.0.1");
        veryfiedDevice.setDeleted(Boolean.valueOf(false));
        veryfiedDevice.setPort(Integer.valueOf(80));
        veryfiedDevice.setUser("admin");
        veryfiedDevice.setPass("admin");
        veryfiedDevice.setVersion("v3.1.0.1");
        Assert.assertEquals((Object)veryfiedDevice, (Object)device);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifySuccessfulyWithInitialUsernameAndPassword() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService channelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)channelsClient);
        URL channelsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?action=get");
        EasyMock.expect((Object)channelsClient.get("00:1A:B6:00:0B:B5", channelsUrl)).andReturn((Object)this.prepareChannelsResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService usersClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)usersClient);
        URL usersUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?action=getUsers");
        EasyMock.expect((Object)usersClient.get("00:1A:B6:00:0B:B5", usersUrl)).andReturn((Object)this.prepareUsersResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5", true));
        HashMap alreadyStoredCapabilities = new HashMap();
        HashMap<String, String> otherDeviceCapabilities = new HashMap<String, String>();
        otherDeviceCapabilities.put("k1", "v1");
        otherDeviceCapabilities.put("k2", "v2");
        otherDeviceCapabilities.put("k3", "v3");
        otherDeviceCapabilities.put("k4", "v4");
        otherDeviceCapabilities.put("k5", "v5");
        alreadyStoredCapabilities.put("00:00:00:00:00:00", otherDeviceCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(alreadyStoredCapabilities);
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:00:00:00:00:00", otherDeviceCapabilities);
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "001AB6000BB5", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDevice veryfiedDevice = new LanDevice();
        veryfiedDevice.setGatewayClient(TestDataUtils.prepareGatewaClient());
        veryfiedDevice.setMac("00:1A:B6:00:0B:B5");
        veryfiedDevice.setIpAddress("127.0.0.1");
        veryfiedDevice.setDeleted(Boolean.valueOf(false));
        veryfiedDevice.setPort(Integer.valueOf(80));
        veryfiedDevice.setUser("testUsername");
        veryfiedDevice.setPass("testPassword");
        veryfiedDevice.setVersion("v3.1.0.1");
        Assert.assertEquals((Object)veryfiedDevice, (Object)device);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureError() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService channelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)channelsClient);
        URL channelsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?action=get");
        EasyMock.expect((Object)channelsClient.get("00:1A:B6:00:0B:B5", channelsUrl)).andReturn((Object)this.prepareChannelsResponse(HTTPClientServiceResult.Result.ERROR));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDevice veryfiedDevice = new LanDevice();
        veryfiedDevice.setGatewayClient(TestDataUtils.prepareGatewaClient());
        veryfiedDevice.setMac("00:1A:B6:00:0B:B5");
        veryfiedDevice.setIpAddress("127.0.0.1");
        veryfiedDevice.setDeleted(Boolean.valueOf(false));
        veryfiedDevice.setPort(Integer.valueOf(80));
        veryfiedDevice.setUser("admin");
        veryfiedDevice.setPass("admin");
        Assert.assertEquals((Object)veryfiedDevice, (Object)device);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureNoAccess() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.NOACCESS));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.NOACCESS;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDevice veryfiedDevice = new LanDevice();
        veryfiedDevice.setGatewayClient(TestDataUtils.prepareGatewaClient());
        veryfiedDevice.setMac("00:1A:B6:00:0B:B5");
        veryfiedDevice.setIpAddress("127.0.0.1");
        veryfiedDevice.setDeleted(Boolean.valueOf(false));
        veryfiedDevice.setPort(Integer.valueOf(80));
        veryfiedDevice.setUser("admin");
        veryfiedDevice.setPass("admin");
        Assert.assertEquals((Object)veryfiedDevice, (Object)device);
        PowerMock.verifyAll();
    }

    @Test
    public void testVerifyFailureNoAnswer() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.NOANSWER));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.verify(device);
        AccessVerificationStatus expectedResponse = AccessVerificationStatus.NOANSWER;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDevice veryfiedDevice = new LanDevice();
        veryfiedDevice.setGatewayClient(TestDataUtils.prepareGatewaClient());
        veryfiedDevice.setMac("00:1A:B6:00:0B:B5");
        veryfiedDevice.setIpAddress("127.0.0.1");
        veryfiedDevice.setDeleted(Boolean.valueOf(false));
        veryfiedDevice.setPort(Integer.valueOf(80));
        veryfiedDevice.setUser("admin");
        veryfiedDevice.setPass("admin");
        Assert.assertEquals((Object)veryfiedDevice, (Object)device);
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureDeviceNull() {
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(null, "");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureDeviceMacAddressNull() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setMac(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testInitFailureDeviceIpAddressNull() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setIpAddress(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testInitSuccessfulyWithViewerUserRegistration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[]{pl.smartapps.restserver.util.Utils.class});
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDevice(false), device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[]{pl.smartapps.restserver.util.Utils.class});
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDevice(false), device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithNotNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setParam("video_quality", "BEST", "BEST");
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[]{pl.smartapps.restserver.util.Utils.class});
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        LanDeviceEntity expectedDevice = this.prepareExpectedDevice(false);
        expectedDevice.setParam("video_quality", "BEST", "BEST");
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("20", "60"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    public void testInitWithWifi(StringBuilder wifiSettings, LanDeviceEntity expectedDevice) throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService downloadWifiSettingsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)downloadWifiSettingsClient);
        URL downloadWifiSettingsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?action=get");
        EasyMock.expect((Object)downloadWifiSettingsClient.get("00:1A:B6:00:0B:B5", downloadWifiSettingsUrl)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, wifiSettings));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.verifyDevice(expectedDevice, device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitWithNoneSecuredWifiAndInfrastructureWlanMode() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareOpenWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 3, false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi("smart-apps", "INFRASTRUCTURE", "3", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithNoneSecuredWifiAndAdHocWlanMode() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareOpenWifiSettings("smart-apps", WlanMode.AD_HOC, 1, false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithOpenWifi("smart-apps", "AD_HOC", "1", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndAutoAuthModeAndAsciiKeyFormantAnd128BitsKeyLength() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.AUTO, ReadWepKeyType.ASCII_128_OLD_FIRMWARE, 1, "1234567890", "2345678901", "3456789012", "4567890123", false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "AUTO", "LENGTH_128_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndOpenAuthModeAndAsciiKeyFormantAnd64BitsKeyLength() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.OPEN, ReadWepKeyType.ASCII_64_OLD_FIRMWARE, 2, "1234567890", "2345678901", "3456789012", "4567890123", false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "OPEN", "LENGTH_64_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "2", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndSharedAuthModeAndHexKeyFormantAnd128BitsKeyLength() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.SHARED, ReadWepKeyType.HEX_128_OLD_FIRMWARE, 3, "1234567890", "2345678901", "3456789012", "4567890123", false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "SHARED", "LENGTH_128_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "3", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndAutoAuthModeAndHexKeyFormantAnd64BitsKeyLength() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.AUTO, ReadWepKeyType.HEX_64_OLD_FIRMWARE, 4, "1234567890", "2345678901", "3456789012", "4567890123", false);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "AUTO", "LENGTH_64_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "4", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndAutoAuthModeAndAsciiKeyFormantAnd128BitsKeyLengthForNewFirmware() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.AUTO, ReadWepKeyType.ASCII_128_NEW_FIRMWARE, 1, "1234567890", "2345678901", "3456789012", "4567890123", true);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "AUTO", "LENGTH_128_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "1", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndOpenAuthModeAndAsciiKeyFormantAnd64BitsKeyLengthForNewFirmware() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.OPEN, ReadWepKeyType.ASCII_64_NEW_FIRMWARE, 2, "1234567890", "2345678901", "3456789012", "4567890123", true);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "OPEN", "LENGTH_64_BITS", "ASCII", "1234567890", "2345678901", "3456789012", "4567890123", "2", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndSharedAuthModeAndHexKeyFormantAnd128BitsKeyLengthForNewFirmware() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.SHARED, ReadWepKeyType.HEX_128_NEW_FIRMWARE, 3, "1234567890", "2345678901", "3456789012", "4567890123", true);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "SHARED", "LENGTH_128_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "3", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWepSecuredWifiAndAutoAuthModeAndHexKeyFormantAnd64BitsKeyLengthForNewFirmware() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWepWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 2, WepAuthenticationType.AUTO, ReadWepKeyType.HEX_64_NEW_FIRMWARE, 4, "1234567890", "2345678901", "3456789012", "4567890123", true);
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWepWifi("smart-apps", "INFRASTRUCTURE", "2", "AUTO", "LENGTH_64_BITS", "HEX", "1234567890", "2345678901", "3456789012", "4567890123", "4", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWpaSecuredWifiWithTkipAlgorithm() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWpaWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 6, Encryption.WPA, Algorithm.TKIP, "testpassword");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi("smart-apps", "INFRASTRUCTURE", "6", "WPA", "TKIP", "testpassword", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWpaSecuredWifiWithAesAlgorithm() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWpaWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 6, Encryption.WPA, Algorithm.AES, "testpassword");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi("smart-apps", "INFRASTRUCTURE", "6", "WPA", "AES_CCMP", "testpassword", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWpa2SecuredWifiWithTkipAlgorithm() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWpaWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 6, Encryption.WPA2, Algorithm.TKIP, "testpassword");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi("smart-apps", "INFRASTRUCTURE", "6", "WPA2", "TKIP", "testpassword", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWith2WpaSecuredWifiWithAesAlgorithm() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWpaWifiSettings("smart-apps", WlanMode.INFRASTRUCTURE, 6, Encryption.WPA2, Algorithm.AES, "testpassword");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi("smart-apps", "INFRASTRUCTURE", "6", "WPA2", "AES_CCMP", "testpassword", "ON");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitWithWifiDisabled() throws MalformedURLException {
        StringBuilder openWifiSettings = this.prepareWpaWifiSettings("Brickcom", WlanMode.INFRASTRUCTURE, 6, Encryption.OPEN, Algorithm.AES, "testpassword");
        LanDeviceEntity expectedDevice = this.prepareExpectedDeviceWithWpaWifi("", "", "", "", "", "", "OFF");
        this.testInitWithWifi(openWifiSettings, expectedDevice);
    }

    @Test
    public void testInitViewerUserRegistrationFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService regiserUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)regiserUserClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)regiserUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitSuccessfulyWithViewerUserUpdating() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDevice(false), device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitSuccessfulyWithViewerUserUpdatingAndEventUpdating() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", false));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService regiserUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)regiserUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)regiserUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient1);
        Capture addEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient1.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)addEventUrlCapture))).andReturn((Object)this.prepareEventAlredyExistsResponse());
        HTTPClientService configureEventClient2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient2);
        Capture updateEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient2.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.OK;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.verifyDevice(this.prepareExpectedDevice(false), device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)addEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, true), (Capture)updateEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitEventUpdatingFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService regiserUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)regiserUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)regiserUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient1);
        Capture addEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient1.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)addEventUrlCapture))).andReturn((Object)this.prepareEventAlredyExistsResponse());
        HTTPClientService configureEventClient2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient2);
        Capture updateEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient2.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)addEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, true), (Capture)updateEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitViewerUserUpdatingFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", false, null, true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService registerViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerUserClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "4", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigureChannelsFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService regiserUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)regiserUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)regiserUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigureLedFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigurePrivacyButtonFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigureHttpNotificationFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigurePirSensorFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitConfigureEventFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities);
        HTTPClientService updateViewerUserClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)updateViewerUserClient);
        Capture updateViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)updateViewerUserClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)updateViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        GenericLanDevice.ConfigurationStatus response = this.cameraBrickcomGeneric.init(device, "admin");
        GenericLanDevice.ConfigurationStatus expectedResponse = GenericLanDevice.ConfigurationStatus.FAILED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(false, "4", "viewerUser", "viewerPassword"), (Capture)updateViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableSomeSupportedSettings() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "ON", "OFF");
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "ON", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        device.getLanDeviceParams().add(ledOffParam);
        device.getLanDeviceParams().add(privacyButtonParam);
        device.getLanDeviceParams().add(motionDetectionParam);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        String enableLedOffUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?off=1&action=set";
        HTTPClientService httpClientService1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService1);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService1, enableLedOffUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{ledOffParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enableMotionDetectionUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?enabled=1&name=HOMEMONITOR_PIR&action=updateEventSetting";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService3, enableMotionDetectionUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enablePrivacyButtonUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/camera.cgi?action=setPrivacy&privacyButtonEnabled=1";
        HTTPClientService httpClientService2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService2);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService2, enablePrivacyButtonUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{privacyButtonParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableAllSupportedSettings() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "ON");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "OFF", "ON");
        device.getLanDeviceParams().add(ledOffParam);
        device.getLanDeviceParams().add(privacyButtonParam);
        device.getLanDeviceParams().add(motionDetectionParam);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        String enableLedOffUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?off=0&action=set";
        HTTPClientService httpClientService1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService1);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService1, enableLedOffUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{ledOffParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enableMotionDetectionUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?enabled=0&name=HOMEMONITOR_PIR&action=updateEventSetting";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService3, enableMotionDetectionUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enablePrivacyButtonUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/camera.cgi?action=setPrivacy&privacyButtonEnabled=0";
        HTTPClientService httpClientService2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService2);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService2, enablePrivacyButtonUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{privacyButtonParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSomeSupportedSettings() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        device.getLanDeviceParams().add(ledOffParam);
        device.getLanDeviceParams().add(privacyButtonParam);
        device.getLanDeviceParams().add(motionDetectionParam);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        String enableLedOffUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?off=0&action=set";
        HTTPClientService httpClientService1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService1);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService1, enableLedOffUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{ledOffParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enableMotionDetectionUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?enabled=1&name=HOMEMONITOR_PIR&action=updateEventSetting";
        HTTPClientService httpClientService2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService2);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService2, enableMotionDetectionUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSomeSupportedSettingsAndWifiSettings() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "OFF");
        LanDeviceParamEntity wifiSsid = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssid = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannel = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryption = new LanDeviceParamEntity("wifi_encryption", "WPA", "OPEN");
        LanDeviceParamEntity wifiAlgorithm = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "NONE");
        LanDeviceParamEntity wifiPassword = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "");
        device.getLanDeviceParams().add(ledOffParam);
        device.getLanDeviceParams().add(privacyButtonParam);
        device.getLanDeviceParams().add(motionDetectionParam);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"");
        String enableLedOffUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?off=0&action=set";
        HTTPClientService httpClientService1 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService1);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService1, enableLedOffUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{ledOffParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String enableMotionDetectionUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?enabled=1&name=HOMEMONITOR_PIR&action=updateEventSetting";
        HTTPClientService httpClientService2 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService2);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService2, enableMotionDetectionUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{motionDetectionParam}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        String updateWifiSettingsUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?SSID=linksys&action=set&securityMode=2&WPA.algorithmType=1&channel=0&WPA.sharedKey=wifipassword&mode=0";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService3, updateWifiSettingsUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsid, wifiBssid, wifiChannel, wifiEncryption, wifiAlgorithm, wifiPassword}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisableWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "OFF", "ON");
        device.getLanDeviceParams().add(wifiEnabled);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"10");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"30");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"linksys");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"00:1E:2A:50:ED:40");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"6");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"WPA");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"AES_CCMP");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"wifipassword");
        String updateWifiSettingsUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?SSID=Brickcom&action=set&securityMode=0";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService3, updateWifiSettingsUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiEnabled}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testEnableWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity wifiEnabled = new LanDeviceParamEntity("wifi_enabled", "ON", "OFF");
        device.getLanDeviceParams().add(wifiEnabled);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"10");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"30");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"linksys");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"00:1E:2A:50:ED:40");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"6");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"WPA");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"AES_CCMP");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"wifipassword");
        String updateWifiSettingsUrl = "http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?SSID=linksys&action=set&securityMode=2&WPA.algorithmType=1&channel=0&WPA.sharedKey=wifipassword&mode=0";
        HTTPClientService httpClientService3 = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService3);
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance(httpClientService3, updateWifiSettingsUrl, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this.cameraBrickcomGeneric, Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiEnabled}))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testNoSupportedSettingsNeedsUpdate() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        LanDeviceParamEntity ledOffParam = new LanDeviceParamEntity("system_ledoff", "OFF", "OFF");
        LanDeviceParamEntity privacyButtonParam = new LanDeviceParamEntity("privacy_button", "OFF", "OFF");
        LanDeviceParamEntity motionDetectionParam = new LanDeviceParamEntity("motion_detection", "ON", "ON");
        device.getLanDeviceParams().add(ledOffParam);
        device.getLanDeviceParams().add(privacyButtonParam);
        device.getLanDeviceParams().add(motionDetectionParam);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessCorrectUpdatedSettingsResponse() {
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "OFF", "OFF")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<LanDeviceParamEntity> processingParams = new ArrayList<LanDeviceParamEntity>();
        processingParams.add(processingParam);
        this.cameraBrickcomGeneric.processUpdatedSettingsResponse(null, this.preparePostResponse(HTTPClientServiceResult.Result.OK, true), processingParams);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessIncorrectUpdatedSettingsResponse() {
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<LanDeviceParamEntity> processingParams = new ArrayList<LanDeviceParamEntity>();
        processingParams.add(processingParam);
        this.cameraBrickcomGeneric.processUpdatedSettingsResponse(null, this.preparePostResponse(HTTPClientServiceResult.Result.OK, false), processingParams);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessIncorrectUpdatedSettingsResponse2() {
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("system_ledoff", "OFF", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "system_ledoff", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<LanDeviceParamEntity> processingParams = new ArrayList<LanDeviceParamEntity>();
        processingParams.add(processingParam);
        this.cameraBrickcomGeneric.processUpdatedSettingsResponse(null, this.prepareResponse(HTTPClientServiceResult.Result.NOACCESS, null), processingParams);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusSuccessfuly() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.OK, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailureIncompatibleMac() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://testUsername:testPassword@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "0A:1A:B6:00:0B:B8"));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOANSWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailureEmptyResponseBody() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, new StringBuilder()));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailureErrorResponse() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.ERROR, "00:1A:B6:00:0B:B8"));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailureNoAccessResponse() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.NOACCESS, "00:1A:B6:00:0B:B8"));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOACCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckStatusFailureNoAnswerResponse() throws MalformedURLException {
        LanDevice device = new LanDevice();
        device.setGatewayClient(TestDataUtils.prepareGatewaClient());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        device.setPort(Integer.valueOf(80));
        device.setUser("testUsername");
        device.setPass("testPassword");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.NOANSWER, "00:1A:B6:00:0B:B8"));
        PowerMock.replayAll((Object[])new Object[0]);
        AccessVerificationStatus response = this.cameraBrickcomGeneric.checkStatus(device);
        Assert.assertEquals((Object)AccessVerificationStatus.NOANSWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMacAddressSuccessfuly() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.cameraBrickcomGeneric.getMacAddress(device);
        Assert.assertEquals((Object)"00:1A:B6:00:0B:B5", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMacAddressWithLowerCaseSuccessfuly() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1a:b6:00:0b:b5"));
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.cameraBrickcomGeneric.getMacAddress(device);
        Assert.assertEquals((Object)"00:1A:B6:00:0B:B5", (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMacAddressIncorrectResponse() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.NOACCESS, "00:1a:b6:00:0b:b5"));
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.cameraBrickcomGeneric.getMacAddress(device);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMacAddressResponseDoNotContainMac() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL url = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", url)).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, new StringBuilder()));
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.cameraBrickcomGeneric.getMacAddress(device);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetWirelessNetworksSuccessfulyForRegularForm() {
        EasyMock.expect((Object)this.serviceFactory.getSearchWlanAccessPointsService()).andReturn((Object)this.searchWlanAccessPointsService);
        StringBuilder wifiData = new StringBuilder();
        wifiData.append("          Cell 01 - Address: D8:5D:4C:86:6C:A2").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"sa\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.412 GHz (Channel 1)").append("\n");
        wifiData.append("                    Quality:89/100  Signal level:-55 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("          Cell 02 - Address: 00:1A:70:9A:6D:18").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"linksys\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.437 GHz (Channel 6)").append("\n");
        wifiData.append("                    Quality:83/100  Signal level:-57 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                    Encryption key:off").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("          Cell 03 - Address: 00:1F:F3:C3:60:24").append("\n");
        wifiData.append("                    Protocol:802.11b/g/n").append("\n");
        wifiData.append("                    ESSID:\"sa-tc\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.457 GHz").append("\n");
        wifiData.append("                    Quality:100/100  Signal level:-39 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: WPA Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (1) : TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("                    IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("          Cell 04 - Address: 00:1E:2A:50:ED:40").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"Astimar\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.462 GHz").append("\n");
        wifiData.append("                    Quality:37/100  Signal level:-75 dBm  Noise level:-70 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: WPA Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (1) : TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("          Cell 05 - Address: 76:54:8B:97:E2:AB").append("\n");
        wifiData.append("                    Protocol:802.11b/g/n").append("\n");
        wifiData.append("                    ESSID:\"wep wifi ad-hoc\"").append("\n");
        wifiData.append("                    Mode:Ad-Hoc").append("\n");
        wifiData.append("                    Frequency:2.472 GHz").append("\n");
        wifiData.append("                    Quality:100/100  Signal level:-41 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:144 Mb/s").append("\n");
        wifiData.append("          Cell 06 - Address: 00:1E:2A:50:ED:28").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"test\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.422 GHz").append("\n");
        wifiData.append("                    Quality:15/100  Signal level:-75 dBm  Noise level:-70 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: WPA Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (1) : CCMP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("          Cell 07 - Address: 00:11:22:33:44:55").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"ala ma kota\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.447 GHz").append("\n");
        wifiData.append("                    Quality:56/100  Signal level:-75 dBm  Noise level:-70 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("          Cell 08 - Address: AA:BB:CC:DD:EE:FF").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"unsupported authentication suit\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.447 GHz").append("\n");
        wifiData.append("                    Quality:56/100  Signal level:-75 dBm  Noise level:-70 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : RADIUS  ").append("\n");
        wifiData.append("          Cell 09 - Address: AA:BB:CC:DD:EE:FF").append("\n");
        wifiData.append("                    Protocol:802.11b/g").append("\n");
        wifiData.append("                    ESSID:\"dlink\"").append("\n");
        wifiData.append("                    Mode:Managed").append("\n");
        wifiData.append("                    Frequency:2.442 GHz").append("\n");
        wifiData.append("                    Quality:56/100  Signal level:-75 dBm  Noise level:-70 dBm").append("\n");
        wifiData.append("                    Encryption key:on").append("\n");
        wifiData.append("                    Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                    IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                        Group Cipher : TKIP ").append("\n");
        wifiData.append("                        Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                        Authentication Suites (1) : RADIUS PSK ").append("\n");
        wifiData.append("").append("\n");
        wifiData.append("").append("\n");
        EasyMock.expect((Object)this.searchWlanAccessPointsService.searchWlanAccessPoints("00:1A:B6:00:0B:B5")).andReturn((Object)wifiData.toString());
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity device = this.prepareDeviceToInit();
        List response = this.cameraBrickcomGeneric.getWirelessNetworks(device);
        ArrayList<WlanAccessPoint> expectedResponse = new ArrayList<WlanAccessPoint>();
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa", (String)"D8:5D:4C:86:6C:A2", (int)1, (int)89, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WEP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"linksys", (String)"00:1A:70:9A:6D:18", (int)6, (int)83, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.OPEN}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa-tc", (String)"00:1F:F3:C3:60:24", (int)10, (int)100, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP, TestDataUtils.WPA2_AES, TestDataUtils.WPA2_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"Astimar", (String)"00:1E:2A:50:ED:40", (int)11, (int)37, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.AD_HOC, (String)"wep wifi ad-hoc", (String)"76:54:8B:97:E2:AB", (int)13, (int)100, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WEP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"test", (String)"00:1E:2A:50:ED:28", (int)3, (int)15, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_AES}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"ala ma kota", (String)"00:11:22:33:44:55", (int)8, (int)56, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA2_AES, TestDataUtils.WPA2_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"dlink", (String)"AA:BB:CC:DD:EE:FF", (int)7, (int)56, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA2_AES, TestDataUtils.WPA2_TKIP}));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetWirelessNetworksSuccessfulyForUnshapelyForm() {
        EasyMock.expect((Object)this.serviceFactory.getSearchWlanAccessPointsService()).andReturn((Object)this.searchWlanAccessPointsService);
        StringBuilder wifiData = new StringBuilder();
        wifiData.append("         Cell 01 - Address: D8:5D:4C:86:6C:A2").append("\n");
        wifiData.append("                   Protocol:802.11b/g/n").append("\n");
        wifiData.append("                   ESSID:\"sa\"").append("\n");
        wifiData.append("                   Mode:Managed").append("\n");
        wifiData.append("                   Frequency:2.412 GHz (Channel 1)").append("\n");
        wifiData.append("                   Quality:100/100  Signal level:-35 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                   Encryption key:on").append("\n");
        wifiData.append("                   Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                   IE: WPA Version 1").append("\n");
        wifiData.append("                       Group Cipher : TKIP ").append("\n");
        wifiData.append("                       Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                       Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("                   IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                       Group Cipher : TKIP ").append("\n");
        wifiData.append("                       Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                       Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("                   IE: WPA Version 18960").append("\n");
        wifiData.append("                       Group Cipher : Proprietary").append("\n");
        wifiData.append("                       Pairwise Ciphers (68) :           Cell 02 - Address: 00:1A:70:9A:6D:18").append("\n");
        wifiData.append("                   Protocol:802.11b/g").append("\n");
        wifiData.append("                   ESSID:\"linksys\"").append("\n");
        wifiData.append("                   Mode:Managed").append("\n");
        wifiData.append("                   Frequency:2.437 GHz (Channel 6)").append("\n");
        wifiData.append("                   Quality:63/100  Signal level:-65 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                   Encryption key:off").append("\n");
        wifiData.append("                   Bit Rates:54 Mb/s").append("\n");
        wifiData.append("         Cell 03 - Address: 00:1F:F3:C3:60:24").append("\n");
        wifiData.append("                   Protocol:802.11b/g/n").append("\n");
        wifiData.append("                   ESSID:\"sa-tc\"").append("\n");
        wifiData.append("                   Mode:Managed").append("\n");
        wifiData.append("                   Frequency:2.457 GHz").append("\n");
        wifiData.append("                   Quality:100/100  Signal level:-41 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                   Encryption key:on").append("\n");
        wifiData.append("                   Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                   IE: WPA Version 1").append("\n");
        wifiData.append("                       Group Cipher : TKIP ").append("\n");
        wifiData.append("                       Pairwise Ciphers (1) : TKIP ").append("\n");
        wifiData.append("                       Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("                   IE: IEEE 802.11i/WPA2 Version 1").append("\n");
        wifiData.append("                       Group Cipher : TKIP ").append("\n");
        wifiData.append("                       Pairwise Ciphers (2) : CCMP TKIP ").append("\n");
        wifiData.append("                       Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("         Cell 04 - Address: 00:1E:2A:50:ED:40").append("\n");
        wifiData.append("                   Protocol:802.11b/g").append("\n");
        wifiData.append("                   ESSID:\"Astimar\"").append("\n");
        wifiData.append("                   Mode:Managed").append("\n");
        wifiData.append("                   Frequency:2.462 GHz").append("\n");
        wifiData.append("                   Quality:63/100  Signal level:-65 dBm  Noise level:-92 dBm").append("\n");
        wifiData.append("                   Encryption key:on").append("\n");
        wifiData.append("                   Bit Rates:54 Mb/s").append("\n");
        wifiData.append("                   IE: WPA Version 1").append("\n");
        wifiData.append("                       Group Cipher : TKIP ").append("\n");
        wifiData.append("                       Pairwise Ciphers (1) : TKIP ").append("\n");
        wifiData.append("                       Authentication Suites (1) : PSK  ").append("\n");
        wifiData.append("").append("\n");
        wifiData.append("").append("\n");
        EasyMock.expect((Object)this.searchWlanAccessPointsService.searchWlanAccessPoints("00:1A:B6:00:0B:B5")).andReturn((Object)wifiData.toString());
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity device = this.prepareDeviceToInit();
        List response = this.cameraBrickcomGeneric.getWirelessNetworks(device);
        ArrayList<WlanAccessPoint> expectedResponse = new ArrayList<WlanAccessPoint>();
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa", (String)"D8:5D:4C:86:6C:A2", (int)1, (int)100, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_AES, TestDataUtils.WPA_TKIP, TestDataUtils.WPA2_AES, TestDataUtils.WPA2_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"linksys", (String)"00:1A:70:9A:6D:18", (int)6, (int)63, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.OPEN}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"sa-tc", (String)"00:1F:F3:C3:60:24", (int)10, (int)100, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP, TestDataUtils.WPA2_AES, TestDataUtils.WPA2_TKIP}));
        expectedResponse.add(TestDataUtils.createWirelessNetwork((WlanAccessPoint.WlanMode)WlanAccessPoint.WlanMode.INFRASTRUCTURE, (String)"Astimar", (String)"00:1E:2A:50:ED:40", (int)11, (int)63, (EncryptionMode[])new EncryptionMode[]{TestDataUtils.WPA_TKIP}));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetWirelessNetworksFailure() {
        EasyMock.expect((Object)this.serviceFactory.getSearchWlanAccessPointsService()).andReturn((Object)this.searchWlanAccessPointsService);
        EasyMock.expect((Object)this.searchWlanAccessPointsService.searchWlanAccessPoints("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity device = this.prepareDeviceToInit();
        List response = this.cameraBrickcomGeneric.getWirelessNetworks(device);
        ArrayList expectedResponse = new ArrayList();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUnsecuredWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUnsecuredAndAdHocWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiWlanModeParam = new LanDeviceParamEntity("wifi_wlan_mode", "AD_HOC", "INFRASTRUCTURE");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiWlanModeParam, wifiChannelParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=1");
        url.append("&channel=6");
        url.append("&SSID=linksys");
        url.append("&securityMode=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetupWepSecuredWifiWithKeyLength128AndKeyFormatHexAndDefaultKey1() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"wifipassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WEP", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "WEP", "NONE");
        LanDeviceParamEntity wifiWepKeyLengthParam = new LanDeviceParamEntity("wifi_wep_key_length", "LENGTH_128_BITS", "");
        LanDeviceParamEntity wifiWepKeyFormatParam = new LanDeviceParamEntity("wifi_wep_key_format", "HEX", "");
        LanDeviceParamEntity wifiWepKey1Param = new LanDeviceParamEntity("wifi_wep_key1", "wifipassword", "");
        LanDeviceParamEntity wifiWepDefaultKeyParam = new LanDeviceParamEntity("wifi_wep_default_key", "1", "");
        LanDeviceParamEntity wifiAuthModeParam = new LanDeviceParamEntity("wifi_wep_auth_mode", "OPEN", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiWepKeyLengthParam, wifiWepKeyFormatParam, wifiWepKey1Param, wifiWepDefaultKeyParam, wifiAuthModeParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=1");
        url.append("&WEP.defaultTransmitKeyIndex=1");
        url.append("&WEP.wepKeyLength=2");
        url.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=wifipassword");
        url.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=");
        url.append("&WEP.authenticationType=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWepSecuredWifiWithKeyLength128AndKeyFormatAsciiAndDefaultKey2() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"wifipassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WEP", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "WEP", "NONE");
        LanDeviceParamEntity wifiWepKeyLengthParam = new LanDeviceParamEntity("wifi_wep_key_length", "LENGTH_128_BITS", "");
        LanDeviceParamEntity wifiWepKeyFormatParam = new LanDeviceParamEntity("wifi_wep_key_format", "ASCII", "");
        LanDeviceParamEntity wifiWepKey1Param = new LanDeviceParamEntity("wifi_wep_key1", "wifipassword", "");
        LanDeviceParamEntity wifiWepDefaultKeyParam = new LanDeviceParamEntity("wifi_wep_default_key", "2", "");
        LanDeviceParamEntity wifiAuthModeParam = new LanDeviceParamEntity("wifi_wep_auth_mode", "OPEN", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiWepKeyLengthParam, wifiWepKeyFormatParam, wifiWepKey1Param, wifiWepDefaultKeyParam, wifiAuthModeParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=1");
        url.append("&WEP.defaultTransmitKeyIndex=2");
        url.append("&WEP.wepKeyLength=4");
        url.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=wifipassword");
        url.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=");
        url.append("&WEP.authenticationType=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWepSecuredWifiWithKeyLength64AndKeyFormatHexAndDefaultKey3() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"wifipassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WEP", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "WEP", "NONE");
        LanDeviceParamEntity wifiWepKeyLengthParam = new LanDeviceParamEntity("wifi_wep_key_length", "LENGTH_64_BITS", "");
        LanDeviceParamEntity wifiWepKeyFormatParam = new LanDeviceParamEntity("wifi_wep_key_format", "HEX", "");
        LanDeviceParamEntity wifiWepKey1Param = new LanDeviceParamEntity("wifi_wep_key1", "wifipassword", "");
        LanDeviceParamEntity wifiWepDefaultKeyParam = new LanDeviceParamEntity("wifi_wep_default_key", "3", "");
        LanDeviceParamEntity wifiAuthModeParam = new LanDeviceParamEntity("wifi_wep_auth_mode", "OPEN", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiWepKeyLengthParam, wifiWepKeyFormatParam, wifiWepKey1Param, wifiWepDefaultKeyParam, wifiAuthModeParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=1");
        url.append("&WEP.defaultTransmitKeyIndex=3");
        url.append("&WEP.wepKeyLength=1");
        url.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=wifipassword");
        url.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=");
        url.append("&WEP.authenticationType=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWepSecuredWifiWithKeyLength64AndKeyFormatAsciiAndDefaultKey4() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"wifipassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WEP", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "WEP", "NONE");
        LanDeviceParamEntity wifiWepKeyLengthParam = new LanDeviceParamEntity("wifi_wep_key_length", "LENGTH_64_BITS", "");
        LanDeviceParamEntity wifiWepKeyFormatParam = new LanDeviceParamEntity("wifi_wep_key_format", "ASCII", "");
        LanDeviceParamEntity wifiWepKey1Param = new LanDeviceParamEntity("wifi_wep_key1", "wifipassword", "");
        LanDeviceParamEntity wifiWepDefaultKeyParam = new LanDeviceParamEntity("wifi_wep_default_key", "4", "");
        LanDeviceParamEntity wifiAuthModeParam = new LanDeviceParamEntity("wifi_wep_auth_mode", "OPEN", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiWepKeyLengthParam, wifiWepKeyFormatParam, wifiWepKey1Param, wifiWepDefaultKeyParam, wifiAuthModeParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=1");
        url.append("&WEP.defaultTransmitKeyIndex=4");
        url.append("&WEP.wepKeyLength=3");
        url.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=wifipassword");
        url.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=");
        url.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=");
        url.append("&WEP.authenticationType=0");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWpaTkipSecuredWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WPA", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "TKIP", "NONE");
        LanDeviceParamEntity wifiPreSharedKeyParam = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiPreSharedKeyParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=2");
        url.append("&WPA.algorithmType=0");
        url.append("&WPA.sharedKey=wifipassword");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWpaAesSecuredWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WPA", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "NONE");
        LanDeviceParamEntity wifiPreSharedKeyParam = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiPreSharedKeyParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=2");
        url.append("&WPA.algorithmType=1");
        url.append("&WPA.sharedKey=wifipassword");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testSetupWpa2AesSecuredWifi() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_limit", (String)"10", (String)"15");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"record_video", (String)"ON", (String)"OFF");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_recording_duration", (String)"30", (String)"45");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"ON");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"linksys", (String)"Brickcom");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"INFRASTRUCTURE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"00:1E:2A:50:ED:40", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"6", (String)"0");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"OPEN");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"NONE");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"wifipassword", (String)"");
        LanDeviceParamEntity wifiSsidParam = new LanDeviceParamEntity("wifi_ssid", "linksys", "Brickcom");
        LanDeviceParamEntity wifiBssidParam = new LanDeviceParamEntity("wifi_bssid", "00:1E:2A:50:ED:40", "");
        LanDeviceParamEntity wifiChannelParam = new LanDeviceParamEntity("wifi_channel", "6", "0");
        LanDeviceParamEntity wifiEncryptionParam = new LanDeviceParamEntity("wifi_encryption", "WPA2", "OPEN");
        LanDeviceParamEntity wifiAlgorithmParam = new LanDeviceParamEntity("wifi_alghoritm", "AES_CCMP", "NONE");
        LanDeviceParamEntity wifiPreSharedKeyParam = new LanDeviceParamEntity("wifi_pre_shared_key", "wifipassword", "");
        List processingParams = Utils.wrap((Object[])new LanDeviceParamEntity[]{wifiSsidParam, wifiBssidParam, wifiChannelParam, wifiEncryptionParam, wifiAlgorithmParam, wifiPreSharedKeyParam});
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        StringBuilder url = new StringBuilder();
        url.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        url.append("action=set");
        url.append("&mode=0");
        url.append("&channel=0");
        url.append("&SSID=linksys");
        url.append("&securityMode=3");
        url.append("&WPA.algorithmType=1");
        url.append("&WPA.sharedKey=wifipassword");
        Capture capturedUrl = new Capture();
        Capture processingParamsCapture = new Capture();
        EasyMock.expect((Object)this.updateHandlerFactory.getInstance((HTTPClientService)EasyMock.eq((Object)httpClientService), (String)EasyMock.capture((Capture)capturedUrl), (HttpCommand.SendMethod)EasyMock.eq((Object)HttpCommand.SendMethod.POST), (LanDeviceEntity)EasyMock.eq((Object)device), (UpdatedSettingsListener)EasyMock.eq((Object)this.cameraBrickcomGeneric), (List)EasyMock.capture((Capture)processingParamsCapture))).andReturn((Object)this.updateSettingsHandler);
        this.updateSettingsHandler.start();
        PowerMock.replayAll((Object[])new Object[0]);
        this.cameraBrickcomGeneric.updateSettings(device);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.verifyProcessingParams(processingParams, processingParamsCapture));
        Assert.assertTrue((boolean)Utils.verifyTextUrl((String)url.toString(), (Capture)capturedUrl));
    }

    @Test
    public void testUpdateSingleSettingSuccessfuly() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("illumination", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "illumination", "ON", "ON")).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.SUCCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingParamUnsupported() {
        LanDeviceEntity device = this.prepareDeviceToInit();
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "test", "test");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_PARAMUNSUPPORTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingUnexpectedParam() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "alarm_user", "alarmUser");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_PARAMUNSUPPORTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingSendRequestReturnError() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, false));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingSendRequestReturnNoAnswer() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.NOANSWER, false));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_NOANSEWER, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingSendRequestReturnNoAccess() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.NOACCESS, false));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.FAILED_NOACCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingCameraSettingUpdateFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateSingleSettingDatabaseUpdateFailure() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceToInit();
        Utils.addDeviceParam((LanDeviceEntity)device, (Integer)1, (String)"illumination", (String)"OFF", (String)"OFF");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL illuminationUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?apply=1&level=10&action=set&method=1");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", illuminationUrl)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        LanDeviceParamEntity processingParam = new LanDeviceParamEntity("illumination", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceService.updateLanDeviceParam(Integer.valueOf(1), "illumination", "ON", "ON")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.cameraBrickcomGeneric.updateSingleSetting(device, "illumination", "ON");
        Assert.assertEquals((Object)UpdateSettingStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetConnCheckUrl() {
        Assert.assertEquals((Object)"/blank.html", (Object)this.cameraBrickcomGeneric.getConnCheckUrl());
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectForNullVideo() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "10", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "10", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoFpsForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "10", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "1", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "20", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIorrectVideoFpsForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "20", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationinCorrectVideoQualityForVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "2", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoFpsForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "1", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "3", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "40", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationInorrectVideoFpsForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "2", "40", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectVideoQualityForVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "4", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "20", "60", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationInorrectVideoFpsForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "3", "60", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationincorrectVideoQualityForVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "20", "6", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpa2AesWithInfrastructureWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpa2TkipWithAdhocWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.AD_HOC, 0, Encryption.WPA2, Algorithm.TKIP, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWpaTkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA, Algorithm.TKIP, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep64Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepAuthenticationType.OPEN, WepKeyType.HEX_64, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep64Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_64, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep128Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.HEX_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiWep128Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationCorrectForWfiDisabled() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "5", "30", true, true, true, true, 0, 5, "Brickcom", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectPrivacyButtonOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectPrivacyButtonOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", false, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectLedoffOnOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", false, true, true, false, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectLedoffOnOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", false, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectViewerUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlarmUser() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlarmPassword() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectMotionDetectionOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, false, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectMotionDetectionOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectIlluminationOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, false, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectIlluminationOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, false, true, true, 10, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionOn() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, false, true, 10, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionOff() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAudioDetectionSensitivity() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectSsid() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectWlanMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectEncryption() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectAlgorithm() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestIncorrectSharedKey() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium2", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 10, 3, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, null, 0, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectAuthMode() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"AUTO", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectKeyLength() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectKeyType() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey1() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key11", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey2() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key22", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey3() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key33", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKey4() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key44", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckConfigurationTestConfigurationIncorrectWepKeyIndex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        URL cababilitiesUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/configfile.dump");
        HTTPClientServiceResult capabilitiesResponse = this.prepareDeviceConfigResponse("viewerUser", "viewerPassword", "alarmUser", "alarmPassword", "10", "30", true, true, true, true, 0, 5, "smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, "", WepAuthenticationType.OPEN, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1, HTTPClientServiceResult.Result.OK);
        EasyMock.expect((Object)httpClientService.get("00:1A:B6:00:0B:B5", cababilitiesUrl)).andReturn((Object)capabilitiesResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckConfigurationStatus response = this.cameraBrickcomGeneric.checkConfiguration(device);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithNullVideoQuality() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityAcceptable() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"ACCEPTABLE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("2", "10"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityModerate() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"MODERATE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("3", "20"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityVeryGood() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"VERY_GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("10", "40"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithVideoQualityBest() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"BEST", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("20", "60"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOnAndWithWifiWpa2Aes() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"AES_CCMP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(true), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(true), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(true, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(10), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(true, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA2, Algorithm.AES, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOffAndWithWifiWpa2Tkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"AD_HOC", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.AD_HOC, 0, Encryption.WPA2, Algorithm.TKIP, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithAllParamsOffAndWithWifiWpaTkip() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WPA, Algorithm.TKIP, "1$millennium", null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiOpen() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"NONE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep64Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepKeyType.HEX_64, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep128Hex() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"HEX", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepKeyType.HEX_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep64Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_64_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepKeyType.ASCII_64, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithWifiWep128Ascii() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureSuccessfulyWithDisabledWifi() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"0", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WPA", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"TKIP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"1$millennium", (String)"");
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.OK, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("Brickcom", null, -1, Encryption.OPEN, null, null, null, null, null, null, null, -1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureDownloadsDeviceCapabilities() throws MalformedURLException {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.NOACCESS, "00:1A:B6:00:0B:B5"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.ERROR, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureWifiConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureTimeClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureTimeClient);
        Capture configureTimeUrlCapture = new Capture();
        EasyMock.expect((Object)configureTimeClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureTimeUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureWifiClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureWifiClient);
        Capture configureWifiUrlCapture = new Capture();
        EasyMock.expect((Object)configureWifiClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureWifiUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationTimeRequest(), (Capture)configureTimeUrlCapture));
        String configureWifiUrl = this.prepareConfigurationWifiRequest("smart-apps", WlanMode.INFRASTRUCTURE, 0, Encryption.WEP, null, null, WepKeyType.ASCII_128, "key1", "key2", "key3", "key4", 1);
        Assert.assertTrue((boolean)Utils.verifyUrl((String)configureWifiUrl, (Capture)configureWifiUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureAudioDetectionEventConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionEventClient);
        Capture configureAudioDetectionEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationAudioDetectionEventRequest(false, false), (Capture)configureAudioDetectionEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureAudioDetectionSensitivityConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureAudioDetectionSensitivityClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureAudioDetectionSensitivityClient);
        Capture configureAudioDetectionSensitivityUrlCapture = new Capture();
        EasyMock.expect((Object)configureAudioDetectionSensitivityClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureAudioDetectionSensitivityUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigurationAudioDetectionSensitivityRequest(Integer.valueOf(5)), (Capture)configureAudioDetectionSensitivityUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureIlluminationConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureIlluminationClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureIlluminationClient);
        Capture configureIlluminationUrlCapture = new Capture();
        EasyMock.expect((Object)configureIlluminationClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureIlluminationUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationIlluminationRequest(0), (Capture)configureIlluminationUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailurePirConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePirSensorClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePirSensorClient);
        Capture configurePirSensorUrlCapture = new Capture();
        EasyMock.expect((Object)configurePirSensorClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePirSensorUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPirSensorRequest(), (Capture)configurePirSensorUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureHttpNotificationConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureHttpNotificationsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureHttpNotificationsClient);
        Capture configureHttpNotificationsUrlCapture = new Capture();
        EasyMock.expect((Object)configureHttpNotificationsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureHttpNotificationsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationHttpNotificationsRequest(), (Capture)configureHttpNotificationsUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureMotionDetectionEventConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureEventClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureEventClient);
        Capture configureEventUrlCapture = new Capture();
        EasyMock.expect((Object)configureEventClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureEventUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationMotionDetectionEventRequest(false, false), (Capture)configureEventUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailurePrivacyButtonConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configurePrivacyButtonClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configurePrivacyButtonClient);
        Capture configurePrivacyButtonUrlCapture = new Capture();
        EasyMock.expect((Object)configurePrivacyButtonClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configurePrivacyButtonUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationPrivacyButtonRequest(false), (Capture)configurePrivacyButtonUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureLedConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        HTTPClientService configureLedClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureLedClient);
        Capture configureLedUrlCapture = new Capture();
        EasyMock.expect((Object)configureLedClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureLedUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationLedRequest(false), (Capture)configureLedUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureChannelsConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDesc("camera", "Brickcom", "WCB-100Ap")).andReturn((Object)CameraBrickcomGenericTests.prepareDeviceDescEntity());
        HTTPClientService configureChannelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)configureChannelsClient);
        Capture configureChannelsUrlCapture = new Capture();
        EasyMock.expect((Object)configureChannelsClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)configureChannelsUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareConfigrationChannelRequest("5", "30"), (Capture)configureChannelsUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureFailureUsersConfiguration() throws MalformedURLException {
        LanDeviceEntity device = this.prepareDeviceForFailureReconfigurationTests();
        this.downloadDeviceCapabilities();
        HashMap<String, Map> storedCapabilities = new HashMap<String, Map>();
        storedCapabilities.put("00:1A:B6:00:0B:B5", this.prepareDeviceCapabilities("00:1A:B6:00:0B:B5", true, "viewerUser", true));
        this.authUtils.storeData("device_cababilities", storedCapabilities);
        EasyMock.expect((Object)this.authUtils.getStoredData("device_cababilities")).andReturn(storedCapabilities).times(2);
        HTTPClientService registerViewerClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)registerViewerClient);
        Capture registerViewerUserUrlCapture = new Capture();
        EasyMock.expect((Object)registerViewerClient.post((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)registerViewerUserUrlCapture))).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.ERROR, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)GenericLanDevice.ConfigurationStatus.FAILED, (Object)this.cameraBrickcomGeneric.reconfigure(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)this.prepareViewerUserRequest(true, "5", "viewerUser", "viewerPassword"), (Capture)registerViewerUserUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionSuccessfully() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, new StringBuilder("macAddress=ac:81:12:25:76:41\nfirmwareVersion=1.1")));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"1.1", (Object)this.cameraBrickcomGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/system.cgi?action=get", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionFailureMissingVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, new StringBuilder("macAddress=ac:81:12:25:76:41\n")));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/system.cgi?action=get", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionFailureEmptyResponseBody() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.OK, new StringBuilder()));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/system.cgi?action=get", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionNoAnswer() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOANSWER, new StringBuilder()));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/system.cgi?action=get", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetVersionNoAccess() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        HTTPClientService getVersionClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)getVersionClient);
        Capture getVersionUrlCapture = new Capture();
        EasyMock.expect((Object)getVersionClient.get((String)EasyMock.eq((Object)"00:1A:B6:00:0B:B5"), (URL)EasyMock.capture((Capture)getVersionUrlCapture))).andReturn((Object)this.prepareResponse(HTTPClientServiceResult.Result.NOACCESS, new StringBuilder()));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.getVersion(device));
        Assert.assertTrue((boolean)Utils.verifyUrl((String)"http://root:rootPass@192.168.21.138:80/cgi-bin/system.cgi?action=get", (Capture)getVersionUrlCapture));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDate() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("123");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.cameraBrickcomGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareObsolete() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("1234");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.cameraBrickcomGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDateNullFirmwareVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsFirmwareUpToDateEmptyFirmwareVersion() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        device.setVersion("123");
        device.getDeviceDesc().setFirmwareVersion("");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.cameraBrickcomGeneric.isFirmwareUpToDate(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore
    public void testUpgradeFirmwareOldSuccessfully() throws Exception {
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/macbinary");
        firmwareBody.setContentDisposition("form-data", "file", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        BodyPart sendBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)sendBody);
        sendBody.setContentDisposition("form-data", "send", null);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        multipart.addPart(sendBody);
        byte[] multipartBody = new byte[10];
        EasyMock.expect((Object)multipart.getBytes()).andReturn((Object)multipartBody);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setTimeout(Integer.valueOf(900));
        URL upgradeFirmwareUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/upgradeFirmware.cgi");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "multipart/form-data; boundary=--boundry1234");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", upgradeFirmwareUrl, headers, multipartBody)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, true));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore
    public void testUpgradeFirmwareOldFailureCameraResponse() throws Exception {
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/macbinary");
        firmwareBody.setContentDisposition("form-data", "file", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        BodyPart sendBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)sendBody);
        sendBody.setContentDisposition("form-data", "send", null);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        multipart.addPart(sendBody);
        byte[] multipartBody = new byte[10];
        EasyMock.expect((Object)multipart.getBytes()).andReturn((Object)multipartBody);
        HTTPClientService httpClientService = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)httpClientService);
        httpClientService.setTimeout(Integer.valueOf(900));
        URL upgradeFirmwareUrl = new URL("http://root:rootPass@192.168.21.138:80/cgi-bin/upgradeFirmware.cgi");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "multipart/form-data; boundary=--boundry1234");
        EasyMock.expect((Object)httpClientService.post("00:1A:B6:00:0B:B5", upgradeFirmwareUrl, headers, multipartBody)).andReturn((Object)this.preparePostResponse(HTTPClientServiceResult.Result.OK, false));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore
    public void testUpgradeFirmwareOldEmptyMultipartBody() throws Exception {
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/macbinary");
        firmwareBody.setContentDisposition("form-data", "file", "new_firmware.bin");
        byte[] firmware = new byte[5];
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        firmwareBody.setBody(firmware);
        BodyPart sendBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)sendBody);
        sendBody.setContentDisposition("form-data", "send", null);
        Multipart multipart = (Multipart)PowerMock.createMock(Multipart.class);
        PowerMock.expectNew(Multipart.class, (Object[])new Object[]{"--boundry1234"}).andReturn((Object)multipart);
        multipart.addPart(firmwareBody);
        multipart.addPart(sendBody);
        EasyMock.expect((Object)multipart.getBytes()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    @Ignore
    public void testUpgradeFirmwareOldEmptyFirmware() throws Exception {
        this.cameraBrickcomGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        BodyPart firmwareBody = (BodyPart)PowerMock.createMock(BodyPart.class);
        PowerMock.expectNew(BodyPart.class, (Object[])new Object[0]).andReturn((Object)firmwareBody);
        firmwareBody.setContentType("application/macbinary");
        firmwareBody.setContentDisposition("form-data", "file", "new_firmware.bin");
        EasyMock.expect((Object)this.systemSupport.readFile("/firmwares//new_firmware.bin")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraBrickcomGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRSSILowerVersion() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity ld = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ld.getGatewayClient().setVersion("2.7");
        Integer response = this.cameraBrickcomGeneric.checkRSSI(ld);
        Assert.assertEquals((Object)83, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRSSIEqualVersion() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan-rssi.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity ld = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ld.getGatewayClient().setVersion("2.8");
        Integer response = this.cameraBrickcomGeneric.checkRSSI(ld);
        Assert.assertEquals((Object)83, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRSSIGreaterVersion() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "scanwlan-rssi.sh")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity ld = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ld.getGatewayClient().setVersion("2.9");
        Integer response = this.cameraBrickcomGeneric.checkRSSI(ld);
        Assert.assertEquals((Object)83, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRSSINullVersion() {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDeviceEntity ld = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ld.getGatewayClient().setVersion(null);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(ld);
        Assert.assertEquals((Object)83, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiSuccessfully() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)83, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiForDisabledWirelessSuccessfully() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)-1, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureTooFewLines() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureTooManyLines() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000   83.  -36   -66        0      0      0      0      0        0").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureTooFewValues() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        StringBuilder cmdRsp = new StringBuilder();
        cmdRsp.append("Inter-| sta-|   Quality        |   Discarded packets               | Missed | WE").append("\n");
        cmdRsp.append(" face | tus | link level noise |  nwid  crypt   frag  retry   misc | beacon | 19").append("\n");
        cmdRsp.append("   ra0: 0000                                                               ").append("\n");
        CommandResult result = new CommandResult();
        result.setOutput(cmdRsp.toString());
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn((Object)result);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureExecuteCommand() throws InvalidSessionException {
        ExecCmdService execCmdService = (ExecCmdService)PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect((Object)this.serviceFactory.getExecCmdService()).andReturn((Object)execCmdService);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT)).andReturn((Object)"2.8");
        EasyMock.expect((Object)execCmdService.executeCommand("00:1A:B6:00:0B:B5", "./scanwlan.sh rssi")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Integer response = this.cameraBrickcomGeneric.checkRSSI(TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    private LanDeviceEntity prepareDeviceForFailureReconfigurationTests() {
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"privacy_button", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"motion_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"audio_detection_sensitivity", (String)"50", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"system_ledoff", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)"OFF", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"video_quality", (String)"GOOD", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_enabled", (String)"ON", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_ssid", (String)"smart-apps", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wlan_mode", (String)"INFRASTRUCTURE", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_bssid", (String)"", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_channel", (String)"3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_encryption", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_alghoritm", (String)"WEP", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_auth_mode", (String)"OPEN", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_length", (String)"LENGTH_128_BITS", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key_format", (String)"ASCII", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key1", (String)"key1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key2", (String)"key2", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key3", (String)"key3", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_key4", (String)"key4", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_wep_default_key", (String)"1", (String)"");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"wifi_pre_shared_key", (String)"", (String)"");
        return device;
    }

    private void downloadDeviceCapabilities() throws MalformedURLException {
        HTTPClientService systemClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)systemClient);
        URL systemUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/system.cgi?action=get");
        EasyMock.expect((Object)systemClient.get("00:1A:B6:00:0B:B5", systemUrl)).andReturn((Object)this.prepareSystemResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5"));
        HTTPClientService capabilitiesClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)capabilitiesClient);
        URL capabilitiesUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/capability.cgi?action=get");
        EasyMock.expect((Object)capabilitiesClient.get("00:1A:B6:00:0B:B5", capabilitiesUrl)).andReturn((Object)this.prepareCapabilitiesResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService featureClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)featureClient);
        URL featureUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/featureList.cgi?action=get");
        EasyMock.expect((Object)featureClient.get("00:1A:B6:00:0B:B5", featureUrl)).andReturn((Object)this.prepareFeatureResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService channelsClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)channelsClient);
        URL channelsUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?action=get");
        EasyMock.expect((Object)channelsClient.get("00:1A:B6:00:0B:B5", channelsUrl)).andReturn((Object)this.prepareChannelsResponse(HTTPClientServiceResult.Result.OK));
        HTTPClientService usersClient = (HTTPClientService)PowerMock.createMock(HTTPClientService.class);
        EasyMock.expect((Object)this.serviceFactory.getHttpClientService()).andReturn((Object)usersClient);
        URL usersUrl = new URL("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?action=getUsers");
        EasyMock.expect((Object)usersClient.get("00:1A:B6:00:0B:B5", usersUrl)).andReturn((Object)this.prepareUsersResponse(HTTPClientServiceResult.Result.OK, "00:1A:B6:00:0B:B5", true));
    }

    public static DeviceDescEntity prepareDeviceDescEntity() {
        DeviceDescEntity deviceDesc = new DeviceDescEntity();
        deviceDesc.setDeviceDescId(Integer.valueOf(1));
        deviceDesc.setClassDevice("camera");
        deviceDesc.setMake("Brickcom");
        deviceDesc.setModel("WCB-100Ap");
        deviceDesc.setDriverclass("CameraBrickcomGeneric");
        return deviceDesc;
    }

    private String prepareViewerUserRequest(boolean register, String index, String username, String password) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/users.cgi?");
        request.append("action=").append(register ? "add" : "update");
        request.append("&index=").append(index);
        request.append("&username=").append(username);
        request.append("&password=").append(password);
        request.append("&privilege=0");
        return request.toString();
    }

    private String prepareConfigrationChannelRequest(String fps, String quality) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/channels.cgi?");
        request.append("action=updateAll");
        request.append("&apply=1");
        request.append("&c1Enable=1");
        request.append("&c1VideoFormatCodecType=MJPEG");
        request.append("&c1VideoFormatResolutionWidth=640");
        request.append("&c1VideoFormatResolutionHeight=480");
        request.append("&c1VideoFormatFrameRate=").append(fps);
        request.append("&c1VideoFormatQuality=").append(quality);
        request.append("&c1VideoFormatConstantBitrate=0");
        request.append("&c1TransportType=2");
        request.append("&c2Enable=1");
        request.append("&c2VideoFormatCodecType=MJPEG");
        request.append("&c2VideoFormatResolutionWidth=320");
        request.append("&c2VideoFormatResolutionHeight=240");
        request.append("&c2VideoFormatFrameRate=").append(fps);
        request.append("&c2VideoFormatQuality=").append(quality);
        request.append("&c2VideoFormatConstantBitrate=0");
        request.append("&c2TransportType=2");
        return request.toString();
    }

    private String prepareConfigrationLedRequest(boolean off) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/led.cgi?");
        request.append("action=set");
        request.append("&off=").append(off ? "1" : "0");
        return request.toString();
    }

    private String prepareConfigrationPrivacyButtonRequest(boolean enabled) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/camera.cgi?");
        request.append("action=setPrivacy");
        request.append("&privacyButtonEnabled=").append(enabled ? "1" : "0");
        return request.toString();
    }

    private String prepareConfigrationHttpNotificationsRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=setHttp");
        request.append("&HttpUrl=http://homemonitor.ch:8080/app/events/motion/brickcom");
        request.append("&username=alarmUser");
        request.append("&password=alarmPassword");
        request.append("&Message=id=00:1A:B6:00:0B:B5");
        return request.toString();
    }

    private String prepareConfigrationPirSensorRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/pirsensor.cgi?");
        request.append("action=set");
        request.append("&enabled=0");
        request.append("&sensitivity=10");
        return request.toString();
    }

    private String prepareConfigrationMotionDetectionEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_PIR");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=PIR");
        request.append("&actions=SNAPSHOT:HTTP");
        return request.toString();
    }

    private String prepareConfigrationIlluminationRequest(int level) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/wledctl.cgi?");
        request.append("action=set");
        request.append("&method=1");
        request.append("&apply=1");
        request.append("&level=").append(String.valueOf(level));
        return request.toString();
    }

    private String prepareConfigurationAudioDetectionSensitivityRequest(Integer sensitivity) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/audio.cgi?");
        request.append("action=setAudioDetection");
        request.append("&sensitivity=").append(sensitivity);
        return request.toString();
    }

    private String prepareConfigrationAudioDetectionEventRequest(boolean enabled, boolean update) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/event.cgi?");
        request.append("action=").append(update ? "updateEventSetting" : "addEventSetting");
        request.append("&name=HOMEMONITOR_AD");
        request.append("&enabled=").append(enabled ? "1" : "0");
        request.append("&sched.type=0");
        request.append("&eventID=AD");
        request.append("&actions=SNAPSHOT:HTTP");
        return request.toString();
    }

    private String prepareConfigrationTimeRequest() {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/time.cgi?");
        request.append("action=set");
        request.append("&type=2");
        request.append("&timezoneID=13");
        request.append("&ntp.ntpServerLoc1=ntp.homemonitor.ch");
        request.append("&ntp.ntpServerLoc2=clock.stdtime.gov.tw");
        request.append("&enableDST=0");
        return request.toString();
    }

    private HTTPClientServiceResult prepareResponse(HTTPClientServiceResult.Result result, StringBuilder body) {
        HTTPClientServiceResult response = new HTTPClientServiceResult();
        response.setResult(result);
        if (body != null) {
            response.setBody(body.toString().getBytes());
        }
        return response;
    }

    private HTTPClientServiceResult preparePostResponse(HTTPClientServiceResult.Result result, boolean correct) {
        StringBuilder postResponseBody = new StringBuilder();
        postResponseBody.append("statusCode=").append(correct ? "0" : "1").append("\n");
        return this.prepareResponse(result, postResponseBody);
    }

    private HTTPClientServiceResult prepareEventAlredyExistsResponse() {
        StringBuilder postResponseBody = new StringBuilder();
        postResponseBody.append("statusCode=13001").append("\n");
        postResponseBody.append("statusString=This name already exists.").append("\n");
        return this.prepareResponse(HTTPClientServiceResult.Result.OK, postResponseBody);
    }

    private HTTPClientServiceResult prepareSystemResponse(HTTPClientServiceResult.Result result, String macAddress) {
        StringBuilder systemResponseBody = new StringBuilder();
        systemResponseBody.append("chipVersion=G").append("\n");
        systemResponseBody.append("sensorID=OV9715").append("\n");
        systemResponseBody.append("macAddress=").append(macAddress).append("\n");
        systemResponseBody.append("firmwareVersion=v3.1.0.1").append("\n");
        systemResponseBody.append("firmwareReleaseDate=08/24/2011 15:29").append("\n");
        systemResponseBody.append("internalName=Brickcom").append("\n");
        systemResponseBody.append("productName=WCB-100Ap").append("\n");
        systemResponseBody.append("modelNumber=100").append("\n");
        systemResponseBody.append("companyName=Brickcom Corporation").append("\n");
        systemResponseBody.append("comments=[CUBE HD IPCam Professional][Wireless]").append("\n");
        return this.prepareResponse(result, systemResponseBody);
    }

    private HTTPClientServiceResult prepareCapabilitiesResponse(HTTPClientServiceResult.Result result) {
        StringBuilder capabilitiesResponseBody = new StringBuilder();
        capabilitiesResponseBody.append("[media]").append("\n");
        capabilitiesResponseBody.append("channels=2").append("\n");
        capabilitiesResponseBody.append("videoCodecs=H264,MJPEG,MPEG4").append("\n");
        capabilitiesResponseBody.append("audioCodesc=G711,AMR-NB").append("\n");
        capabilitiesResponseBody.append("resolutions=640x400,320x192,640x352,320x176,640x480,320x240").append("\n");
        capabilitiesResponseBody.append("H264frameRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("MJPEGframeRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("MPEG4frameRate=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30").append("\n");
        capabilitiesResponseBody.append("bitrate=64,128,256,384,512,768,1000,1500,2000,4000,6000,8000,10000,12000").append("\n");
        capabilitiesResponseBody.append("Events=MD,PIR,AD,SCHEDULE").append("\n");
        capabilitiesResponseBody.append("Event.actions=SAVESTREAM,SNAPSHOT,EMAIL,HTTP,UDP,MULTICAST,LIGHTLED,SPEAKER").append("\n");
        capabilitiesResponseBody.append("Event.SaveStreamMethod=FTP,EMAIL,HTTP,SAMBA,SD").append("\n");
        capabilitiesResponseBody.append("Event.SnapshotMethod=FTP,EMAIL,HTTP,SAMBA,SD").append("\n");
        capabilitiesResponseBody.append("Event.Schedule.SaveStreamMethod=sd").append("\n");
        return this.prepareResponse(result, capabilitiesResponseBody);
    }

    private HTTPClientServiceResult prepareFeatureResponse(HTTPClientServiceResult.Result result) {
        StringBuilder featureResponseBody = new StringBuilder();
        featureResponseBody.append("ExposureControl=1").append("\n");
        featureResponseBody.append("AutoIris=0").append("\n");
        featureResponseBody.append("IRCut=0").append("\n");
        featureResponseBody.append("IRLED=0").append("\n");
        featureResponseBody.append("ColorEffect=2").append("\n");
        featureResponseBody.append("PrivacyMask=1").append("\n");
        featureResponseBody.append("EasyLink=1").append("\n");
        featureResponseBody.append("Wireless=1").append("\n");
        featureResponseBody.append("ScheduledEvent=1").append("\n");
        featureResponseBody.append("DIDO=0").append("\n");
        featureResponseBody.append("AudioClip=1").append("\n");
        featureResponseBody.append("PIR=1").append("\n");
        featureResponseBody.append("MSNSetting=0").append("\n");
        featureResponseBody.append("StorageManagement=1").append("\n");
        return this.prepareResponse(result, featureResponseBody);
    }

    private HTTPClientServiceResult prepareChannelsResponse(HTTPClientServiceResult.Result result) {
        StringBuilder channelsResponseBody = new StringBuilder();
        channelsResponseBody.append("size = 2").append("\n");
        channelsResponseBody.append("CH1.enabled=1").append("\n");
        channelsResponseBody.append("CH1.name=H264").append("\n");
        channelsResponseBody.append("CH1.transportType=2").append("\n");
        channelsResponseBody.append("CH1.video.enabled=1").append("\n");
        channelsResponseBody.append("CH1.video.format.sourceDevice=0").append("\n");
        channelsResponseBody.append("CH1.video.format.codecType=MJPEG").append("\n");
        channelsResponseBody.append("CH1.video.format.constantBitrate=0").append("\n");
        channelsResponseBody.append("CH1.video.format.bitrateInKbps=4000").append("\n");
        channelsResponseBody.append("CH1.video.format.resolutionWidth=640").append("\n");
        channelsResponseBody.append("CH1.video.format.resolutionHeight=400").append("\n");
        channelsResponseBody.append("CH1.video.format.frameRate=25").append("\n");
        channelsResponseBody.append("CH1.video.format.frameRate2=20").append("\n");
        channelsResponseBody.append("CH1.video.format.gop=0").append("\n");
        channelsResponseBody.append("CH1.video.format.quality=30").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH1.video.transport.multicastPort=10000").append("\n");
        channelsResponseBody.append("CH1.video.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH1.audio.enabled=0").append("\n");
        channelsResponseBody.append("CH1.audio.format.codecType=G711").append("\n");
        channelsResponseBody.append("CH1.audio.format.codecSubType=PCMU").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastAddress=").append("\n");
        channelsResponseBody.append("CH1.audio.transport.multicastPort=10002").append("\n");
        channelsResponseBody.append("CH1.audio.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH1.meta.enabled=1").append("\n");
        channelsResponseBody.append("CH1.meta.format.mdAlarmEnabled=0").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH1.meta.transport.multicastPort=10004").append("\n");
        channelsResponseBody.append("CH1.meta.transport.ttl=10").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("CH2.enabled=1").append("\n");
        channelsResponseBody.append("CH2.name=MJPEG").append("\n");
        channelsResponseBody.append("CH2.transportType=2").append("\n");
        channelsResponseBody.append("CH2.video.enabled=1").append("\n");
        channelsResponseBody.append("CH2.video.format.sourceDevice=0").append("\n");
        channelsResponseBody.append("CH2.video.format.codecType=MJPEG").append("\n");
        channelsResponseBody.append("CH2.video.format.constantBitrate=0").append("\n");
        channelsResponseBody.append("CH2.video.format.bitrateInKbps=64").append("\n");
        channelsResponseBody.append("CH2.video.format.resolutionWidth=640").append("\n");
        channelsResponseBody.append("CH2.video.format.resolutionHeight=400").append("\n");
        channelsResponseBody.append("CH2.video.format.frameRate=25").append("\n");
        channelsResponseBody.append("CH2.video.format.frameRate2=20").append("\n");
        channelsResponseBody.append("CH2.video.format.gop=0").append("\n");
        channelsResponseBody.append("CH2.video.format.quality=30").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH2.video.transport.multicastPort=20000").append("\n");
        channelsResponseBody.append("CH2.video.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH2.audio.enabled=0").append("\n");
        channelsResponseBody.append("CH2.audio.format.codecType=G711").append("\n");
        channelsResponseBody.append("CH2.audio.format.codecSubType=PCMU").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastAddress=").append("\n");
        channelsResponseBody.append("CH2.audio.transport.multicastPort=20002").append("\n");
        channelsResponseBody.append("CH2.audio.transport.ttl=10").append("\n");
        channelsResponseBody.append("CH2.meta.enabled=1").append("\n");
        channelsResponseBody.append("CH2.meta.format.mdAlarmEnabled=0").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastEnabled=0").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastAddress=234.1.2.3").append("\n");
        channelsResponseBody.append("CH2.meta.transport.multicastPort=20004").append("\n");
        channelsResponseBody.append("CH2.meta.transport.ttl=10").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        channelsResponseBody.append("").append("\n");
        return this.prepareResponse(result, channelsResponseBody);
    }

    private HTTPClientServiceResult prepareUsersResponse(HTTPClientServiceResult.Result result, String macAddress, boolean attachViewerUser) {
        StringBuilder usersResponseBody = new StringBuilder();
        usersResponseBody.append("size=4").append("\n");
        usersResponseBody.append("User1.index=1").append("\n");
        usersResponseBody.append("User1.username=admin").append("\n");
        usersResponseBody.append("User1.password=admin").append("\n");
        usersResponseBody.append("User1.privilege=1").append("\n");
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("User2.index=2").append("\n");
        usersResponseBody.append("User2.username=viewer").append("\n");
        usersResponseBody.append("User2.password=viewer").append("\n");
        usersResponseBody.append("User2.privilege=0").append("\n");
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("User3.index=3").append("\n");
        usersResponseBody.append("User3.username=rviewer").append("\n");
        usersResponseBody.append("User3.password=rviewer").append("\n");
        usersResponseBody.append("User3.privilege=2").append("\n");
        usersResponseBody.append("").append("\n");
        if (attachViewerUser) {
            usersResponseBody.append("User4.index=4").append("\n");
            usersResponseBody.append("User4.username=").append(macAddress.replace(":", "")).append("\n");
            usersResponseBody.append("User4.password=OmKMqWmPu1").append("\n");
            usersResponseBody.append("User4.privilege=0").append("\n");
        }
        usersResponseBody.append("").append("\n");
        usersResponseBody.append("").append("\n");
        return this.prepareResponse(result, usersResponseBody);
    }

    private Map<String, String> prepareDeviceCapabilities(String macAddress, boolean attachViewerUser, String viewerUsername, boolean wifiSupport) {
        HashMap<String, String> deviceCapabilities = new HashMap<String, String>();
        deviceCapabilities.put("chipVersion", "G");
        deviceCapabilities.put("sensorID", "OV9715");
        deviceCapabilities.put("macAddress", macAddress);
        deviceCapabilities.put("firmwareVersion", "v3.1.0.1");
        deviceCapabilities.put("firmwareReleaseDate", "08/24/2011 15:29");
        deviceCapabilities.put("internalName", "Brickcom");
        deviceCapabilities.put("productName", "WCB-100Ap");
        deviceCapabilities.put("modelNumber", "100");
        deviceCapabilities.put("companyName", "Brickcom Corporation");
        deviceCapabilities.put("comments", "[CUBE HD IPCam Professional][Wireless]");
        deviceCapabilities.put("channels", "2");
        deviceCapabilities.put("videoCodecs", "H264,MJPEG,MPEG4");
        deviceCapabilities.put("audioCodesc", "G711,AMR-NB");
        deviceCapabilities.put("resolutions", "640x400,320x192,640x352,320x176,640x480,320x240");
        deviceCapabilities.put("H264frameRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("MJPEGframeRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("MPEG4frameRate", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30");
        deviceCapabilities.put("bitrate", "64,128,256,384,512,768,1000,1500,2000,4000,6000,8000,10000,12000");
        deviceCapabilities.put("Events", "MD,PIR,AD,SCHEDULE");
        deviceCapabilities.put("Event.actions", "SAVESTREAM,SNAPSHOT,EMAIL,HTTP,UDP,MULTICAST,LIGHTLED,SPEAKER");
        deviceCapabilities.put("Event.SaveStreamMethod", "FTP,EMAIL,HTTP,SAMBA,SD");
        deviceCapabilities.put("Event.SnapshotMethod", "FTP,EMAIL,HTTP,SAMBA,SD");
        deviceCapabilities.put("Event.Schedule.SaveStreamMethod", "sd");
        deviceCapabilities.put("ExposureControl", "1");
        deviceCapabilities.put("AutoIris", "0");
        deviceCapabilities.put("IRCut", "0");
        deviceCapabilities.put("IRLED", "0");
        deviceCapabilities.put("ColorEffect", "2");
        deviceCapabilities.put("PrivacyMask", "1");
        deviceCapabilities.put("EasyLink", "1");
        deviceCapabilities.put("Wireless", wifiSupport ? "1" : "0");
        deviceCapabilities.put("ScheduledEvent", "1");
        deviceCapabilities.put("DIDO", "0");
        deviceCapabilities.put("AudioClip", "1");
        deviceCapabilities.put("PIR", "1");
        deviceCapabilities.put("MSNSetting", "0");
        deviceCapabilities.put("StorageManagement", "1");
        deviceCapabilities.put("CH1.enabled", "1");
        deviceCapabilities.put("CH1.name", "H264");
        deviceCapabilities.put("CH1.transportType", "2");
        deviceCapabilities.put("CH1.video.enabled", "1");
        deviceCapabilities.put("CH1.video.format.sourceDevice", "0");
        deviceCapabilities.put("CH1.video.format.codecType", "MJPEG");
        deviceCapabilities.put("CH1.video.format.constantBitrate", "0");
        deviceCapabilities.put("CH1.video.format.bitrateInKbps", "4000");
        deviceCapabilities.put("CH1.video.format.resolutionWidth", "640");
        deviceCapabilities.put("CH1.video.format.resolutionHeight", "400");
        deviceCapabilities.put("CH1.video.format.frameRate", "25");
        deviceCapabilities.put("CH1.video.format.frameRate2", "20");
        deviceCapabilities.put("CH1.video.format.gop", "0");
        deviceCapabilities.put("CH1.video.format.quality", "30");
        deviceCapabilities.put("CH1.video.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.video.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH1.video.transport.multicastPort", "10000");
        deviceCapabilities.put("CH1.video.transport.ttl", "10");
        deviceCapabilities.put("CH1.audio.enabled", "0");
        deviceCapabilities.put("CH1.audio.format.codecType", "G711");
        deviceCapabilities.put("CH1.audio.format.codecSubType", "PCMU");
        deviceCapabilities.put("CH1.audio.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.audio.transport.multicastAddress", "");
        deviceCapabilities.put("CH1.audio.transport.multicastPort", "10002");
        deviceCapabilities.put("CH1.audio.transport.ttl", "10");
        deviceCapabilities.put("CH1.meta.enabled", "1");
        deviceCapabilities.put("CH1.meta.format.mdAlarmEnabled", "0");
        deviceCapabilities.put("CH1.meta.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH1.meta.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH1.meta.transport.multicastPort", "10004");
        deviceCapabilities.put("CH1.meta.transport.ttl", "10");
        deviceCapabilities.put("CH2.enabled", "1");
        deviceCapabilities.put("CH2.name", "MJPEG");
        deviceCapabilities.put("CH2.transportType", "2");
        deviceCapabilities.put("CH2.video.enabled", "1");
        deviceCapabilities.put("CH2.video.format.sourceDevice", "0");
        deviceCapabilities.put("CH2.video.format.codecType", "MJPEG");
        deviceCapabilities.put("CH2.video.format.constantBitrate", "0");
        deviceCapabilities.put("CH2.video.format.bitrateInKbps", "64");
        deviceCapabilities.put("CH2.video.format.resolutionWidth", "640");
        deviceCapabilities.put("CH2.video.format.resolutionHeight", "400");
        deviceCapabilities.put("CH2.video.format.frameRate", "25");
        deviceCapabilities.put("CH2.video.format.frameRate2", "20");
        deviceCapabilities.put("CH2.video.format.gop", "0");
        deviceCapabilities.put("CH2.video.format.quality", "30");
        deviceCapabilities.put("CH2.video.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.video.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH2.video.transport.multicastPort", "20000");
        deviceCapabilities.put("CH2.video.transport.ttl", "10");
        deviceCapabilities.put("CH2.audio.enabled", "0");
        deviceCapabilities.put("CH2.audio.format.codecType", "G711");
        deviceCapabilities.put("CH2.audio.format.codecSubType", "PCMU");
        deviceCapabilities.put("CH2.audio.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.audio.transport.multicastAddress", "");
        deviceCapabilities.put("CH2.audio.transport.multicastPort", "20002");
        deviceCapabilities.put("CH2.audio.transport.ttl", "10");
        deviceCapabilities.put("CH2.meta.enabled", "1");
        deviceCapabilities.put("CH2.meta.format.mdAlarmEnabled", "0");
        deviceCapabilities.put("CH2.meta.transport.multicastEnabled", "0");
        deviceCapabilities.put("CH2.meta.transport.multicastAddress", "234.1.2.3");
        deviceCapabilities.put("CH2.meta.transport.multicastPort", "20004");
        deviceCapabilities.put("CH2.meta.transport.ttl", "10");
        deviceCapabilities.put("size", "4");
        deviceCapabilities.put("User1.index", "1");
        deviceCapabilities.put("User1.username", "admin");
        deviceCapabilities.put("User1.password", "admin");
        deviceCapabilities.put("User1.privilege", "1");
        deviceCapabilities.put("User2.index", "2");
        deviceCapabilities.put("User2.username", "viewer");
        deviceCapabilities.put("User2.password", "viewer");
        deviceCapabilities.put("User2.privilege", "0");
        deviceCapabilities.put("User3.index", "3");
        deviceCapabilities.put("User3.username", "rviewer");
        deviceCapabilities.put("User3.password", "rviewer");
        deviceCapabilities.put("User3.privilege", "2");
        if (attachViewerUser) {
            deviceCapabilities.put("User4.index", "4");
            deviceCapabilities.put("User4.username", viewerUsername);
            deviceCapabilities.put("User4.password", "OmKMqWmPu1");
            deviceCapabilities.put("User4.privilege", "0");
        }
        return deviceCapabilities;
    }

    private HTTPClientServiceResult prepareDeviceConfigResponse(String viewerUsername, String viewerPassword, String alarmUser, String alarmPassword, String videoFps, String videoQuality, boolean privacyButtonEnabled, boolean motionDetectionEnabled, boolean audioDetectionEnabled, boolean ledOff, int illuminationLevel, int audioDetectionSensitivity, String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String wpaPass, WepAuthenticationType wepAuthenticationType, WepKeyType wepKeyType, String key1, String key2, String key3, String key4, int keyIndex, HTTPClientServiceResult.Result result) {
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("WCB-100Ap").append("\n");
        responseBody.append("UserSetSetting.userList.size=4").append("\n");
        responseBody.append("UserSetSetting.userList.users0.index=1").append("\n");
        responseBody.append("UserSetSetting.userList.users0.password=admin").append("\n");
        responseBody.append("UserSetSetting.userList.users0.privilege=1").append("\n");
        responseBody.append("UserSetSetting.userList.users0.username=admin").append("\n");
        responseBody.append("UserSetSetting.userList.users1.index=2").append("\n");
        responseBody.append("UserSetSetting.userList.users1.password=viewer").append("\n");
        responseBody.append("UserSetSetting.userList.users1.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users1.username=viewer").append("\n");
        responseBody.append("UserSetSetting.userList.users2.index=3").append("\n");
        responseBody.append("UserSetSetting.userList.users2.password=rviewer").append("\n");
        responseBody.append("UserSetSetting.userList.users2.privilege=2").append("\n");
        responseBody.append("UserSetSetting.userList.users2.username=rviewer").append("\n");
        responseBody.append("UserSetSetting.userList.users3.index=4").append("\n");
        responseBody.append("UserSetSetting.userList.users3.password=").append(viewerPassword).append("\n");
        responseBody.append("UserSetSetting.userList.users3.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users3.username=").append(viewerUsername).append("\n");
        responseBody.append("UserSetSetting.userList.users4.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users4.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users4.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users4.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users5.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users5.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users5.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users5.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users6.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users6.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users6.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users6.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users7.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users7.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users7.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users7.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users8.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users8.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users8.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users8.username=").append("\n");
        responseBody.append("UserSetSetting.userList.users9.index=0").append("\n");
        responseBody.append("UserSetSetting.userList.users9.password=").append("\n");
        responseBody.append("UserSetSetting.userList.users9.privilege=0").append("\n");
        responseBody.append("UserSetSetting.userList.users9.username=").append("\n");
        responseBody.append("PrivacySetting.ButtonEnabled=").append(privacyButtonEnabled ? "1" : "0").append("\n");
        responseBody.append("WIFISetting.channel=").append(String.valueOf(channel)).append("\n");
        responseBody.append("WIFISetting.mode=").append(wlanMode.getCode()).append("\n");
        responseBody.append("WIFISetting.SSID=").append(ssid).append("\n");
        responseBody.append("WIFISetting.securityMode=").append(encryption.getCode()).append("\n");
        if (encryption == Encryption.WEP) {
            responseBody.append("WIFISetting.WEP.authenticationType=").append(wepAuthenticationType.getCode()).append("\n");
            responseBody.append("WIFISetting.WEP.defaultTransmitKeyIndex=").append(keyIndex).append("\n");
            responseBody.append("WIFISetting.WEP.wepKeyLength=").append(wepKeyType.getCode()).append("\n");
            System.out.println("adding key 0");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry0.encryptionKey=").append(key1).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry1.encryptionKey=").append(key2).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry2.encryptionKey=").append(key3).append("\n");
            responseBody.append("WIFISetting.WEP.encryptionKeyList.keyEntry3.encryptionKey=").append(key4).append("\n");
        } else if (encryption == Encryption.WPA || encryption == Encryption.WPA2) {
            responseBody.append("WIFISetting.WPA.algorithmType=").append(algorithm.getCode()).append("\n");
            responseBody.append("WIFISetting.WPA.sharedKey=").append(wpaPass).append("\n");
        }
        responseBody.append("ChannelSetSetting.channelList.size=2").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.enabled=1").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.transportType=2").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.codecType=MJPEG").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.constantBitrate=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.frameRate=").append(videoFps).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.resolutionHeight=480").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.resolutionWidth=640").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels0.video.format.quality=").append(videoQuality).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.enabled=1").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.name=MJPEG").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.transportType=2").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.codecType=MJPEG").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.constantBitrate=0").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.frameRate=").append(videoFps).append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.resolutionHeight=240").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.resolutionWidth=320").append("\n");
        responseBody.append("ChannelSetSetting.channelList.channels1.video.format.quality=").append(videoQuality).append("\n");
        responseBody.append("TimeSetting.type=2").append("\n");
        responseBody.append("TimeSetting.enableDST=0").append("\n");
        responseBody.append("TimeSetting.manual.year=2012").append("\n");
        responseBody.append("TimeSetting.manual.month=1").append("\n");
        responseBody.append("TimeSetting.manual.day=4").append("\n");
        responseBody.append("TimeSetting.manual.hour=11").append("\n");
        responseBody.append("TimeSetting.manual.minute=27").append("\n");
        responseBody.append("TimeSetting.manual.second=38").append("\n");
        responseBody.append("TimeSetting.timezoneID=13").append("\n");
        responseBody.append("TimeSetting.ntp.ntpServerLoc1=ntp.homemonitor.ch").append("\n");
        responseBody.append("TimeSetting.ntp.ntpServerLoc2=clock.stdtime.gov.tw").append("\n");
        responseBody.append("EmailSetting.primary.accountName=").append(alarmUser).append("\n");
        responseBody.append("EmailSetting.primary.authenticationMode=0").append("\n");
        responseBody.append("EmailSetting.primary.password=").append(alarmPassword).append("\n");
        responseBody.append("EmailSetting.primary.portNo=25").append("\n");
        responseBody.append("EmailSetting.primary.smtpServerHostName=homemonitor.ch").append("\n");
        responseBody.append("EmailSetting.secondary.accountName=").append("\n");
        responseBody.append("EmailSetting.secondary.authenticationMode=0").append("\n");
        responseBody.append("EmailSetting.secondary.password=").append("\n");
        responseBody.append("EmailSetting.secondary.portNo=25").append("\n");
        responseBody.append("EmailSetting.secondary.smtpServerHostName=").append("\n");
        responseBody.append("Event.ruleList.size=2").append("\n");
        responseBody.append("Event.ruleList.cEntry0.actions=SNAPSHOT:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry0.enabled=").append(motionDetectionEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry0.eventName=PIR").append("\n");
        responseBody.append("Event.ruleList.cEntry0.token=HOMEMONITOR_PIR").append("\n");
        responseBody.append("Event.ruleList.cEntry0.sched.type=0").append("\n");
        responseBody.append("Event.ruleList.cEntry0.sched.time=").append("\n");
        responseBody.append("Event.ruleList.cEntry1.actions=SNAPSHOT:HTTP").append("\n");
        responseBody.append("Event.ruleList.cEntry1.enabled=").append(audioDetectionEnabled ? "1" : "0").append("\n");
        responseBody.append("Event.ruleList.cEntry1.eventName=AD").append("\n");
        responseBody.append("Event.ruleList.cEntry1.token=HOMEMONITOR_AD").append("\n");
        responseBody.append("Event.ruleList.cEntry1.sched.type=0").append("\n");
        responseBody.append("EventHttp.transport.destURL=http://homemonitor.ch:8080/app/events/motion/brickcom").append("\n");
        responseBody.append("EventHttp.transport.destMsg=id=00:02:D1:06:CD:80").append("\n");
        responseBody.append("EventHttp.transport.username=").append(alarmUser).append("\n");
        responseBody.append("EventHttp.transport.password=").append(alarmPassword).append("\n");
        responseBody.append("LEDSetting.level=0").append("\n");
        responseBody.append("LEDSetting.off=").append(ledOff ? "1" : "0").append("\n");
        responseBody.append("PIRSensor.sensitivity=10").append("\n");
        responseBody.append("PIRSensor.enabled=0").append("\n");
        responseBody.append("LightCTL.level=").append(String.valueOf(illuminationLevel)).append("\n");
        responseBody.append("LightCTL.method=1").append("\n");
        responseBody.append("AudioDetection.enabled=0").append("\n");
        responseBody.append("AudioDetection.sensitivity=").append(String.valueOf(audioDetectionSensitivity)).append("\n");
        responseBody.append("END").append("\n");
        return this.prepareResponse(result, responseBody);
    }

    @After
    public void tearDown() {
    }

    private LanDeviceEntity prepareDeviceToInit() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setGatewayClient(TestDataUtils.prepareGatewaClientEntity());
        device.setMac("00:1A:B6:00:0B:B5");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(false);
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_user", (String)"viewerUser", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"viewer_pass", (String)"viewerPassword", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_user", (String)"alarmUser", null);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"alarm_pass", (String)"alarmPassword", null);
        return device;
    }

    private boolean verifyProcessingParams(List<LanDeviceParamEntity> expectedParams, Capture<List<LanDeviceParamEntity>> capture) {
        List capturedParams = (List)capture.getValue();
        if (expectedParams.size() != capturedParams.size()) {
            System.out.println("Different counts of params (expected params count: " + expectedParams.size() + "; captured params count: " + capturedParams.size() + ".");
            return false;
        }
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort(expectedParams, comparator);
        Collections.sort(capturedParams, comparator);
        System.out.println("capturedParams: " + capturedParams);
        System.out.println("expectedParams: " + expectedParams);
        return expectedParams.equals(capturedParams);
    }

    private LanDeviceEntity prepareExpectedDevice(boolean supportedWifi) {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setModel("WCB-100Ap");
        device.setDeviceDesc(TestDataUtils.prepareBrickcomDeviceDescEntity());
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "15", "15");
        device.setParam("illumination", "OFF", "OFF");
        device.setParam("event_led_light", "OFF", "OFF");
        device.setParam("audio_detection", "OFF", "OFF");
        device.setParam("audio_detection_sensitivity", "50", "50");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("path", "channel1", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("snapshot_path", "/snapshot.jpg", null);
        device.setParam("path_low", "channel2", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path_low", "/snapshot2.jpg", null);
        device.setParam("has_home", "OFF", null);
        device.setParam("has_pan", "OFF", null);
        device.setParam("has_tilt", "OFF", null);
        device.setParam("has_zoom", "OFF", null);
        device.setParam("need_restart_after_network_changes", "OFF", null);
        if (supportedWifi) {
            device.setParam("wifi_ssid", "Brickcom", "Brickcom");
            device.setParam("wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", "0", "0");
            device.setParam("wifi_encryption", "OPEN", "OPEN");
            device.setParam("wifi_alghoritm", "NONE", "NONE");
            device.setParam("wifi_wep_auth_mode", "", "");
            device.setParam("wifi_wep_key_length", "", "");
            device.setParam("wifi_wep_key_format", "", "");
            device.setParam("wifi_wep_key1", "", "");
            device.setParam("wifi_wep_key2", "", "");
            device.setParam("wifi_wep_key3", "", "");
            device.setParam("wifi_wep_key4", "", "");
            device.setParam("wifi_wep_default_key", "", "");
            device.setParam("wifi_pre_shared_key", "", "");
        }
        return device;
    }

    private LanDeviceEntity prepareExpectedDeviceWithOpenWifi(String ssid, String wlanMode, String channel, String wifiEnabled) {
        return this.prepareExpectedDevice(true, ssid, wlanMode, channel, "OPEN", "NONE", "", "", "", "", "", "", "", "", "", wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDeviceWithWepWifi(String ssid, String wlanMode, String channel, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String wifiEnabled) {
        return this.prepareExpectedDevice(true, ssid, wlanMode, channel, "WEP", "WEP", authAuthMode, wepKeyLength, wepKeyFormat, key1, key2, key3, key4, keyIndex, "", wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDeviceWithWpaWifi(String ssid, String wlanMode, String channel, String encryption, String algorithm, String preSharedKey, String wifiEnabled) {
        return this.prepareExpectedDevice(true, ssid, wlanMode, channel, encryption, algorithm, "", "", "", "", "", "", "", "", preSharedKey, wifiEnabled);
    }

    private LanDeviceEntity prepareExpectedDevice(boolean supportedWifi, String ssid, String wlanMode, String channel, String encryption, String algorithm, String authAuthMode, String wepKeyLength, String wepKeyFormat, String key1, String key2, String key3, String key4, String keyIndex, String preSharedKey, String wifiEnabled) {
        LanDeviceEntity device = this.prepareDeviceToInit();
        device.setModel("WCB-100Ap");
        device.setDeviceDesc(TestDataUtils.prepareBrickcomDeviceDescEntity());
        device.setParam("system_ledoff", "OFF", "OFF");
        device.setParam("privacy_button", "ON", "ON");
        device.setParam("motion_detection", "OFF", "OFF");
        device.setParam("alarm_limit", "0", "0");
        device.setParam("record_video", "OFF", "OFF");
        device.setParam("video_recording_duration", "15", "15");
        device.setParam("illumination", "OFF", "OFF");
        device.setParam("event_led_light", "OFF", "OFF");
        device.setParam("audio_detection", "OFF", "OFF");
        device.setParam("audio_detection_sensitivity", "50", "50");
        device.setParam("video_quality", "GOOD", "GOOD");
        device.setParam("path", "channel1", null);
        device.setParam("resolution", "640x480", null);
        device.setParam("snapshot_path", "/snapshot.jpg", null);
        device.setParam("path_low", "channel2", null);
        device.setParam("resolution_low", "320x240", null);
        device.setParam("snapshot_path_low", "/snapshot2.jpg", null);
        device.setParam("has_home", "OFF", null);
        device.setParam("has_pan", "OFF", null);
        device.setParam("has_tilt", "OFF", null);
        device.setParam("has_zoom", "OFF", null);
        device.setParam("need_restart_after_network_changes", "OFF", null);
        if (supportedWifi) {
            device.setParam("wifi_enabled", wifiEnabled, wifiEnabled);
            device.setParam("wifi_ssid", ssid, ssid);
            device.setParam("wifi_wlan_mode", wlanMode, wlanMode);
            device.setParam("wifi_bssid", "", "");
            device.setParam("wifi_channel", channel, channel);
            device.setParam("wifi_encryption", encryption, encryption);
            device.setParam("wifi_alghoritm", algorithm, algorithm);
            device.setParam("wifi_wep_auth_mode", authAuthMode, authAuthMode);
            device.setParam("wifi_wep_key_length", wepKeyLength, wepKeyLength);
            device.setParam("wifi_wep_key_format", wepKeyFormat, wepKeyFormat);
            device.setParam("wifi_wep_key1", key1, key1);
            device.setParam("wifi_wep_key2", key2, key2);
            device.setParam("wifi_wep_key3", key3, key3);
            device.setParam("wifi_wep_key4", key4, key4);
            device.setParam("wifi_wep_default_key", keyIndex, keyIndex);
            device.setParam("wifi_pre_shared_key", preSharedKey, preSharedKey);
        }
        return device;
    }

    private StringBuilder prepareOpenWifiSettings(String ssid, WlanMode wlanMode, int channel, boolean newFirmware) {
        return this.prepareWifiSettings(ssid, wlanMode, channel, Encryption.OPEN, null, null, Integer.valueOf(0), null, null, null, null, null, null, newFirmware);
    }

    private StringBuilder prepareWepWifiSettings(String ssid, WlanMode wlanMode, int channel, WepAuthenticationType wepAuthenticationType, ReadWepKeyType wepKeyType, int keyIndex, String key1, String key2, String key3, String key4, boolean newFirmware) {
        return this.prepareWifiSettings(ssid, wlanMode, channel, Encryption.WEP, wepAuthenticationType, wepKeyType, Integer.valueOf(keyIndex), key1, key2, key3, key4, null, null, newFirmware);
    }

    private StringBuilder prepareWpaWifiSettings(String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String password) {
        return this.prepareWifiSettings(ssid, wlanMode, channel, encryption, null, null, null, null, null, null, null, algorithm, password, true);
    }

    private StringBuilder prepareWifiSettings(String ssid, WlanMode wlanMode, int channel, Encryption encryption, WepAuthenticationType wepAuthenticationType, ReadWepKeyType wepKeyType, Integer keyIndex, String key1, String key2, String key3, String key4, Algorithm algorithm, String password, boolean newFirmware) {
        StringBuilder settings = new StringBuilder();
        settings.append("enabled= 0").append("\n");
        settings.append("mode=").append(wlanMode.getCode()).append("\n");
        settings.append("operationMode=5").append("\n");
        settings.append("channel=").append(channel).append("\n");
        settings.append("countryregion=1").append("\n");
        settings.append("wmm=1").append("\n");
        settings.append("SSID=").append(ssid).append("\n");
        settings.append("preamble=2").append("\n");
        settings.append("rtsThreshold=2347").append("\n");
        settings.append("fragmentationThreshold=2346").append("\n");
        settings.append("authentication=0").append("\n");
        settings.append("channelBandWidth=0").append("\n");
        settings.append("securityMode=").append(encryption.getCode()).append("\n");
        settings.append("TxPower=100").append("\n");
        settings.append("WPS.WPSMode=0").append("\n");
        settings.append("WPS.PINCode=10896037").append("\n");
        settings.append("WPS.wpsbtn_enabled=1").append("\n");
        settings.append("wifibridge=1").append("\n");
        settings.append("wlNetworkSetting.wifiaddressType=1").append("\n");
        settings.append("wlNetworkSetting.wifiipv4Address=").append("\n");
        settings.append("wlNetworkSetting.wifisubnetMask=").append("\n");
        settings.append("wlNetworkSetting.wifigatewayAddress=").append("\n");
        settings.append("wlNetworkSetting.wifidnsAddress1=").append("\n");
        settings.append("wlNetworkSetting.wifidnsAddress2=").append("\n");
        settings.append("wlNetworkSetting.wifipppoe.username=").append("\n");
        settings.append("wlNetworkSetting.wifipppoe.password=").append("\n");
        if (encryption == Encryption.WEP) {
            settings.append("WEP.authenticationType=").append(wepAuthenticationType.getCode()).append("\n");
            settings.append("WEP.defaultTransmitKeyIndex=").append(keyIndex).append("\n");
            if (newFirmware) {
                settings.append("WEP.wepKeyLength=").append(wepKeyType.getCode()).append("\n");
            } else {
                settings.append("WEP.defaultTransmitKeyIndex=").append(wepKeyType.getCode()).append("\n");
            }
            settings.append("WEP.encryptionKeyList.Keyentry1.encryptionKey=").append(key1).append("\n");
            settings.append("WEP.encryptionKeyList.Keyentry2.encryptionKey=").append(key2).append("\n");
            settings.append("WEP.encryptionKeyList.Keyentry3.encryptionKey=").append(key3).append("\n");
            settings.append("WEP.encryptionKeyList.Keyentry4.encryptionKey=").append(key4).append("\n");
        } else if (encryption == Encryption.WPA || encryption == Encryption.WPA2) {
            settings.append("WPA.algorithmType=").append(algorithm.getCode()).append("\n");
            settings.append("WPA.sharedKey=").append(password).append("\n");
        }
        return settings;
    }

    private String prepareConfigurationWifiRequest(String ssid, WlanMode wlanMode, int channel, Encryption encryption, Algorithm algorithm, String sharedKey, WepKeyType wepKeyType, String key1, String key2, String key3, String key4, int keyIndex) {
        StringBuilder request = new StringBuilder();
        request.append("http://admin:admin@127.0.0.1:80/cgi-bin/wifi.cgi?");
        request.append("action=set");
        request.append("&SSID=").append(ssid);
        if (wlanMode != null) {
            request.append("&mode=").append(wlanMode.getCode());
        }
        if (channel != -1) {
            request.append("&channel=").append(String.valueOf(channel));
        }
        request.append("&securityMode=").append(encryption.getCode());
        if (encryption != Encryption.OPEN) {
            if (encryption == Encryption.WEP) {
                request.append("&WEP.wepKeyLength=").append(wepKeyType.getCode());
                request.append("&WEP.encryptionKeyList.keyEntry1.encryptionKey=").append(key1);
                request.append("&WEP.encryptionKeyList.keyEntry2.encryptionKey=").append(key2);
                request.append("&WEP.encryptionKeyList.keyEntry3.encryptionKey=").append(key3);
                request.append("&WEP.encryptionKeyList.keyEntry4.encryptionKey=").append(key4);
                request.append("&WEP.defaultTransmitKeyIndex=").append(keyIndex);
                request.append("&WEP.authenticationType=0");
            } else {
                request.append("&WPA.algorithmType=").append(algorithm.getCode());
                request.append("&WPA.sharedKey=").append(sharedKey);
            }
        }
        return request.toString();
    }

    private boolean verifyDevice(LanDeviceEntity expectedDevice, LanDeviceEntity device) {
        if (!expectedDevice.equals((Object)device)) {
            Log.debug((String)"Device are not equals");
            return false;
        }
        2 paramComparator = new /* Unavailable Anonymous Inner Class!! */;
        List expectedParams = expectedDevice.getLanDeviceParams();
        List params = device.getLanDeviceParams();
        Collections.sort(expectedParams, paramComparator);
        System.out.println("expectedParams: " + expectedParams);
        Collections.sort(params, paramComparator);
        System.out.println("params:         " + params);
        return expectedParams.equals(params);
    }
}

