/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.brickcom;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.UpdateSettingsHandlerFactory;
import pl.smartapps.containerserver.landevice.UpdatedSettingsListener;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.containerserver.landevice.WepAuthenticationType;
import pl.smartapps.containerserver.landevice.WepKeyFormat;
import pl.smartapps.containerserver.landevice.WepKeyLength;
import pl.smartapps.containerserver.landevice.brickcom.CameraBrickcomGeneric;
import pl.smartapps.containerserver.landevice.multipart.BodyPart;
import pl.smartapps.containerserver.landevice.multipart.Multipart;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="CameraBrickcomGeneric")
@Scope(value="prototype")
public class CameraBrickcomGeneric
extends GenericCamera
implements UpdatedSettingsListener {
    private static final String CHANNELS_CMD = "/cgi-bin/channels.cgi";
    private static final String LED_CMD = "/cgi-bin/led.cgi";
    private static final String PRIVACY_CMD = "/cgi-bin/camera.cgi";
    private static final String EVENT_CMD = "/cgi-bin/event.cgi";
    private static final String PIR_SENSOR_CMD = "/cgi-bin/pirsensor.cgi";
    private static final String USERS_CMD = "/cgi-bin/users.cgi";
    private static final String WIFI_CMD = "/cgi-bin/wifi.cgi";
    private static final String ILLUMINATION_CMD = "/cgi-bin/wledctl.cgi";
    private static final String AUDIO_CMD = "/cgi-bin/audio.cgi";
    private static final String CAPABILITIES_CMD = "/cgi-bin/configfile.dump";
    private static final String WIFI_PARAM_NAME = "wifi";
    private static final String UPGRADE_FIRMWARE_CMD = "/cgi-bin/upgradeFirmware.cgi";
    private static final String TIME_CMD = "/cgi-bin/time.cgi";
    protected static final String DEFAULT_USER = "admin";
    protected static final String DEFAULT_PASSWORD = "admin";
    private static Map<VideoQualityLevel, VideoQuality> videoQualities = new /* Unavailable Anonymous Inner Class!! */;
    private static Logger log = Logger.getLogger(CameraBrickcomGeneric.class);
    private String udpNotificationServerIP;
    private String udpNotificationServerPort;
    private UpdateSettingsHandlerFactory updateHandlerFactory;
    private TaskExecutor taskExecutor;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$EncryptionMode$Encryption;

    public CameraBrickcomGeneric() {
        this.user = "admin";
        this.pass = "admin";
        this.cameraProducer = "Brickcom";
        this.capabilitiesCommands = new String[]{"/cgi-bin/system.cgi?action=get", "/cgi-bin/capability.cgi?action=get", "/cgi-bin/featureList.cgi?action=get", "/cgi-bin/channels.cgi?action=get", "/cgi-bin/users.cgi?action=getUsers"};
        this.firmwareVersionParam = "firmwareVersion";
        this.modelParam = "productName";
    }

    @Value(value="${UDPNotificationServer.serverAddress:192.168.21.119}")
    public void setUdpNotificationServerIP(String udpNotificationServerIP) {
        this.udpNotificationServerIP = udpNotificationServerIP;
    }

    @Value(value="${UDPNotificationServer.listenPort:4321}")
    public void setUdpNotificationServerPort(String udpNotificationServerPort) {
        this.udpNotificationServerPort = udpNotificationServerPort;
    }

    @Autowired
    @Required
    public void setUpdateHandlerFactory(UpdateSettingsHandlerFactory updateHandlerFactory) {
        this.updateHandlerFactory = updateHandlerFactory;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    private String createBaseRequest(LanDevice device, String cmd) {
        return this.createBaseRequest(device.getIpAddress(), device.getPort(), device.getUser(), device.getPass(), cmd);
    }

    private String createBaseRequest(LanDeviceEntity device, String cmd) {
        return this.createBaseRequest(device.getIpAddress(), device.getPort(), device.getUsername(), device.getPass(), cmd);
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        if (parsedResponse.containsKey("WEP.defaultTransmitKeyIndex")) {
            parsedResponse.put("WEP.wepKeyLength", parsedResponse.get("WEP.defaultTransmitKeyIndex"));
            return true;
        }
        return false;
    }

    public Map<String, String> parseResponse(String response) {
        String model;
        Map parsedResponse = super.parseResponse(response);
        if (!parsedResponse.isEmpty() && "IP7142".equals(model = (String)parsedResponse.get("system_info_modelname"))) {
            parsedResponse.put("capability_ptzenabled", "0");
        }
        return parsedResponse;
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        String alarmVideoClipEnabledValue;
        boolean muteAudio;
        if (!reconfiguration) {
            device.setParam("path", "channel1");
            device.setParam("resolution", "640x480");
            device.setParam("snapshot_path", "/snapshot.jpg");
            device.setParam("path_low", "channel2");
            device.setParam("resolution_low", "320x240");
            device.setParam("snapshot_path_low", "/snapshot2.jpg");
            device.setParam("has_home", "OFF");
            device.setParam("has_pan", "OFF");
            device.setParam("has_tilt", "OFF");
            device.setParam("has_zoom", "OFF");
            device.setParam("need_restart_after_network_changes", "OFF");
            device.setParam("system_ledoff", "OFF", "OFF");
            device.setParam("privacy_button", "ON", "ON");
            device.setParam("mute_audio", "OFF", "OFF");
            device.setParam("motion_detection", "OFF", "OFF");
            device.setParam("alarm_limit", "0", "0");
            device.setParam("record_video", "OFF", "OFF");
            device.setParam("video_recording_duration", "15", "15");
            device.setParam("illumination", "OFF", "OFF");
            device.setParam("event_led_light", "OFF", "OFF");
            device.setParam("audio_detection", "OFF", "OFF");
            device.setParam("audio_detection_sensitivity", "50", "50");
            device.setParam("audio_strength_sensor", "ON", "ON");
            device.setParam("alarm_video_clip", "OFF", "OFF");
            String maxVideoClipDuration = "30";
            device.setParam("videoclip_duration", maxVideoClipDuration, maxVideoClipDuration);
        }
        if (this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device)) {
            device.setParam("path_rtsp_over_http_get", "stream/bidirect/channel1");
            device.setParam("path_low_rtsp_over_http_get", "stream/bidirect/channel1");
            device.setParam("path_rtsp_over_http_post", "http_multiplexer");
            device.setParam("path_low_rtsp_over_http_post", "http_multiplexer");
            device.setParam("rtsp_port", "554");
            device.setParam("rtsp_over_http_port", "80");
            if (this.videoclipDisabledForBrickcom()) {
                device.setParam("has_videoclip_recording", "OFF");
                device.setParam("alarm_video_clip", "OFF", "OFF");
            } else {
                device.setParam("has_videoclip_recording", "ON");
            }
            if (!device.hasParam("alarm_video_clip")) {
                device.setParam("alarm_video_clip", "OFF", "OFF");
            }
            if (!device.hasParam("videoclip_duration")) {
                device.setParam("videoclip_duration", "30", "30");
            }
            if (!device.hasParam("max_videoclip_duration")) {
                device.setParam("max_videoclip_duration", "30");
            }
            if (!device.hasParam("min_videoclip_duration")) {
                device.setParam("min_videoclip_duration", "6");
            }
        } else {
            device.setParam("has_videoclip_recording", "OFF");
        }
        if (device.getVideoEncoding().equals("MJPEG")) {
            device.setParam("has_mute_audio", "OFF");
            device.setParam("mute_audio", "ON", "ON");
        } else if (device.getVideoEncoding().equals("H264") || device.getVideoEncoding().equals("MPEG4")) {
            device.setParam("has_mute_audio", "ON");
            if (!device.hasParam("mute_audio")) {
                device.setParam("mute_audio", "OFF", "OFF");
            }
        }
        if (!this.isCorrectPostResponse(this.configureChannels(device))) {
            log.info((Object)("Channel configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "video_quality");
        boolean bl = muteAudio = device.getParamValue("has_mute_audio").equals("OFF") || device.getParamValue("mute_audio").equals("ON");
        if (!this.isCorrectPostResponse(this.configureAudio(device, muteAudio))) {
            log.info((Object)("Audio configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "mute_audio");
        boolean ledOff = device.getParamValue("system_ledoff").equals("ON");
        if (!this.isCorrectPostResponse(this.configureLed(device, ledOff))) {
            log.info((Object)("Led configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "system_ledoff");
        boolean privacyButtonEnabled = device.getParamValue("privacy_button").equals("ON");
        if (!this.isCorrectPostResponse(this.configurePrivacyButtonEnabled(device, privacyButtonEnabled))) {
            log.info((Object)("Privacy button configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "privacy_button");
        boolean motionDetectionEnabled = device.getParamValue("motion_detection").equals("ON");
        Map motionDetectionConfParams = this.prepareEventConfigurationParams(device, motionDetectionEnabled, EventName.HOMEMONITOR_PIR, EventType.PIR, false, false, false);
        if (!this.isCorrectPostResponse(this.configureEvent(device, motionDetectionConfParams))) {
            log.info((Object)("Motion detection event configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "motion_detection");
        if (!this.isCorrectPostResponse(this.configureHTTPNotifications(device))) {
            log.info((Object)("Http notifications configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        if (!this.isCorrectPostResponse(this.configurePirSensor(device))) {
            log.info((Object)("PIR sernsor configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        boolean illuminationEnabled = device.getParamValue("illumination").equals("ON");
        if (!this.isCorrectPostResponse(this.configureIlluminationEnabled(device, illuminationEnabled))) {
            log.info((Object)("Illumination configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "illumination");
        Integer sensitivity = Integer.parseInt(device.getParamValue("audio_detection_sensitivity"));
        if (!this.isCorrectPostResponse(this.configureAudioDetectionSensitivity(device, sensitivity))) {
            log.info((Object)("Audio detection sensitivity configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "audio_detection_sensitivity");
        boolean audioDetectionEnabled = device.getParamValue("audio_detection").equals("ON");
        Map audioDetectionConfParams = this.prepareEventConfigurationParams(device, audioDetectionEnabled, EventName.HOMEMONITOR_AD, EventType.AD, false, false, false);
        if (!this.isCorrectPostResponse(this.configureEvent(device, audioDetectionConfParams))) {
            log.info((Object)("Audio detection event configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.applyValueToRemoteValue(device, "audio_detection");
        if (!this.isCorrectPostResponse(this.configureTime(device))) {
            log.info((Object)("Time configuration failure for device with mac address '" + device.getMac() + "'."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        if (this.supportVideoClipRecording(device)) {
            if (!this.isCorrectPostResponse(this.configureAlarmMedia(device))) {
                log.info((Object)("Media alarm configuration failure for device with mac address '" + device.getMac() + "'."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            this.applyValueToRemoteValue(device, "videoclip_duration");
            boolean videoclipMotionSaved = false;
            boolean videoclipAudioSaved = false;
            boolean alarmVideoClipEnabled = device.getParamValue("alarm_video_clip").equals("ON");
            Map motionDetectionVideoClipConfParams = this.prepareEventConfigurationParams(device, alarmVideoClipEnabled && motionDetectionEnabled, EventName.HOMEMONITOR_PIR2, EventType.PIR, true, false, false);
            if (!this.isCorrectPostResponse(this.configureEvent(device, motionDetectionVideoClipConfParams))) {
                log.info((Object)("Motion detection video clip event configuration failure for device with mac address '" + device.getMac() + "'."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            videoclipMotionSaved = true;
            Map audioDetectionVideoClipConfParams = this.prepareEventConfigurationParams(device, alarmVideoClipEnabled && audioDetectionEnabled, EventName.HOMEMONITOR_AD2, EventType.AD, true, false, false);
            if (!this.isCorrectPostResponse(this.configureEvent(device, audioDetectionVideoClipConfParams))) {
                log.info((Object)("Audio detection video clip event configuration failure for device with mac address '" + device.getMac() + "'."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            videoclipAudioSaved = true;
            if (videoclipMotionSaved && videoclipAudioSaved) {
                this.applyValueToRemoteValue(device, "alarm_video_clip");
            }
        } else if (this.videoclipDisabledForBrickcom() && (alarmVideoClipEnabledValue = device.getParamValue("alarm_video_clip")) != null) {
            boolean videoclipMotionSaved = false;
            boolean videoclipAudioSaved = false;
            boolean alarmVideoClipEnabled = alarmVideoClipEnabledValue.equals("ON");
            Map motionDetectionVideoClipConfParams = this.prepareEventConfigurationParams(device, alarmVideoClipEnabled && motionDetectionEnabled, EventName.HOMEMONITOR_PIR2, EventType.PIR, true, false, false);
            if (!this.isCorrectPostResponse(this.configureEvent(device, motionDetectionVideoClipConfParams))) {
                log.info((Object)("Motion detection video clip event configuration failure for device with mac address '" + device.getMac() + "'."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            videoclipMotionSaved = true;
            Map audioDetectionVideoClipConfParams = this.prepareEventConfigurationParams(device, alarmVideoClipEnabled && audioDetectionEnabled, EventName.HOMEMONITOR_AD2, EventType.AD, true, false, false);
            if (!this.isCorrectPostResponse(this.configureEvent(device, audioDetectionVideoClipConfParams))) {
                log.info((Object)("Audio detection video clip event configuration failure for device with mac address '" + device.getMac() + "'."));
                return GenericLanDevice.ConfigurationStatus.FAILED;
            }
            videoclipAudioSaved = true;
            if (videoclipMotionSaved && videoclipAudioSaved) {
                this.applyValueToRemoteValue(device, "alarm_video_clip");
            }
        }
        if (this.isWifiSupported(this.deviceCapabilities)) {
            if (reconfiguration) {
                if (!this.isCorrectPostResponse(this.configureWifiSettings(device))) {
                    log.info((Object)("Wifi settings configuration failure for device with mac address " + device.getMac() + "."));
                    return GenericLanDevice.ConfigurationStatus.FAILED;
                }
            } else if (!this.restoreCameraWifiSettings(device)) {
                log.warn((Object)("Restore wifi settings from camera with mac='" + device.getMac() + "' problem."));
                return GenericLanDevice.ConfigurationStatus.MANUAL;
            }
        }
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    private void applyValueToRemoteValue(LanDeviceEntity device, String paramName) {
        LanDeviceParamEntity lanDeviceParam = device.getParam(paramName);
        if (lanDeviceParam == null) {
            return;
        }
        lanDeviceParam.setRemoteValue(lanDeviceParam.getValue());
    }

    private boolean videoclipDisabledForBrickcom() {
        boolean disabled = "OFF".equalsIgnoreCase(this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_BRICKCOM_VIDEOCLIP));
        log.debug((Object)("videoclipDisabledForBrickcom? " + disabled));
        return disabled;
    }

    private HTTPClientServiceResult configureChannels(LanDeviceEntity device) {
        VideoQuality videoQuality = this.getVideoQuality(device);
        String request = this.createConfigureChannelsUrl(device, videoQuality);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureChannelsUrl(LanDeviceEntity device, VideoQuality videoQuality) {
        HashMap<String, String> params = new HashMap<String, String>();
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        if (videoEncoding.equals("MJPEG")) {
            int quality = videoQuality.getQualityMjpeg();
            params.put("action", "updateAll");
            params.put("apply", "1");
            params.put("c1Enable", "1");
            params.put("c1VideoFormatCodecType", "MJPEG");
            params.put("c1VideoFormatResolutionWidth", "640");
            params.put("c1VideoFormatResolutionHeight", "480");
            params.put("c1VideoFormatFrameRate", String.valueOf(fps));
            params.put("c1VideoFormatQuality", String.valueOf(quality));
            params.put("c1VideoFormatConstantBitrate", "0");
            params.put("c1TransportType", "2");
            params.put("c2Enable", "1");
            params.put("c2VideoFormatCodecType", "MJPEG");
            params.put("c2VideoFormatResolutionWidth", "320");
            params.put("c2VideoFormatResolutionHeight", "240");
            params.put("c2VideoFormatFrameRate", String.valueOf(fps));
            params.put("c2VideoFormatQuality", String.valueOf(quality));
            params.put("c2VideoFormatConstantBitrate", "0");
            params.put("c2TransportType", "2");
        } else {
            params.put("action", "updateAll");
            params.put("apply", "1");
            params.put("c1Enable", "1");
            params.put("c1VideoFormatCodecType", "H264");
            params.put("c1VideoFormatResolutionWidth", "640");
            params.put("c1VideoFormatResolutionHeight", "480");
            params.put("c1VideoFormatFrameRate", String.valueOf(fps));
            params.put("c1VideoFormatConstantBitrate", "1");
            params.put("c1VideoFormatBitrateInKbps", String.valueOf(videoQuality.getBitrate(videoEncoding)));
            params.put("c1TransportType", "0");
            params.put("c1VideoFormatCQT", "0");
            params.put("c1VideoFormatGop", "0");
            params.put("c2Enable", "1");
            params.put("c2VideoFormatCodecType", "H264");
            params.put("c2VideoFormatResolutionWidth", "320");
            params.put("c2VideoFormatResolutionHeight", "240");
            params.put("c2VideoFormatFrameRate", String.valueOf(fps));
            params.put("c2VideoFormatConstantBitrate", "1");
            params.put("c2VideoFormatBitrateInKbps", String.valueOf(videoQuality.getBitrateLow(videoEncoding)));
            params.put("c2TransportType", "0");
            params.put("c2VideoFormatCQT", "0");
            params.put("c2VideoFormatGop", "0");
        }
        return this.createRequest(device, "/cgi-bin/channels.cgi", params);
    }

    private VideoQuality getVideoQuality(LanDeviceEntity device) {
        String level = device.getParamValue("video_quality");
        return this.getVideoQuality(level);
    }

    private VideoQuality getVideoQuality(String videoQualityLevel) {
        if (videoQualityLevel == null) {
            return null;
        }
        return (VideoQuality)videoQualities.get(VideoQualityLevel.valueOf((String)videoQualityLevel));
    }

    private HTTPClientServiceResult configureLed(LanDeviceEntity device, boolean off) {
        String request = this.createConfigureLedUrl(device, off);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureLedUrl(LanDeviceEntity device, boolean off) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        params.put("off", off ? "1" : "0");
        return this.createRequest(device, "/cgi-bin/led.cgi", params);
    }

    private HTTPClientServiceResult configureIlluminationEnabled(LanDeviceEntity device, boolean enabled) {
        String request = this.createConfigureIlluminationEnabledUrl(device, enabled);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureIlluminationEnabledUrl(LanDeviceEntity device, boolean enabled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        params.put("method", "1");
        params.put("apply", "1");
        params.put("level", enabled ? "10" : "0");
        return this.createRequest(device, "/cgi-bin/wledctl.cgi", params);
    }

    private HTTPClientServiceResult configurePrivacyButtonEnabled(LanDeviceEntity device, boolean enabled) {
        String request = this.createConfigurePrivacyButtonEnabledUrl(device, enabled);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigurePrivacyButtonEnabledUrl(LanDeviceEntity device, boolean enabled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "setPrivacy");
        params.put("privacyButtonEnabled", enabled ? "1" : "0");
        return this.createRequest(device, "/cgi-bin/camera.cgi", params);
    }

    private HTTPClientServiceResult configureAlarmMedia(LanDeviceEntity device) {
        Integer duration = Integer.parseInt(device.getParamValue("videoclip_duration"));
        String request = this.createConfigureAlamrMediaUrl(device, duration.intValue());
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureAlamrMediaUrl(LanDeviceEntity device, int duration) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "setAlarmMediaInfo");
        params.put("timeBeforeEvent", "5");
        params.put("timeAfterEvent", String.valueOf(duration - 5));
        params.put("maxBufferSize", "6144");
        params.put("snapshotPreAlarm", "0");
        params.put("snapshotPostAlarm", "1");
        return this.createRequest(device, "/cgi-bin/event.cgi", params);
    }

    private HTTPClientServiceResult configureEvent(LanDeviceEntity device, Map<String, String> params) {
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/event.cgi", params, HttpCommand.SendMethod.POST);
        if (this.isCorrectPostResponse(response) || response == null || response.getResult() != HTTPClientServiceResult.Result.OK) {
            return response;
        }
        String status = (String)this.parseResponse(response.getBodyAsText()).get("statusString");
        if (status != null && status.equals("This name already exists.")) {
            log.debug((Object)"Event with name 'HOMEMONITOR_PIR' exists already. Trying update this event");
            params.put("action", "updateEventSetting");
            return this.sendCommand(device, "/cgi-bin/event.cgi", params, HttpCommand.SendMethod.POST);
        }
        log.warn((Object)("Unexpected event configuration state: " + response + "."));
        HTTPClientServiceResult errorResponse = new HTTPClientServiceResult();
        errorResponse.setResult(HTTPClientServiceResult.Result.ERROR);
        return errorResponse;
    }

    private Map<String, String> prepareEventConfigurationParams(LanDeviceEntity device, boolean eventEnabled, EventName eventName, EventType eventType, boolean videoclipEnabled, boolean ledLightEnabled, boolean updateEvent) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", updateEvent ? "updateEventSetting" : "addEventSetting");
        params.put("name", eventName.name());
        params.put("enabled", eventEnabled ? "1" : "0");
        params.put("sched.type", "0");
        params.put("eventID", eventType.name());
        String actions = "SNAPSHOT:HTTP";
        if (device.getVideoEncoding().equals("H264") && !videoclipEnabled) {
            actions = "UDP:NONE";
            params.put("udp.ipAddress", this.udpNotificationServerIP);
            params.put("udp.portNo", this.udpNotificationServerPort);
            String message = String.valueOf(device.getMac().toUpperCase()) + "," + device.getParamValue("alarm_user") + "," + device.getParamValue("alarm_pass");
            params.put("udp.message", message);
        } else if (device.getVideoEncoding().equals("H264") && videoclipEnabled) {
            actions = "";
        }
        if (videoclipEnabled) {
            actions = String.valueOf(actions) + (actions.isEmpty() ? "" : ",");
            actions = String.valueOf(actions) + "SAVESTREAM:HTTP";
        }
        if (ledLightEnabled) {
            actions = String.valueOf(actions) + ",LIGHTLED:NONE";
        }
        params.put("actions", actions);
        return params;
    }

    private HTTPClientServiceResult configureAudio(LanDeviceEntity device, boolean muteAudio) {
        String request = this.createConfigureAudioUrl(device, muteAudio);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureAudioUrl(LanDeviceEntity device, boolean mute) {
        HashMap<String, String> params = new HashMap<String, String>();
        String state = mute ? "0" : "1";
        params.put("action", "updateAll");
        params.put("c1AudioEnabled", state);
        params.put("c1AudioFormatCodecType", "AMR");
        params.put("c1AudioFormatCodecSubType", "AMR-MR122");
        params.put("c2AudioEnabled", state);
        params.put("c2AudioFormatCodecType", "AMR");
        params.put("c2AudioFormatCodecSubType", "AMR-MR122");
        return this.createRequest(device, "/cgi-bin/channels.cgi", params);
    }

    private HTTPClientServiceResult configureHTTPNotifications(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "setHttp");
        params.put("HttpUrl", String.valueOf(this.serverUrl) + "/events/motion/brickcom");
        params.put("Message", "id=" + device.getMac());
        params.put("username", device.getParamValue("alarm_user"));
        params.put("password", device.getParamValue("alarm_pass"));
        return this.sendCommand(device, "/cgi-bin/event.cgi", params, HttpCommand.SendMethod.POST);
    }

    private HTTPClientServiceResult configurePirSensor(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        params.put("enabled", "0");
        params.put("sensitivity", "10");
        return this.sendCommand(device, "/cgi-bin/pirsensor.cgi", params, HttpCommand.SendMethod.POST);
    }

    private HTTPClientServiceResult configureAudioDetectionSensitivity(LanDeviceEntity device, Integer sensitivity) {
        String request = this.createConfigureAudioDetectionSensitivityUrl(device, sensitivity);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.POST);
    }

    private String createConfigureAudioDetectionSensitivityUrl(LanDeviceEntity device, Integer sensitivity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "setAudioDetection");
        params.put("sensitivity", this.mapSensitivity(sensitivity));
        return this.createRequest(device, "/cgi-bin/audio.cgi", params);
    }

    private HTTPClientServiceResult configureTime(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        params.put("type", "2");
        params.put("timezoneID", "13");
        params.put("ntp.ntpServerLoc1", "ntp.homemonitor.ch");
        params.put("ntp.ntpServerLoc2", "clock.stdtime.gov.tw");
        params.put("enableDST", "0");
        return this.sendCommand(device, "/cgi-bin/time.cgi", params, HttpCommand.SendMethod.POST);
    }

    private String mapSensitivity(Integer sensitivity) {
        if (sensitivity == null) {
            log.warn((Object)("Unexpected audio detection sensitivity: " + sensitivity + ". Default sensitivity will be apply."));
            return "5";
        }
        switch (sensitivity) {
            case 10: {
                return "1";
            }
            case 20: {
                return "2";
            }
            case 30: {
                return "3";
            }
            case 40: {
                return "4";
            }
            case 50: {
                return "5";
            }
            case 60: {
                return "6";
            }
            case 70: {
                return "7";
            }
            case 80: {
                return "8";
            }
            case 90: {
                return "9";
            }
            case 100: {
                return "10";
            }
        }
        log.warn((Object)("Unexpected audio detection sensitivity: " + sensitivity + ". Default sensitivity will be apply."));
        return "5";
    }

    private HTTPClientServiceResult configureWifiSettings(LanDeviceEntity device) {
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), this.createConfigureWifiUrl(device), HttpCommand.SendMethod.POST);
    }

    private boolean restoreCameraWifiSettings(LanDeviceEntity device) {
        Map wifiSettings = this.downloadWifiSettings(device);
        if (wifiSettings == null) {
            return false;
        }
        String ssid = (String)wifiSettings.get("SSID");
        if (ssid == null) {
            log.warn((Object)("Not found ssid for device with mac=" + device.getMac() + "."));
            return false;
        }
        WlanAccessPoint.WlanMode wlanMode = this.extractWlanMode(wifiSettings);
        if (wlanMode == null) {
            log.warn((Object)("Not found wlan mode for device with mac=" + device.getMac() + "."));
            return false;
        }
        String channel = (String)wifiSettings.get("channel");
        if (channel == null) {
            log.warn((Object)("Not found channel for device with mac=" + device.getMac() + "."));
            return false;
        }
        EncryptionMode.Encryption encryption = this.extractEncryption(wifiSettings);
        if (encryption == null) {
            log.warn((Object)("Not found encryption for device with mac=" + device.getMac() + "."));
            return false;
        }
        EncryptionMode.Algorithm algorithm = this.extractAlgorithm(encryption, wifiSettings);
        if (algorithm == null) {
            log.warn((Object)("Not found algorithm for device with mac=" + device.getMac() + "."));
            return false;
        }
        if (ssid.equals("Brickcom") && encryption == EncryptionMode.Encryption.OPEN) {
            device.setParam("wifi_enabled", "OFF", "OFF");
            device.setParam("wifi_alghoritm", "", "");
            device.setParam("wifi_encryption", "", "");
            device.setParam("wifi_channel", "", "");
            device.setParam("wifi_ssid", "", "");
            device.setParam("wifi_wlan_mode", "", "");
            device.setParam("wifi_bssid", "", "");
        } else {
            device.setParam("wifi_enabled", "ON", "ON");
            device.setParam("wifi_alghoritm", algorithm.name(), algorithm.name());
            device.setParam("wifi_encryption", encryption.name(), encryption.name());
            device.setParam("wifi_channel", channel, channel);
            device.setParam("wifi_ssid", ssid, ssid);
            device.setParam("wifi_wlan_mode", wlanMode.name(), wlanMode.name());
            device.setParam("wifi_bssid", "", "");
        }
        if (encryption == EncryptionMode.Encryption.OPEN) {
            device.setParam("wifi_wep_auth_mode", "", "");
            device.setParam("wifi_wep_key_length", "", "");
            device.setParam("wifi_wep_key_format", "", "");
            device.setParam("wifi_wep_key1", "", "");
            device.setParam("wifi_wep_key2", "", "");
            device.setParam("wifi_wep_key3", "", "");
            device.setParam("wifi_wep_key4", "", "");
            device.setParam("wifi_wep_default_key", "", "");
            device.setParam("wifi_pre_shared_key", "", "");
        } else if (encryption == EncryptionMode.Encryption.WEP) {
            WepAuthenticationType wepAuthType = this.extractWepAuthenticationType(wifiSettings);
            if (wepAuthType == null) {
                log.warn((Object)("Not found wep authentication type for device with mac=" + device.getMac() + "."));
                return false;
            }
            device.setParam("wifi_wep_auth_mode", wepAuthType.name(), wepAuthType.name());
            WepKeyType wepKeyType = this.extractWebKeyLength((String)wifiSettings.get("WEP.wepKeyLength"));
            if (wepKeyType.keyLength == null) {
                log.warn((Object)("Not found wep key length for device with mac=" + device.getMac() + "."));
                return false;
            }
            device.setParam("wifi_wep_key_length", wepKeyType.keyLength.name(), wepKeyType.keyLength.name());
            if (wepKeyType.keyFormat == null) {
                log.warn((Object)("Not found wep key format for device with mac=" + device.getMac() + "."));
                return false;
            }
            device.setParam("wifi_wep_key_format", wepKeyType.keyFormat.name(), wepKeyType.keyFormat.name());
            String key1 = (String)wifiSettings.get("WEP.encryptionKeyList.Keyentry1.encryptionKey");
            device.setParam("wifi_wep_key1", key1, key1);
            String key2 = (String)wifiSettings.get("WEP.encryptionKeyList.Keyentry2.encryptionKey");
            device.setParam("wifi_wep_key2", key2, key2);
            String key3 = (String)wifiSettings.get("WEP.encryptionKeyList.Keyentry3.encryptionKey");
            device.setParam("wifi_wep_key3", key3, key3);
            String key4 = (String)wifiSettings.get("WEP.encryptionKeyList.Keyentry4.encryptionKey");
            device.setParam("wifi_wep_key4", key4, key4);
            String wepDefaultKey = (String)wifiSettings.get("WEP.defaultTransmitKeyIndex");
            if (wepDefaultKey == null) {
                log.warn((Object)("Not found wep default key for device with mac=" + device.getMac() + "."));
                return false;
            }
            device.setParam("wifi_wep_default_key", wepDefaultKey, wepDefaultKey);
            device.setParam("wifi_pre_shared_key", "", "");
        } else {
            device.setParam("wifi_wep_auth_mode", "", "");
            device.setParam("wifi_wep_key_length", "", "");
            device.setParam("wifi_wep_key_format", "", "");
            device.setParam("wifi_wep_key1", "", "");
            device.setParam("wifi_wep_key2", "", "");
            device.setParam("wifi_wep_key3", "", "");
            device.setParam("wifi_wep_key4", "", "");
            device.setParam("wifi_wep_default_key", "", "");
            String password = wifiSettings.containsKey("WPA.sharedKey") ? (String)wifiSettings.get("WPA.sharedKey") : "";
            device.setParam("wifi_pre_shared_key", password, password);
        }
        return true;
    }

    private WlanAccessPoint.WlanMode extractWlanMode(Map<String, String> wifiSettings) {
        String wlanModeTextCode = wifiSettings.get("mode");
        if (wlanModeTextCode == null) {
            return null;
        }
        Integer wlanModeCode = Integer.parseInt(wlanModeTextCode);
        switch (wlanModeCode) {
            case 0: {
                return WlanAccessPoint.WlanMode.INFRASTRUCTURE;
            }
            case 1: {
                return WlanAccessPoint.WlanMode.AD_HOC;
            }
        }
        return null;
    }

    private WepAuthenticationType extractWepAuthenticationType(Map<String, String> wifiSettings) {
        String authenticationTypeText = wifiSettings.get("WEP.authenticationType");
        if (authenticationTypeText == null) {
            return null;
        }
        Integer authenticationType = Integer.parseInt(authenticationTypeText);
        switch (authenticationType) {
            case 0: {
                return WepAuthenticationType.OPEN;
            }
            case 1: {
                return WepAuthenticationType.SHARED;
            }
            case 2: {
                return WepAuthenticationType.AUTO;
            }
        }
        return null;
    }

    private WepKeyType extractWebKeyLength(String wepKeLengthText) {
        int[] oldCodes = new int[]{1, 2, 3, 4};
        int[] newCodes = new int[]{5, 10, 13, 26};
        if (wepKeLengthText == null) {
            return new WepKeyType(this);
        }
        Integer wepKeyLength = Integer.parseInt(wepKeLengthText);
        if (wepKeyLength == null) {
            return new WepKeyType(this);
        }
        if (this.contains(oldCodes, wepKeyLength.intValue())) {
            switch (wepKeyLength) {
                case 1: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_64_BITS, WepKeyFormat.HEX);
                }
                case 2: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_128_BITS, WepKeyFormat.HEX);
                }
                case 3: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_64_BITS, WepKeyFormat.ASCII);
                }
                case 4: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_128_BITS, WepKeyFormat.ASCII);
                }
            }
            return new WepKeyType(this);
        }
        if (this.contains(newCodes, wepKeyLength.intValue())) {
            switch (wepKeyLength) {
                case 10: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_64_BITS, WepKeyFormat.HEX);
                }
                case 26: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_128_BITS, WepKeyFormat.HEX);
                }
                case 5: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_64_BITS, WepKeyFormat.ASCII);
                }
                case 13: {
                    return new WepKeyType(this, WepKeyLength.LENGTH_128_BITS, WepKeyFormat.ASCII);
                }
            }
            return new WepKeyType(this);
        }
        log.warn((Object)("Unexpected wep key length code: " + wepKeyLength + "."));
        return new WepKeyType(this);
    }

    private boolean contains(int[] collection, int value) {
        int i = 0;
        while (i < collection.length) {
            if (collection[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private EncryptionMode.Encryption extractEncryption(Map<String, String> wifiSettings) {
        Integer securityMode = Integer.parseInt(wifiSettings.get("securityMode"));
        switch (securityMode) {
            case 0: {
                return EncryptionMode.Encryption.OPEN;
            }
            case 1: {
                return EncryptionMode.Encryption.WEP;
            }
            case 2: {
                return EncryptionMode.Encryption.WPA;
            }
            case 3: {
                return EncryptionMode.Encryption.WPA2;
            }
        }
        return null;
    }

    private EncryptionMode.Algorithm extractAlgorithm(EncryptionMode.Encryption encryption, Map<String, String> wifiSettings) {
        if (encryption == EncryptionMode.Encryption.OPEN) {
            return EncryptionMode.Algorithm.NONE;
        }
        if (encryption == EncryptionMode.Encryption.WEP) {
            return EncryptionMode.Algorithm.WEP;
        }
        Integer algorithm = Integer.parseInt(wifiSettings.get("WPA.algorithmType"));
        switch (algorithm) {
            case 0: {
                return EncryptionMode.Algorithm.TKIP;
            }
            case 1: {
                return EncryptionMode.Algorithm.AES_CCMP;
            }
        }
        return null;
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        return this.isRegisteredVieverUser(device) ? this.updateViewerUser(device) : this.registerViewerUser(device);
    }

    private boolean isRegisteredVieverUser(LanDeviceEntity device) {
        String viewerUsername = device.getParamValue("viewer_user");
        for (Map.Entry entry : this.deviceCapabilities.entrySet()) {
            if (!((String)entry.getKey()).endsWith(".username") || !((String)entry.getValue()).equals(viewerUsername)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        if (response == null || response.getResult() != HTTPClientServiceResult.Result.OK) {
            return false;
        }
        Map params = this.parseResponse(response.getBodyAsText());
        return "0".equals(params.get("statusCode"));
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        log.debug((Object)("start registerUser(device=" + device + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/users.cgi", params, HttpCommand.SendMethod.POST);
        log.debug((Object)("update viewer user response: " + response.toString()));
        return this.isCorrectPostResponse(response);
    }

    private boolean registerViewerUser(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "add");
        int index = this.getMaxUserIndex(this.deviceCapabilities) + 1;
        params.put("index", String.valueOf(index));
        params.put("username", device.getParamValue("viewer_user"));
        params.put("password", device.getParamValue("viewer_pass"));
        params.put("privilege", "0");
        return this.registerUser(device, params);
    }

    private int getMaxUserIndex(Map<String, String> users) {
        int index = 0;
        for (Map.Entry<String, String> entry : users.entrySet()) {
            int value;
            if (!entry.getKey().endsWith(".index") || (value = Integer.parseInt(entry.getValue())) <= index) continue;
            index = value;
        }
        return index;
    }

    private boolean updateViewerUser(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "update");
        String viewerUsername = device.getParamValue("viewer_user");
        int index = this.extractUserIndex(this.deviceCapabilities, viewerUsername);
        params.put("index", String.valueOf(index));
        params.put("username", viewerUsername);
        params.put("password", device.getParamValue("viewer_pass"));
        params.put("privilege", "0");
        return this.registerUser(device, params);
    }

    private boolean updateAdminUser(LanDeviceEntity device, Map<String, String> capabilities, String currentAdminPassword) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "update");
        int index = this.extractUserIndex(capabilities, "admin");
        params.put("index", String.valueOf(index));
        params.put("username", "admin");
        params.put("password", device.getPass());
        params.put("privilege", "1");
        return this.registerUser(device, params);
    }

    private int extractUserIndex(Map<String, String> capabilities, String username) {
        int subindex = this.extractUserSubindex(capabilities, username);
        if (subindex > -1) {
            String desiredKey = "User" + subindex + ".index";
            for (Map.Entry<String, String> entry : capabilities.entrySet()) {
                if (!entry.getKey().equals(desiredKey)) continue;
                return Integer.parseInt(entry.getValue());
            }
        }
        return -1;
    }

    private int extractUserSubindex(Map<String, String> capabilities, String username) {
        for (Map.Entry<String, String> entry : capabilities.entrySet()) {
            if (!entry.getKey().endsWith(".username") || !entry.getValue().equals(username)) continue;
            String sub = entry.getKey().replace("User", "").replace(".username", "");
            return Integer.parseInt(sub);
        }
        return -1;
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        log.debug((Object)("start getCurrentSnapshot(device=" + device + ", resolution=" + resolution + ")"));
        String pathParam = "snapshot_path_low";
        if (resolution.equals(device.getParamValue("resolution"))) {
            pathParam = "snapshot_path";
        } else if (resolution.equals("resolution_low")) {
            pathParam = "snapshot_path_low";
        }
        String path = device.getParamValue(pathParam);
        String request = String.valueOf(this.cameraBaseUrl(device)) + path;
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), request, HttpCommand.SendMethod.GET);
        return response == null ? null : response.getBody();
    }

    public ControlParams getControlParams() {
        return null;
    }

    public Set<String> getSupportedSettings() {
        HashSet<String> supportedSettings = new HashSet<String>();
        supportedSettings.add("system_ledoff");
        supportedSettings.add("privacy_button");
        supportedSettings.add("motion_detection");
        supportedSettings.add("illumination");
        supportedSettings.add("audio_detection");
        supportedSettings.add("audio_detection_sensitivity");
        supportedSettings.add("wifi_wlan_mode");
        supportedSettings.add("wifi_ssid");
        supportedSettings.add("wifi_channel");
        supportedSettings.add("wifi_encryption");
        supportedSettings.add("wifi_alghoritm");
        supportedSettings.add("wifi_pre_shared_key");
        supportedSettings.add("wifi_wep_auth_mode");
        supportedSettings.add("wifi_wep_key_length");
        supportedSettings.add("wifi_wep_key_format");
        supportedSettings.add("wifi_wep_key1");
        supportedSettings.add("wifi_wep_key2");
        supportedSettings.add("wifi_wep_key3");
        supportedSettings.add("wifi_wep_key4");
        supportedSettings.add("wifi_wep_default_key");
        supportedSettings.add("wifi_enabled");
        supportedSettings.add("video_quality");
        supportedSettings.add("alarm_video_clip");
        supportedSettings.add("videoclip_duration");
        supportedSettings.add("mute_audio");
        return supportedSettings;
    }

    private Set<String> getParamsToUpdate(LanDeviceEntity device, boolean force) {
        if (device == null || device.getLanDeviceParams() == null || device.getLanDeviceParams().isEmpty()) {
            return Collections.emptySet();
        }
        Set supportedSettigs = this.getSupportedSettings();
        HashSet<String> params = new HashSet<String>();
        for (LanDeviceParamEntity deviceParam : device.getLanDeviceParams()) {
            if (!supportedSettigs.contains(deviceParam.getName())) continue;
            if (force) {
                params.add(deviceParam.getName());
                continue;
            }
            if (!this.isChanged(deviceParam)) continue;
            if (deviceParam.getName().startsWith("wifi_")) {
                log.trace((Object)("Changed wifi param: " + deviceParam));
                params.add("wifi");
                continue;
            }
            params.add(deviceParam.getName());
        }
        log.debug((Object)("params to update: " + params));
        return params;
    }

    public void updateSettings(LanDeviceEntity device) {
        log.info((Object)("drvdrvdrvdrvdrvdrvdrvdrvdrvdrvdrvdrvdrvdrvdrv " + device.dump()));
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateSetting(LanDeviceEntity device, String paramName, Set<String> remainsParams) {
        if (remainsParams.contains(paramName)) {
            List requests = this.getUpdateSettingsRequests(device, paramName, null, remainsParams);
            for (SettingsRequest request : requests) {
                if (request == null) {
                    log.warn((Object)("Unexpected param. For this param could not create update request: " + paramName));
                }
                this.updateHandlerFactory.getInstance(this.getHttpClientService(), request.request, HttpCommand.SendMethod.POST, device, (UpdatedSettingsListener)this, request.params).run();
            }
        }
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        if (!this.getSupportedSettings().contains(paramName)) {
            log.debug((Object)("Device not supported setting with name " + paramName + "."));
            return UpdateSettingStatus.FAILED_PARAMUNSUPPORTED;
        }
        HashSet<String> remainsParams = new HashSet<String>();
        remainsParams.add(paramName);
        if (paramName.equals("motion_detection") || paramName.equals("audio_detection")) {
            device.setParam(paramName, paramValue, device.getParam(paramName) != null ? device.getParam(paramName).getRemoteValue() : null);
            this.updateSetting(device, paramName, remainsParams);
            return UpdateSettingStatus.SUCCESS;
        }
        List requests = this.getUpdateSettingsRequests(device, paramName, paramValue, remainsParams);
        if (requests.size() > 1) {
            log.warn((Object)"Unsupported operation yet. This opration requires to send more than one request.");
            return UpdateSettingStatus.ERROR;
        }
        SettingsRequest request = (SettingsRequest)requests.get(0);
        if (request == null) {
            log.warn((Object)("Unexpected param. For this param could not create update request: " + paramName));
            return UpdateSettingStatus.ERROR;
        }
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), request.request, HttpCommand.SendMethod.POST);
        if (this.isCorrectPostResponse(response)) {
            LanDeviceParamEntity processingParam = (LanDeviceParamEntity)request.params.get(0);
            if (this.lanDeviceService.updateLanDeviceParam(device.getLanDeviceId(), processingParam.getName(), paramValue, paramValue)) {
                return UpdateSettingStatus.SUCCESS;
            }
            log.warn((Object)("Setting " + paramName + " has not been updated in database"));
            return UpdateSettingStatus.ERROR;
        }
        return this.prepareUpdateSettingStatus(response);
    }

    /*
     * Exception decompiling
     */
    private UpdateSettingStatus prepareUpdateSettingStatus(HTTPClientServiceResult response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> List<T> wrap(T ... args) {
        ArrayList<T> container = new ArrayList<T>();
        T[] TArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            T arg = TArray[n2];
            container.add(arg);
            ++n2;
        }
        return container;
    }

    private List<SettingsRequest> getUpdateSettingsRequests(LanDeviceEntity device, String paramName, String paramValue, Set<String> remainsParams) {
        LanDeviceParamEntity param = device.getParam(paramName);
        if (paramValue == null && param != null) {
            paramValue = param.getValue();
        }
        if (paramName.equals("system_ledoff")) {
            remainsParams.remove("system_ledoff");
            boolean off = paramValue.equals("ON");
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureLedUrl(device, off), param)});
        }
        if (paramName.equals("privacy_button")) {
            remainsParams.remove("privacy_button");
            boolean enabled = paramValue.equals("ON");
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigurePrivacyButtonEnabledUrl(device, enabled), param)});
        }
        if (paramName.equals("mute_audio")) {
            remainsParams.remove("mute_audio");
            boolean mute = paramValue.equals("ON");
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureAudioUrl(device, mute), param)});
        }
        if (paramName.equals("illumination")) {
            remainsParams.remove("illumination");
            boolean enabled = paramValue.equals("ON");
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureIlluminationEnabledUrl(device, enabled), param)});
        }
        if (paramName.equals("audio_detection_sensitivity")) {
            remainsParams.remove("audio_detection_sensitivity");
            Integer sensitivity = Integer.valueOf(param.getValue());
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureAudioDetectionSensitivityUrl(device, sensitivity), param)});
        }
        if (paramName.equals("video_quality")) {
            remainsParams.remove("video_quality");
            VideoQuality videoQuality = this.getVideoQuality(param.getValue());
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureChannelsUrl(device, videoQuality), param)});
        }
        if (paramName.equals("video_recording_duration")) {
            remainsParams.remove("video_recording_duration");
            Integer duration = Integer.parseInt(device.getParamValue("video_recording_duration"));
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureAlamrMediaUrl(device, duration.intValue()), param)});
        }
        if (paramName.equals("alarm_video_clip")) {
            remainsParams.remove("alarm_video_clip");
            boolean videoClipEnabled = paramValue.equals("ON");
            boolean motionDetectionEnabled = device.getParamValue("motion_detection").equals("ON");
            String updateMotionDetectionUrl = this.createEnableEventUrl(device, EventName.HOMEMONITOR_PIR2, videoClipEnabled && motionDetectionEnabled);
            SettingsRequest motionDetectionRequest = new SettingsRequest(this, updateMotionDetectionUrl, this.wrap((Object[])new LanDeviceParamEntity[]{param}));
            boolean audioDetectionEnabled = device.getParamValue("audio_detection").equals("ON");
            String updateAudioDetectionUrl = this.createEnableEventUrl(device, EventName.HOMEMONITOR_AD2, videoClipEnabled && audioDetectionEnabled);
            SettingsRequest audioDetectionRequest = new SettingsRequest(this, updateAudioDetectionUrl, this.wrap((Object[])new LanDeviceParamEntity[]{param}));
            return this.wrap((Object[])new SettingsRequest[]{motionDetectionRequest, audioDetectionRequest});
        }
        if (paramName.equals("motion_detection")) {
            remainsParams.remove("motion_detection");
            boolean motionDetectionEnabled = paramValue.equals("ON");
            SettingsRequest updateMotionDetectionRequest = new SettingsRequest(this, this.createEnableEventUrl(device, EventName.HOMEMONITOR_PIR, motionDetectionEnabled), param);
            if (this.supportVideoClipRecording(device)) {
                boolean videoClipEnabled = device.getParamValue("alarm_video_clip").equals("ON");
                SettingsRequest updateMotionDetectionVideoClipRequest = new SettingsRequest(this, this.createEnableEventUrl(device, EventName.HOMEMONITOR_PIR2, motionDetectionEnabled && videoClipEnabled));
                return this.wrap((Object[])new SettingsRequest[]{updateMotionDetectionRequest, updateMotionDetectionVideoClipRequest});
            }
            return this.wrap((Object[])new SettingsRequest[]{updateMotionDetectionRequest});
        }
        if (paramName.equals("audio_detection")) {
            remainsParams.remove("audio_detection");
            boolean audioDetectionEnabled = paramValue.equals("ON");
            SettingsRequest updateAudioDetectionRequest = new SettingsRequest(this, this.createEnableEventUrl(device, EventName.HOMEMONITOR_AD, audioDetectionEnabled), param);
            if (this.supportVideoClipRecording(device)) {
                boolean videoClipEnabled = device.getParamValue("alarm_video_clip").equals("ON");
                SettingsRequest updateAudioDetectionVideoClipRequest = new SettingsRequest(this, this.createEnableEventUrl(device, EventName.HOMEMONITOR_AD2, audioDetectionEnabled && videoClipEnabled));
                return this.wrap((Object[])new SettingsRequest[]{updateAudioDetectionRequest, updateAudioDetectionVideoClipRequest});
            }
            return this.wrap((Object[])new SettingsRequest[]{updateAudioDetectionRequest});
        }
        if (paramName.equals("videoclip_duration")) {
            remainsParams.remove("videoclip_duration");
            Integer duration = Integer.parseInt(device.getParamValue("videoclip_duration"));
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureAlamrMediaUrl(device, duration.intValue()), param)});
        }
        if (paramName.equals("wifi")) {
            remainsParams.remove("wifi");
            return this.wrap((Object[])new SettingsRequest[]{new SettingsRequest(this, this.createConfigureWifiUrl(device), this.getChangedWifiParams(device))});
        }
        return null;
    }

    private String createEnableEventUrl(LanDeviceEntity device, EventName eventName, boolean enabled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "updateEventSetting");
        params.put("name", eventName.name());
        params.put("enabled", enabled ? "1" : "0");
        return this.createRequest(device, "/cgi-bin/event.cgi", params);
    }

    List<LanDeviceParamEntity> getChangedWifiParams(LanDeviceEntity device) {
        log.debug((Object)("start getChangedWifiParams(device=" + device + ")"));
        ArrayList<LanDeviceParamEntity> changedWifiParams = new ArrayList<LanDeviceParamEntity>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!param.getName().startsWith("wifi_") || !this.isChanged(param)) continue;
            changedWifiParams.add(param);
        }
        return changedWifiParams;
    }

    private boolean isChanged(LanDeviceParamEntity param) {
        if (param.getValue() == null && param.getRemoteValue() == null) {
            return false;
        }
        return param.getValue() == null && param.getRemoteValue() != null || param.getValue() != null && param.getRemoteValue() == null || !param.getValue().equals(param.getRemoteValue());
    }

    private String createConfigureWifiUrl(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        if (this.isWifiEnabled(device) && !this.isWlanSsidEmpty(device)) {
            log.debug((Object)"wifi enabled");
            if (this.getWlanMode(device) == WlanAccessPoint.WlanMode.INFRASTRUCTURE) {
                params.put("mode", "0");
                params.put("channel", "0");
            } else {
                params.put("mode", "1");
                params.put("channel", device.getParamValue("wifi_channel"));
            }
            params.put("SSID", device.getParamValue("wifi_ssid"));
            params.putAll(this.getSecurityMode(device));
        } else if (!this.isWifiEnabled(device)) {
            log.debug((Object)"wifi disabled");
            params.put("SSID", "Brickcom");
            params.put("securityMode", "0");
        }
        return this.createRequest(device, "/cgi-bin/wifi.cgi", params);
    }

    private boolean isWifiEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("wifi_enabled"));
    }

    private boolean isWlanSsidEmpty(LanDeviceEntity device) {
        return "".equals(this.getWlanSsid(device));
    }

    private String getWlanSsid(LanDeviceEntity device) {
        return device.getParamValue("wifi_ssid");
    }

    private WlanAccessPoint.WlanMode getWlanMode(LanDeviceEntity device) {
        return WlanAccessPoint.WlanMode.valueOf((String)device.getParamValue("wifi_wlan_mode"));
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> getSecurityMode(LanDeviceEntity device) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getAlgorithmType(LanDeviceEntity device) {
        String algorithmType = device.getParamValue("wifi_alghoritm");
        if (algorithmType == null) {
            return null;
        }
        if (algorithmType.equals("TKIP")) {
            return "0";
        }
        if (algorithmType.equals("AES_CCMP")) {
            return "1";
        }
        log.warn((Object)("Unexpected algorithm type: " + algorithmType + "."));
        return null;
    }

    private String getWepKeyLength(LanDeviceEntity device) {
        String keyLength = device.getParamValue("wifi_wep_key_length");
        String keyFormat = device.getParamValue("wifi_wep_key_format");
        if (keyLength == null || keyFormat == null) {
            return null;
        }
        if (keyLength.equals("LENGTH_128_BITS")) {
            return keyFormat.equals("HEX") ? "2" : "4";
        }
        return keyFormat.equals("HEX") ? "1" : "3";
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return this.checkStatus(device, "/cgi-bin/system.cgi?action=get");
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        String serialnumber = ((String)this.parseResponse(response.getBodyAsText()).get("macAddress")).toUpperCase();
        if (serialnumber == null || !serialnumber.substring(0, 8).equals(device.getMac().substring(0, 8))) {
            return AccessVerificationStatus.NOANSWER;
        }
        return AccessVerificationStatus.OK;
    }

    public String getMacAddress(LanDeviceEntity device) {
        String macAddress;
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/system.cgi?action=get", HttpCommand.SendMethod.GET);
        if (this.isCorrectResponse(response) && (macAddress = (String)this.parseResponse(response.getBodyAsText()).get("macAddress")) != null) {
            return macAddress.toUpperCase();
        }
        return null;
    }

    public void processUpdatedSettingsResponse(LanDeviceEntity entity, HTTPClientServiceResult response, List<LanDeviceParamEntity> processingParams) {
        log.debug((Object)("start processUpdatedSettingsResponse(response=" + response + ", processingParams=" + processingParams + ")"));
        if (processingParams == null || processingParams.isEmpty()) {
            return;
        }
        for (LanDeviceParamEntity processingParam : processingParams) {
            if (!this.isWifiParam(processingParam) && !this.isCorrectPostResponse(response)) continue;
            String value = processingParam.getValue();
            this.lanDeviceService.updateLanDeviceParam(entity.getLanDeviceId(), processingParam.getName(), value, value);
        }
    }

    private boolean isWifiParam(LanDeviceParamEntity param) {
        return param.getName().startsWith("wifi");
    }

    private String createRequest(LanDeviceEntity device, String baseCommand, Map<String, String> params) {
        return this.createRequest(device.getIpAddress(), device.getPort().intValue(), device.getUsername(), device.getPass(), baseCommand, params);
    }

    private String createRequest(String ipAddress, int port, String username, String password, String baseCommand, Map<String, String> params) {
        return this.createBaseRequest(ipAddress, Integer.valueOf(port), username, password, this.createCommand(baseCommand, params));
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        log.debug((Object)("start getWirelessNetworks(device=" + device + ")"));
        ArrayList<WlanAccessPoint> accessPoints = new ArrayList<WlanAccessPoint>();
        String wifiData = this.searchWlanAccessPoints(device);
        log.debug((Object)("start wifi data:\n" + wifiData + "\nend wifiData"));
        if (wifiData == null || wifiData.trim().length() == 0) {
            return accessPoints;
        }
        List accessPointsRawData = this.divideWifiRawData(wifiData);
        for (Map accessPointRawData : accessPointsRawData) {
            WlanAccessPoint accessPoint = this.parseWirelessRawData(accessPointRawData);
            if (accessPoint == null) continue;
            accessPoints.add(accessPoint);
        }
        log.debug((Object)("exit getWirelessNetworks(device=...): " + accessPoints));
        return accessPoints;
    }

    private List<String> extractWirelessRows(String text) {
        if (text == null) {
            return Collections.emptyList();
        }
        ArrayList<String> wirelessRows = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{\"Channel\".*\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            wirelessRows.add(text.substring(matcher.start(), matcher.end()));
        }
        return wirelessRows;
    }

    private Map<String, String> extractWirelessRawParameters(String text) {
        log.debug((Object)("start extractWirelessRawParameters(text=" + text + ")"));
        if (text == null || text.trim().length() == 0) {
            return Collections.emptyMap();
        }
        text = text.replace("{", "");
        text = text.replace("\"", "");
        text = text.replace("}", "");
        String[] params = text.split(",");
        HashMap<String, String> wirelessParameters = new HashMap<String, String>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            log.trace((Object)("Processing param: " + param));
            if (param == null || param.trim().length() == 0 || !param.contains(":")) {
                log.warn((Object)("Unexpected wireless param representation: " + param));
            } else {
                int colonPos = param.indexOf(":");
                String key = param.substring(0, colonPos).trim();
                String value = param.substring(colonPos + 1).trim();
                wirelessParameters.put(key, value);
            }
            ++n2;
        }
        log.debug((Object)("exit extractWirelessRawParameters(text=" + text + "): " + wirelessParameters));
        return wirelessParameters;
    }

    private WlanAccessPoint parseWirelessRawParameters(Map<String, String> params) {
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(this.parseWlanMode(params.get("NT")));
        wlanAccessPoint.setSsid(params.get("SSID"));
        wlanAccessPoint.setChannel(Integer.valueOf(Integer.parseInt(params.get("Channel"))));
        wlanAccessPoint.setSignalStrength(Integer.valueOf(Integer.parseInt(params.get("Signal"))));
        wlanAccessPoint.setEncryptionModes(this.parseSecurity(params.get("Security")));
        return wlanAccessPoint;
    }

    private WlanAccessPoint.WlanMode parseWlanMode(String text) {
        if (text == null) {
            return null;
        }
        return text.equals("Infrastructure") ? WlanAccessPoint.WlanMode.INFRASTRUCTURE : WlanAccessPoint.WlanMode.AD_HOC;
    }

    private List<EncryptionMode> parseSecurity(String security) {
        if (security == null || security.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<EncryptionMode> modes = new ArrayList<EncryptionMode>();
        if (security.equals("NONE")) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
            return modes;
        }
        if (security.equals("WEP")) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP));
            return modes;
        }
        if (security.equals("WPA-PSK/WPA2-PSK")) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP));
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP));
            modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.TKIP));
            return modes;
        }
        List<String> securitySegments = Arrays.asList(security.split("/"));
        if (securitySegments.contains("WPAPSK")) {
            if (securitySegments.contains("TKIP")) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
            }
            if (securitySegments.contains("AES")) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP));
            }
        }
        if (securitySegments.contains("WPA2PSK")) {
            if (securitySegments.contains("TKIP")) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.TKIP));
            }
            if (securitySegments.contains("AES")) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP));
            }
        }
        return modes;
    }

    private boolean isWifiSupported(Map<String, String> deviceCapabilities) {
        String wifi = deviceCapabilities.get("Wireless");
        return wifi != null && !wifi.equals("0");
    }

    public List<WlanAccessPoint> parseWirelessNetworks(String wifiData) {
        if (wifiData == null || wifiData.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<WlanAccessPoint> accessPoints = new ArrayList<WlanAccessPoint>();
        return accessPoints;
    }

    private List<Map<String, String>> divideWifiRawData(String wifiData) {
        String[] accessPointsRawData;
        ArrayList<Map<String, String>> accessPoints = new ArrayList<Map<String, String>>();
        wifiData = wifiData.replaceAll("^\\s*", "");
        wifiData = wifiData.replaceAll("\n\\s*", "\n");
        wifiData = wifiData.replace("\"", "");
        String[] stringArray = accessPointsRawData = wifiData.split("Cell.* - ");
        int n = accessPointsRawData.length;
        int n2 = 0;
        while (n2 < n) {
            String accessPointRawData = stringArray[n2];
            if (accessPointRawData.trim().length() > 0) {
                accessPoints.add(this.parseRawAccessPointsData(accessPointRawData));
            }
            ++n2;
        }
        return accessPoints;
    }

    private Map<String, String> parseRawAccessPointsData(String rawAccessPointData) {
        String[] rows;
        HashMap<String, String> accessPoint = new HashMap<String, String>();
        int ieIndex = -1;
        String[] stringArray = rows = rawAccessPointData.split("\n");
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            int colonPos = row.indexOf(":");
            if (colonPos == -1) {
                log.warn((Object)("Unexpected param representation: " + row));
            } else {
                String key = row.substring(0, colonPos).trim();
                String value = row.substring(colonPos + 1).trim();
                if (key.equals("IE")) {
                    accessPoint.put("ie_count", String.valueOf(++ieIndex + 1));
                }
                key = key.replaceAll(" \\([0-9]{1}\\)$", "");
                key = ieIndex == -1 ? key : String.valueOf(key) + "_" + ieIndex;
                accessPoint.put(key, value);
            }
            ++n2;
        }
        return accessPoint;
    }

    private WlanAccessPoint parseWirelessRawData(Map<String, String> params) {
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(this.getWlanMode(params));
        wlanAccessPoint.setSsid(params.get("ESSID"));
        wlanAccessPoint.setChannel(this.getChannel(params));
        wlanAccessPoint.setSignalStrength(this.extractSignalStrength(params));
        List encryptionModes = this.getEncryptionModes(params);
        if (encryptionModes.isEmpty()) {
            log.warn((Object)"Wlan access point are secured by unsupported encryption or algorithm!");
            return null;
        }
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        wlanAccessPoint.setBssid(params.get("Address"));
        return wlanAccessPoint;
    }

    private Integer extractSignalStrength(Map<String, String> params) {
        String quality = params.get("Quality");
        if (quality == null || quality.trim().length() == 0) {
            return null;
        }
        int slashPos = quality.indexOf("/");
        if (slashPos == -1) {
            log.warn((Object)("Unexpected representation signal quality: '" + quality + "'."));
            return null;
        }
        return Integer.parseInt(quality.substring(0, slashPos));
    }

    private List<EncryptionMode> getEncryptionModes(Map<String, String> params) {
        ArrayList<EncryptionMode> modes = new ArrayList<EncryptionMode>();
        if (!this.isSecuritySupported(params)) {
            modes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        } else {
            int ieCount = this.getIeCount(params);
            if (ieCount == 0) {
                modes.add(new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP));
            } else {
                int i = 0;
                while (i < this.getIeCount(params)) {
                    if (!this.isPSKSecurity(params, i)) {
                        log.debug((Object)"Non PSK security detected. This security will be ignored!");
                    } else {
                        EncryptionMode.Encryption encryption = this.getEncryptionType(params, i);
                        if (encryption == null) {
                            log.warn((Object)"Unsupported encryption detected. This security will be ignored!.");
                        } else {
                            List algorithms = this.getAlgorithms(params, i);
                            if (algorithms.isEmpty()) {
                                log.warn((Object)"No algorithms found. This security will be ignored!.");
                            } else {
                                for (EncryptionMode.Algorithm algorithm : algorithms) {
                                    modes.add(new EncryptionMode(encryption, algorithm));
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return modes;
    }

    private boolean isSecuritySupported(Map<String, String> params) {
        String encryptionKey = params.get("Encryption key");
        return encryptionKey != null && !encryptionKey.equals("off");
    }

    private int getIeCount(Map<String, String> params) {
        String ieCount = params.get("ie_count");
        return ieCount == null ? 0 : Integer.parseInt(ieCount);
    }

    private boolean isPSKSecurity(Map<String, String> params, int index) {
        String authenticationSuites = params.get("Authentication Suites_" + index);
        return authenticationSuites != null && authenticationSuites.contains("PSK");
    }

    private EncryptionMode.Encryption getEncryptionType(Map<String, String> params, int index) {
        String ie = params.get("IE_" + index);
        if (ie == null || ie.trim().length() == 0) {
            log.warn((Object)("Not found encryption for index " + index + "."));
            return null;
        }
        if (ie.contains("WPA2")) {
            return EncryptionMode.Encryption.WPA2;
        }
        if (ie.contains("WPA")) {
            return EncryptionMode.Encryption.WPA;
        }
        log.warn((Object)("Unexpected eacryption: '" + ie + "'."));
        return null;
    }

    private List<EncryptionMode.Algorithm> getAlgorithms(Map<String, String> params, int index) {
        String pairwiseCiphers = params.get("Pairwise Ciphers_" + index);
        if (pairwiseCiphers == null || pairwiseCiphers.trim().length() == 0) {
            log.warn((Object)("No algorithm found for index " + index + "."));
            return Collections.emptyList();
        }
        ArrayList<EncryptionMode.Algorithm> algorithms = new ArrayList<EncryptionMode.Algorithm>();
        if (pairwiseCiphers.contains("CCMP")) {
            algorithms.add(EncryptionMode.Algorithm.AES_CCMP);
        }
        if (pairwiseCiphers.contains("TKIP")) {
            algorithms.add(EncryptionMode.Algorithm.TKIP);
        }
        return algorithms;
    }

    private WlanAccessPoint.WlanMode getWlanMode(Map<String, String> params) {
        String mode = params.get("Mode");
        if (mode == null || mode.trim().length() == 0) {
            log.warn((Object)("Not found wlan mode: '" + mode + "'."));
            return null;
        }
        if (mode.equals("Managed")) {
            return WlanAccessPoint.WlanMode.INFRASTRUCTURE;
        }
        if (mode.equals("Ad-Hoc")) {
            return WlanAccessPoint.WlanMode.AD_HOC;
        }
        log.warn((Object)("Unrecognized wlan mode: '" + mode + "'."));
        return null;
    }

    private Integer getChannel(Map<String, String> params) {
        return CameraBrickcomGeneric.calculateChannelNumber((Integer)this.getChannelFrequency(params));
    }

    private Integer getChannelFrequency(Map<String, String> params) {
        String frequency = params.get("Frequency");
        if (frequency == null || frequency.trim().length() == 0) {
            return null;
        }
        Pattern pattern = Pattern.compile("^([0-9]+\\.[0-9]+) GHz");
        Matcher matcher = pattern.matcher(frequency);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1).replace(".", ""));
        }
        return matcher.find() ? Integer.valueOf(Integer.parseInt(matcher.group(1).replace(".", ""))) : null;
    }

    private static Integer calculateChannelNumber(Integer frequencyInMHz) {
        int minFrequency = 2412;
        int macFrequency = 2472;
        return frequencyInMHz == null || frequencyInMHz < minFrequency || frequencyInMHz > macFrequency ? null : Integer.valueOf((frequencyInMHz - minFrequency) / 5 + 1);
    }

    private Map<String, String> downloadWifiSettings(LanDeviceEntity device) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "get");
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/wifi.cgi", params, HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            return null;
        }
        return this.parseResponse(response.getBodyAsText());
    }

    public String getConnCheckUrl() {
        return "/blank.html";
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        String viewerUsername;
        log.debug((Object)("start checkConfiguration(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/configfile.dump", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            if (response.getResult() == HTTPClientServiceResult.Result.NOACCESS) {
                return CheckConfigurationStatus.FAILED_NOACCESS;
            }
            if (response.getResult() == HTTPClientServiceResult.Result.NOANSWER) {
                return CheckConfigurationStatus.FAILED_NOANSWER;
            }
            return CheckConfigurationStatus.ERROR;
        }
        Map settings = this.parseResponse(response.getBodyAsText());
        int userIndex = this.extractUserListIndex(settings, viewerUsername = device.getParamValue("viewer_user"));
        if (userIndex == -1) {
            log.debug((Object)("Not found viewer user '" + viewerUsername + "' on camera."));
            return CheckConfigurationStatus.INCORRECT;
        }
        HashMap<String, String> expectedSettings = new HashMap<String, String>();
        expectedSettings.put("UserSetSetting.userList.users" + userIndex + ".username", viewerUsername);
        expectedSettings.put("UserSetSetting.userList.users" + userIndex + ".password", device.getParamValue("viewer_pass"));
        expectedSettings.put("UserSetSetting.userList.users" + userIndex + ".privilege", "0");
        VideoQuality videoQuality = this.getVideoQuality(device);
        if (videoQuality == null) {
            log.debug((Object)"Not found video quality parameter.");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) && (!device.getVideoEncoding().equals("H264") || !device.hasParam("rtsp_port"))) {
            log.debug((Object)"RTSP port param missing.");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (!(this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) || !device.getVideoEncoding().equals("H264"))) {
            log.debug((Object)"old GDClient configured with H264");
            return CheckConfigurationStatus.INCORRECT;
        }
        if (device.getVideoEncoding().equals("MJPEG") && device.getParamValue("has_mute_audio").equals("ON")) {
            log.debug((Object)"mute audio enabled for MJPEG - need to reconfigure to disable it");
            return CheckConfigurationStatus.INCORRECT;
        }
        if ((device.getVideoEncoding().equals("MPEG4") || device.getVideoEncoding().equals("H264")) && device.getParamValue("has_mute_audio").equals("OFF")) {
            log.debug((Object)("mute audio disabled for " + device.getVideoEncoding() + " - need to reconfigure to enable it"));
            return CheckConfigurationStatus.INCORRECT;
        }
        String videoEncoding = device.getVideoEncoding();
        int fps = videoQuality.getFps(videoEncoding);
        expectedSettings.put("ChannelSetSetting.channelList.channels0.enabled", "1");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.codecType", "MJPEG");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionWidth", "640");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionHeight", "480");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.frameRate", String.valueOf(fps));
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.quality", String.valueOf(videoQuality.getQualityMjpeg()));
        expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.constantBitrate", "0");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.transportType", "2");
        if (videoEncoding.equals("MJPEG")) {
            int quality = videoQuality.getQualityMjpeg();
            expectedSettings.put("ChannelSetSetting.channelList.channels0.enabled", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.codecType", "MJPEG");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionWidth", "640");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionHeight", "480");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.frameRate", String.valueOf(fps));
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.quality", String.valueOf(quality));
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.constantBitrate", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.transportType", "2");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.enabled", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.codecType", "MJPEG");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.resolutionWidth", "320");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.resolutionHeight", "240");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.frameRate", String.valueOf(fps));
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.quality", String.valueOf(quality));
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.constantBitrate", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.transportType", "2");
        } else if (device.getVideoEncoding().equals("H264")) {
            expectedSettings.put("ChannelSetSetting.channelList.channels0.enabled", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.transportType", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.codecType", "H264");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.constantBitrate", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.bitrateInKbps", String.valueOf(videoQuality.getBitrate(videoEncoding)));
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.frameRate", String.valueOf(fps));
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionHeight", "480");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.resolutionWidth", "640");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.gop", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels0.video.format.customQt", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.enabled", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.transportType", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.codecType", "H264");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.constantBitrate", "1");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.bitrateInKbps", String.valueOf(videoQuality.getBitrateLow(videoEncoding)));
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.frameRate", String.valueOf(fps));
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.resolutionHeight", "240");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.resolutionWidth", "320");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.gop", "0");
            expectedSettings.put("ChannelSetSetting.channelList.channels1.video.format.customQt", "0");
        } else {
            log.warn((Object)("Unexpected video encoding: " + device.getVideoEncoding() + "."));
            return CheckConfigurationStatus.INCORRECT;
        }
        String muteAudio = device.getParamValue("mute_audio");
        String muteAudioValue = muteAudio.equals("OFF") ? "1" : "0";
        expectedSettings.put("ChannelSetSetting.channelList.channels0.audio.enabled", muteAudioValue);
        expectedSettings.put("ChannelSetSetting.channelList.channels0.audio.format.codecType", "AMR");
        expectedSettings.put("ChannelSetSetting.channelList.channels0.audio.format.codecSubType", "AMR-MR122");
        expectedSettings.put("ChannelSetSetting.channelList.channels1.audio.enabled", muteAudioValue);
        expectedSettings.put("ChannelSetSetting.channelList.channels1.audio.format.codecType", "AMR");
        expectedSettings.put("ChannelSetSetting.channelList.channels1.audio.format.codecSubType", "AMR-MR122");
        String systemLedOff = device.getParamValue("system_ledoff");
        expectedSettings.put("LEDSetting.off", systemLedOff.equals("OFF") ? "0" : "1");
        String privacyButton = device.getParamValue("privacy_button");
        expectedSettings.put("PrivacySetting.ButtonEnabled", privacyButton.equals("ON") ? "1" : "0");
        int motionDetectionEventIndex = this.extractEventIndex(settings, "HOMEMONITOR_PIR");
        if (motionDetectionEventIndex == -1) {
            log.debug((Object)"Not found motion detection event configuration");
            return CheckConfigurationStatus.INCORRECT;
        }
        expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".token", "HOMEMONITOR_PIR");
        boolean motionDetectionEnabled = device.getParamValue("motion_detection").equals("ON");
        expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".enabled", motionDetectionEnabled ? "1" : "0");
        expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".sched.type", "0");
        expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".eventName", "PIR");
        if (device.getVideoEncoding().equals("H264")) {
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".actions", "UDP:NONE");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".udp.ipAddress", this.udpNotificationServerIP);
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".udp.portNo", this.udpNotificationServerPort);
            String message = String.valueOf(device.getMac().toUpperCase()) + "," + device.getParamValue("alarm_user") + "," + device.getParamValue("alarm_pass");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".udp.message", message);
        } else {
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionEventIndex + ".actions", "SNAPSHOT:HTTP");
        }
        expectedSettings.put("EventHttp.transport.destURL", String.valueOf(this.serverUrl) + "/events/motion/brickcom");
        expectedSettings.put("EventHttp.transport.destMsg", "id=" + device.getMac());
        expectedSettings.put("EventHttp.transport.username", device.getParamValue("alarm_user"));
        expectedSettings.put("EventHttp.transport.password", device.getParamValue("alarm_pass"));
        expectedSettings.put("PIRSensor.sensitivity", "10");
        expectedSettings.put("PIRSensor.enabled", "0");
        String illumination = device.getParamValue("illumination");
        expectedSettings.put("LightCTL.level", illumination.equals("ON") ? "10" : "0");
        expectedSettings.put("LightCTL.method", "1");
        expectedSettings.put("AudioDetection.enabled", "0");
        Integer audioDetectionSensitivity = Integer.parseInt(device.getParamValue("audio_detection_sensitivity"));
        expectedSettings.put("AudioDetection.sensitivity", this.mapSensitivity(audioDetectionSensitivity));
        int audioDetectionEventIndex = this.extractEventIndex(settings, "HOMEMONITOR_AD");
        if (audioDetectionEventIndex == -1) {
            log.debug((Object)"Not found audio detection event configuration.");
            return CheckConfigurationStatus.INCORRECT;
        }
        expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".token", "HOMEMONITOR_AD");
        boolean audioDetectionEnabled = device.getParamValue("audio_detection").equals("ON");
        expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".enabled", audioDetectionEnabled ? "1" : "0");
        expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".sched.type", "0");
        expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".eventName", "AD");
        if (device.getVideoEncoding().equals("H264")) {
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".actions", "UDP:NONE");
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".udp.ipAddress", this.udpNotificationServerIP);
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".udp.portNo", this.udpNotificationServerPort);
            String message = String.valueOf(device.getMac().toUpperCase()) + "," + device.getParamValue("alarm_user") + "," + device.getParamValue("alarm_pass");
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".udp.message", message);
        } else {
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionEventIndex + ".actions", "SNAPSHOT:HTTP");
        }
        expectedSettings.put("TimeSetting.type", "2");
        expectedSettings.put("TimeSetting.enableDST", "0");
        expectedSettings.put("TimeSetting.timezoneID", "13");
        expectedSettings.put("TimeSetting.ntp.ntpServerLoc1", "ntp.homemonitor.ch");
        expectedSettings.put("TimeSetting.ntp.ntpServerLoc2", "clock.stdtime.gov.tw");
        if (this.supportVideoClipRecording(device)) {
            int audioDetectionVideoClipEventIndex;
            int motionDetectionVideoClipEventIndex = this.extractEventIndex(settings, "HOMEMONITOR_PIR2");
            if (motionDetectionVideoClipEventIndex == -1) {
                log.debug((Object)"Not found motion detection vide clipevent configuration.");
                return CheckConfigurationStatus.INCORRECT;
            }
            boolean videoClipEnabled = device.getParamValue("alarm_video_clip").equals("ON");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionVideoClipEventIndex + ".token", "HOMEMONITOR_PIR2");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionVideoClipEventIndex + ".enabled", videoClipEnabled && motionDetectionEnabled ? "1" : "0");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionVideoClipEventIndex + ".sched.type", "0");
            expectedSettings.put("Event.ruleList.cEntry" + motionDetectionVideoClipEventIndex + ".eventName", "PIR");
            if (device.getVideoEncoding().equals("H264")) {
                expectedSettings.put("Event.ruleList.cEntry" + motionDetectionVideoClipEventIndex + ".actions", "SAVESTREAM:HTTP");
            }
            if ((audioDetectionVideoClipEventIndex = this.extractEventIndex(settings, "HOMEMONITOR_AD2")) == -1) {
                log.debug((Object)"Not found audio detection vide clipevent configuration.");
                return CheckConfigurationStatus.INCORRECT;
            }
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionVideoClipEventIndex + ".token", "HOMEMONITOR_AD2");
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionVideoClipEventIndex + ".enabled", videoClipEnabled && audioDetectionEnabled ? "1" : "0");
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionVideoClipEventIndex + ".sched.type", "0");
            expectedSettings.put("Event.ruleList.cEntry" + audioDetectionVideoClipEventIndex + ".eventName", "AD");
            if (device.getVideoEncoding().equals("H264")) {
                expectedSettings.put("Event.ruleList.cEntry" + audioDetectionVideoClipEventIndex + ".actions", "SAVESTREAM:HTTP");
            }
            expectedSettings.put("AlarmMediaInfo.snapShotEnabled", "1");
            expectedSettings.put("AlarmMediaInfo.videoClipEnabled", "1");
            expectedSettings.put("AlarmMediaInfo.preAlarmInterval", "5");
            Integer videoClipDuration = Integer.parseInt(device.getParamValue("videoclip_duration"));
            expectedSettings.put("AlarmMediaInfo.postAlarmInterval", String.valueOf(videoClipDuration - 5));
            expectedSettings.put("AlarmMediaInfo.snapshotPreAlarm", "0");
            expectedSettings.put("AlarmMediaInfo.snapshotPostAlarm", "1");
            expectedSettings.put("AlarmMediaInfo.maxBufferSize", "6144");
            expectedSettings.put("AlarmMediaInfo.chIndexToRecord", "1");
        } else if (!this.videoclipDisabledForBrickcom() && this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device)) {
            return CheckConfigurationStatus.INCORRECT;
        }
        expectedSettings.putAll(this.getExpectedWifiSettings(device, (String)settings.get("DeviceBasicInfo.firmwareVersion")));
        return this.verifySettings(settings, expectedSettings) ? CheckConfigurationStatus.CORRECT : CheckConfigurationStatus.INCORRECT;
    }

    private boolean supportVideoClipRecording(LanDeviceEntity device) {
        String hasVideoclipRecording = device.getParamValue("has_videoclip_recording");
        return hasVideoclipRecording != null && hasVideoclipRecording.equals("ON");
    }

    private Map<String, String> getExpectedWifiSettings(LanDeviceEntity device, String firmwareVersion) {
        HashMap<String, String> wifiSettings = new HashMap<String, String>();
        if (this.isWifiEnabled(device)) {
            if (this.getWlanMode(device) == WlanAccessPoint.WlanMode.INFRASTRUCTURE) {
                wifiSettings.put("WIFISetting.mode", "0");
                wifiSettings.put("WIFISetting.channel", "0");
            } else {
                wifiSettings.put("WIFISetting.mode", "1");
                wifiSettings.put("WIFISetting.channel", device.getParamValue("wifi_channel"));
            }
            wifiSettings.put("WIFISetting.SSID", device.getParamValue("wifi_ssid"));
            wifiSettings.putAll(this.getExpectedWifiSecurityMode(device, firmwareVersion));
        } else {
            wifiSettings.put("WIFISetting.SSID", "Brickcom");
            wifiSettings.put("WIFISetting.securityMode", "0");
        }
        return wifiSettings;
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> getExpectedWifiSecurityMode(LanDeviceEntity device, String firmwareVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int extractUserListIndex(Map<String, String> settings, String username) {
        if (!settings.containsValue(username)) {
            return -1;
        }
        for (Map.Entry<String, String> setting : settings.entrySet()) {
            if (!setting.getValue().equals(username)) continue;
            String index = setting.getKey().replace("UserSetSetting.userList.users", "").replace(".username", "").trim();
            return Integer.parseInt(index);
        }
        return -1;
    }

    private int extractEventIndex(Map<String, String> settings, String eventName) {
        log.debug((Object)("start extractEventIndex(settings=..., eventName=" + eventName + ")"));
        for (Map.Entry<String, String> setting : settings.entrySet()) {
            if (!setting.getValue().equals(eventName)) continue;
            String index = setting.getKey().replace("Event.ruleList.cEntry", "").replace(".token", "").trim();
            return Integer.parseInt(index);
        }
        return -1;
    }

    protected boolean verifySettings(Map<String, String> actualSettings, Map<String, String> expectedSettings) {
        for (Map.Entry<String, String> expectedSetting : expectedSettings.entrySet()) {
            if (this.verifySetting(actualSettings, expectedSetting.getKey(), expectedSetting.getValue())) continue;
            log.debug((Object)("Unexpected camera setting '" + expectedSetting.getKey() + "'. Expected value is '" + expectedSetting.getValue() + "' but was '" + actualSettings.get(expectedSetting.getKey()) + "'"));
            return false;
        }
        return true;
    }

    private boolean verifySetting(Map<String, String> settings, String settingName, String expectedSettingValue) {
        String settingValue = settings.get(settingName);
        return settingValue != null && settingValue.equals(expectedSettingValue);
    }

    public GenericLanDevice.ConfigurationStatus reconfigure(LanDeviceEntity device) {
        String[] commands;
        HashMap capabilities = new HashMap();
        String[] stringArray = commands = new String[]{"/cgi-bin/system.cgi?action=get", "/cgi-bin/capability.cgi?action=get", "/cgi-bin/featureList.cgi?action=get", "/cgi-bin/channels.cgi?action=get", "/cgi-bin/users.cgi?action=getUsers"};
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            HTTPClientServiceResult response = this.sendCommand(device, cmd, HttpCommand.SendMethod.GET);
            if (!this.isCorrectResponse(response)) {
                log.info((Object)("Failed to download capability '" + cmd + "' for device with landDeviceId=" + device.getLanDeviceId() + "."));
                return GenericLanDevice.ConfigurationStatus.ERROR;
            }
            capabilities.putAll(this.parseResponse(response.getBodyAsText()));
            ++n2;
        }
        this.storeDeviceCapabilities(device.getGatewayClient().getMac(), capabilities);
        return this.init(device, device.getPass(), true);
    }

    public String getVersion(LanDeviceEntity device) {
        log.debug((Object)("start getVersion(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        HTTPClientServiceResult response = this.sendCommand(device, "/cgi-bin/system.cgi?action=get", HttpCommand.SendMethod.GET);
        if (!this.isCorrectResponse(response)) {
            String logMsg = "Failed to download firmware version for device with lanDeviceId=" + device.getLanDeviceId() + ": " + response.getResult();
            if (response.getResult() == HTTPClientServiceResult.Result.NOANSWER) {
                log.debug((Object)logMsg);
            } else {
                log.warn((Object)logMsg);
            }
            return null;
        }
        return (String)this.parseResponse(response.getBodyAsText()).get("firmwareVersion");
    }

    public boolean upgradeFirmwareOld(LanDeviceEntity device) {
        byte[] body;
        HashMap<String, String> additionalRequestHeaders;
        block4: {
            log.debug((Object)("start upgradeFirmwareOld(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
            try {
                additionalRequestHeaders = new HashMap<String, String>();
                String boundry = "--boundry1234";
                additionalRequestHeaders.put("Content-Type", "multipart/form-data; boundary=" + boundry);
                body = this.encodeMuptipart(device, boundry);
                if (body != null) break block4;
                log.warn((Object)"Failed to create firmware upgrade body.");
                return false;
            }
            catch (IOException e) {
                log.warn((Object)("Failed to upgrade firmware for device with lanDeviceId=" + device.getLanDeviceId() + ":" + e.getMessage()));
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return this.isCorrectPostResponse(this.sendCommand(device, "/cgi-bin/upgradeFirmware.cgi", additionalRequestHeaders, body, 900));
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        HttpResponse response;
        DefaultHttpClient httpclient;
        block8: {
            File firmware;
            HttpPost httppost;
            block7: {
                log.debug((Object)("start upgradeFirmware(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
                httpclient = new DefaultHttpClient();
                httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
                httppost = new HttpPost(this.getUpgradeFirmwareUrl("/cgi-bin/upgradeFirmware.cgi"));
                httppost.addHeader("Cookie", this.getUpgradeFirmwareCookie(device));
                httppost.addHeader("Authorization", this.getAuthorizationHeader(device));
                firmware = this.systemSupport.getFile(String.valueOf(this.firmwares) + "/" + device.getDeviceDesc().getFirmwareFile());
                if (this.isFileReadable(firmware)) break block7;
                log.warn((Object)("Can not read firmware file for device with lanDeviceId=" + device.getLanDeviceId() + "."));
                return false;
            }
            MultipartEntity multipart = new MultipartEntity();
            FileBody fileBody = new FileBody(firmware, "application/macbinary");
            multipart.addPart("file", (ContentBody)fileBody);
            multipart.addPart("send", (ContentBody)new StringBody(""));
            httppost.setEntity((HttpEntity)multipart);
            response = httpclient.execute((HttpUriRequest)httppost);
            if (response.getEntity() != null) break block8;
            log.warn((Object)("Missing entity in upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        try {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(EntityUtils.toString((HttpEntity)response.getEntity()));
            log.debug((Object)("Upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + ": " + responseBuffer.toString()));
            if (!responseBuffer.toString().contains("statusString")) {
                int tryCount = 0;
                while (tryCount < 5) {
                    log.debug((Object)("Waiting for full response. Try " + ++tryCount));
                    Thread.sleep(1000L);
                    responseBuffer.append(EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (responseBuffer.toString().contains("statusString")) break;
                }
            }
            log.debug((Object)("Full upgrade firmware response for device with lanDeviceId=" + device.getLanDeviceId() + ": " + responseBuffer.toString()));
            httpclient.getConnectionManager().shutdown();
            Map responseParams = this.parseResponse(responseBuffer.toString());
            log.debug((Object)("upgrade firmware response params: " + responseParams));
            return "0".equals(responseParams.get("statusCode"));
        }
        catch (Exception e) {
            log.warn((Object)("Failed to upgrade firmware for device with lanDeviceId=" + device.getLanDeviceId() + ": " + e.getMessage() + "."));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private HTTPClientServiceResult sendCommand(LanDeviceEntity device, String cmd, Map<String, String> additionalRequestHeaders, byte[] body, int timeout) {
        String request = this.createBaseRequest(device.getIpAddress(), device.getPort(), device.getUsername(), device.getPass(), cmd);
        return this.sendRequest(device.getGatewayClient().getSerialNumber(), request, additionalRequestHeaders, body, timeout);
    }

    private byte[] encodeMuptipart(LanDeviceEntity device, String boundry) throws IOException {
        BodyPart firmwareBody = new BodyPart();
        firmwareBody.setContentType("application/macbinary");
        firmwareBody.setContentDisposition("form-data", "file", this.extractFirmwareFilename(device));
        byte[] firmware = this.systemSupport.readFile(String.valueOf(this.firmwares) + "/" + device.getDeviceDesc().getFirmwareFile());
        if (firmware == null) {
            log.warn((Object)"Empty firmware.");
            return null;
        }
        firmwareBody.setBody(firmware);
        BodyPart sendBody = new BodyPart();
        sendBody.setContentDisposition("form-data", "send", null);
        Multipart multipart = new Multipart(boundry);
        multipart.addPart(firmwareBody);
        multipart.addPart(sendBody);
        return multipart.getBytes();
    }

    private String extractFirmwareFilename(LanDeviceEntity device) {
        String filename = device.getDeviceDesc().getFirmwareFile();
        if (filename == null) {
            return null;
        }
        int lastSlashPos = filename.lastIndexOf("/");
        return lastSlashPos == -1 ? filename : filename.substring(lastSlashPos + 1);
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        ExecCmdService execCmdService = this.serviceFactory.getExecCmdService();
        CommandResult cmdResult = null;
        cmdResult = Utils.isAtMinimalVersion((String)device.getGatewayClient().getVersion(), (String)this.getUsesScriptsDirectoryMinimalVersion()) ? execCmdService.executeCommand(device.getGatewayClient().getSerialNumber(), "scanwlan-rssi.sh") : execCmdService.executeCommand(device.getGatewayClient().getSerialNumber(), "./scanwlan.sh rssi");
        if (cmdResult == null) {
            return null;
        }
        return this.extractRssi(cmdResult.getOutput());
    }

    private Integer extractRssi(String text) {
        log.debug((Object)("start extractRssi(text=" + text + ")"));
        if (text == null) {
            return null;
        }
        String[] rows = text.split("\n");
        if (rows.length == 2) {
            return -1;
        }
        if (rows.length == 3) {
            String valuesRow = rows[2];
            String[] values = (valuesRow = valuesRow.replaceAll(" {2,}", " ").trim()).split(" ");
            if (values == null || values.length < 3) {
                log.debug((Object)"Unexpected values count.");
                return null;
            }
            String rssiText = values[2].replaceAll("\\D", "");
            return Integer.parseInt(rssiText);
        }
        return null;
    }

    public boolean isRtcpOverRtspSupported() {
        return false;
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        return "H264";
    }

    static /* synthetic */ Set access$0(CameraBrickcomGeneric cameraBrickcomGeneric, LanDeviceEntity lanDeviceEntity, boolean bl) {
        return cameraBrickcomGeneric.getParamsToUpdate(lanDeviceEntity, bl);
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }

    static /* synthetic */ void access$2(CameraBrickcomGeneric cameraBrickcomGeneric, LanDeviceEntity lanDeviceEntity, String string, Set set) {
        cameraBrickcomGeneric.updateSetting(lanDeviceEntity, string, set);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
        }
        int[] nArray = new int[HTTPClientServiceResult.Result.values().length];
        try {
            nArray[HTTPClientServiceResult.Result.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$EncryptionMode$Encryption() {
        if ($SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$EncryptionMode$Encryption != null) {
            return $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$EncryptionMode$Encryption;
        }
        int[] nArray = new int[EncryptionMode.Encryption.values().length];
        try {
            nArray[EncryptionMode.Encryption.OPEN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EncryptionMode.Encryption.PASSPHRASE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EncryptionMode.Encryption.WEP.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EncryptionMode.Encryption.WPA.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EncryptionMode.Encryption.WPA2.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$EncryptionMode$Encryption = nArray;
        return nArray;
    }
}

