/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice.askey;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;

@Component(value="CameraAskeyGeneric")
@Scope(value="prototype")
public class CameraAskeyGeneric
extends GenericCamera {
    protected static final String DEFAULT_USER = "root";
    protected static final String DEFAULT_PASSWORD = "";

    public CameraAskeyGeneric() {
        this.user = DEFAULT_USER;
        this.pass = DEFAULT_PASSWORD;
        this.cameraProducer = "Askey";
        this.capabilitiesCommands = new String[0];
    }

    public ControlParams getControlParams() {
        return new ControlParams();
    }

    public void updateSettings(LanDeviceEntity device) {
    }

    public UpdateSettingStatus updateSingleSetting(LanDeviceEntity device, String paramName, String paramValue) {
        return UpdateSettingStatus.SUCCESS;
    }

    public AccessVerificationStatus checkStatus(LanDevice device) {
        return AccessVerificationStatus.OK;
    }

    public Set<String> getSupportedSettings() {
        return Collections.emptySet();
    }

    public GenericLanDevice.AuthType getAuthType() {
        return GenericLanDevice.AuthType.BASIC;
    }

    public String getMacAddress(LanDeviceEntity device) {
        return device.getGatewayClient().getMac();
    }

    public List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity device) {
        return Collections.emptyList();
    }

    public String getConnCheckUrl() {
        return null;
    }

    public CheckConfigurationStatus checkConfiguration(LanDeviceEntity device) {
        return CheckConfigurationStatus.CORRECT;
    }

    public GenericLanDevice.ConfigurationStatus reconfigure(LanDeviceEntity device) {
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    public String getVersion(LanDeviceEntity device) {
        return null;
    }

    public Boolean isFirmwareUpToDate(LanDeviceEntity device) {
        return true;
    }

    public boolean upgradeFirmware(LanDeviceEntity device) {
        return true;
    }

    public Integer checkRSSI(LanDeviceEntity device) {
        return null;
    }

    protected AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult response, LanDevice device) {
        return AccessVerificationStatus.OK;
    }

    public GenericLanDevice.ConfigurationStatus init(LanDeviceEntity device, String currentAdminPassword) {
        device.setVideoEncoding("H264");
        return super.init(device, currentAdminPassword);
    }

    public AccessVerificationStatus verify(LanDevice device) {
        this.log.debug((Object)("start verify(device=" + device + ")"));
        device.setPort(Integer.valueOf(80));
        if (device.getUser() == null) {
            device.setUser("admin");
        }
        if (device.getPass() == null) {
            device.setPass("admin");
        }
        return AccessVerificationStatus.OK;
    }

    public byte[] getCurrentSnapshot(LanDeviceEntity device, String resolution) {
        String url = String.valueOf(this.cameraBaseUrl(device)) + "/cgi-bin/viewer/video.jpg?resolution=" + resolution;
        HTTPClientServiceResult response = this.sendRequest(device.getGatewayClient().getSerialNumber(), url, HttpCommand.SendMethod.GET);
        return response == null ? null : response.getBody();
    }

    protected boolean registerUser(LanDeviceEntity device, Map<String, String> params) {
        return true;
    }

    protected boolean manageViewerUser(LanDeviceEntity device) {
        return true;
    }

    protected GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        String resolution = "1280x720";
        device.setParam("resolution", resolution);
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=" + resolution);
        String resolutionLow = "640x480";
        device.setParam("resolution_low", resolutionLow);
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=" + resolutionLow);
        device.setParam("path", "live1.sdp");
        device.setParam("path_low", "live2.sdp");
        device.setParam("path_rtsp_over_http_get", "live1.sdp");
        device.setParam("path_low_rtsp_over_http_get", "live2.sdp");
        device.setParam("path_rtsp_over_http_post", "live1.sdp");
        device.setParam("path_low_rtsp_over_http_post", "live2.sdp");
        device.setParam("rtsp_port", "554");
        device.setParam("rtsp_over_http_port", "80");
        device.setParam("has_two_way_audio", "ON");
        device.setParam("twa_upload_type", "HTTP");
        device.setParam("twa_http_path", "/stream/begin");
        device.setParam("twa_http_port", "8889");
        device.setParam("twa_sample_type", "SInt16");
        device.setParam("twa_sample_rate", "8000");
        device.setParam("twa_channel_count", "1");
        device.setParam("twa_codec", "MuLaw");
        device.setParam("twa_http_service_cookie", "TWA_ASKEY");
        return GenericLanDevice.ConfigurationStatus.OK;
    }

    protected boolean isCorrectPostResponse(HTTPClientServiceResult response) {
        return true;
    }

    protected boolean specialResponseKey(Map<String, String> parsedResponse, String key, String value) {
        return true;
    }

    public String getAVCVideoCodec(LanDeviceEntity device) {
        return "H264";
    }
}

