/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice;

public class VideoQuality {
    private int fpsMjpeg = 0;
    private int fpsAvc = 0;
    private int qualityMjpeg = 0;
    private int bitrateMpeg4 = 0;
    private int bitrateMpeg4Low = 0;
    private int bitrateH264 = 0;
    private int bitrateH264Low = 0;

    public int getFps(String encoding) {
        if (this.isAvcEncoding(encoding)) {
            return this.fpsAvc;
        }
        return this.fpsMjpeg;
    }

    private boolean isAvcEncoding(String encoding) {
        return !"MJPEG".equalsIgnoreCase(encoding);
    }

    public int getQualityMjpeg() {
        return this.qualityMjpeg;
    }

    public int getBitrate(String encoding) {
        if (encoding.equalsIgnoreCase("H264")) {
            return this.bitrateH264;
        }
        return this.bitrateMpeg4;
    }

    public int getBitrateLow(String encoding) {
        if (encoding.equalsIgnoreCase("H264")) {
            return this.bitrateH264Low;
        }
        return this.bitrateMpeg4Low;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fpsMjpeg;
        result = 31 * result + this.fpsAvc;
        result = 31 * result + this.qualityMjpeg;
        result = 31 * result + this.bitrateMpeg4;
        result = 31 * result + this.bitrateMpeg4Low;
        result = 31 * result + this.bitrateH264;
        result = 31 * result + this.bitrateH264Low;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoQuality other = (VideoQuality)obj;
        return this.fpsMjpeg == other.fpsMjpeg && this.fpsAvc == other.fpsAvc && this.qualityMjpeg == other.qualityMjpeg && this.bitrateH264 == other.bitrateH264 && this.bitrateH264Low == other.bitrateH264Low && this.bitrateMpeg4 == other.bitrateMpeg4 && this.bitrateMpeg4Low == other.bitrateMpeg4Low;
    }

    public String toString() {
        return "VideoQuality [fps=" + this.fpsMjpeg + ", quality=" + this.qualityMjpeg + ", bitrateH264=" + this.bitrateH264 + ", bitrateH264Low=" + this.bitrateH264Low + ", fpsAvc=" + this.fpsAvc + ", bitrateMpeg4=" + this.bitrateMpeg4 + ", bitrateMpeg4Low=" + this.bitrateMpeg4Low + "]";
    }

    public VideoQuality setFpsMjpeg(int value) {
        this.fpsMjpeg = value;
        return this;
    }

    public VideoQuality setQualityMjpeg(int value) {
        this.qualityMjpeg = value;
        return this;
    }

    public VideoQuality setFpsAvc(int value) {
        this.fpsAvc = value;
        return this;
    }

    public VideoQuality setBitrateMpeg4(int bitrate, int bitrateLow) {
        this.bitrateMpeg4 = bitrate;
        this.bitrateMpeg4Low = bitrateLow;
        return this;
    }

    public VideoQuality setBitrateH264(int bitrate, int bitrateLow) {
        this.bitrateH264 = bitrate;
        this.bitrateH264Low = bitrateLow;
        return this;
    }
}

