/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekGeneric;
import pl.smartapps.containerserver.landevice.vivotek.CameraVivotekSettings;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CameraVivotekGeneric.class, HttpPost.class, DefaultHttpClient.class, EntityUtils.class, File.class})
public class UpgradeFirmwareTests {
    private CameraVivotekGeneric cameraVivotekGeneric;
    private CameraVivotekSettings cameraVivotekSettings;
    private AuthenticationUtils authUtils;
    private DeviceDescDAO deviceDescDAO;
    private LanDeviceService lanDeviceService;
    private SystemSupport systemSupport;
    private ContainerserverServiceFactory serviceFactory;

    @Before
    public void setUp() {
        this.cameraVivotekGeneric = new CameraVivotekGeneric();
        this.cameraVivotekGeneric.setServerUrl("http://homemonitor.ch:8080/app");
        this.cameraVivotekSettings = (CameraVivotekSettings)PowerMock.createMock(CameraVivotekSettings.class);
        this.cameraVivotekGeneric.setCameraVivotekSettings(this.cameraVivotekSettings);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.cameraVivotekGeneric.setAuthUtils(this.authUtils);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.cameraVivotekGeneric.setDeviceDescDAO(this.deviceDescDAO);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.cameraVivotekGeneric.setLanDeviceService(this.lanDeviceService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.cameraVivotekGeneric.setSystemSupport(this.systemSupport);
        this.serviceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.cameraVivotekGeneric.setServiceFactory(this.serviceFactory);
    }

    @Test
    public void testUpgradeFirmwareSuccessfully() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/octet-stream"}).andReturn((Object)fileBody);
        multipart.addPart("fimage", (ContentBody)fileBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(2);
        StringBuilder responseBody = new StringBuilder();
        responseBody.append("Update system image success").append("\n");
        responseBody.append("Write new image complete").append("\n");
        responseBody.append("Update armboot env success").append("\n");
        responseBody.append("Reboot system now !!").append("\n");
        responseBody.append("This connection will close").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)responseBody.toString());
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwarePartialResponseSuccessfully() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/octet-stream"}).andReturn((Object)fileBody);
        multipart.addPart("fimage", (ContentBody)fileBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(3);
        StringBuilder partialResponseBody1 = new StringBuilder();
        partialResponseBody1.append("Update system image success").append("\n");
        partialResponseBody1.append("Write new image complete").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody1.toString());
        StringBuilder partialResponseBody2 = new StringBuilder();
        partialResponseBody2.append("Update armboot env success").append("\n");
        partialResponseBody2.append("Reboot system now !!").append("\n");
        partialResponseBody2.append("This connection will close").append("\n");
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody2.toString());
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailurePartialResponse() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/octet-stream"}).andReturn((Object)fileBody);
        multipart.addPart("fimage", (ContentBody)fileBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        HttpEntity responseEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)responseEntity).times(7);
        StringBuilder partialResponseBody = new StringBuilder();
        partialResponseBody.append("Update system image success").append("\n");
        partialResponseBody.append("Write new image complete").append("\n");
        PowerMock.mockStatic(EntityUtils.class);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)partialResponseBody.toString());
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)responseEntity)).andReturn((Object)"").times(5);
        ClientConnectionManager connectionManager = (ClientConnectionManager)PowerMock.createMock(ClientConnectionManager.class);
        EasyMock.expect((Object)httpClient.getConnectionManager()).andReturn((Object)connectionManager);
        connectionManager.shutdown();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureCanNotReadFirmwareFile() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureFirmwareFileIsNotFile() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureFirmwareFileNotExists() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailureEmptyResponseEntity() throws Exception {
        this.cameraVivotekGeneric.setGdtServerAddress("http://beta.homemonitor.ch");
        this.cameraVivotekGeneric.setGdtServerPort(1443);
        this.cameraVivotekGeneric.setFirmwares("/firmwares/");
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device.getDeviceDesc().setFirmwareFile("new_firmware.bin");
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams httpParams = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)httpParams);
        EasyMock.expect((Object)httpParams.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1)).andReturn((Object)httpParams);
        HttpPost httpPost = (HttpPost)PowerMock.createMock(HttpPost.class);
        String upgradeFirmwareUrl = "http://beta.homemonitor.ch:1443/cgi-bin/admin/upgrade.cgi";
        PowerMock.expectNew(HttpPost.class, (Object[])new Object[]{upgradeFirmwareUrl}).andReturn((Object)httpPost);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"abc123");
        httpPost.addHeader("Cookie", "METHOD=POST, HTTP_STATUS_SWITCH=0, CUSTOM_KEEPALIVE_TIMEOUT=120, GC_ID=1, JSESSIONID=abc123");
        httpPost.addHeader("Authorization", "Basic cm9vdDpyb290UGFzcw==");
        File firmware = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/firmwares//new_firmware.bin")).andReturn((Object)firmware);
        EasyMock.expect((Object)firmware.exists()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.isFile()).andReturn((Object)true);
        EasyMock.expect((Object)firmware.canRead()).andReturn((Object)true);
        MultipartEntity multipart = (MultipartEntity)PowerMock.createMock(MultipartEntity.class);
        PowerMock.expectNew(MultipartEntity.class, (Object[])new Object[0]).andReturn((Object)multipart);
        FileBody fileBody = (FileBody)PowerMock.createMock(FileBody.class);
        PowerMock.expectNew(FileBody.class, (Object[])new Object[]{firmware, "application/octet-stream"}).andReturn((Object)fileBody);
        multipart.addPart("fimage", (ContentBody)fileBody);
        httpPost.setEntity((HttpEntity)multipart);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpPost)).andReturn((Object)response);
        EasyMock.expect((Object)response.getEntity()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.cameraVivotekGeneric.upgradeFirmware(device));
        PowerMock.verifyAll();
    }
}

