/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import pl.smartapps.containerserver.CapabilitiesCache;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.HTTPClientService;
import pl.smartapps.containerserver.SearchWlanAccessPointsService;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.VideoQuality;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SettingsService;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class GenericLanDevice {
    protected Logger log = Logger.getLogger(GenericLanDevice.class);
    protected DeviceDescDAO deviceDescDAO;
    protected LanDeviceService lanDeviceService;
    protected SettingsService settingsService;
    protected ParameterService parameterService;
    protected boolean legacyMode = false;
    protected ContainerserverServiceFactory serviceFactory;
    protected AuthenticationUtils authUtils;
    protected GatewayDeviceConnectionService gatewayDeviceConnection;
    private String gdtServerAddress;
    private int gdtServerPort;
    private String defaultSsid;
    private CapabilitiesCache capabilitiesCache;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getUsesScriptsDirectoryMinimalVersion() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT);
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setDeviceDescDAO(DeviceDescDAO deviceDescDAO) {
        this.deviceDescDAO = deviceDescDAO;
    }

    @Autowired
    @Required
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Autowired
    @Required
    public void setServiceFactory(ContainerserverServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setGatewayClientConnection(GatewayDeviceConnectionService gatewayClientConnection) {
        this.gatewayDeviceConnection = gatewayClientConnection;
    }

    @Autowired
    @Required
    public void setCapabilitiesCache(CapabilitiesCache capabilitiesCache) {
        this.capabilitiesCache = capabilitiesCache;
    }

    @Value(value="${GDTServer.address:localhost}")
    public void setGdtServerAddress(String gdtServerAddress) {
        this.gdtServerAddress = gdtServerAddress;
    }

    @Value(value="${GDTServer.port:1443}")
    public void setGdtServerPort(int gdtServerPort) {
        this.gdtServerPort = gdtServerPort;
    }

    public String getDefaultSsid() {
        return this.defaultSsid;
    }

    public void setDefaultSsid(String defaultSsid) {
        this.defaultSsid = defaultSsid;
    }

    @Deprecated
    public AccessVerificationStatus verify(String deviceId, DiscoveredLanDevice device) {
        if (device != null && device.getMac() != null && device.getIpAddress() != null && deviceId != null && deviceId.trim().length() > 0) {
            return AccessVerificationStatus.OK;
        }
        return AccessVerificationStatus.ERROR;
    }

    public AccessVerificationStatus verify(LanDevice device) {
        if (device != null && device.getMac() != null && device.getIpAddress() != null && device.getGatewayClient() != null) {
            return AccessVerificationStatus.OK;
        }
        return AccessVerificationStatus.ERROR;
    }

    public AccessVerificationStatus verify(LanDeviceEntity device) {
        if (device != null && device.getMac() != null && device.getIpAddress() != null && device.getGatewayClient() != null) {
            return AccessVerificationStatus.OK;
        }
        return AccessVerificationStatus.ERROR;
    }

    public ConfigurationStatus init(LanDeviceEntity device, String currentAdminPassword) {
        return device != null && device.getMac() != null && device.getIpAddress() != null ? ConfigurationStatus.OK : ConfigurationStatus.FAILED;
    }

    public boolean getLegacyMode() {
        return this.legacyMode;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    protected String searchWlanAccessPoints(LanDeviceEntity device) {
        SearchWlanAccessPointsService searchWlanAccessPointsService = this.serviceFactory.getSearchWlanAccessPointsService();
        String gcSerialNumber = device.getGatewayClient().getSerialNumber();
        return searchWlanAccessPointsService.searchWlanAccessPoints(gcSerialNumber);
    }

    protected void storeDeviceCapabilities(String gatewayClientMacAddress, Map<String, String> deviceCapabilities) {
        this.log.debug((Object)("start storeDeviceCapabilities(deviceMacAddress=" + gatewayClientMacAddress + ")"));
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(gatewayClientMacAddress);
        if (gatewayDevice == null) {
            this.log.debug((Object)("not found gatewayClientConnection for macAddress=" + gatewayClientMacAddress));
            return;
        }
        this.capabilitiesCache.storeCapabilities(gatewayClientMacAddress, deviceCapabilities);
    }

    protected Map<String, String> getDeviceCapabilities(String gatewayClientMacAddress) {
        this.log.debug((Object)("start getDeviceCapabilities(deviceMacAddress=" + gatewayClientMacAddress + ")"));
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(gatewayClientMacAddress);
        if (gatewayDevice == null) {
            this.log.trace((Object)("not found gatewayClientConnection for macAddress=" + gatewayClientMacAddress + ", returning empty map"));
            return new HashMap<String, String>();
        }
        return this.capabilitiesCache.getCapabilities(gatewayClientMacAddress);
    }

    protected HTTPClientServiceResult sendRequest(String gcSerialNumber, String request, HttpCommand.SendMethod sendMethod) {
        return this.sendRequest(gcSerialNumber, request, sendMethod, -1);
    }

    protected HTTPClientServiceResult sendRequest(String gcSerialNumber, String request, HttpCommand.SendMethod sendMethod, int timeout) {
        this.log.debug((Object)("start sendRequest(gcSerialNumber=" + gcSerialNumber + ", request=" + request + ", sendMethod=" + sendMethod + ")"));
        HTTPClientServiceResult response = null;
        try {
            URL url = new URL(request);
            response = sendMethod == HttpCommand.SendMethod.GET ? this.serviceFactory.getHttpClientService().get(gcSerialNumber, url) : this.getHttpClientService(timeout).post(gcSerialNumber, url);
            this.log.debug((Object)("Got response for retrieving data for gateway client with serial number '" + gcSerialNumber + "' and request '" + request));
            this.log.trace((Object)("Response text:" + (response == null ? "null" : response.toString())));
            if (response == null) {
                this.log.warn((Object)("Received null response for request=" + request + ", mac=" + gcSerialNumber + ", sendMethod=" + sendMethod + "."));
                response = new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            return response;
        }
        catch (MalformedURLException ex) {
            this.log.warn((Object)("Exception occured when sending data to gateway client with serial number '" + gcSerialNumber + "' with request '" + request + "': " + ex.getMessage()));
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    protected HTTPClientServiceResult sendRequest(String deviceId, String request, Map<String, String> additionalRequestHeaders, byte[] body, int timeout) {
        HTTPClientServiceResult response = null;
        try {
            URL url = new URL(request);
            HTTPClientService httpClientService = this.getHttpClientService();
            httpClientService.setTimeout(Integer.valueOf(timeout));
            response = httpClientService.post(deviceId, url, additionalRequestHeaders, body);
            this.log.debug((Object)("Got response for retrieving data for gateway client with serial number '" + deviceId + "' and request '" + request));
            this.log.trace((Object)("Response text:" + response.toString()));
            return response;
        }
        catch (MalformedURLException ex) {
            this.log.warn((Object)("Exception occured when sending data to gateway client with serial number '" + deviceId + "' with request '" + request + "': " + ex.getMessage()));
            if (this.log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    protected String getUpgradeFirmwareUrl(String command) {
        StringBuilder url = new StringBuilder();
        if (!this.gdtServerAddress.startsWith("http://")) {
            url.append("http://");
        }
        url.append(this.gdtServerAddress);
        url.append(":");
        url.append(this.gdtServerPort);
        url.append(command);
        return url.toString();
    }

    protected String getUpgradeFirmwareCookie(LanDeviceEntity device) {
        StringBuilder cookie = new StringBuilder();
        cookie.append("METHOD=POST, ");
        cookie.append("HTTP_STATUS_SWITCH=0, ");
        cookie.append("CUSTOM_KEEPALIVE_TIMEOUT=120, ");
        cookie.append("GC_ID=").append(device.getGatewayClient().getGatewayClientId()).append(", ");
        cookie.append("LD_ID=").append(device.getLanDeviceId()).append(", ");
        cookie.append("JSESSIONID=").append(this.authUtils.getCurrentSubject().getSession().getId());
        return cookie.toString();
    }

    protected String getAuthorizationHeader(LanDeviceEntity device) {
        String authToken = new String(Base64.encodeBase64((byte[])(String.valueOf(device.getUsername()) + ":" + device.getPass()).getBytes()));
        return "Basic " + authToken;
    }

    protected boolean isFileReadable(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isFile() && file.canRead();
    }

    protected boolean isRtspStreaming() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_RTSP_STREAMING).equalsIgnoreCase("ON");
    }

    protected String cameraBaseUrl(LanDeviceEntity device) {
        StringBuilder request = new StringBuilder(150);
        request.append("http://");
        request.append(device.getUsername()).append(":").append(device.getPass()).append("@");
        request.append(device.getIpAddress());
        request.append(":");
        request.append(device.getPort());
        this.log.info((Object)("cameraBaseUrl: " + request.toString()));
        return request.toString();
    }

    /*
     * Exception decompiling
     */
    protected AccessVerificationStatus checkStatus(LanDevice device, String verifyPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HTTPClientServiceResult sendCommand(LanDevice device, String cmd, HttpCommand.SendMethod sendMethod) {
        this.log.debug((Object)("start sendCommand(device with lanDeviceId=" + device.getLanDeviceId() + ", cmd=" + cmd + ", sendMethod=" + sendMethod + ")"));
        return this.sendCommand(device, cmd, null, sendMethod);
    }

    protected HTTPClientServiceResult sendCommand(LanDevice device, String baseCommand, Map<String, String> params, HttpCommand.SendMethod sendMethod) {
        this.log.debug((Object)("start sendCommand(device=" + device + ", baseCommand=" + baseCommand + ", params=" + params + ", sendMethod=" + sendMethod + ")"));
        String gcSerialNumber = device.getGatewayClient().getSerialNumber();
        return this.sendCommand(gcSerialNumber, device.getIpAddress(), device.getPort().intValue(), device.getUser(), device.getPass(), baseCommand, params, sendMethod);
    }

    protected HTTPClientServiceResult sendCommand(LanDeviceEntity device, String cmd, HttpCommand.SendMethod sendMethod) {
        this.log.debug((Object)("start sendCommand(device with lanDeviceId=" + device.getLanDeviceId() + ", cms=" + cmd + ", sendMethod=" + sendMethod + ")"));
        return this.sendCommand(device, cmd, null, sendMethod);
    }

    protected HTTPClientServiceResult sendCommand(String gcSerialNumber, String ipAddress, int port, String username, String password, String baseCommand, Map<String, String> params, HttpCommand.SendMethod sendMethod) {
        return this.sendCommand(gcSerialNumber, ipAddress, port, username, password, baseCommand, params, sendMethod, -1);
    }

    protected HTTPClientServiceResult sendCommand(String gcSerialNumber, String ipAddress, int port, String username, String password, String baseCommand, Map<String, String> params, HttpCommand.SendMethod sendMethod, int timeout) {
        this.log.debug((Object)("start sendCommand(gcSerialNumber=" + gcSerialNumber + ", ipAddress=" + ipAddress + ", port=" + port + ", username=" + username + ", password=" + password + ", baseCommand=" + baseCommand + ", params=" + params + ", sendMethod=" + sendMethod + ")"));
        String cmd = this.createCommand(baseCommand, params);
        String request = this.createBaseRequest(ipAddress, Integer.valueOf(port), username, password, cmd);
        return this.sendRequest(gcSerialNumber, request, sendMethod, timeout);
    }

    protected HTTPClientServiceResult sendCommand(LanDeviceEntity device, String baseCommand, Map<String, String> params, HttpCommand.SendMethod sendMethod) {
        return this.sendCommand(device, baseCommand, params, sendMethod, -1);
    }

    protected HTTPClientServiceResult sendCommand(LanDeviceEntity device, String baseCommand, Map<String, String> params, HttpCommand.SendMethod sendMethod, int timeout) {
        this.log.debug((Object)("start sendCommand(device=" + device + ", baseCommand=" + baseCommand + ", params=" + params + ", sendMethod=" + sendMethod + ")"));
        String gcSerialNumber = device.getGatewayClient().getSerialNumber();
        return this.sendCommand(gcSerialNumber, device.getIpAddress(), device.getPort().intValue(), device.getUsername(), device.getPass(), baseCommand, params, sendMethod, timeout);
    }

    protected String createCommand(String baseCmd, Map<String, String> params) {
        if (baseCmd == null) {
            return "";
        }
        StringBuilder command = new StringBuilder();
        command.append(baseCmd);
        if (params != null && !params.isEmpty()) {
            command.append("?");
            for (Map.Entry<String, String> param : params.entrySet()) {
                command.append(param.getKey()).append("=").append(param.getValue()).append("&");
            }
            command.delete(command.length() - 1, command.length());
        }
        return command.toString();
    }

    protected String createBaseRequest(String ipAddress, Integer port, String user, String pass, String cmd) {
        String password;
        StringBuilder request = new StringBuilder(150);
        request.append("http://");
        String username = user == null ? "admin" : user;
        String string = password = pass == null ? "admin" : pass;
        if (username != null && username.length() > 0) {
            request.append(username);
            if (password != null && password.length() > 0) {
                request.append(":").append(password);
            }
            request.append("@");
        }
        request.append(ipAddress);
        if (port != null) {
            request.append(":");
            request.append(port);
        }
        if (cmd != null) {
            request.append(cmd);
        }
        this.log.debug((Object)("created base request: " + request.toString()));
        return request.toString();
    }

    protected boolean isCorrectResponse(HTTPClientServiceResult response) {
        return response != null && response.getResult() == HTTPClientServiceResult.Result.OK && response.getBodyAsText().length() > 0;
    }

    protected String removeHtmlBody(String response) {
        String htmlBodyTail = "</body></html>";
        int pos = response.indexOf(htmlBodyTail);
        if (pos > -1) {
            response = response.substring(pos + htmlBodyTail.length()).trim();
        }
        return response;
    }

    protected boolean verifySettings(Map<String, String> actualSettings, Map<String, String> expectedSettings) {
        for (Map.Entry<String, String> expectedSetting : expectedSettings.entrySet()) {
            if (this.verifySetting(actualSettings, expectedSetting.getKey(), expectedSetting.getValue())) continue;
            this.log.debug((Object)("Unexpected camera setting '" + expectedSetting.getKey() + "'. Expected value is '" + expectedSetting.getValue() + "' but was '" + actualSettings.get(expectedSetting.getKey()) + "'"));
            return false;
        }
        return true;
    }

    private boolean verifySetting(Map<String, String> settings, String settingName, String expectedSettingValue) {
        String settingValue = settings.get(settingName);
        return settingValue != null && settingValue.equals(expectedSettingValue);
    }

    protected static VideoQuality getVideoQuality(LanDeviceEntity device, Map<VideoQualityLevel, VideoQuality> videoQualities) {
        String level = device.getParamValue("video_quality");
        return GenericLanDevice.getVideoQuality((String)level, videoQualities);
    }

    protected static VideoQuality getVideoQuality(String videoQualityLevel, Map<VideoQualityLevel, VideoQuality> videoQualities) {
        return videoQualities.get(VideoQualityLevel.valueOf((String)videoQualityLevel));
    }

    public String getIpAddress(String gatewayClientMac, String lanDeviceMac) {
        return null;
    }

    public abstract ControlParams getControlParams();

    public abstract void updateSettings(LanDeviceEntity var1);

    public abstract UpdateSettingStatus updateSingleSetting(LanDeviceEntity var1, String var2, String var3);

    public abstract AccessVerificationStatus checkStatus(LanDevice var1);

    public abstract Set<String> getSupportedSettings();

    public abstract AuthType getAuthType();

    public abstract String getMacAddress(LanDeviceEntity var1);

    public abstract List<WlanAccessPoint> getWirelessNetworks(LanDeviceEntity var1);

    public abstract String getConnCheckUrl();

    public abstract CheckConfigurationStatus checkConfiguration(LanDeviceEntity var1);

    public abstract ConfigurationStatus reconfigure(LanDeviceEntity var1);

    public abstract String getVersion(LanDeviceEntity var1);

    public abstract Boolean isFirmwareUpToDate(LanDeviceEntity var1);

    public abstract boolean upgradeFirmware(LanDeviceEntity var1);

    public abstract Integer checkRSSI(LanDeviceEntity var1);

    protected abstract AccessVerificationStatus processCheckStatusResponse(HTTPClientServiceResult var1, LanDevice var2);

    public LanDevice getLanDevice(GatewayDevice gatewayDevice, String lanDeviceMac) {
        LanDevice lanDevice = new LanDevice();
        lanDevice.setMac(lanDeviceMac);
        lanDevice.setIpAddress("127.0.0.1");
        lanDevice.setPort(Integer.valueOf(80));
        lanDevice.setDeleted(Boolean.valueOf(false));
        return lanDevice;
    }

    public CameraDiscoveryService getCameraDiscoveryService() {
        return null;
    }

    public boolean isRtcpOverRtspSupported() {
        return true;
    }

    protected HTTPClientServiceResult sendCommand(LanDeviceEntity device, String path, HttpCommand.SendMethod sendMethod, String ... arguments) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < arguments.length) {
            params.put(arguments[i], arguments[i + 1]);
            i += 2;
        }
        return this.sendCommand(device, path, params, sendMethod);
    }

    protected HTTPClientService getHttpClientService() {
        return this.getHttpClientService(-1);
    }

    protected HTTPClientService getHttpClientService(int timeout) {
        HTTPClientService service = this.serviceFactory.getHttpClientService();
        service.setConnectionType(HttpCommand.ConnectionType.TCP_PROXY);
        if (timeout > 0) {
            service.setTimeout(Integer.valueOf(timeout));
        }
        return service;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
        }
        int[] nArray = new int[HTTPClientServiceResult.Result.values().length];
        try {
            nArray[HTTPClientServiceResult.Result.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result = nArray;
        return nArray;
    }
}

