/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.util.Utils;

public abstract class GenericCamera
extends GenericLanDevice {
    protected static final String ON = "ON";
    protected static final String OFF = "OFF";
    protected static final String YES = "yes";
    protected static final String NO = "no";
    protected static final String H264 = "H264";
    protected static final String MPEG4 = "MPEG4";
    protected static final String MJPEG = "MJPEG";
    protected static final int DEFAULT_PORT = 80;
    protected String[] capabilitiesCommands;
    protected Map<String, String> deviceCapabilities;
    protected String firmwareVersionParam;
    protected String firmwares;
    protected SystemSupport systemSupport;
    protected String serverUrl;
    protected String modelParam;
    protected String cameraProducer;
    protected String user;
    protected String pass;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;

    public abstract byte[] getCurrentSnapshot(LanDeviceEntity var1, String var2);

    protected abstract boolean registerUser(LanDeviceEntity var1, Map<String, String> var2);

    protected abstract boolean manageViewerUser(LanDeviceEntity var1);

    protected abstract GenericLanDevice.ConfigurationStatus configure(LanDeviceEntity var1, String var2, boolean var3);

    protected abstract boolean isCorrectPostResponse(HTTPClientServiceResult var1);

    protected abstract boolean specialResponseKey(Map<String, String> var1, String var2, String var3);

    public AccessVerificationStatus verify(LanDevice device) {
        this.log.debug((Object)("start verify(device=" + device + ")"));
        AccessVerificationStatus result = super.verify(device);
        if (result != AccessVerificationStatus.OK) {
            return result;
        }
        this.setDefaultAccess(device);
        HashMap capabilities = new HashMap();
        String[] stringArray = this.capabilitiesCommands;
        int n = this.capabilitiesCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            HTTPClientServiceResult response = this.sendCommand(device, cmd, HttpCommand.SendMethod.GET);
            if (!this.isCorrectResponse(response)) {
                return this.prepareVerificationStatus(response);
            }
            capabilities.putAll(this.parseResponse(response.getBodyAsText()));
            ++n2;
        }
        if (!this.isDeviceSupported(capabilities)) {
            return AccessVerificationStatus.NOT_SUPPORTED;
        }
        this.storeDeviceCapabilities(device.getGatewayClient().getMac(), capabilities);
        device.setVersion((String)capabilities.get(this.firmwareVersionParam));
        return AccessVerificationStatus.OK;
    }

    public AccessVerificationStatus verify(LanDeviceEntity device) {
        this.log.debug((Object)("start verify(device=" + device + ")"));
        AccessVerificationStatus result = super.verify(device);
        if (result != AccessVerificationStatus.OK) {
            return result;
        }
        this.setDefaultAccess(device);
        HashMap capabilities = new HashMap();
        String[] stringArray = this.capabilitiesCommands;
        int n = this.capabilitiesCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            HTTPClientServiceResult response = this.sendCommand(device, cmd, HttpCommand.SendMethod.GET);
            if (!this.isCorrectResponse(response)) {
                return this.prepareVerificationStatus(response);
            }
            capabilities.putAll(this.parseResponse(response.getBodyAsText()));
            ++n2;
        }
        if (!this.isDeviceSupported(capabilities)) {
            return AccessVerificationStatus.NOT_SUPPORTED;
        }
        this.storeDeviceCapabilities(device.getGatewayClient().getMac(), capabilities);
        device.setVersion((String)capabilities.get(this.firmwareVersionParam));
        return AccessVerificationStatus.OK;
    }

    /*
     * Exception decompiling
     */
    protected AccessVerificationStatus prepareVerificationStatus(HTTPClientServiceResult response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected CheckConfigurationStatus prepareCheckConfigurationStatus(HTTPClientServiceResult response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected GenericLanDevice.ConfigurationStatus prepareConfigurationStatus(HTTPClientServiceResult response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isDeviceSupported(Map<String, String> deviceCapabilities) {
        return true;
    }

    public GenericLanDevice.ConfigurationStatus reconfigure(LanDeviceEntity device) {
        return this.init(device, device.getPass(), true);
    }

    public GenericLanDevice.ConfigurationStatus init(LanDeviceEntity device, String currentAdminPassword) {
        this.log.debug((Object)("start init(device=" + device + ")"));
        return this.init(device, currentAdminPassword, false);
    }

    protected GenericLanDevice.ConfigurationStatus init(LanDeviceEntity device, String currentAdminPassword, boolean reconfiguration) {
        this.log.debug((Object)("start init(device=" + device + ")"));
        if (super.init(device, currentAdminPassword) == GenericLanDevice.ConfigurationStatus.FAILED) {
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        this.deviceCapabilities = this.getDeviceCapabilities(device.getGatewayClient().getMac());
        if (!this.manageViewerUser(device)) {
            this.log.info((Object)"Register or update viwer user on lan device failed!");
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        String model = null;
        if (!reconfiguration) {
            model = (String)this.deviceCapabilities.get(this.modelParam);
            device.setModel(model);
            this.log.debug((Object)("configuring camera model: " + model));
        } else {
            model = device.getModel();
        }
        DeviceDescEntity deviceDesc = this.deviceDescDAO.findDeviceDesc("camera", this.cameraProducer, model);
        if (deviceDesc == null) {
            this.log.debug((Object)("No deviceDesc found for model=" + model + ". Retrieving generic deviceDesc."));
            deviceDesc = this.deviceDescDAO.findDeviceDesc("camera", this.cameraProducer, "generic");
        }
        if (deviceDesc == null) {
            this.log.warn((Object)("No deviceDesc found for make=" + this.cameraProducer + ". Failed to add camera."));
            return GenericLanDevice.ConfigurationStatus.FAILED;
        }
        device.setDeviceDesc(deviceDesc);
        this.setDefaultSsid(this.cameraProducer);
        if (!device.hasParam("video_quality")) {
            device.setParam("video_quality", "GOOD", "GOOD");
        }
        if (this.isRtspStreaming() && this.hasGatewayClientWithMPEG4Support(device) && this.modelSupportsAVCEncoding(model)) {
            device.setVideoEncoding(this.getAVCVideoCodec(device));
        } else {
            device.setVideoEncoding(MJPEG);
        }
        return this.configure(device, currentAdminPassword, reconfiguration);
    }

    protected boolean modelSupportsAVCEncoding(String model) {
        return true;
    }

    protected boolean modelWithoutAudioDetectionSupport(String model) {
        return false;
    }

    protected void setDefaultAccess(LanDevice device) {
        if (device.getUser() == null) {
            this.log.debug((Object)"setting default username");
        }
        device.setUser(this.user);
        if (device.getPass() == null) {
            this.log.debug((Object)"setting default password");
        }
        device.setPass(this.pass);
        if (device.getPort() == null) {
            this.log.debug((Object)"setting default port");
        }
        device.setPort(Integer.valueOf(80));
    }

    protected void setDefaultAccess(LanDeviceEntity device) {
        if (device.getUser() == null) {
            this.log.debug((Object)"setting default username");
        }
        device.setUsername(this.user);
        if (device.getPass() == null) {
            this.log.debug((Object)"setting default password");
        }
        device.setPass(this.pass);
        if (device.getPort() == null) {
            this.log.debug((Object)"setting default port");
        }
        device.setPort(Integer.valueOf(80));
    }

    protected Map<String, String> parseResponse(String response) {
        String[] rows;
        this.log.debug((Object)("start parseResponse(response=" + response + ")"));
        if (response == null || response.trim().length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parsedResponse = new HashMap<String, String>();
        response = this.removeHtmlBody(response);
        String[] stringArray = rows = response.split("\n");
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            this.log.trace((Object)("Processing row: " + row));
            int equalsPos = row.indexOf("=");
            if (equalsPos == -1) {
                equalsPos = row.indexOf(":");
            }
            if (equalsPos == -1) {
                this.log.debug((Object)("Unexpected device param representation: " + row + "."));
            } else {
                String value;
                String key = row.substring(0, equalsPos).trim();
                if (!this.specialResponseKey(parsedResponse, key, value = row.substring(equalsPos + 1).replace("'", "").trim())) {
                    parsedResponse.put(key, value);
                }
            }
            ++n2;
        }
        return parsedResponse;
    }

    protected boolean isCorrectResponse(HTTPClientServiceResult response, HttpCommand.SendMethod sendMethod) {
        return sendMethod == HttpCommand.SendMethod.GET ? this.isCorrectResponse(response) : this.isCorrectPostResponse(response);
    }

    protected Map<String, String> getCommandResult(LanDeviceEntity device, String path) {
        HTTPClientServiceResult response = this.sendCommand(device, path, HttpCommand.SendMethod.GET);
        if (this.isCorrectResponse(response)) {
            return this.parseResponse(response.getBodyAsText());
        }
        return null;
    }

    protected String getCommandResult(LanDeviceEntity device, String path, String param) {
        HTTPClientServiceResult response = this.sendCommand(device, path, HttpCommand.SendMethod.GET);
        if (this.isCorrectResponse(response)) {
            return (String)this.parseResponse(response.getBodyAsText()).get(param);
        }
        return null;
    }

    public Boolean isFirmwareUpToDate(LanDeviceEntity device) {
        String validFirmwareVersion = device.getDeviceDesc().getFirmwareVersion();
        if (validFirmwareVersion == null || validFirmwareVersion.isEmpty()) {
            return null;
        }
        return validFirmwareVersion.equals(device.getVersion());
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Value(value="${lanDevice.firmware:./firmwares}")
    public void setFirmwares(String firmwares) {
        this.firmwares = firmwares;
    }

    @Value(value="${lanDevice.serverUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public GenericLanDevice.AuthType getAuthType() {
        return GenericLanDevice.AuthType.BASIC;
    }

    protected boolean hasGatewayClientWithMPEG4Support(LanDeviceEntity device) {
        return Utils.isAtMinimalVersion((String)device.getGatewayClient().getVersion(), (String)this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT));
    }

    public boolean hasNativeRtspOverHttpSupport() {
        return true;
    }

    public abstract String getAVCVideoCodec(LanDeviceEntity var1);

    protected TwoWayAudioUploadType getTwoWayAudioUploadType(LanDeviceEntity device) {
        return null;
    }

    protected TwoWayAudioSampleType getTwoWayAudioSampleType(LanDeviceEntity device) {
        return null;
    }

    protected Integer getTwoWayAudioSampleRate(LanDeviceEntity device) {
        return null;
    }

    protected Integer getTwoWayAudioChannelCount(LanDeviceEntity device) {
        return null;
    }

    protected TwoWayAudioCodec getTwoWayAudioCodec(LanDeviceEntity device) {
        return null;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result() {
        if ($SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result != null) {
            return $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result;
        }
        int[] nArray = new int[HTTPClientServiceResult.Result.values().length];
        try {
            nArray[HTTPClientServiceResult.Result.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOACCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTTPClientServiceResult.Result.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$vestiacom$gdserver$rest$response$HTTPClientServiceResult$Result = nArray;
        return nArray;
    }
}

