/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.landevice;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.ParameterService;

@Component
public class DeviceDriverFactory
implements ApplicationContextAware {
    private static Logger log = Logger.getLogger(DeviceDriverFactory.class);
    private ApplicationContext applicationContext;
    private ParameterService parameterService;
    private DeviceDescDAO deviceDescDAO;
    private Map<String, String> drivers = new HashMap();

    @Required
    @Autowired
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Required
    @Autowired
    public void setDeviceDescDAO(DeviceDescDAO deviceDescDAO) {
        this.deviceDescDAO = deviceDescDAO;
    }

    private void loadMacPrefixes(ParameterService.ParameterCode code, String driver) {
        String[] macPrefixes;
        log.trace((Object)("start loadMacPrefixes(code=" + code + ", driver=" + driver + ")"));
        String prefixes = this.parameterService.getParameterValue(code);
        if (prefixes == null || prefixes.trim().isEmpty()) {
            log.debug((Object)("Device driver MAC prefixes missing in DB: " + driver));
            return;
        }
        String[] stringArray = macPrefixes = prefixes.split(",");
        int n = macPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String macPrefix = stringArray[n2];
            this.drivers.put(macPrefix.trim(), driver);
            ++n2;
        }
    }

    public String getDriverClassNameByMacPrefix(String mac) {
        log.debug((Object)("start getDriverClassNameByMacPrefix(mac=" + mac + ")"));
        this.drivers.clear();
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_NAS_MAC_PREFIXES, "NAS");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_TRENDNET_MAC_PREFIXES, "CameraNipcaGeneric");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_VIVOTEK_MAC_PREFIXES, "CameraVivotekGeneric");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_BRICKCOM_MAC_PREFIXES, "CameraBrickcomGeneric");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_COMPRO_MAC_PREFIXES, "CameraComproGeneric");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_EDIMAX_MAC_PREFIXES, "CameraEdimaxGeneric");
        this.loadMacPrefixes(ParameterService.ParameterCode.LANDEVICE_STARGATE_WEB_INTERFACE_PREFIXES, "StargateWebInterface");
        String macPrefix = mac.substring(0, 8);
        return (String)this.drivers.get(macPrefix);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public GenericLanDevice getDriver(String deviceClassName, boolean legacyMode) {
        GenericLanDevice driver = (GenericLanDevice)this.applicationContext.getBean(deviceClassName);
        if (deviceClassName.equals("CameraVivotekGeneric") && legacyMode) {
            driver.setLegacyMode(legacyMode);
        }
        return driver;
    }

    public GenericLanDevice getDriver(LanDeviceEntity device) {
        String driverClassName = this.getDriverClassName(device);
        if (driverClassName == null || driverClassName.trim().isEmpty()) {
            return null;
        }
        return this.getDriver(driverClassName, this.getLegacyMode(device));
    }

    public GenericLanDevice getDriverByMacPrefix(String mac, boolean legacyMode) {
        log.debug((Object)("start getDriverByMacPrefix(mac=" + mac + ")"));
        String driverClassName = this.getDriverClassNameByMacPrefix(mac);
        if (driverClassName == null) {
            log.warn((Object)("Not found driver for mac prefix " + mac.substring(0, 8) + "!"));
            return null;
        }
        return this.getDriver(driverClassName, legacyMode);
    }

    private String getDriverClassName(LanDeviceEntity device) {
        if (device == null || device.getDeviceDesc() == null) {
            return null;
        }
        return device.getDeviceDesc().getDriverclass();
    }

    private boolean getLegacyMode(LanDeviceEntity device) {
        return device.hasParam("router_address");
    }

    public GenericLanDevice getDriver(String deviceClass, String make, String model) {
        DeviceDescEntity deviceDesc = this.deviceDescDAO.findDeviceDesc(deviceClass, make, model);
        if (deviceDesc == null) {
            log.warn((Object)("Not found device desc for deviceClass=" + deviceClass + ", make=" + make + ", model=" + model + ")"));
            return null;
        }
        return this.getDriver(deviceDesc.getDriverclass(), false);
    }
}

