/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.connector;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.util.ExceptionsTrigger;

@Component
@Scope(value="prototype")
public class UrlBuilder {
    private String url;
    private String path;
    private Map<String, String> params = new HashMap();

    public UrlBuilder setUrl(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        return this;
    }

    public UrlBuilder setPath(String path) {
        this.path = path.startsWith("/") ? path.substring(1, path.length()) : path;
        return this;
    }

    public UrlBuilder addParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public UrlBuilder setParams(Map<String, String> params) {
        this.params = params == null ? new HashMap() : new HashMap<String, String>(params);
        return this;
    }

    public String build() {
        ExceptionsTrigger.throwIfNull((Object)this.url, (RuntimeException)new NullPointerException("url"));
        StringBuilder sb = new StringBuilder();
        sb.append(this.url);
        if (this.path != null) {
            sb.append("/").append(this.path);
        }
        boolean first = true;
        for (Map.Entry param : this.params.entrySet()) {
            if (first) {
                sb.append("?");
                first = false;
            } else {
                sb.append("&");
            }
            sb.append((String)param.getKey()).append("=").append(this.encode((String)param.getValue()));
        }
        return sb.toString();
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

