/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver.connector;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vestiacom.gdserver.rest.model.Bytes;
import com.vestiacom.gdserver.rest.model.RegisteredBatch;
import com.vestiacom.gdserver.rest.response.GetDeviceServerUrlResponse;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.connector.Rotator;
import pl.smartapps.containerserver.connector.UrlBuilder;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.DeviceSessions;
import pl.smartapps.restserver.util.Utils;

@Component
public class Connector
implements ApplicationContextAware {
    private static Logger log = Logger.getLogger(Connector.class);
    private ApplicationContext applicationContext;
    private DeviceSessions sessions;
    private ParameterService parameterService;
    private boolean allowSelfSignedCertificates;
    private int tryCount;
    private long trySleep;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired
    @Required
    public void setSessions(DeviceSessions sessions) {
        this.sessions = sessions;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Value(value="${CommServerConnector.allowSelfSignedCertificates:false}")
    public void setAllowSelfSignedCertificates(boolean allowSelfSignedCertificates) {
        this.allowSelfSignedCertificates = allowSelfSignedCertificates;
    }

    @Value(value="${CommServerConnector.try.count:1}")
    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    @Value(value="${CommServerConnector.try.sleep[ms]:100}")
    public void setTrySleep(long trySleep) {
        this.trySleep = trySleep;
    }

    public Response get(String deviceId, String path, Map<String, String> params, Class<? extends Response> responseClass) {
        log.trace((Object)("start get(deviceId=" + deviceId + ", path=" + path + ", params=" + params + ", responseClass=" + responseClass + ")"));
        String serverUrl = this.getServerUrl(deviceId);
        if (serverUrl == null) {
            log.info((Object)("Not found serverUrl for deivceId=" + deviceId + ")"));
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
        Response response = this.getWithRetry(url, responseClass);
        if (response == null) {
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        if (response.getStatus() == Response.Status.ANOTHER_NODE_CONNECTED) {
            log.debug((Object)("Redirecting GET command to " + response.getServerUrl()));
            url = this.getUrlBuilder().setUrl(response.getServerUrl()).setPath(path).setParams(params).build();
            response = this.getWithRetry(url, responseClass);
        }
        return response;
    }

    public Response get(String path, Map<String, String> params, Class<? extends Response> responseClass) {
        log.trace((Object)("start get(path=" + path + ", params=" + params + ", responseClass=" + responseClass + ")"));
        Set gdServerUrls = this.getGdServerUrls();
        Rotator rotator = new Rotator(new ArrayList(gdServerUrls), this.tryCount);
        String serverUrl = null;
        Response response = null;
        while (response == null && (serverUrl = rotator.get()) != null) {
            log.trace((Object)("Executing GET method for path=" + path + " and serverUrl=" + serverUrl));
            String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
            response = this.get(url, responseClass);
            if (response != null) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getServerUrl(String deviceId) {
        log.trace((Object)("start getServerUrl(deviceId=" + deviceId + ")"));
        String serverUrl = null;
        if (deviceId == null) {
            log.debug((Object)"Unspecified deviceId. Searching for any CommServer url...");
            return this.searchForServerUrl();
        }
        serverUrl = this.sessions.get(deviceId);
        if (serverUrl == null) {
            log.trace((Object)("Not found serverUrl for device " + deviceId + ". Discovering..."));
            serverUrl = this.discoveryServerUrl(deviceId);
            log.trace((Object)("Discoverded serverUrl=" + serverUrl));
            if (serverUrl != null) {
                this.sessions.add(deviceId, serverUrl);
            }
        }
        return serverUrl;
    }

    private String searchForServerUrl() {
        Set urls = this.sessions.getUrls();
        if (urls.isEmpty()) {
            Set gdServerUrls = this.getGdServerUrls();
            if (!gdServerUrls.isEmpty()) {
                return (String)gdServerUrls.iterator().next();
            }
            log.warn((Object)"Not found any url to CommServer");
            return null;
        }
        return (String)urls.iterator().next();
    }

    private Response getWithRetry(String url, Class<? extends Response> responseClass) {
        Response response = null;
        int tries = 0;
        while (response == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send GET " + url + " for " + ++tries + " time"));
            response = this.get(url, responseClass);
            if (response != null) break;
            if (tries >= this.tryCount) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response makeHttpRequest(HttpRequestBase httpRequest, Class<? extends Response> responseClass) {
        HttpClient httpClient = null;
        String response = null;
        try {
            httpClient = this.getHttpClient(httpRequest);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                log.debug((Object)("Received " + httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase() + " for GET " + httpRequest.getURI().toString()));
            }
            if (httpResponse.getEntity() == null) {
                log.warn((Object)("Missing response entity for executed " + httpRequest.getMethod() + " command with url=" + httpRequest.getURI().toString()));
                return null;
            }
            response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            log.trace((Object)("Response: " + response));
            Response response2 = this.deserialize(response, responseClass);
            return response2;
        }
        catch (Exception ex) {
            log.error((Object)("Failed to execute GET command with url=" + httpRequest.getURI().toString() + ". Got response: " + response + ". Cause: " + ex.getMessage()));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    private Response get(String url, Class<? extends Response> responseClass) {
        log.trace((Object)("start get(url=" + url + ", responseClass=" + responseClass + ")"));
        return this.makeHttpRequest((HttpRequestBase)new HttpGet(url), responseClass);
    }

    private HttpClient getHttpClient(HttpRequestBase request) throws NoSuchAlgorithmException, KeyManagementException {
        DefaultHttpClient httpClient = null;
        if (this.allowSelfSignedCertificates) {
            log.trace((Object)"Creating httpclient accepted self-signed certificates");
            X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            sf.setHostnameVerifier(hostnameVerifier);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            URI uri = request.getURI();
            log.trace((Object)("Creating httpclient for scheme=" + uri.getScheme() + " and port=" + uri.getPort()));
            if (uri.getScheme().equals("https")) {
                schemeRegistry.register(new Scheme("https", uri.getPort(), (SchemeSocketFactory)sf));
            } else {
                schemeRegistry.register(new Scheme("http", uri.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            }
            SingleClientConnManager cm = new SingleClientConnManager(schemeRegistry);
            httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
        } else {
            log.trace((Object)"Creating default httpclient");
            httpClient = new DefaultHttpClient();
        }
        return httpClient;
    }

    private Response deserialize(String json, Class<? extends Response> responseClass) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        gsonBuilder.registerTypeAdapter(Bytes.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        Gson gson = gsonBuilder.create();
        return (Response)gson.fromJson(json, responseClass);
    }

    private UrlBuilder getUrlBuilder() {
        return (UrlBuilder)this.applicationContext.getBean("urlBuilder");
    }

    private String discoveryServerUrl(String deviceId) {
        log.trace((Object)("start discoveryServerUrl(deviceId=" + deviceId + ")"));
        Set gdServerUrls = this.getGdServerUrls();
        return this.discoveryServerUrl(gdServerUrls, deviceId);
    }

    private String discoveryServerUrl(Set<String> gdServerUrls, String deviceId) {
        for (String gdServerUrl : gdServerUrls) {
            String url = this.discoveryServerUrl(gdServerUrl, deviceId);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private String discoveryServerUrl(String gdServerUrl, String deviceId) {
        log.trace((Object)("start discoveryServerUrl(gdServerUrl=" + gdServerUrl + ", deviceId=" + deviceId + ")"));
        String url = String.valueOf(gdServerUrl) + "/rest/device/" + deviceId + "/serverUrl";
        Response baseResponse = this.get(url, GetDeviceServerUrlResponse.class);
        if (baseResponse == null) {
            return null;
        }
        GetDeviceServerUrlResponse response = (GetDeviceServerUrlResponse)baseResponse;
        return response.getStatus() == Response.Status.SUCCESS ? response.getServerUrl() : null;
    }

    private Set<String> getGdServerUrls() {
        HashSet<String> urls = new HashSet<String>();
        String joinedUrls = this.parameterService.getParameterValue(ParameterService.ParameterCode.GDSERVER_ADDRESSES);
        if (joinedUrls == null) {
            return Collections.emptySet();
        }
        String[] splitedUrls = joinedUrls.split(";");
        int i = 0;
        while (i < splitedUrls.length) {
            urls.add(splitedUrls[i].trim());
            ++i;
        }
        return urls;
    }

    public Response post(String path, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        log.trace((Object)("start post(path=" + path + ", params=" + params + ", entity=" + entity + ", responseClass=" + responseClass + ")"));
        Set gdServerUrls = this.getGdServerUrls();
        Rotator rotator = new Rotator(new ArrayList(gdServerUrls), this.tryCount);
        String serverUrl = null;
        Response response = null;
        while (response == null && (serverUrl = rotator.get()) != null) {
            log.trace((Object)("Executing POST method for path=" + path + " and serverUrl=" + serverUrl));
            String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
            response = this.postInternal(url, params, entity, responseClass);
            if (response != null) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    public Response post(String deviceId, String path, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        String serverUrl = this.getServerUrl(deviceId);
        if (serverUrl == null) {
            log.info((Object)("Not found serverUrl for deivceId=" + deviceId + ")"));
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
        Response response = this.postWithRetry(url, params, entity, responseClass);
        if (response == null) {
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        if (response.getStatus() == Response.Status.ANOTHER_NODE_CONNECTED) {
            log.debug((Object)("Redirecting POST command to " + response.getServerUrl()));
            url = this.getUrlBuilder().setUrl(response.getServerUrl()).setPath(path).setParams(params).build();
            response = this.postWithRetry(url, params, entity, responseClass);
        }
        return response;
    }

    private <T extends Response> T createResponse(Class<T> clazz, Response.Status status) {
        log.trace((Object)("start createResponse(clazz=" + clazz + ", status=" + status + ")"));
        try {
            Constructor<T> ctor = clazz.getConstructor(Response.Status.class);
            return (T)((Response)ctor.newInstance(status));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Response postWithRetry(String url, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        Response response = null;
        int tries = 0;
        while (response == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send POST " + url + " for " + ++tries + " time"));
            response = this.postInternal(url, params, entity, responseClass);
            if (response != null) break;
            if (tries >= this.tryCount) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response postInternal(String url, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(entity);
        return this.makeHttpRequest((HttpRequestBase)httpPost, responseClass);
    }

    public Response put(String deviceId, String path, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        String serverUrl = this.getServerUrl(deviceId);
        if (serverUrl == null) {
            log.info((Object)("Not found serverUrl for deivceId=" + deviceId + ")"));
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
        Response response = this.putWithRetry(url, params, entity, responseClass);
        if (response == null) {
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        if (response.getStatus() == Response.Status.ANOTHER_NODE_CONNECTED) {
            log.debug((Object)("Redirecting PUT command to " + response.getServerUrl()));
            url = this.getUrlBuilder().setUrl(response.getServerUrl()).setPath(path).setParams(params).build();
            response = this.putWithRetry(url, params, entity, responseClass);
        }
        return response;
    }

    public Response put(String path, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        log.trace((Object)("start put(path=" + path + ", params=" + params + ", entity=" + entity + ", responseClass=" + responseClass + ")"));
        Set gdServerUrls = this.getGdServerUrls();
        Rotator rotator = new Rotator(new ArrayList(gdServerUrls), this.tryCount);
        String serverUrl = null;
        Response response = null;
        while (response == null && (serverUrl = rotator.get()) != null) {
            log.trace((Object)("Executing PUT method for path=" + path + " and serverUrl=" + serverUrl));
            String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
            response = this.putInternal(url, entity, responseClass);
            if (response != null) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response putWithRetry(String url, Map<String, String> params, HttpEntity entity, Class<? extends Response> responseClass) {
        Response response = null;
        int tries = 0;
        while (response == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send PUT " + url + " for " + ++tries + " time"));
            response = this.putInternal(url, entity, responseClass);
            if (response != null) break;
            if (tries >= this.tryCount) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response putInternal(String url, HttpEntity entity, Class<? extends Response> responseClass) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity(entity);
        return this.makeHttpRequest((HttpRequestBase)httpPut, responseClass);
    }

    public SetRegisteredResponse setRegistered(String deviceId, boolean registered) {
        log.trace((Object)("start setRegistered(deviceId=" + deviceId + ", registered=" + registered + ")"));
        String path = this.getSetRegisteredPath(deviceId, registered);
        return (SetRegisteredResponse)this.put(path, null, null, SetRegisteredResponse.class);
    }

    private String getSetRegisteredPath(String deviceId, boolean registered) {
        return "/rest/device/" + deviceId + "/registered?registered=" + registered;
    }

    public Response batchRegistered(Map<String, Boolean> batch) {
        log.trace((Object)("start batchRegistered(batch=" + Utils.getSize(batch) + ")"));
        try {
            StringEntity entity = Utils.createEntity((Object)new RegisteredBatch(batch));
            return this.put("/rest/registered", null, (HttpEntity)entity, Response.class);
        }
        catch (UnsupportedEncodingException ex) {
            return new Response(Response.Status.FAILURE);
        }
    }

    public Response delete(String path, Map<String, String> params, Class<? extends Response> responseClass) {
        log.trace((Object)("start delete(path=" + path + ", params=" + params + ", responseClass=" + responseClass + ")"));
        Set gdServerUrls = this.getGdServerUrls();
        Rotator rotator = new Rotator(new ArrayList(gdServerUrls), this.tryCount);
        String serverUrl = null;
        Response response = null;
        while (response == null && (serverUrl = rotator.get()) != null) {
            log.trace((Object)("Executing DELETE method for path=" + path + " and serverUrl=" + serverUrl));
            String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
            response = this.delete(url, responseClass);
            if (response != null) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    public Response delete(String deviceId, String path, Map<String, String> params, Class<? extends Response> responseClass) {
        log.trace((Object)("start delete(deviceId=" + deviceId + ", path=" + path + ", params=" + params + ", responseClass=" + responseClass + ")"));
        String serverUrl = this.getServerUrl(deviceId);
        if (serverUrl == null) {
            log.info((Object)("Not found serverUrl for deivceId=" + deviceId + ")"));
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        String url = this.getUrlBuilder().setUrl(serverUrl).setPath(path).setParams(params).build();
        Response response = this.deleteWithRetry(url, responseClass);
        if (response == null) {
            return this.createResponse(responseClass, Response.Status.CLUSTER_NOT_CONNECTED);
        }
        if (response.getStatus() == Response.Status.ANOTHER_NODE_CONNECTED) {
            log.debug((Object)("Redirecting DELETE command to " + response.getServerUrl()));
            url = this.getUrlBuilder().setUrl(response.getServerUrl()).setPath(path).setParams(params).build();
            response = this.deleteWithRetry(url, responseClass);
        }
        return response;
    }

    private Response deleteWithRetry(String url, Class<? extends Response> responseClass) {
        Response response = null;
        int tries = 0;
        while (response == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send DELETE " + url + " for " + ++tries + " time"));
            response = this.delete(url, responseClass);
            if (response != null) break;
            if (tries >= this.tryCount) continue;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response delete(String url, Class<? extends Response> responseClass) {
        log.trace((Object)("start delete(url=" + url + ", responseClass=" + responseClass + ")"));
        return this.makeHttpRequest((HttpRequestBase)new HttpDelete(url), responseClass);
    }

    public String getVeryfiedServerUrl(String deviceId) {
        log.trace((Object)("start getVeryfiedServerUrl(deviceId=" + deviceId + ")"));
        if (Utils.isBlank((String)deviceId)) {
            return null;
        }
        String url = this.discoveryServerUrl(this.sessions.getUrls(), deviceId);
        if (url == null) {
            url = this.discoveryServerUrl(this.getGdServerUrls(), deviceId);
        }
        return url;
    }
}

