/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.DiscoverCameraIpAddressResponse;
import com.vestiacom.gdserver.rest.response.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.restserver.db.main.LanDeviceEntity;

@Service
public class VivotekCameraIpAddressDiscoveryService {
    private static Logger log = Logger.getLogger(VivotekCameraIpAddressDiscoveryService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public String getCameraIpAddress(String deviceId, String cameraMacAddress) {
        log.debug((Object)("start getCameraIpAddress(deviceId=" + deviceId + ", cameraMacAddress=" + cameraMacAddress + ")"));
        String path = "/rest/device/" + deviceId + "/discoverCameraIp?mac=" + cameraMacAddress;
        Response baseResponse = this.connector.get(deviceId, path, null, DiscoverCameraIpAddressResponse.class);
        if (baseResponse == null) {
            log.warn((Object)("Failed to get IP address for deivceId=" + deviceId + " (cameraMacAddress=" + cameraMacAddress + ")"));
            return null;
        }
        DiscoverCameraIpAddressResponse response = (DiscoverCameraIpAddressResponse)baseResponse;
        if (response.getStatus() == Response.Status.SUCCESS) {
            return response.getIpAddress();
        }
        log.warn((Object)("Failed to get IP address for deivceId=" + deviceId + " (cameraMacAddress=" + cameraMacAddress + ") cause: " + response.getErrorCode() + "."));
        return null;
    }

    public String getCameraIpAddres(LanDeviceEntity device) {
        return this.getCameraIpAddress(device.getGatewayClient().getSerialNumber(), device.getMac());
    }
}

