/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.model.DiscoverDeviceResponse;
import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.model.Make;
import com.vestiacom.gdserver.rest.response.Response;
import java.util.Collections;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;

@WebService
@Service
public class VivotekCameraDiscoveryService
implements CameraDiscoveryService {
    private static Logger log = Logger.getLogger(VivotekCameraDiscoveryService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @WebResult(name="devices")
    public List<DiscoveredLanDevice> discover(@WebParam(name="id") String deviceId) {
        Response baseResponse = this.connector.get(deviceId, this.getPath(deviceId), null, DiscoverDeviceResponse.class);
        if (baseResponse == null) {
            log.warn((Object)("Failed to discover devices for deivceId=" + deviceId + ")"));
            return Collections.emptyList();
        }
        DiscoverDeviceResponse response = (DiscoverDeviceResponse)baseResponse;
        if (response.getStatus() == Response.Status.SUCCESS) {
            return response.getDevices();
        }
        log.warn((Object)("Failed to discover devices for deivceId=" + deviceId + ", cause: " + response.getErrorCode() + "."));
        return Collections.emptyList();
    }

    private String getPath(String deviceId) {
        return "/rest/device/" + deviceId + "/discover" + "?make=" + Make.VIVOTEK.name().toLowerCase();
    }
}

